/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JdkEx;
import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.RemoteBrowser;
import com.jetbrains.cef.remote.RemoteClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.cef.CefApp;
import org.cef.CefBrowserSettings;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserFactory;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefPaintEvent;
import org.cef.browser.CefRendering;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMediaAccessCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefNativeAdapter;
import org.cef.callback.CefPrintDialogCallback;
import org.cef.callback.CefPrintJobCallback;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefPermissionHandler;
import org.cef.handler.CefPrintHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefScreenInfo;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.CefLog;
import org.cef.misc.CefPrintSettings;
import org.cef.misc.CefRange;
import org.cef.network.CefRequest;
import org.cef.security.CefSSLInfo;

public class CefClient
extends CefClientHandler
implements CefContextMenuHandler,
CefDialogHandler,
CefDisplayHandler,
CefDownloadHandler,
CefDragHandler,
CefFocusHandler,
CefPermissionHandler,
CefJSDialogHandler,
CefKeyboardHandler,
CefLifeSpanHandler,
CefLoadHandler,
CefPrintHandler,
CefRenderHandler,
CefRequestHandler,
CefWindowHandler {
    private static final boolean TRACE_LIFESPAN = Boolean.getBoolean("jcef.trace.cefclient.lifespan");
    private final RemoteClient remoteClient;
    private final ConcurrentHashMap<Integer, CefBrowser> browser_ = new ConcurrentHashMap();
    private CefContextMenuHandler contextMenuHandler_ = null;
    private CefDialogHandler dialogHandler_ = null;
    private CefDisplayHandler displayHandler_ = null;
    private CefDownloadHandler downloadHandler_ = null;
    private CefDragHandler dragHandler_ = null;
    private CefFocusHandler focusHandler_ = null;
    private CefPermissionHandler permissionHandler_ = null;
    private CefJSDialogHandler jsDialogHandler_ = null;
    private CefKeyboardHandler keyboardHandler_ = null;
    private final List<CefLifeSpanHandler> lifeSpanHandlers_ = new ArrayList<CefLifeSpanHandler>();
    private CefLoadHandler loadHandler_ = null;
    private CefPrintHandler printHandler_ = null;
    private CefRequestHandler requestHandler_ = null;
    private boolean isDisposed_ = false;
    private Runnable onDisposed_ = null;
    private volatile CefBrowser focusedBrowser_ = null;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (CefClient.this.focusedBrowser_ != null) {
                Component browserUI = CefClient.this.focusedBrowser_.getUIComponent();
                if (browserUI == null) {
                    return;
                }
                Object oldUI = evt.getOldValue();
                if (CefClient.this.isPartOf(oldUI, browserUI)) {
                    CefClient.this.focusedBrowser_.setFocus(false);
                    CefClient.this.focusedBrowser_ = null;
                }
            }
        }
    };

    CefClient() throws UnsatisfiedLinkError {
        RemoteClient remoteClient = this.remoteClient = CefApp.isRemoteEnabled() ? CefServer.instance().createClient() : null;
        if (this.remoteClient == null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.propertyChangeListener);
        }
        if (TRACE_LIFESPAN) {
            CefLog.Debug("CefClient: created client %s [remote=%s]", this, this.remoteClient);
        }
    }

    private boolean isPartOf(Object obj, Component browserUI) {
        Component[] childs;
        Component[] componentArray;
        int n;
        int n2;
        if (obj == browserUI) {
            return true;
        }
        if (obj instanceof Container && (n2 = 0) < (n = (componentArray = (childs = ((Container)obj).getComponents())).length)) {
            Component child = componentArray[n2];
            return this.isPartOf(child, browserUI);
        }
        return false;
    }

    @Override
    public void dispose() {
        if (TRACE_LIFESPAN) {
            CefLog.Debug("CefClient: dispose client %s [remote=%s]", this, this.remoteClient);
        }
        this.isDisposed_ = true;
        if (this.remoteClient != null) {
            this.remoteClient.dispose();
            CefApp app = CefApp.getInstanceIfAny();
            if (app != null) {
                app.clientWasDisposed(this);
            }
            if (this.onDisposed_ != null) {
                this.onDisposed_.run();
            }
        } else {
            this.cleanupBrowser(-1);
        }
    }

    public void setOnDisposeCallback(Runnable onDisposed) {
        this.onDisposed_ = onDisposed;
    }

    @Deprecated
    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent) {
        return this.createBrowser(url, isOffscreenRendered, isTransparent, null);
    }

    @Deprecated
    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent, CefRequestContext context) {
        return this.createBrowser(url, isOffscreenRendered ? CefRendering.OFFSCREEN : CefRendering.DEFAULT, isTransparent, context);
    }

    @Deprecated
    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent, CefRequestContext context, CefBrowserSettings settings) {
        return this.createBrowser(url, isOffscreenRendered ? CefRendering.OFFSCREEN : CefRendering.DEFAULT, isTransparent, context, settings);
    }

    public CefBrowser createBrowser(String url, CefRendering rendering, boolean isTransparent) {
        return this.createBrowser(url, rendering, isTransparent, null);
    }

    public CefBrowser createBrowser(String url, CefRendering rendering, boolean isTransparent, CefRequestContext context) {
        if (this.isDisposed_) {
            throw new IllegalStateException("Can't create browser. CefClient is disposed");
        }
        if (this.remoteClient != null) {
            return this.remoteClient.createBrowser(url, context, this, rendering);
        }
        return CefBrowserFactory.create(this, url, rendering, isTransparent, context, null);
    }

    public CefBrowser createBrowser(String url, CefRendering rendering, boolean isTransparent, CefRequestContext context, CefBrowserSettings settings) {
        if (this.isDisposed_) {
            throw new IllegalStateException("Can't create browser. CefClient is disposed");
        }
        if (this.remoteClient != null) {
            return this.remoteClient.createBrowser(url, context, this, rendering);
        }
        return CefBrowserFactory.create(this, url, rendering, isTransparent, context, settings);
    }

    @Override
    protected CefBrowser getBrowser(int identifier) {
        if (this.remoteClient != null) {
            return this.remoteClient.getRemoteBrowser(identifier);
        }
        return this.browser_.get(identifier);
    }

    @Override
    protected Object[] getAllBrowser() {
        if (this.remoteClient != null) {
            return this.remoteClient.getAllBrowsers();
        }
        return this.browser_.values().stream().filter(browser -> !browser.isClosing()).toArray();
    }

    @Override
    protected CefContextMenuHandler getContextMenuHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getContextMenuHandler();
        }
        return this;
    }

    @Override
    protected CefDialogHandler getDialogHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getDialogHandler();
        }
        return this;
    }

    @Override
    protected CefDisplayHandler getDisplayHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getDisplayHandler();
        }
        return this;
    }

    @Override
    protected CefDownloadHandler getDownloadHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getDownloadHandler();
        }
        return this;
    }

    @Override
    protected CefDragHandler getDragHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getDragHandler();
        }
        return this;
    }

    @Override
    protected CefFocusHandler getFocusHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getFocusHandler();
        }
        return this;
    }

    @Override
    protected CefPermissionHandler getPermissionHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getPermissionHandler();
        }
        return this;
    }

    @Override
    protected CefJSDialogHandler getJSDialogHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getJSDialogHandler();
        }
        return this;
    }

    @Override
    protected CefKeyboardHandler getKeyboardHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getKeyboardHandler();
        }
        return this;
    }

    @Override
    protected CefLifeSpanHandler getLifeSpanHandler() {
        if (this.remoteClient != null) {
            CefLog.Error("CefClient.getLifeSpanHandler mustn't be called in remote mode.", new Object[0]);
            return null;
        }
        return this;
    }

    @Override
    protected CefLoadHandler getLoadHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getLoadHandler();
        }
        return this;
    }

    @Override
    protected CefPrintHandler getPrintHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getPrintHandler();
        }
        return this;
    }

    @Override
    protected CefRenderHandler getRenderHandler() {
        if (this.remoteClient != null) {
            CefLog.Error("CefClient.getRenderHandler mustn't be called in remote mode.", new Object[0]);
            return null;
        }
        return this;
    }

    @Override
    protected CefRequestHandler getRequestHandler() {
        if (this.remoteClient != null) {
            return this.remoteClient.getRequestHandler();
        }
        return this;
    }

    @Override
    protected CefWindowHandler getWindowHandler() {
        if (this.remoteClient != null) {
            return null;
        }
        return this;
    }

    public CefClient addContextMenuHandler(CefContextMenuHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addContextMenuHandler(handler);
        } else if (this.contextMenuHandler_ == null) {
            this.contextMenuHandler_ = handler;
        }
        return this;
    }

    public void removeContextMenuHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeContextMenuHandler();
        } else {
            this.contextMenuHandler_ = null;
        }
    }

    @Override
    public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
        if (this.remoteClient != null) {
            CefLog.Error("onBeforeContextMenu mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.contextMenuHandler_ != null && browser != null) {
            this.contextMenuHandler_.onBeforeContextMenu(browser, frame, params, model);
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
        if (this.remoteClient != null) {
            CefLog.Error("onContextMenuCommand mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.contextMenuHandler_ != null && browser != null) {
            return this.contextMenuHandler_.onContextMenuCommand(browser, frame, params, commandId, eventFlags);
        }
        return false;
    }

    @Override
    public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
        if (this.remoteClient != null) {
            CefLog.Error("onContextMenuDismissed mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.contextMenuHandler_ != null && browser != null) {
            this.contextMenuHandler_.onContextMenuDismissed(browser, frame);
        }
    }

    public CefClient addDialogHandler(CefDialogHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addDialogHandler(handler);
        } else if (this.dialogHandler_ == null) {
            this.dialogHandler_ = handler;
        }
        return this;
    }

    public void removeDialogHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeDialogHandler();
        } else {
            this.dialogHandler_ = null;
        }
    }

    @Override
    public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefFileDialogCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onFileDialog mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.dialogHandler_ != null && browser != null) {
            return this.dialogHandler_.onFileDialog(browser, mode, title, defaultFilePath, acceptFilters, callback);
        }
        return false;
    }

    public CefClient addDisplayHandler(CefDisplayHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addDisplayHandler(handler);
        } else if (this.displayHandler_ == null) {
            this.displayHandler_ = handler;
        }
        return this;
    }

    public void removeDisplayHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeDisplayHandler();
        } else {
            this.displayHandler_ = null;
        }
    }

    @Override
    public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
        if (this.remoteClient != null) {
            CefLog.Error("onAddressChange mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onAddressChange(browser, frame, url);
        }
    }

    @Override
    public void onTitleChange(CefBrowser browser, String title) {
        if (this.remoteClient != null) {
            CefLog.Error("onTitleChange mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onTitleChange(browser, title);
        }
    }

    @Override
    public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onFullscreenModeChange(browser, fullscreen);
        }
    }

    @Override
    public boolean onTooltip(CefBrowser browser, String text) {
        if (this.remoteClient != null) {
            CefLog.Error("onTooltip mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.displayHandler_ != null && browser != null) {
            return this.displayHandler_.onTooltip(browser, text);
        }
        return false;
    }

    @Override
    public void onStatusMessage(CefBrowser browser, String value) {
        if (this.remoteClient != null) {
            CefLog.Error("onStatusMessage mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onStatusMessage(browser, value);
        }
    }

    @Override
    public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
        if (this.remoteClient != null) {
            CefLog.Error("onConsoleMessage mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.displayHandler_ != null && browser != null) {
            return this.displayHandler_.onConsoleMessage(browser, level, message, source, line);
        }
        return false;
    }

    @Override
    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        if (this.remoteClient != null) {
            CefLog.Error("onCursorChange mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return false;
        }
        if (this.displayHandler_ != null && this.displayHandler_.onCursorChange(browser, cursorType)) {
            return true;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.onCursorChange(browser, cursorType);
        }
        return false;
    }

    public CefClient addDownloadHandler(CefDownloadHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addDownloadHandler(handler);
        } else if (this.downloadHandler_ == null) {
            this.downloadHandler_ = handler;
        }
        return this;
    }

    public void removeDownloadHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeDownloadHandler();
        } else {
            this.downloadHandler_ = null;
        }
    }

    @Override
    public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onBeforeDownload mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.downloadHandler_ != null && browser != null) {
            this.downloadHandler_.onBeforeDownload(browser, downloadItem, suggestedName, callback);
        }
    }

    @Override
    public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onDownloadUpdated mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.downloadHandler_ != null && browser != null) {
            this.downloadHandler_.onDownloadUpdated(browser, downloadItem, callback);
        }
    }

    public CefClient addDragHandler(CefDragHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addDragHandler(handler);
        } else if (this.dragHandler_ == null) {
            this.dragHandler_ = handler;
        }
        return this;
    }

    public void removeDragHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeDragHandler();
        } else {
            this.dragHandler_ = null;
        }
    }

    @Override
    public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
        if (this.remoteClient != null) {
            CefLog.Error("onDragEnter mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.dragHandler_ != null && browser != null) {
            return this.dragHandler_.onDragEnter(browser, dragData, mask);
        }
        return false;
    }

    public CefClient addFocusHandler(CefFocusHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addFocusHandler(handler);
        } else if (this.focusHandler_ == null) {
            this.focusHandler_ = handler;
        }
        return this;
    }

    public void removeFocusHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeFocusHandler();
        } else {
            this.focusHandler_ = null;
        }
    }

    @Override
    public void onTakeFocus(CefBrowser browser, boolean next) {
        if (this.remoteClient != null) {
            CefLog.Error("onTakeFocus mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        browser.setFocus(false);
        Component uiComponent = browser.getUIComponent();
        if (uiComponent == null) {
            return;
        }
        Container parent = uiComponent.getParent();
        if (parent != null) {
            FocusTraversalPolicy policy = null;
            while (parent != null && (policy = parent.getFocusTraversalPolicy()) == null) {
                parent = parent.getParent();
            }
            if (policy != null) {
                Component nextComp;
                Component component = nextComp = next ? policy.getComponentAfter(parent, uiComponent) : policy.getComponentBefore(parent, uiComponent);
                if (nextComp == null) {
                    policy.getDefaultComponent(parent).requestFocus();
                } else {
                    nextComp.requestFocus();
                }
            }
        }
        this.focusedBrowser_ = null;
        if (this.focusHandler_ != null) {
            this.focusHandler_.onTakeFocus(browser, next);
        }
    }

    @Override
    public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
        if (this.remoteClient != null) {
            CefLog.Error("onSetFocus mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return false;
        }
        Boolean alreadyHandled = Boolean.FALSE;
        if (this.focusHandler_ != null) {
            Component uiComponent = browser.getUIComponent();
            if (uiComponent == null) {
                return true;
            }
            alreadyHandled = JdkEx.invokeOnEDTAndWait(() -> this.focusHandler_.onSetFocus(browser, source), Boolean.TRUE, uiComponent);
        }
        return alreadyHandled;
    }

    @Override
    public void onGotFocus(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onGotFocus mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        if (this.focusedBrowser_ == browser) {
            return;
        }
        this.focusedBrowser_ = browser;
        browser.setFocus(true);
        if (this.focusHandler_ != null) {
            Component uiComponent = browser.getUIComponent();
            if (uiComponent == null) {
                return;
            }
            JdkEx.invokeOnEDTAndWait(() -> this.focusHandler_.onGotFocus(browser), uiComponent);
        }
    }

    public CefClient addPermissionHandler(CefPermissionHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addPermissionHandler(handler);
        } else if (this.permissionHandler_ == null) {
            this.permissionHandler_ = handler;
        }
        return this;
    }

    public void removePermissionHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removePermissionHandler();
        } else {
            this.permissionHandler_ = null;
        }
    }

    @Override
    public boolean onRequestMediaAccessPermission(CefBrowser browser, CefFrame frame, String requesting_url, int requested_permissions, CefMediaAccessCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onRequestMediaAccessPermission mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.permissionHandler_ != null && browser != null) {
            return this.permissionHandler_.onRequestMediaAccessPermission(browser, frame, requesting_url, requested_permissions, callback);
        }
        return false;
    }

    public CefClient addJSDialogHandler(CefJSDialogHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addJSDialogHandler(handler);
        } else if (this.jsDialogHandler_ == null) {
            this.jsDialogHandler_ = handler;
        }
        return this;
    }

    public void removeJSDialogHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeJSDialogHandler();
        } else {
            this.jsDialogHandler_ = null;
        }
    }

    @Override
    public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
        if (this.remoteClient != null) {
            CefLog.Error("onJSDialog mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.jsDialogHandler_ != null && browser != null) {
            return this.jsDialogHandler_.onJSDialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message);
        }
        return false;
    }

    @Override
    public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onBeforeUnloadDialog mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.jsDialogHandler_ != null && browser != null) {
            return this.jsDialogHandler_.onBeforeUnloadDialog(browser, message_text, is_reload, callback);
        }
        return false;
    }

    @Override
    public void onResetDialogState(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onResetDialogState mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.jsDialogHandler_ != null && browser != null) {
            this.jsDialogHandler_.onResetDialogState(browser);
        }
    }

    @Override
    public void onDialogClosed(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onDialogClosed mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.jsDialogHandler_ != null && browser != null) {
            this.jsDialogHandler_.onDialogClosed(browser);
        }
    }

    public CefClient addKeyboardHandler(CefKeyboardHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addKeyboardHandler(handler);
        } else if (this.keyboardHandler_ == null) {
            this.keyboardHandler_ = handler;
        }
        return this;
    }

    public void removeKeyboardHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeKeyboardHandler();
        } else {
            this.keyboardHandler_ = null;
        }
    }

    @Override
    public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
        if (this.remoteClient != null) {
            CefLog.Error("onPreKeyEvent mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.keyboardHandler_ != null && browser != null) {
            return this.keyboardHandler_.onPreKeyEvent(browser, event, is_keyboard_shortcut);
        }
        return false;
    }

    @Override
    public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
        if (this.remoteClient != null) {
            CefLog.Error("onKeyEvent mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.keyboardHandler_ != null && browser != null) {
            return this.keyboardHandler_.onKeyEvent(browser, event);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CefClient addLifeSpanHandler(CefLifeSpanHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addLifeSpanHandler(handler);
        } else {
            List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
            synchronized (list) {
                this.lifeSpanHandlers_.add(handler);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifeSpanHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeAllLifeSpanHandlers();
        } else {
            List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
            synchronized (list) {
                this.lifeSpanHandlers_.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
        if (this.remoteClient != null) {
            CefLog.Error("onBeforePopup mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.isDisposed_) {
            return true;
        }
        if (browser == null) {
            return false;
        }
        List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
        synchronized (list) {
            boolean result = false;
            for (CefLifeSpanHandler lsh : this.lifeSpanHandlers_) {
                result |= lsh.onBeforePopup(browser, frame, target_url, target_frame_name);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterCreated(CefBrowser browser) {
        boolean disposed;
        if (this.remoteClient != null) {
            CefLog.Error("onAfterCreated mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        if (TRACE_LIFESPAN) {
            CefLog.Debug("CefClient: browser=%s: onAfterCreated", browser);
        }
        if (disposed = this.isDisposed_) {
            CefLog.Info("Browser %s was created while CefClient was marked as disposed", browser);
        }
        Integer identifier = browser.getIdentifier();
        if (!disposed) {
            this.browser_.put(identifier, browser);
        }
        List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
        synchronized (list) {
            for (CefLifeSpanHandler lsh : this.lifeSpanHandlers_) {
                lsh.onAfterCreated(browser);
            }
        }
        if (disposed) {
            browser.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterParentChanged(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onAfterParentChanged mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
        synchronized (list) {
            for (CefLifeSpanHandler lsh : this.lifeSpanHandlers_) {
                lsh.onAfterParentChanged(browser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doClose(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("doClose mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return false;
        }
        List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
        synchronized (list) {
            for (CefLifeSpanHandler lsh : this.lifeSpanHandlers_) {
                lsh.doClose(browser);
            }
        }
        return browser.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeClose(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onBeforeClose mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        if (TRACE_LIFESPAN) {
            CefLog.Debug("CefClient: browser=%s: onBeforeClose", browser);
        }
        List<CefLifeSpanHandler> list = this.lifeSpanHandlers_;
        synchronized (list) {
            for (CefLifeSpanHandler lsh : this.lifeSpanHandlers_) {
                lsh.onBeforeClose(browser);
            }
        }
        browser.onBeforeClose();
        this.cleanupBrowser(browser.getIdentifier());
    }

    private void cleanupBrowser(int identifier) {
        if (identifier >= 0) {
            this.browser_.remove(identifier);
        } else {
            assert (this.isDisposed_);
            ArrayList<CefBrowser> browserList = new ArrayList<CefBrowser>(this.browser_.values());
            if (!browserList.isEmpty()) {
                if (TRACE_LIFESPAN) {
                    CefLog.Debug("CefClient: cleanup %d browsers", browserList.size());
                }
                for (CefBrowser browser : browserList) {
                    if (TRACE_LIFESPAN) {
                        CefLog.Debug("CefClient: close %s", browser);
                    }
                    browser.close(true);
                }
                return;
            }
        }
        if (!this.isDisposed_) {
            return;
        }
        if (!this.browser_.isEmpty()) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.propertyChangeListener);
        this.removeContextMenuHandler(this);
        this.removeDialogHandler(this);
        this.removeDisplayHandler(this);
        this.removeDownloadHandler(this);
        this.removeDragHandler(this);
        this.removeFocusHandler(this);
        this.removeJSDialogHandler(this);
        this.removeKeyboardHandler(this);
        this.removeLifeSpanHandler(this);
        this.removeLoadHandler(this);
        this.removePrintHandler(this);
        this.removeRenderHandler(this);
        this.removeRequestHandler(this);
        this.removeWindowHandler(this);
        super.dispose();
        CefApp app = CefApp.getInstanceIfAny();
        if (app != null) {
            app.clientWasDisposed(this);
        }
        if (this.onDisposed_ != null) {
            this.onDisposed_.run();
        }
    }

    public CefClient addLoadHandler(CefLoadHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addLoadHandler(handler);
        } else if (this.loadHandler_ == null) {
            this.loadHandler_ = handler;
        }
        return this;
    }

    public void removeLoadHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeLoadHandler();
        } else {
            this.loadHandler_ = null;
        }
    }

    @Override
    public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
        if (this.remoteClient != null) {
            CefLog.Error("onLoadingStateChange mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
        }
    }

    @Override
    public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
        if (this.remoteClient != null) {
            CefLog.Error("onLoadStart mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadStart(browser, frame, transitionType);
        }
    }

    @Override
    public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
        if (this.remoteClient != null) {
            CefLog.Error("onLoadEnd mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadEnd(browser, frame, httpStatusCode);
        }
    }

    @Override
    public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
        if (this.remoteClient != null) {
            CefLog.Error("onLoadError mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadError(browser, frame, errorCode, errorText, failedUrl);
        }
    }

    public CefClient addPrintHandler(CefPrintHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addPrintHandler(handler);
        } else if (this.printHandler_ == null) {
            this.printHandler_ = handler;
        }
        return this;
    }

    public void removePrintHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removePrintHandler();
        } else {
            this.printHandler_ = null;
        }
    }

    @Override
    public void onPrintStart(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onPrintStart mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.printHandler_ != null && browser != null) {
            this.printHandler_.onPrintStart(browser);
        }
    }

    @Override
    public void onPrintSettings(CefBrowser browser, CefPrintSettings settings, boolean getDefaults) {
        if (this.remoteClient != null) {
            CefLog.Error("onPrintSettings mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.printHandler_ != null && browser != null) {
            this.printHandler_.onPrintSettings(browser, settings, getDefaults);
        }
    }

    @Override
    public boolean onPrintDialog(CefBrowser browser, boolean hasSelection, CefPrintDialogCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onPrintDialog mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.printHandler_ != null && browser != null) {
            return this.printHandler_.onPrintDialog(browser, hasSelection, callback);
        }
        return false;
    }

    @Override
    public boolean onPrintJob(CefBrowser browser, String documentName, String pdfFilePath, CefPrintJobCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onPrintJob mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.printHandler_ != null && browser != null) {
            return this.printHandler_.onPrintJob(browser, documentName, pdfFilePath, callback);
        }
        return false;
    }

    @Override
    public void onPrintReset(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("onPrintReset mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.printHandler_ != null && browser != null) {
            this.printHandler_.onPrintReset(browser);
        }
    }

    @Override
    public Dimension getPdfPaperSize(CefBrowser browser, int deviceUnitsPerInch) {
        if (this.remoteClient != null) {
            CefLog.Error("getPdfPaperSize mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.printHandler_ != null && browser != null) {
            return this.printHandler_.getPdfPaperSize(browser, deviceUnitsPerInch);
        }
        return null;
    }

    @Override
    public synchronized void addMessageRouter(CefMessageRouter messageRouter) {
        if (this.remoteClient != null) {
            this.remoteClient.addMessageRouter(messageRouter);
        } else {
            super.addMessageRouter(messageRouter);
        }
    }

    @Override
    public synchronized void removeMessageRouter(CefMessageRouter messageRouter) {
        if (this.remoteClient != null) {
            this.remoteClient.removeMessageRouter(messageRouter);
        } else {
            super.removeMessageRouter(messageRouter);
        }
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("getViewRect mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return new Rectangle(0, 0, 1, 1);
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            Rectangle rect = realHandler.getViewRect(browser);
            if (rect.width <= 0 || rect.height <= 0) {
                rect = new Rectangle(rect.x, rect.y, 1, 1);
            }
            return rect;
        }
        return new Rectangle(0, 0, 1, 1);
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        if (this.remoteClient != null) {
            CefLog.Error("getScreenPoint mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return new Point(0, 0);
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.getScreenPoint(browser, viewPoint);
        }
        return new Point(0, 0);
    }

    @Override
    public double getDeviceScaleFactor(CefBrowser browser) {
        CefRenderHandler realHandler;
        if (this.remoteClient != null) {
            CefLog.Error("getDeviceScaleFactor mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if ((realHandler = browser.getRenderHandler()) != null) {
            return realHandler.getDeviceScaleFactor(browser);
        }
        return JCefAppConfig.getDeviceScaleFactor(browser.getUIComponent());
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (this.remoteClient != null) {
            CefLog.Error("onPopupShow mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPopupShow(browser, show);
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        if (this.remoteClient != null) {
            CefLog.Error("onPopupSize mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPopupSize(browser, size);
        }
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (this.remoteClient != null) {
            CefLog.Error("onPaint mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPaint(browser, popup, dirtyRects, buffer, width, height);
        }
    }

    @Override
    public void addOnPaintListener(Consumer<CefPaintEvent> listener) {
    }

    @Override
    public void setOnPaintListener(Consumer<CefPaintEvent> listener) {
    }

    @Override
    public void removeOnPaintListener(Consumer<CefPaintEvent> listener) {
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        if (this.remoteClient != null) {
            CefLog.Error("startDragging mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return false;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.startDragging(browser, dragData, mask, x, y);
        }
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
        if (this.remoteClient != null) {
            CefLog.Error("updateDragCursor mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.updateDragCursor(browser, operation);
        }
    }

    @Override
    public void OnImeCompositionRangeChanged(CefBrowser browser, CefRange selectionRange, Rectangle[] characterBounds) {
        if (this.remoteClient != null) {
            CefLog.Error("OnImeCompositionRangeChanged mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.OnImeCompositionRangeChanged(browser, selectionRange, characterBounds);
        }
    }

    @Override
    public void OnTextSelectionChanged(CefBrowser browser, String selectedText, CefRange selectionRange) {
        if (this.remoteClient != null) {
            CefLog.Error("OnTextSelectionChanged mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.OnTextSelectionChanged(browser, selectedText, selectionRange);
        }
    }

    @Override
    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        if (this.remoteClient != null) {
            CefLog.Error("getScreenInfo mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return false;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.getScreenInfo(browser, screenInfo);
        }
        return false;
    }

    public CefClient addRequestHandler(CefRequestHandler handler) {
        if (this.remoteClient != null) {
            this.remoteClient.addRequestHandler(handler);
        } else if (this.requestHandler_ == null) {
            this.requestHandler_ = handler;
        }
        return this;
    }

    public void removeRequestHandler() {
        if (this.remoteClient != null) {
            this.remoteClient.removeRequestHandler();
        } else {
            this.requestHandler_ = null;
        }
    }

    @Override
    public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
        if (this.remoteClient != null) {
            CefLog.Error("onBeforeBrowse mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect);
        }
        return false;
    }

    @Override
    public boolean onOpenURLFromTab(CefBrowser browser, CefFrame frame, String target_url, boolean user_gesture) {
        if (this.remoteClient != null) {
            CefLog.Error("onOpenURLFromTab mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.isDisposed_) {
            return true;
        }
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onOpenURLFromTab(browser, frame, target_url, user_gesture);
        }
        return false;
    }

    @Override
    public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
        if (this.remoteClient != null) {
            CefLog.Error("getResourceRequestHandler mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.getResourceRequestHandler(browser, frame, request, isNavigation, isDownload, requestInitiator, disableDefaultHandling);
        }
        return null;
    }

    @Override
    public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("getAuthCredentials mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback);
        }
        return false;
    }

    @Override
    public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefSSLInfo sslInfo, CefCallback callback) {
        if (this.remoteClient != null) {
            CefLog.Error("onCertificateError mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
            CefRequestHandler handler = this.remoteClient.getRequestHandler();
            if (handler != null) {
                return handler.onCertificateError(browser, cert_error, request_url, sslInfo, callback);
            }
        }
        if (this.requestHandler_ != null) {
            return this.requestHandler_.onCertificateError(browser, cert_error, request_url, sslInfo, callback);
        }
        return false;
    }

    @Override
    public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
        if (this.remoteClient != null) {
            CefLog.Error("onRenderProcessTerminated mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (this.requestHandler_ != null) {
            this.requestHandler_.onRenderProcessTerminated(browser, status);
        }
    }

    @Override
    public Rectangle getRect(CefBrowser browser) {
        if (this.remoteClient != null) {
            CefLog.Error("getRect mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefWindowHandler realHandler = browser.getWindowHandler();
        if (realHandler != null) {
            return realHandler.getRect(browser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void onMouseEvent(CefBrowser browser, int event, int screenX, int screenY, int modifier, int button) {
        if (this.remoteClient != null) {
            CefLog.Error("onMouseEvent mustn't be called in remote mode (it seems that user manually called this method).", new Object[0]);
        }
        if (browser == null) {
            return;
        }
        CefWindowHandler realHandler = browser.getWindowHandler();
        if (realHandler != null) {
            realHandler.onMouseEvent(browser, event, screenX, screenY, modifier, button);
        }
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder(this.toString());
        if (this.browser_.isEmpty()) {
            sb.append(" [0 active browsers]");
        } else {
            sb.append(" | ");
            for (CefBrowser b : this.browser_.values()) {
                sb.append(b);
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static boolean isNativeBrowserCreationStarted(CefBrowser browser) {
        if (browser instanceof CefNativeAdapter) {
            return ((CefNativeAdapter)((Object)browser)).getNativeRef("CefBrowser") != 0L;
        }
        if (browser instanceof RemoteBrowser) {
            return ((RemoteBrowser)browser).isNativeBrowserCreationStarted();
        }
        return false;
    }
}

