/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.thrift_codegen.PostDataElement;
import java.nio.ByteBuffer;
import org.cef.misc.DebugFormatter;
import org.cef.network.CefPostDataElement;

public class RemotePostDataElement
extends CefPostDataElement {
    private final PostDataElement myElement;

    public RemotePostDataElement(PostDataElement postDataElement) {
        this.myElement = postDataElement;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isReadOnly() {
        return this.myElement.isReadOnly;
    }

    @Override
    public void setToEmpty() {
        this.myElement.file = null;
        this.myElement.bytes = null;
    }

    @Override
    public void setToFile(String fileName) {
        this.myElement.file = fileName;
        this.myElement.bytes = null;
    }

    @Override
    public void setToBytes(int size, byte[] bytes) {
        this.myElement.file = null;
        this.myElement.bytes = ByteBuffer.wrap(bytes, 0, size);
    }

    @Override
    public CefPostDataElement.Type getType() {
        if (this.myElement.file == null && this.myElement.bytes == null) {
            return CefPostDataElement.Type.PDE_TYPE_EMPTY;
        }
        if (this.myElement.file == null) {
            return CefPostDataElement.Type.PDE_TYPE_BYTES;
        }
        return CefPostDataElement.Type.PDE_TYPE_FILE;
    }

    @Override
    public String getFile() {
        return this.myElement.file;
    }

    @Override
    public int getBytesCount() {
        return this.myElement.bytes == null ? 0 : this.myElement.bytes.capacity();
    }

    @Override
    public int getBytes(int size, byte[] bytes) {
        if (this.myElement.bytes == null) {
            return 0;
        }
        this.myElement.bytes.get(bytes, 0, size);
        return size;
    }

    static PostDataElement toThriftWithMap(CefPostDataElement postData) {
        PostDataElement e = new PostDataElement(postData.isReadOnly());
        if (postData.getType() == CefPostDataElement.Type.PDE_TYPE_FILE) {
            e.file = postData.getFile();
        } else if (postData.getType() == CefPostDataElement.Type.PDE_TYPE_BYTES) {
            byte[] buf = new byte[postData.getBytesCount()];
            postData.getBytes(postData.getBytesCount(), buf);
            e.bytes = ByteBuffer.wrap(buf);
        }
        return e;
    }

    @Override
    public String toString() {
        return DebugFormatter.toString_PostDataElement(null, this);
    }
}

