/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.thrift_codegen.Server;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.cef.misc.CefLog;

public class RpcExecutor {
    private TTransport myTransport;
    private TProtocol myProtocol;
    private Server.Iface myServer;

    public RpcExecutor openTransport() throws TTransportException {
        if (ThriftTransport.isTcp()) {
            this.initTcp(ThriftTransport.getServerPort());
        } else {
            this.initPipe(ThriftTransport.getServerPipe().toString());
        }
        return this;
    }

    private void initTcp(int port) throws TTransportException {
        try {
            this.myTransport = new TSocket("localhost", port);
            this.myTransport.open();
            this.myProtocol = new TBinaryProtocol(this.myTransport);
            this.myServer = new Server.Client(this.myProtocol);
        }
        catch (TTransportException e) {
            this.myTransport = null;
            throw e;
        }
    }

    private void initPipe(String pipeName) throws TTransportException {
        this.myTransport = ThriftTransport.openPipeTransport(pipeName);
        this.myProtocol = new TBinaryProtocol(this.myTransport);
        this.myServer = new Server.Client(this.myProtocol);
    }

    public TTransport getTransport() {
        return this.myTransport;
    }

    public boolean isValid() {
        TTransport t = this.myTransport;
        return t != null && t.isOpen();
    }

    public synchronized int connect(boolean asMaster) {
        if (this.myTransport == null) {
            return -1;
        }
        try {
            return ThriftTransport.isTcp() ? this.myServer.connectTcp(ThriftTransport.getJavaHandlersPort(), asMaster) : this.myServer.connect(ThriftTransport.getJavaHandlersPipe(), asMaster);
        }
        catch (TException e) {
            this.onThriftException(e);
            return -1;
        }
    }

    public synchronized void exec(Rpc r) {
        if (this.myTransport == null) {
            return;
        }
        try {
            r.run(this.myServer);
        }
        catch (TException e) {
            this.onThriftException(e);
        }
    }

    public synchronized <T> T execObj(RpcObj<T> r) {
        if (this.myTransport == null) {
            return null;
        }
        try {
            return r.run(this.myServer);
        }
        catch (TException e) {
            this.onThriftException(e);
            return null;
        }
    }

    public synchronized void closeTransport() {
        if (this.myTransport != null) {
            this.myTransport.close();
            this.myTransport = null;
        }
    }

    private void onThriftException(TException e) {
        CefLog.Error("thrift exception '%s'", e.getMessage());
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        CefLog.Error(sw.getBuffer().toString(), new Object[0]);
    }

    public static interface Rpc {
        public void run(Server.Iface var1) throws TException;
    }

    public static interface RpcObj<T> {
        public T run(Server.Iface var1) throws TException;
    }
}

