/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TException;
import org.cef.misc.CefLog;

public abstract class RemoteServerObjectLocal {
    protected final int myId;
    protected final RpcExecutor myServer;
    protected final Map<String, String> myCache = new HashMap<String, String>();

    public RemoteServerObjectLocal(RpcExecutor server, RObject robj) {
        this.myId = robj.objId;
        this.myServer = server;
        if (robj.objInfo != null) {
            this.myCache.putAll(robj.objInfo);
        }
    }

    public abstract void flush();

    protected RObject thriftId() {
        return new RObject(this.myId);
    }

    protected RObject thriftIdWithCache() {
        return new RObject(this.myId).setObjInfo(this.myCache);
    }

    protected void onThriftException(TException e) {
        CefLog.Error("thrift exception '%s'", e.getMessage());
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        CefLog.Error(sw.getBuffer().toString(), new Object[0]);
    }

    protected long getLongVal(String key) {
        return this.getLongVal(key, 0L);
    }

    protected long getLongVal(String key, long def) {
        String sval = this.myCache.get(key);
        if (sval == null || sval.isEmpty()) {
            return def;
        }
        try {
            return Long.parseLong(sval);
        }
        catch (NumberFormatException e) {
            CefLog.Error("not long value: %s -> %s", key, sval);
            return def;
        }
    }

    protected boolean getBoolVal(String key) {
        return this.getBoolVal(key, false);
    }

    protected boolean getBoolVal(String key, boolean def) {
        String sval = this.myCache.get(key);
        if (sval == null || sval.isEmpty()) {
            return def;
        }
        try {
            return Boolean.parseBoolean(sval);
        }
        catch (NumberFormatException e) {
            CefLog.Error("not bool value: %s -> %s", key, sval);
            return def;
        }
    }

    protected void setStrVal(String key, String value) {
        if (value == null || value.isEmpty()) {
            this.myCache.remove(key);
        } else {
            this.myCache.put(key, value);
        }
    }

    protected void setLongVal(String key, long value) {
        this.myCache.put(key, String.valueOf(value));
    }
}

