/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.MultiHandler;
import com.jetbrains.cef.remote.RemoteBrowser;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.network.RemoteRequestContext;
import com.jetbrains.cef.remote.router.RemoteMessageRouter;
import com.jetbrains.cef.remote.router.RemoteMessageRouterImpl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.cef.CefClient;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRendering;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.handler.CefPermissionHandler;
import org.cef.handler.CefPrintHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.misc.CefLog;

public class RemoteClient {
    private static AtomicInteger ourCounter = new AtomicInteger(0);
    private final int myCid;
    private final RpcExecutor myService;
    private final Map<Integer, RemoteBrowser> ourBid2Browser;
    private final Map<Integer, RemoteBrowser> myNativeIdentifier2Browser = new ConcurrentHashMap<Integer, RemoteBrowser>();
    private final List<RemoteBrowser> myBrowsers = Collections.synchronizedList(new ArrayList());
    private CefContextMenuHandler contextMenuHandler_ = null;
    private CefDialogHandler dialogHandler_ = null;
    private CefDisplayHandler displayHandler_ = null;
    private CefDownloadHandler downloadHandler_ = null;
    private CefDragHandler dragHandler_ = null;
    private CefFocusHandler focusHandler_ = null;
    private CefPermissionHandler permissionHandler_ = null;
    private CefJSDialogHandler jsDialogHandler_ = null;
    private CefKeyboardHandler keyboardHandler_ = null;
    private CefPrintHandler printHandler_ = null;
    private CefRequestHandler requestHandler_ = null;
    private CefLoadHandler loadHandler_ = null;
    protected final MultiHandler<CefLifeSpanHandler> hLifeSpan = new MultiHandler();
    private int myHandlersMask = 0;
    private Vector<RemoteMessageRouterImpl> msgRouters = new Vector();

    public RemoteClient(RpcExecutor service, Map<Integer, RemoteBrowser> bid2browser) {
        this.myCid = ourCounter.getAndIncrement();
        this.myService = service;
        this.ourBid2Browser = bid2browser;
    }

    protected void onAfterCreated(RemoteBrowser browser, int nativeBrowserIdentifier) {
        browser.setNativeBrowserCreated(nativeBrowserIdentifier);
        this.myNativeIdentifier2Browser.put(nativeBrowserIdentifier, browser);
        this.hLifeSpan.handle(lsh -> lsh.onAfterCreated(browser));
        CefLog.Debug("Browser %s was created (native server-side part).", browser);
    }

    protected void onBeforeClosed(RemoteBrowser browser) {
        int bid;
        this.hLifeSpan.handle(lsh -> lsh.onBeforeClose(browser));
        if (!this.myBrowsers.remove(browser)) {
            CefLog.Error("Browser %s already was removed.", browser);
        }
        if (this.myNativeIdentifier2Browser.remove(browser.getNativeBrowserIdentifier()) == null) {
            CefLog.Error("Browser with native id %d already was removed.", browser.getNativeBrowserIdentifier());
        }
        if ((bid = browser.getBid()) >= 0) {
            RemoteBrowser removed = this.ourBid2Browser.remove(bid);
            if (removed == null) {
                CefLog.Error("Unregister bid: bid=%d was already removed.", new Object[0]);
            }
        } else {
            CefLog.Error("Can't unregister invalid bid %d", bid);
        }
        browser.onBeforeClose();
        CefLog.Debug("Browser %s was closed (native server-side part).", browser);
    }

    protected void onNewBid(RemoteBrowser browser) {
        int bid = browser.getBid();
        assert (bid >= 0);
        this.ourBid2Browser.put(bid, browser);
    }

    public CefContextMenuHandler getContextMenuHandler() {
        return this.contextMenuHandler_;
    }

    public CefDialogHandler getDialogHandler() {
        return this.dialogHandler_;
    }

    public CefDisplayHandler getDisplayHandler() {
        return this.displayHandler_;
    }

    public CefDownloadHandler getDownloadHandler() {
        return this.downloadHandler_;
    }

    public CefDragHandler getDragHandler() {
        return this.dragHandler_;
    }

    public CefFocusHandler getFocusHandler() {
        return this.focusHandler_;
    }

    public CefPermissionHandler getPermissionHandler() {
        return this.permissionHandler_;
    }

    public CefJSDialogHandler getJSDialogHandler() {
        return this.jsDialogHandler_;
    }

    public CefKeyboardHandler getKeyboardHandler() {
        return this.keyboardHandler_;
    }

    public CefPrintHandler getPrintHandler() {
        return this.printHandler_;
    }

    public CefRequestHandler getRequestHandler() {
        return this.requestHandler_;
    }

    public CefLoadHandler getLoadHandler() {
        return this.loadHandler_;
    }

    public RemoteBrowser getRemoteBrowser(int nativeIdentifier) {
        return this.myNativeIdentifier2Browser.get(nativeIdentifier);
    }

    public RemoteBrowser[] getAllBrowsers() {
        return this.myNativeIdentifier2Browser.values().toArray(new RemoteBrowser[0]);
    }

    public int getCid() {
        return this.myCid;
    }

    public int getHandlersMask() {
        return this.myHandlersMask;
    }

    public RemoteBrowser createBrowser(String url, CefRequestContext context, CefClient client, CefNativeRenderHandler renderHandler, Component component) {
        RemoteRequestContext ctx = null;
        if (context instanceof RemoteRequestContext) {
            ctx = (RemoteRequestContext)context;
        } else if (context != null) {
            CefLog.Error("Unsupported class %s, will be used default (global) request context. Please use RemoteRequestContext.", context.getClass());
        }
        RemoteBrowser browser = new RemoteBrowser(this.myService, this, client, url, ctx);
        browser.setComponent(component, renderHandler);
        this.myBrowsers.add(browser);
        return browser;
    }

    public RemoteBrowser createBrowser(String url, CefRequestContext context, CefClient client, CefRendering rendering) {
        if (rendering instanceof CefRendering.CefRenderingWithHandler) {
            CefRendering.CefRenderingWithHandler rh = (CefRendering.CefRenderingWithHandler)rendering;
            if (rh.getRenderHandler() instanceof CefNativeRenderHandler) {
                return this.createBrowser(url, context, client, (CefNativeRenderHandler)rh.getRenderHandler(), rh.getComponent());
            }
            throw new IllegalStateException("Can't create remote browser with render-handler: " + rh.getRenderHandler());
        }
        throw new IllegalStateException("Can't create remote browser with rendering: " + rendering);
    }

    private void _updateMask(Object handler, int handlerMask) {
        this.myHandlersMask = handler != null ? (this.myHandlersMask |= handlerMask) : (this.myHandlersMask &= ~handlerMask);
    }

    public void addLifeSpanHandler(CefLifeSpanHandler handler) {
        this.hLifeSpan.addHandler(handler);
    }

    public void removeAllLifeSpanHandlers() {
        this.hLifeSpan.removeAllHandlers();
    }

    public void addLoadHandler(CefLoadHandler loadHandler) {
        if (this.loadHandler_ != null && !Objects.equals(this.loadHandler_, loadHandler)) {
            CefLog.Warn("loadHandler_ will be replaced.", new Object[0]);
        }
        this.loadHandler_ = loadHandler;
        this._updateMask(this.loadHandler_, HandlerMasks.Load.val());
    }

    public void removeLoadHandler() {
        this.loadHandler_ = null;
        this._updateMask(this.loadHandler_, HandlerMasks.Load.val());
    }

    public void addDisplayHandler(CefDisplayHandler displayHandler) {
        if (this.displayHandler_ != null && !Objects.equals(this.displayHandler_, displayHandler)) {
            CefLog.Warn("displayHandler_ will be replaced.", new Object[0]);
        }
        this.displayHandler_ = displayHandler;
        this._updateMask(this.displayHandler_, HandlerMasks.Display.val());
    }

    public void removeDisplayHandler() {
        this.displayHandler_ = null;
        this._updateMask(this.displayHandler_, HandlerMasks.Display.val());
    }

    public void addRequestHandler(CefRequestHandler requestHandler) {
        if (this.requestHandler_ != null && !Objects.equals(this.requestHandler_, requestHandler)) {
            CefLog.Warn("requestHandler_ will be replaced.", new Object[0]);
        }
        this.requestHandler_ = requestHandler;
        this._updateMask(this.requestHandler_, HandlerMasks.Request.val());
    }

    public void removeRequestHandler() {
        this.requestHandler_ = null;
        this._updateMask(this.requestHandler_, HandlerMasks.Request.val());
    }

    public void addContextMenuHandler(CefContextMenuHandler handler) {
        if (this.contextMenuHandler_ != null && !Objects.equals(this.contextMenuHandler_, handler)) {
            CefLog.Warn("contextMenuHandler_ will be replaced.", new Object[0]);
        }
        this.contextMenuHandler_ = handler;
        this._updateMask(this.contextMenuHandler_, HandlerMasks.ContextMenu.val());
    }

    public void removeContextMenuHandler() {
        this.contextMenuHandler_ = null;
        this._updateMask(this.contextMenuHandler_, HandlerMasks.ContextMenu.val());
    }

    public void addDialogHandler(CefDialogHandler handler) {
        if (this.dialogHandler_ != null && !Objects.equals(this.dialogHandler_, handler)) {
            CefLog.Warn("dialogHandler_ will be replaced.", new Object[0]);
        }
        this.dialogHandler_ = handler;
        this._updateMask(this.dialogHandler_, HandlerMasks.Dialog.val());
    }

    public void removeDialogHandler() {
        this.dialogHandler_ = null;
        this._updateMask(this.dialogHandler_, HandlerMasks.Dialog.val());
    }

    public void addDownloadHandler(CefDownloadHandler handler) {
        if (this.downloadHandler_ != null && !Objects.equals(this.downloadHandler_, handler)) {
            CefLog.Warn("downloadHandler_ will be replaced.", new Object[0]);
        }
        this.downloadHandler_ = handler;
        this._updateMask(this.downloadHandler_, HandlerMasks.Download.val());
    }

    public void removeDownloadHandler() {
        this.downloadHandler_ = null;
        this._updateMask(this.downloadHandler_, HandlerMasks.Download.val());
    }

    public void addDragHandler(CefDragHandler handler) {
        if (this.dragHandler_ != null && !Objects.equals(this.dragHandler_, handler)) {
            CefLog.Warn("dragHandler_ will be replaced.", new Object[0]);
        }
        this.dragHandler_ = handler;
        this._updateMask(this.dragHandler_, HandlerMasks.Drag.val());
    }

    public void removeDragHandler() {
        this.dragHandler_ = null;
        this._updateMask(this.dragHandler_, HandlerMasks.Drag.val());
    }

    public void addFocusHandler(CefFocusHandler handler) {
        if (this.focusHandler_ != null && !Objects.equals(this.focusHandler_, handler)) {
            CefLog.Warn("focusHandler_ will be replaced.", new Object[0]);
        }
        this.focusHandler_ = handler;
        this._updateMask(this.focusHandler_, HandlerMasks.Focus.val());
    }

    public void removeFocusHandler() {
        this.focusHandler_ = null;
        this._updateMask(this.focusHandler_, HandlerMasks.Focus.val());
    }

    public void addPermissionHandler(CefPermissionHandler handler) {
        if (this.permissionHandler_ != null && !Objects.equals(this.permissionHandler_, handler)) {
            CefLog.Warn("permissionHandler_ will be replaced.", new Object[0]);
        }
        this.permissionHandler_ = handler;
        this._updateMask(this.permissionHandler_, HandlerMasks.Permission.val());
    }

    public void removePermissionHandler() {
        this.permissionHandler_ = null;
        this._updateMask(this.permissionHandler_, HandlerMasks.Permission.val());
    }

    public void addJSDialogHandler(CefJSDialogHandler handler) {
        if (this.jsDialogHandler_ != null && !Objects.equals(this.jsDialogHandler_, handler)) {
            CefLog.Warn("jsDialogHandler_ will be replaced.", new Object[0]);
        }
        this.jsDialogHandler_ = handler;
        this._updateMask(this.jsDialogHandler_, HandlerMasks.JSDialog.val());
    }

    public void removeJSDialogHandler() {
        this.jsDialogHandler_ = null;
        this._updateMask(this.jsDialogHandler_, HandlerMasks.JSDialog.val());
    }

    public void addKeyboardHandler(CefKeyboardHandler handler) {
        if (this.keyboardHandler_ != null && !Objects.equals(this.keyboardHandler_, handler)) {
            CefLog.Warn("keyboardHandler_ will be replaced.", new Object[0]);
        }
        this.keyboardHandler_ = handler;
        this._updateMask(this.keyboardHandler_, HandlerMasks.Keyboard.val());
    }

    public void removeKeyboardHandler() {
        this.keyboardHandler_ = null;
        this._updateMask(this.keyboardHandler_, HandlerMasks.Keyboard.val());
    }

    public void addPrintHandler(CefPrintHandler handler) {
        if (this.printHandler_ != null && !Objects.equals(this.printHandler_, handler)) {
            CefLog.Warn("printHandler_ will be replaced.", new Object[0]);
        }
        this.printHandler_ = handler;
        this._updateMask(this.printHandler_, HandlerMasks.Print.val());
    }

    public void removePrintHandler() {
        this.printHandler_ = null;
        this._updateMask(this.printHandler_, HandlerMasks.Print.val());
    }

    public void addMessageRouter(CefMessageRouter messageRouter) {
        RemoteMessageRouter router = (RemoteMessageRouter)messageRouter;
        this.msgRouters.add(router.getImpl());
        this.myBrowsers.forEach(rb -> {
            int bid;
            int n = bid = rb != null ? rb.getBid() : -1;
            if (bid >= 0) {
                router.getImpl().addToBrowser(bid);
            }
        });
    }

    public void removeMessageRouter(CefMessageRouter messageRouter) {
        RemoteMessageRouter router = (RemoteMessageRouter)messageRouter;
        this.myBrowsers.forEach(rb -> {
            int bid;
            int n = bid = rb != null ? rb.getBid() : -1;
            if (bid >= 0) {
                router.getImpl().removeFromBrowser(bid);
            }
        });
        this.msgRouters.remove(router.getImpl());
    }

    public void dispose() {
        CefLog.Debug("RemoteClient: dispose cid=%d", this.myCid);
        this.msgRouters.clear();
        this.myBrowsers.forEach(rb -> {
            if (rb != null && !rb.isClosed()) {
                rb.close(true);
            }
        });
        this.myBrowsers.clear();
    }

    public String toString() {
        return "RemoteClient_" + this.myCid;
    }

    static enum HandlerMasks {
        Request(1),
        NativeRender(2),
        Load(4),
        ContextMenu(16),
        Dialog(32),
        Display(64),
        Focus(128),
        Permission(256),
        JSDialog(512),
        Keyboard(1024),
        Print(2048),
        Download(4096),
        Drag(8192);

        private final int maskVal;

        private HandlerMasks(int maskVal) {
            this.maskVal = maskVal;
        }

        int val() {
            return this.maskVal;
        }

        static String toString(int mask) {
            Object result = "Lifespan";
            for (HandlerMasks m : HandlerMasks.values()) {
                if ((m.val() & mask) == 0) continue;
                result = (String)result + ", " + m.name();
            }
            return result;
        }
    }
}

