/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.WindowsPipeSocket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class NativeServerManager {
    private static final String ALT_CEF_SERVER_PATH = Utils.getString("ALT_CEF_SERVER_PATH");
    private static final boolean CHECK_PROCESS_ALIVE = Utils.getBoolean("JCEF_CHECK_PROCESS_ALIVE", true);
    private static Process ourNativeServerProcess = null;

    public static boolean startProcessAndWait(CefAppHandler appHandler, CefSettings settings, long timeoutMs) {
        File serverExe;
        PrintStream ps;
        Path pipeName = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("cef_server_params.txt");
        File f = new File(pipeName.toString());
        try {
            new FileOutputStream(f).close();
            f.createNewFile();
            ps = new PrintStream(new FileOutputStream(f, false));
        }
        catch (IOException e) {
            CefLog.Error("Can't create temp file with server params path=%s, msg=%s", pipeName.toString(), e.getMessage());
            return false;
        }
        String sectionCmdLine = "[COMMAND_LINE]:";
        ps.printf("%s\n", "[COMMAND_LINE]:");
        if (appHandler instanceof CefAppHandlerAdapter) {
            CefAppHandlerAdapter h = (CefAppHandlerAdapter)appHandler;
            String[] commandLineArgs = h.getArgs();
            if (commandLineArgs != null && commandLineArgs.length > 0) {
                for (String arg : commandLineArgs) {
                    ps.printf("%s\n", arg);
                }
            }
        } else if (appHandler != null) {
            CefLog.Error("Unsupported class of CefAppHandler %s. Overridden command-line arguments will be ignored.", CefAppHandler.class);
        }
        ps.printf("[SETTINGS]:\n", new Object[0]);
        if (settings != null) {
            Map<String, String> settingsMap = settings.toMap();
            for (Map.Entry entry : settingsMap.entrySet()) {
                if (OS.isMacintosh() && "browser_subprocess_path".equals(entry.getKey())) {
                    CefLog.Warn("Skip setting browser_subprocess_path=%s, will be replaced with calculated path.", entry.getValue());
                    continue;
                }
                ps.printf("%s=%s\n", entry.getKey(), entry.getValue());
            }
        }
        if (OS.isMacintosh() && (serverExe = NativeServerManager.getServerExe()) != null) {
            File contents = serverExe.getParentFile().getParentFile();
            ps.printf("browser_subprocess_path=%s\n", contents.getAbsolutePath() + "/Frameworks/cef_server Helper.app/Contents/MacOS/cef_server Helper");
        }
        ps.printf("[CUSTOM_SCHEMES]:\n", new Object[0]);
        if (appHandler != null) {
            CefSchemeRegistrar collector = new CefSchemeRegistrar(){

                @Override
                public boolean addCustomScheme(String schemeName, boolean isStandard, boolean isLocal, boolean isDisplayIsolated, boolean isSecure, boolean isCorsEnabled, boolean isCspBypassing, boolean isFetchEnabled) {
                    int options = 0;
                    if (isStandard) {
                        options |= 1;
                    }
                    if (isLocal) {
                        options |= 2;
                    }
                    if (isDisplayIsolated) {
                        options |= 4;
                    }
                    if (isSecure) {
                        options |= 8;
                    }
                    if (isCorsEnabled) {
                        options |= 0x10;
                    }
                    if (isCspBypassing) {
                        options |= 0x20;
                    }
                    if (isFetchEnabled) {
                        options |= 0x40;
                    }
                    ps.printf("%s|%d\n", schemeName, options);
                    return false;
                }
            };
            appHandler.onRegisterCustomSchemes(collector);
        }
        ps.flush();
        ps.close();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String line = reader.readLine();
            if (line == null || line.isEmpty() || !line.contains("[COMMAND_LINE]:")) {
                CefLog.Error("Write errors (when write temp file with server params), was written:", new Object[0]);
                while (line != null) {
                    CefLog.Error("\t%s", line);
                    line = reader.readLine();
                }
            }
            reader.close();
        }
        catch (IOException e) {
            CefLog.Error("Can't read temp file with server params: %s", e.getMessage());
        }
        return NativeServerManager.startProcessAndWait(f.getAbsolutePath(), timeoutMs);
    }

    public static boolean isProcessAlive() {
        Process p = ourNativeServerProcess;
        return p != null && p.isAlive();
    }

    private static boolean isConnectable(boolean withDebug) {
        try {
            if (ThriftTransport.isTcp()) {
                try {
                    TSocket socket = new TSocket("localhost", ThriftTransport.getServerPort());
                    socket.open();
                    socket.close();
                    if (withDebug) {
                        CefLog.Debug("isConnectable: tcp-port %d, opened and connected.", ThriftTransport.getServerPort());
                    }
                    return true;
                }
                catch (TTransportException e) {
                    if (withDebug) {
                        CefLog.Debug("isConnectable: tcp-port %d, TTransportException occurred: %s", ThriftTransport.getServerPort(), e.getMessage());
                    }
                    return false;
                }
            }
            try {
                if (OS.isWindows()) {
                    WindowsPipeSocket pipe = new WindowsPipeSocket(ThriftTransport.getServerPipe());
                    pipe.close();
                    if (withDebug) {
                        CefLog.Debug("isConnectable: win-pipe '%s', opened and connected.", ThriftTransport.getServerPipe());
                    }
                    return true;
                }
                UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(ThriftTransport.getServerPipe());
                SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);
                channel.connect(socketAddress);
                channel.close();
                if (withDebug) {
                    CefLog.Debug("isConnectable: pipe '%s', opened and connected.", ThriftTransport.getServerPipe());
                }
                return true;
            }
            catch (IOException e) {
                if (withDebug) {
                    CefLog.Debug("isConnectable: pipe '%s', IOException occurred: %s", ThriftTransport.getServerPipe(), e.getMessage());
                }
            }
        }
        catch (Throwable e) {
            CefLog.Error("isConnectable: exception %s", e.getMessage());
        }
        return false;
    }

    private static boolean isServerSocketBusy(boolean withDebug) {
        block6: {
            try {
                if (!ThriftTransport.isTcp()) break block6;
                TServerSocket serverSocket = null;
                try {
                    serverSocket = new TServerSocket(ThriftTransport.getServerPort());
                }
                catch (TTransportException e) {
                    if (withDebug) {
                        CefLog.Debug("isServerTransportBusy: tcp-port %d, TTransportException occurred: %s", ThriftTransport.getServerPort(), e.getMessage());
                    }
                    return true;
                }
                if (withDebug) {
                    CefLog.Debug("isServerTransportBusy: tcp-port %d, opened and connected.", ThriftTransport.getServerPort());
                }
                serverSocket.close();
            }
            catch (Throwable e) {
                CefLog.Error("isServerSocketBusy: exception %s", e.getMessage());
            }
        }
        return false;
    }

    public static boolean isRunning() {
        return NativeServerManager.isRunning(false);
    }

    public static boolean isRunning(boolean withDebug) {
        if (CHECK_PROCESS_ALIVE && ourNativeServerProcess != null && !ourNativeServerProcess.isAlive()) {
            if (withDebug) {
                CefLog.Debug("isRunning: server process is not alive.", new Object[0]);
            }
            return false;
        }
        try {
            boolean result;
            RpcExecutor test;
            if (ThriftTransport.isTcp() && !NativeServerManager.isServerSocketBusy(withDebug)) {
                return false;
            }
            if (!NativeServerManager.isConnectable(withDebug)) {
                return false;
            }
            try {
                test = new RpcExecutor().openTransport();
            }
            catch (TTransportException e) {
                if (withDebug) {
                    CefLog.Debug("isRunning: TTransportException occurred when open server transport: %s", e.getMessage());
                }
                return false;
            }
            String testMsg = "test_message786";
            String echoMsg = test.execObj(s -> s.echo(testMsg));
            test.closeTransport();
            boolean bl = result = echoMsg != null && echoMsg.equals(testMsg);
            if (!result) {
                CefLog.Error("isRunning: cef_server seems to be running, but echo is incorrect: '%s' (original '%s')", echoMsg, testMsg);
            } else if (withDebug) {
                CefLog.Debug("isRunning: cef_server is running and echo is correct.", new Object[0]);
            }
            return result;
        }
        catch (Throwable e) {
            CefLog.Error("isRunning: exception %s", e.getMessage());
            return false;
        }
    }

    public static String getServerState() {
        try {
            RpcExecutor test = new RpcExecutor().openTransport();
            String state2 = test.execObj(s -> s.state());
            test.closeTransport();
            return state2;
        }
        catch (TTransportException e) {
            return "stopped";
        }
    }

    public static boolean stopAndWait(long timeoutMs) {
        CefLog.Debug("Stop running cef_server instance.", new Object[0]);
        try {
            RpcExecutor test = new RpcExecutor().openTransport();
            String state2 = test.execObj(s -> s.state());
            CefLog.Debug("Server state before stop: %s", state2);
            test.exec(s -> s.stop());
            test.closeTransport();
        }
        catch (TTransportException e) {
            CefLog.Debug("Exception when trying to stop server, err: %s", e.getMessage());
        }
        boolean stopped = NativeServerManager.waitForStopped(timeoutMs);
        if (!stopped) {
            CefLog.Error("Can't stop server in %d ms (process is %s)", timeoutMs, NativeServerManager.isProcessAlive() ? "alive" : "dead");
            CefLog.Debug("Server state: %s", NativeServerManager.getServerState());
            return false;
        }
        ourNativeServerProcess = null;
        return true;
    }

    public static boolean waitForRunning(long timeoutMs) {
        return NativeServerManager.waitFor(NativeServerManager::isRunning, timeoutMs, "starting");
    }

    public static boolean waitForStopped(long timeoutMs) {
        return NativeServerManager.waitFor(() -> !NativeServerManager.isRunning(), timeoutMs, "stopping");
    }

    private static boolean waitFor(BooleanSupplier checker, long timeoutMs, String hint) {
        boolean success;
        long startNs = System.nanoTime();
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            CefLog.Debug("Waiting for server %s", hint);
        } while (!(success = checker.getAsBoolean()) && System.nanoTime() - startNs < timeoutMs * 1000000L);
        return success;
    }

    private static File getServerExe() {
        boolean isJava;
        ProcessHandle.Info i = ProcessHandle.current().info();
        String cmd = i.command().get();
        if (cmd == null || cmd.isEmpty()) {
            CefLog.Error("Can't determine cef_server location because process command is empty.", new Object[0]);
            return null;
        }
        boolean bl = isJava = OS.isWindows() ? cmd.endsWith("java.exe") : cmd.endsWith("java");
        if (isJava) {
            File javabin = new File(cmd);
            if (OS.isMacintosh()) {
                return new File(javabin.getParentFile().getParentFile().getParentFile(), "Frameworks/cef_server.app/Contents/MacOS/cef_server");
            }
            if (OS.isLinux()) {
                return new File(javabin.getParentFile().getParentFile(), "lib/cef_server");
            }
            return new File(javabin.getParentFile(), "cef_server.exe");
        }
        CefLog.Info("Java is started via native launcher %s, cef_server from bundled jbr will be used.", cmd);
        File launcher = new File(cmd);
        if (OS.isMacintosh()) {
            return new File(launcher.getParentFile().getParentFile(), "jbr/Contents/Frameworks/cef_server.app/Contents/MacOS/cef_server");
        }
        if (OS.isLinux()) {
            return new File(launcher.getParentFile().getParentFile(), "jbr/lib/cef_server");
        }
        return new File(new File(new File(launcher.getParentFile().getParentFile(), "jbr"), "bin"), "cef_server.exe");
    }

    private static boolean startProcessAndWait(String paramsPath, long timeoutMs) {
        File serverExe;
        if (ourNativeServerProcess != null) {
            CefLog.Debug("Handle of server process will be overwritten.", new Object[0]);
        }
        ourNativeServerProcess = null;
        if (ALT_CEF_SERVER_PATH == null || ALT_CEF_SERVER_PATH.isEmpty()) {
            serverExe = NativeServerManager.getServerExe();
            if (serverExe == null) {
                return false;
            }
        } else {
            serverExe = new File(ALT_CEF_SERVER_PATH.trim());
        }
        CefLog.Debug("Start native cef_server, path='%s', params path='%s'", serverExe.getAbsolutePath(), paramsPath);
        if (!serverExe.exists()) {
            CefLog.Error("Can't start native cef_server, file doesn't exist: %s", serverExe.getAbsolutePath());
            return false;
        }
        ProcessBuilder builder = new ProcessBuilder(serverExe.getAbsolutePath());
        CefLog.Debug("\tWorking dir %s", serverExe.getParentFile());
        builder.directory(serverExe.getParentFile());
        if (ThriftTransport.isTcp()) {
            CefLog.Debug("\tUse tcp-port %d", ThriftTransport.getServerPort());
            builder.command().add(String.format("--port=%d", ThriftTransport.getServerPort()));
        } else {
            CefLog.Debug("\tUse pipe %s", ThriftTransport.getServerPipe());
            builder.command().add(String.format("--pipe=%s", ThriftTransport.getServerPipe()));
        }
        String serverLog = Utils.getString("CEF_SERVER_LOG_PATH");
        if (serverLog != null && !serverLog.isEmpty()) {
            CefLog.Debug("\tLog file %s", serverLog);
            builder.command().add(String.format("--logfile=%s", serverLog.trim()));
        }
        builder.command().add(String.format("--params=%s", paramsPath));
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            ourNativeServerProcess = builder.start();
        }
        catch (IOException e) {
            CefLog.Error("Can't start native cef_server, exception: %s", e.getMessage());
            return false;
        }
        boolean running = NativeServerManager.waitForRunning(timeoutMs);
        if (!running && !(running = NativeServerManager.isRunning(true))) {
            if (ourNativeServerProcess.isAlive()) {
                CefLog.Error("Native cef_server was started but client can't connect.", new Object[0]);
            } else {
                CefLog.Error("Can't start native cef_server, process is dead.", new Object[0]);
                ourNativeServerProcess = null;
            }
        }
        return running;
    }
}

