/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.compose.zoom;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.runtime.Immutable;
import com.github.panpf.zoomimage.zoom.BaseZoomAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/github/panpf/zoomimage/compose/zoom/ZoomAnimationSpec;", "Lcom/github/panpf/zoomimage/zoom/BaseZoomAnimationSpec;", "durationMillis", "", "easing", "Landroidx/compose/animation/core/Easing;", "initialVelocity", "", "<init>", "(ILandroidx/compose/animation/core/Easing;F)V", "getDurationMillis", "()I", "getEasing", "()Landroidx/compose/animation/core/Easing;", "getInitialVelocity", "()F", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "zoomimage-compose"})
@Immutable
public final class ZoomAnimationSpec
implements BaseZoomAnimationSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int durationMillis;
    @NotNull
    private final Easing easing;
    private final float initialVelocity;
    public static final int $stable;
    private static final int DEFAULT_DURATION_MILLIS;
    @NotNull
    private static final ZoomAnimationSpec Default;
    @NotNull
    private static final ZoomAnimationSpec None;

    public ZoomAnimationSpec(int durationMillis, @NotNull Easing easing, float initialVelocity) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.durationMillis = durationMillis;
        this.easing = easing;
        this.initialVelocity = initialVelocity;
    }

    public /* synthetic */ ZoomAnimationSpec(int n, Easing easing, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = DEFAULT_DURATION_MILLIS;
        }
        if ((n2 & 2) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        if ((n2 & 4) != 0) {
            f = 0.0f;
        }
        this(n, easing, f);
    }

    public int getDurationMillis() {
        return this.durationMillis;
    }

    @NotNull
    public final Easing getEasing() {
        return this.easing;
    }

    public final float getInitialVelocity() {
        return this.initialVelocity;
    }

    public final int component1() {
        return this.durationMillis;
    }

    @NotNull
    public final Easing component2() {
        return this.easing;
    }

    public final float component3() {
        return this.initialVelocity;
    }

    @NotNull
    public final ZoomAnimationSpec copy(int durationMillis, @NotNull Easing easing, float initialVelocity) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        return new ZoomAnimationSpec(durationMillis, easing, initialVelocity);
    }

    public static /* synthetic */ ZoomAnimationSpec copy$default(ZoomAnimationSpec zoomAnimationSpec, int n, Easing easing, float f, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = zoomAnimationSpec.durationMillis;
        }
        if ((n2 & 2) != 0) {
            easing = zoomAnimationSpec.easing;
        }
        if ((n2 & 4) != 0) {
            f = zoomAnimationSpec.initialVelocity;
        }
        return zoomAnimationSpec.copy(n, easing, f);
    }

    @NotNull
    public String toString() {
        return "ZoomAnimationSpec(durationMillis=" + this.durationMillis + ", easing=" + this.easing + ", initialVelocity=" + this.initialVelocity + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.durationMillis);
        result = result * 31 + this.easing.hashCode();
        result = result * 31 + Float.hashCode(this.initialVelocity);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ZoomAnimationSpec)) {
            return false;
        }
        ZoomAnimationSpec zoomAnimationSpec = (ZoomAnimationSpec)other;
        if (this.durationMillis != zoomAnimationSpec.durationMillis) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.easing, (Object)zoomAnimationSpec.easing)) {
            return false;
        }
        return Float.compare(this.initialVelocity, zoomAnimationSpec.initialVelocity) == 0;
    }

    public ZoomAnimationSpec() {
        this(0, null, 0.0f, 7, null);
    }

    static {
        DEFAULT_DURATION_MILLIS = BaseZoomAnimationSpec.Companion.getDEFAULT_DURATION_MILLIS();
        Default = new ZoomAnimationSpec(0, null, 0.0f, 7, null);
        None = new ZoomAnimationSpec(0, null, 0.0f, 6, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/github/panpf/zoomimage/compose/zoom/ZoomAnimationSpec$Companion;", "", "<init>", "()V", "DEFAULT_DURATION_MILLIS", "", "getDEFAULT_DURATION_MILLIS", "()I", "Default", "Lcom/github/panpf/zoomimage/compose/zoom/ZoomAnimationSpec;", "getDefault", "()Lcom/github/panpf/zoomimage/compose/zoom/ZoomAnimationSpec;", "None", "getNone", "zoomimage-compose"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_DURATION_MILLIS() {
            return DEFAULT_DURATION_MILLIS;
        }

        @NotNull
        public final ZoomAnimationSpec getDefault() {
            return Default;
        }

        @NotNull
        public final ZoomAnimationSpec getNone() {
            return None;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

