/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.compose.subsampling;

import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntSize;
import com.github.panpf.zoomimage.compose.subsampling.ComposeTileImage;
import com.github.panpf.zoomimage.compose.subsampling.SubsamplingState;
import com.github.panpf.zoomimage.compose.subsampling.Subsampling_nonAndroidKt;
import com.github.panpf.zoomimage.compose.util.Compose_convert_utilsKt;
import com.github.panpf.zoomimage.compose.util.Compose_platform_utilsKt;
import com.github.panpf.zoomimage.compose.zoom.ZoomableState;
import com.github.panpf.zoomimage.subsampling.SubsamplingImage;
import com.github.panpf.zoomimage.subsampling.TileImage;
import com.github.panpf.zoomimage.subsampling.TileSnapshot;
import com.github.panpf.zoomimage.subsampling.Tile_colorKt;
import com.github.panpf.zoomimage.util.IntRectCompat;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/panpf/zoomimage/compose/subsampling/SubsamplingDrawTilesNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/DrawModifierNode;", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "zoomable", "Lcom/github/panpf/zoomimage/compose/zoom/ZoomableState;", "subsampling", "Lcom/github/panpf/zoomimage/compose/subsampling/SubsamplingState;", "<init>", "(Lcom/github/panpf/zoomimage/compose/zoom/ZoomableState;Lcom/github/panpf/zoomimage/compose/subsampling/SubsamplingState;)V", "getZoomable", "()Lcom/github/panpf/zoomimage/compose/zoom/ZoomableState;", "setZoomable", "(Lcom/github/panpf/zoomimage/compose/zoom/ZoomableState;)V", "getSubsampling", "()Lcom/github/panpf/zoomimage/compose/subsampling/SubsamplingState;", "setSubsampling", "(Lcom/github/panpf/zoomimage/compose/subsampling/SubsamplingState;)V", "tilePaint", "Landroidx/compose/ui/graphics/Paint;", "boundsPaint", "update", "", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "drawTile", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "tileSnapshot", "Lcom/github/panpf/zoomimage/subsampling/TileSnapshot;", "drawBounds", "zoomimage-compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nsubsampling.common.kt\nKotlin\n*S Kotlin\n*F\n+ 1 subsampling.common.kt\ncom/github/panpf/zoomimage/compose/subsampling/SubsamplingDrawTilesNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,185:1\n1#2:186\n1869#3,2:187\n1869#3,2:189\n30#4:191\n80#5:192\n*S KotlinDebug\n*F\n+ 1 subsampling.common.kt\ncom/github/panpf/zoomimage/compose/subsampling/SubsamplingDrawTilesNode\n*L\n117#1:187,2\n127#1:189,2\n161#1:191\n161#1:192\n*E\n"})
public final class SubsamplingDrawTilesNode
extends Modifier.Node
implements DrawModifierNode,
CompositionLocalConsumerModifierNode {
    @NotNull
    private ZoomableState zoomable;
    @NotNull
    private SubsamplingState subsampling;
    @NotNull
    private final Paint tilePaint;
    @NotNull
    private final Paint boundsPaint;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SubsamplingDrawTilesNode(@NotNull ZoomableState zoomable, @NotNull SubsamplingState subsampling) {
        void $this$boundsPaint_u24lambda_u241;
        Paint $this$tilePaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)zoomable, (String)"zoomable");
        Intrinsics.checkNotNullParameter((Object)subsampling, (String)"subsampling");
        this.zoomable = zoomable;
        this.subsampling = subsampling;
        Paint paint2 = paint = SkiaBackedPaint_skikoKt.Paint();
        SubsamplingDrawTilesNode subsamplingDrawTilesNode = this;
        boolean bl = false;
        $this$tilePaint_u24lambda_u240.setAntiAlias(!Subsampling_nonAndroidKt.isCloseAntiAliasForDrawTile());
        subsamplingDrawTilesNode.tilePaint = paint;
        $this$tilePaint_u24lambda_u240 = paint = SkiaBackedPaint_skikoKt.Paint();
        subsamplingDrawTilesNode = this;
        boolean bl2 = false;
        $this$boundsPaint_u24lambda_u241.setStyle-k9PVt8s(PaintingStyle.Companion.getStroke-TiuSbCo());
        subsamplingDrawTilesNode.boundsPaint = paint;
    }

    @NotNull
    public final ZoomableState getZoomable() {
        return this.zoomable;
    }

    public final void setZoomable(@NotNull ZoomableState zoomableState) {
        Intrinsics.checkNotNullParameter((Object)zoomableState, (String)"<set-?>");
        this.zoomable = zoomableState;
    }

    @NotNull
    public final SubsamplingState getSubsampling() {
        return this.subsampling;
    }

    public final void setSubsampling(@NotNull SubsamplingState subsamplingState) {
        Intrinsics.checkNotNullParameter((Object)subsamplingState, (String)"<set-?>");
        this.subsampling = subsamplingState;
    }

    public final void update(@NotNull ZoomableState zoomable, @NotNull SubsamplingState subsampling) {
        Intrinsics.checkNotNullParameter((Object)zoomable, (String)"zoomable");
        Intrinsics.checkNotNullParameter((Object)subsampling, (String)"subsampling");
        this.zoomable = zoomable;
        this.subsampling = subsampling;
        DrawModifierNodeKt.invalidateDraw((DrawModifierNode)this);
    }

    public void draw(@NotNull ContentDrawScope $this$draw) {
        IntRect intRect;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        $this$draw.drawContent();
        if (Compose_platform_utilsKt.isEmpty-ozmzZPI(this.zoomable.getContainerSize-YbymL2g())) {
            return;
        }
        if (Compose_platform_utilsKt.isEmpty-ozmzZPI(this.zoomable.getContentSize-YbymL2g())) {
            return;
        }
        IntRect it = intRect = this.subsampling.getForegroundTiles();
        boolean bl = false;
        Object object = !((Collection)it).isEmpty() ? intRect : null;
        if (object == null) {
            return;
        }
        IntRect foregroundTiles = object;
        IntRect it2 = it = this.subsampling.getImageLoadRect();
        boolean bl2 = false;
        Object object2 = intRect = !it2.isEmpty() ? it : null;
        if (intRect == null || (it = Compose_convert_utilsKt.toCompat(intRect)) == null) {
            return;
        }
        IntRect imageLoadRect = it;
        List<TileSnapshot> backgroundTiles = this.subsampling.getBackgroundTiles();
        boolean showTileBounds = this.subsampling.getShowTileBounds();
        Canvas canvas = $this$draw.getDrawContext().getCanvas();
        Ref.IntRef backgroundCount = new Ref.IntRef();
        Ref.IntRef insideLoadCount = new Ref.IntRef();
        Ref.IntRef outsideLoadCount = new Ref.IntRef();
        Ref.IntRef realDrawCount = new Ref.IntRef();
        Iterable $this$forEach$iv = backgroundTiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TileSnapshot tileSnapshot = (TileSnapshot)element$iv;
            boolean bl3 = false;
            if (!tileSnapshot.getSrcRect().overlaps((IntRectCompat)imageLoadRect) || !this.drawTile(canvas, tileSnapshot, false)) continue;
            int n = backgroundCount.element;
            backgroundCount.element = n + 1;
        }
        Density density = (Density)CompositionLocalConsumerModifierNodeKt.currentValueOf((CompositionLocalConsumerModifierNode)this, (CompositionLocal)((CompositionLocal)CompositionLocalsKt.getLocalDensity()));
        this.boundsPaint.setStrokeWidth(0.5f * density.getDensity());
        Iterable $this$forEach$iv2 = (Iterable)foregroundTiles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            int n;
            TileSnapshot tileSnapshot = (TileSnapshot)element$iv;
            boolean bl4 = false;
            if (tileSnapshot.getSrcRect().overlaps((IntRectCompat)imageLoadRect)) {
                n = insideLoadCount.element;
                insideLoadCount.element = n + 1;
                if (!this.drawTile(canvas, tileSnapshot, showTileBounds)) continue;
                n = realDrawCount.element;
                realDrawCount.element = n + 1;
                continue;
            }
            n = outsideLoadCount.element;
            outsideLoadCount.element = n + 1;
        }
        this.subsampling.getLogger().v(() -> SubsamplingDrawTilesNode.draw$lambda$6((List)foregroundTiles, insideLoadCount, outsideLoadCount, realDrawCount, backgroundCount, this));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean drawTile(Canvas canvas, TileSnapshot tileSnapshot, boolean drawBounds) {
        void width$iv;
        Object object;
        block5: {
            block4: {
                TileImage tileImage;
                object = tileSnapshot.getTileImage();
                if (object == null) break block4;
                TileImage it = tileImage = object;
                boolean bl = false;
                object = !it.isRecycled() ? tileImage : null;
                if (object != null) break block5;
            }
            return false;
        }
        TileImage tileImage = object;
        ImageBitmap imageBitmap = ((ComposeTileImage)tileImage).getBitmap();
        IntRect dstRect = Compose_convert_utilsKt.toPlatform(tileSnapshot.getSrcRect());
        this.tilePaint.setAlpha((float)tileSnapshot.getAlpha() / 255.0f);
        int n = imageBitmap.getWidth();
        int height$iv = imageBitmap.getHeight();
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        canvas.drawImageRect-HPBpro0(imageBitmap, IntOffset.Companion.getZero-nOcc-ac(), IntSize.constructor-impl((long)((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL)), dstRect.getTopLeft-nOcc-ac(), dstRect.getSize-YbymL2g(), this.tilePaint);
        if (drawBounds) {
            int boundsColor = Tile_colorKt.tileColor((int)tileSnapshot.getState(), (int)tileSnapshot.getFrom(), (boolean)true);
            this.boundsPaint.setColor-8_81llA(ColorKt.Color((int)boundsColor));
            canvas.drawRect((float)dstRect.getLeft(), (float)dstRect.getTop(), (float)dstRect.getRight(), (float)dstRect.getBottom(), this.boundsPaint);
        }
        return true;
    }

    private static final String draw$lambda$6(List $foregroundTiles, Ref.IntRef $insideLoadCount, Ref.IntRef $outsideLoadCount, Ref.IntRef $realDrawCount, Ref.IntRef $backgroundCount, SubsamplingDrawTilesNode this$0) {
        SubsamplingImage subsamplingImage = this$0.subsampling.getSubsamplingImage();
        return "SubsamplingState. drawTiles. tiles=" + $foregroundTiles.size() + ", insideLoadCount=" + $insideLoadCount.element + ", outsideLoadCount=" + $outsideLoadCount.element + ", realDrawCount=" + $realDrawCount.element + ", backgroundCount=" + $backgroundCount.element + ". '" + (subsamplingImage != null ? subsamplingImage.getKey() : null) + "'";
    }
}

