/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.client.shared.cache.internal;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingSource;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.client.shared.cache.internal.DiskLruCacheKt;
import vet.inpulse.core.client.shared.cache.internal.FaultHidingSink;
import vet.inpulse.shared.log.CoreLogModuleKt;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010)\n\u0002\b\u0005\u0018\u0000 a2\u00060\u0001j\u0002`\u0002:\u0004^_`aB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010:\u001a\u00020;H\u0002J\u0006\u0010<\u001a\u00020;J\b\u0010=\u001a\u00020;H\u0002J\b\u0010>\u001a\u00020#H\u0002J\u0010\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020&H\u0002J\b\u0010A\u001a\u00020;H\u0002J\r\u0010B\u001a\u00020;H\u0000\u00a2\u0006\u0002\bCJ\u0017\u0010D\u001a\b\u0018\u00010ER\u00020\u00002\u0006\u0010F\u001a\u00020&H\u0086\u0002J\u001e\u0010G\u001a\b\u0018\u00010HR\u00020\u00002\u0006\u0010F\u001a\u00020&2\b\b\u0002\u0010I\u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u000bJ!\u0010J\u001a\u00020;2\n\u0010K\u001a\u00060HR\u00020\u00002\u0006\u0010L\u001a\u00020-H\u0000\u00a2\u0006\u0002\bMJ\b\u0010N\u001a\u00020-H\u0002J\u000e\u0010O\u001a\u00020-2\u0006\u0010F\u001a\u00020&J\u0019\u0010P\u001a\u00020-2\n\u0010Q\u001a\u00060'R\u00020\u0000H\u0000\u00a2\u0006\u0002\bRJ\b\u0010S\u001a\u00020;H\u0002J\u0006\u0010T\u001a\u00020;J\u0006\u0010U\u001a\u00020-J\b\u0010V\u001a\u00020;H\u0016J\u0006\u0010W\u001a\u00020;J\b\u0010X\u001a\u00020-H\u0002J\u0006\u0010Y\u001a\u00020;J\u0006\u0010Z\u001a\u00020;J\u0010\u0010[\u001a\u00020;2\u0006\u0010F\u001a\u00020&H\u0002J\u0010\u0010\\\u001a\f\u0012\b\u0012\u00060ER\u00020\u00000]R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010$\u001a&\u0012\u0004\u0012\u00020&\u0012\b\u0012\u00060'R\u00020\u00000%j\u0012\u0012\u0004\u0012\u00020&\u0012\b\u0012\u00060'R\u00020\u0000`(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u00020-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;", "Ljava/io/Closeable;", "Lokio/Closeable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "appVersion", "", "valueCount", "maxSize", "", "<init>", "(Lokio/FileSystem;Lokio/Path;IIJ)V", "getFileSystem", "()Lokio/FileSystem;", "getDirectory", "()Lokio/Path;", "getValueCount", "()I", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "value", "getMaxSize", "()J", "setMaxSize", "(J)V", "journalFile", "journalFileTmp", "journalFileBackup", "size", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Entry;", "Lkotlin/collections/LinkedHashMap;", "getLruEntries$core_client_shared", "()Ljava/util/LinkedHashMap;", "redundantOpCount", "hasJournalErrors", "", "civilizedFileSystem", "initialized", "closed", "getClosed$core_client_shared", "()Z", "setClosed$core_client_shared", "(Z)V", "mostRecentTrimFailed", "mostRecentRebuildFailed", "nextSequenceNumber", "cleanupJob", "Lkotlinx/coroutines/Job;", "launchCleanupTask", "", "initialize", "readJournal", "newJournalWriter", "readJournalLine", "line", "processJournal", "rebuildJournal", "rebuildJournal$core_client_shared", "get", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Snapshot;", "key", "edit", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Editor;", "expectedSequenceNumber", "completeEdit", "editor", "success", "completeEdit$core_client_shared", "journalRebuildRequired", "remove", "removeEntry", "entry", "removeEntry$core_client_shared", "checkNotClosed", "flush", "isClosed", "close", "trimToSize", "removeOldestEntry", "delete", "evictAll", "validateKey", "snapshots", "", "Snapshot", "Editor", "Entry", "Companion", "core-client-shared"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nvet/inpulse/core/client/shared/cache/internal/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1041:1\n1#2:1042\n72#3:1043\n58#3,22:1044\n72#3:1066\n58#3,22:1067\n37#4,2:1089\n37#4,2:1091\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nvet/inpulse/core/client/shared/cache/internal/DiskLruCache\n*L\n207#1:1043\n207#1:1044,22\n331#1:1066\n331#1:1067,22\n625#1:1089,2\n673#1:1091,2\n*E\n"})
public final class DiskLruCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path directory;
    private final int appVersion;
    private final int valueCount;
    @NotNull
    private final Object lock;
    @NotNull
    private final LoggerInterface logger;
    private long maxSize;
    @NotNull
    private final Path journalFile;
    @NotNull
    private final Path journalFileTmp;
    @NotNull
    private final Path journalFileBackup;
    private long size;
    @Nullable
    private BufferedSink journalWriter;
    @NotNull
    private final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean civilizedFileSystem;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    @Nullable
    private Job cleanupJob;
    @NotNull
    private static final String JOURNAL_FILE = "journal";
    @NotNull
    private static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @NotNull
    private static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    private static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    private static final String VERSION_1 = "1";
    private static final long ANY_SEQUENCE_NUMBER = -1L;
    @NotNull
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";

    public DiskLruCache(@NotNull FileSystem fileSystem, @NotNull Path directory, int appVersion, int valueCount, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        this.lock = new Object();
        this.logger = CoreLogModuleKt.getCoreLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.maxSize = maxSize;
        this.lruEntries = new LinkedHashMap(0, 0.75f);
        if (!(maxSize > 0L)) {
            boolean $i$a$-require-DiskLruCache$32 = false;
            String $i$a$-require-DiskLruCache$32 = "maxSize <= 0";
            throw new IllegalArgumentException($i$a$-require-DiskLruCache$32.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = Path.resolve$default((Path)this.directory, (String)JOURNAL_FILE, (boolean)false, (int)2, null);
        this.journalFileTmp = Path.resolve$default((Path)this.directory, (String)JOURNAL_FILE_TEMP, (boolean)false, (int)2, null);
        this.journalFileBackup = Path.resolve$default((Path)this.directory, (String)JOURNAL_FILE_BACKUP, (boolean)false, (int)2, null);
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final Path getDirectory() {
        return this.directory;
    }

    public final int getValueCount() {
        return this.valueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMaxSize() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            l = this.maxSize;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxSize(long value) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.maxSize = value;
            if (this.initialized) {
                this.launchCleanupTask();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final LinkedHashMap<String, Entry> getLruEntries$core_client_shared() {
        return this.lruEntries;
    }

    public final boolean getClosed$core_client_shared() {
        return this.closed;
    }

    public final void setClosed$core_client_shared(boolean bl) {
        this.closed = bl;
    }

    private final void launchCleanupTask() {
        Job job = this.cleanupJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.cleanupJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.MainScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = DiskLruCache.access$getLock$p(this.this$0);
                        DiskLruCache diskLruCache = this.this$0;
                        Object object2 = object;
                        synchronized (object2) {
                            boolean bl = false;
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache)) return Unit.INSTANCE;
                            if (diskLruCache.getClosed$core_client_shared()) {
                                return Unit.INSTANCE;
                            }
                            try {
                                diskLruCache.trimToSize();
                            }
                            catch (IOException ignored) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRebuildRequired(diskLruCache)) {
                                    diskLruCache.rebuildJournal$core_client_shared();
                                    DiskLruCache.access$setRedundantOpCount$p(diskLruCache, 0);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            Unit unit = Unit.INSTANCE;
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            this.civilizedFileSystem = DiskLruCacheKt.access$isCivilized(this.fileSystem, this.journalFileBackup);
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException journalIsCorrupt) {
                    this.logger.w((Throwable)journalIsCorrupt, () -> DiskLruCache.initialize$lambda$5$lambda$4(this, journalIsCorrupt));
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.rebuildJournal$core_client_shared();
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        Unit unit;
        Closeable $this$use$iv = (Closeable)Okio.buffer((Source)this.fileSystem.source(this.journalFile));
        boolean $i$f$use = false;
        Throwable thrown$iv = null;
        try {
            BufferedSource source = (BufferedSource)$this$use$iv;
            boolean bl = false;
            String magic = source.readUtf8LineStrict();
            String version = source.readUtf8LineStrict();
            String appVersionString = source.readUtf8LineStrict();
            String valueCountString = source.readUtf8LineStrict();
            String blank = source.readUtf8LineStrict();
            if (!Intrinsics.areEqual((Object)MAGIC, (Object)magic)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (!Intrinsics.areEqual((Object)VERSION_1, (Object)version)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (!Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (!Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (((CharSequence)blank).length() > 0) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine(source.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
                if (!source.exhausted()) {
                    this.rebuildJournal$core_client_shared();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                unit = Unit.INSTANCE;
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
        }
        catch (Throwable t$iv) {
            try {
                thrown$iv = t$iv;
                unit = null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                block21: {
                    try {
                        Closeable closeable = $this$use$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv2) {
                        if (thrown$iv == null) {
                            thrown$iv = t$iv2;
                            break block21;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                    }
                }
            }
        }
        Unit result$iv = unit;
        Throwable throwable = thrown$iv;
        if (throwable == null) return;
        throw throwable;
    }

    private final BufferedSink newJournalWriter() {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$7(this, arg_0)));
        return Okio.buffer((Sink)((Sink)faultHidingSink));
    }

    private final void readJournalLine(String line) {
        Entry entry;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            String string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key = string;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            String string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key = string;
        }
        if ((entry = this.lruEntries.get(key)) == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = line.substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{' '};
            List parts = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            entry.setReadable$core_client_shared(true);
            entry.setCurrentEditor$core_client_shared(null);
            entry.setLengths$core_client_shared(parts);
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor$core_client_shared(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != READ.length() || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private final void processJournal() {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            int n;
            Entry entry;
            Intrinsics.checkNotNullExpressionValue((Object)i.next(), (String)"next(...)");
            if (entry.getCurrentEditor$core_client_shared() == null) {
                n = this.valueCount;
                for (t = 0; t < n; ++t) {
                    this.size += entry.getLengths$core_client_shared()[t];
                }
                continue;
            }
            entry.setCurrentEditor$core_client_shared(null);
            n = this.valueCount;
            for (t = 0; t < n; ++t) {
                this.fileSystem.delete(entry.getCleanFiles$core_client_shared().get(t));
                this.fileSystem.delete(entry.getDirtyFiles$core_client_shared().get(t));
            }
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rebuildJournal$core_client_shared() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            Throwable thrown$iv;
            block21: {
                boolean bl = false;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                Closeable $this$use$iv = (Closeable)Okio.buffer((Sink)this.fileSystem.sink(this.journalFileTmp));
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    BufferedSink sink = (BufferedSink)$this$use$iv;
                    boolean bl2 = false;
                    sink.writeUtf8(MAGIC).writeByte(10);
                    sink.writeUtf8(VERSION_1).writeByte(10);
                    sink.writeDecimalLong((long)this.appVersion).writeByte(10);
                    sink.writeDecimalLong((long)this.valueCount).writeByte(10);
                    sink.writeByte(10);
                    Iterator<Entry> iterator = this.lruEntries.values().iterator();
                    while (iterator.hasNext()) {
                        BufferedSink bufferedSink2;
                        Entry entry;
                        Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                        if (entry.getCurrentEditor$core_client_shared() != null) {
                            sink.writeUtf8(DIRTY).writeByte(32);
                            sink.writeUtf8(entry.getKey$core_client_shared());
                            bufferedSink2 = sink.writeByte(10);
                            continue;
                        }
                        sink.writeUtf8(CLEAN).writeByte(32);
                        sink.writeUtf8(entry.getKey$core_client_shared());
                        entry.writeLengths$core_client_shared(sink);
                        bufferedSink2 = sink.writeByte(10);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        unit = null;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block22: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv2;
                                    break block22;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Unit result$iv = unit;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
            }
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            this.fileSystem.delete(this.journalFileBackup);
            this.journalWriter = this.newJournalWriter();
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            Unit unit2 = Unit.INSTANCE;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Snapshot get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.lock;
        synchronized (object) {
            Snapshot snapshot;
            block7: {
                Entry entry;
                block6: {
                    boolean bl = false;
                    this.initialize();
                    this.checkNotClosed();
                    this.validateKey(key);
                    if (this.lruEntries.get(key) != null) break block6;
                    Snapshot snapshot2 = null;
                    return snapshot2;
                }
                Entry entry2 = entry;
                if (entry2.snapshot$core_client_shared() != null) break block7;
                Snapshot snapshot3 = null;
                return snapshot3;
            }
            Snapshot snapshot4 = snapshot;
            int n = this.redundantOpCount;
            this.redundantOpCount = n + 1;
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8(key).writeByte(10);
            if (this.journalRebuildRequired()) {
                this.launchCleanupTask();
            }
            Snapshot snapshot5 = snapshot4;
            return snapshot5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Editor edit(@NotNull String key, long expectedSequenceNumber) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                boolean bl = false;
                                this.initialize();
                                this.checkNotClosed();
                                this.validateKey(key);
                                entry = this.lruEntries.get(key);
                                if (expectedSequenceNumber == ANY_SEQUENCE_NUMBER || entry != null && entry.getSequenceNumber$core_client_shared() == expectedSequenceNumber) break block9;
                                Editor editor = null;
                                return editor;
                            }
                            Entry entry2 = entry;
                            if ((entry2 != null ? entry2.getCurrentEditor$core_client_shared() : null) == null) break block10;
                            Editor editor = null;
                            return editor;
                        }
                        if (entry == null || entry.getLockingSourceCount$core_client_shared() == 0) break block11;
                        Editor editor = null;
                        return editor;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block12;
                    this.launchCleanupTask();
                    Editor editor = null;
                    return editor;
                }
                BufferedSink bufferedSink = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink);
                BufferedSink journalWriter = bufferedSink;
                journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8(key).writeByte(10);
                journalWriter.flush();
                if (!this.hasJournalErrors) break block13;
                Editor editor = null;
                return editor;
            }
            if (entry == null) {
                entry = new Entry(key);
                ((Map)this.lruEntries).put(key, entry);
            }
            Editor editor = new Editor(entry);
            entry.setCurrentEditor$core_client_shared(editor);
            Editor editor2 = editor;
            return editor2;
        }
    }

    public static /* synthetic */ Editor edit$default(DiskLruCache diskLruCache, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = ANY_SEQUENCE_NUMBER;
        }
        return diskLruCache.edit(string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long size() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            l = this.size;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void completeEdit$core_client_shared(@NotNull Editor editor, boolean success) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = this.lock;
        synchronized (object) {
            BufferedSink bufferedSink;
            int i;
            int n;
            boolean bl = false;
            Entry entry = editor.getEntry$core_client_shared();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor$core_client_shared(), (Object)editor)) {
                throw new IllegalStateException("Check failed.");
            }
            if (success && !entry.getReadable$core_client_shared()) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    boolean[] blArray = editor.getWritten$core_client_shared();
                    Intrinsics.checkNotNull((Object)blArray);
                    if (!blArray[i]) {
                        editor.abort();
                        throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                    }
                    if (this.fileSystem.exists(entry.getDirtyFiles$core_client_shared().get(i))) continue;
                    editor.abort();
                    return;
                }
            }
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                Path dirty = entry.getDirtyFiles$core_client_shared().get(i);
                if (success && !entry.getZombie$core_client_shared()) {
                    long newLength;
                    if (!this.fileSystem.exists(dirty)) continue;
                    Path clean = entry.getCleanFiles$core_client_shared().get(i);
                    this.fileSystem.atomicMove(dirty, clean);
                    long oldLength = entry.getLengths$core_client_shared()[i];
                    Object object2 = this.fileSystem.metadataOrNull(clean);
                    entry.getLengths$core_client_shared()[i] = newLength = object2 != null && (object2 = object2.getSize()) != null ? (Long)object2 : 0L;
                    this.size = this.size - oldLength + newLength;
                    continue;
                }
                this.fileSystem.delete(dirty);
            }
            entry.setCurrentEditor$core_client_shared(null);
            if (entry.getZombie$core_client_shared()) {
                this.removeEntry$core_client_shared(entry);
                return;
            }
            int n2 = this.redundantOpCount;
            this.redundantOpCount = n2 + 1;
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            BufferedSink $this$completeEdit_u24lambda_u2414_u24lambda_u2413 = bufferedSink = bufferedSink2;
            boolean bl2 = false;
            if (entry.getReadable$core_client_shared() || success) {
                entry.setReadable$core_client_shared(true);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(CLEAN).writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey$core_client_shared());
                entry.writeLengths$core_client_shared($this$completeEdit_u24lambda_u2414_u24lambda_u2413);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
                if (success) {
                    long l = this.nextSequenceNumber;
                    this.nextSequenceNumber = l + 1L;
                    entry.setSequenceNumber$core_client_shared(l);
                }
            } else {
                this.lruEntries.remove(entry.getKey$core_client_shared());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(REMOVE).writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey$core_client_shared());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            }
            $this$completeEdit_u24lambda_u2414_u24lambda_u2413.flush();
            if (this.size > this.getMaxSize() || this.journalRebuildRequired()) {
                this.launchCleanupTask();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean journalRebuildRequired() {
        int redundantOpCompactThreshold = 2000;
        return this.redundantOpCount >= redundantOpCompactThreshold && this.redundantOpCount >= this.lruEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            block5: {
                boolean bl = false;
                this.initialize();
                this.checkNotClosed();
                this.validateKey(key);
                if (this.lruEntries.get(key) != null) break block5;
                boolean bl2 = false;
                return bl2;
            }
            Entry entry2 = entry;
            boolean removed = this.removeEntry$core_client_shared(entry2);
            if (removed && this.size <= this.getMaxSize()) {
                this.mostRecentTrimFailed = false;
            }
            boolean bl = removed;
            return bl;
        }
    }

    public final boolean removeEntry$core_client_shared(@NotNull Entry entry) {
        BufferedSink it;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (!this.civilizedFileSystem) {
            if (entry.getLockingSourceCount$core_client_shared() > 0) {
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    it = bufferedSink;
                    boolean bl = false;
                    it.writeUtf8(DIRTY);
                    it.writeByte(32);
                    it.writeUtf8(entry.getKey$core_client_shared());
                    it.writeByte(10);
                    it.flush();
                }
            }
            if (entry.getLockingSourceCount$core_client_shared() > 0 || entry.getCurrentEditor$core_client_shared() != null) {
                entry.setZombie$core_client_shared(true);
                return true;
            }
        }
        Editor editor = entry.getCurrentEditor$core_client_shared();
        if (editor != null) {
            editor.detach$core_client_shared();
        }
        int n = this.valueCount;
        for (int i = 0; i < n; ++i) {
            this.fileSystem.delete(entry.getCleanFiles$core_client_shared().get(i));
            this.size -= entry.getLengths$core_client_shared()[i];
            entry.getLengths$core_client_shared()[i] = 0L;
        }
        int n2 = this.redundantOpCount;
        this.redundantOpCount = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            it = bufferedSink;
            boolean bl = false;
            it.writeUtf8(REMOVE);
            it.writeByte(32);
            it.writeUtf8(entry.getKey$core_client_shared());
            it.writeByte(10);
        }
        this.lruEntries.remove(entry.getKey$core_client_shared());
        if (this.journalRebuildRequired()) {
            this.launchCleanupTask();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkNotClosed() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(!this.closed)) {
                boolean bl2 = false;
                String string = "cache is closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.initialized) {
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this.closed;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.initialized || this.closed) {
                this.closed = true;
                return;
            }
            Collection<Entry> collection = this.lruEntries.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Collection<Entry> $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
            for (Entry entry : thisCollection$iv.toArray(new Entry[0])) {
                Intrinsics.checkNotNull((Object)entry);
                Entry entry2 = entry;
                if (entry2.getCurrentEditor$core_client_shared() == null) continue;
                Editor editor = entry2.getCurrentEditor$core_client_shared();
                if (editor == null) continue;
                editor.detach$core_client_shared();
            }
            this.trimToSize();
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.close();
            this.journalWriter = null;
            this.closed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void trimToSize() {
        while (this.size > this.getMaxSize()) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            Entry toEvict;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (toEvict.getZombie$core_client_shared()) continue;
            this.removeEntry$core_client_shared(toEvict);
            return true;
        }
        return false;
    }

    public final void delete() {
        this.close();
        this.fileSystem.deleteRecursively(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            Collection<Entry> collection = this.lruEntries.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Collection<Entry> $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
            for (Entry entry : thisCollection$iv.toArray(new Entry[0])) {
                Intrinsics.checkNotNull((Object)entry);
                Entry entry2 = entry;
                this.removeEntry$core_client_shared(entry2);
            }
            this.mostRecentTrimFailed = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + "\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iterator<Snapshot> snapshots() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            Iterator iterator = new Iterator<Snapshot>(this){
                private final Iterator<Entry> delegate;
                private Snapshot nextSnapshot;
                private Snapshot removeSnapshot;
                final /* synthetic */ DiskLruCache this$0;
                {
                    this.this$0 = $receiver;
                    Iterator<Entry> iterator = new ArrayList<Entry>($receiver.getLruEntries$core_client_shared().values()).iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    this.delegate = iterator;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean hasNext() {
                    if (this.nextSnapshot != null) {
                        return true;
                    }
                    Object object = DiskLruCache.access$getLock$p(this.this$0);
                    DiskLruCache diskLruCache = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        block7: {
                            boolean bl = false;
                            if (!diskLruCache.getClosed$core_client_shared()) break block7;
                            boolean bl2 = false;
                            return bl2;
                        }
                        while (this.delegate.hasNext()) {
                            Object object3 = this.delegate.next();
                            if (object3 == null || (object3 = ((Entry)object3).snapshot$core_client_shared()) == null) continue;
                            this.nextSnapshot = object3;
                            boolean bl = true;
                            return bl;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    return false;
                }

                public Snapshot next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.removeSnapshot = this.nextSnapshot;
                    this.nextSnapshot = null;
                    Snapshot snapshot = this.removeSnapshot;
                    Intrinsics.checkNotNull((Object)snapshot);
                    return snapshot;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void remove() {
                    Snapshot removeSnapshot = this.removeSnapshot;
                    if (removeSnapshot == null) {
                        boolean bl = false;
                        String string = "remove() before next()";
                        throw new IllegalStateException(string.toString());
                    }
                    try {
                        this.this$0.remove(removeSnapshot.key());
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this.removeSnapshot = null;
                    }
                }
            };
            return iterator;
        }
    }

    private static final String initialize$lambda$5$lambda$4(DiskLruCache this$0, IOException $journalIsCorrupt) {
        return "DiskLruCache " + this$0.directory + " is corrupt: " + $journalIsCorrupt.getMessage() + ", removing";
    }

    private static final Unit newJournalWriter$lambda$7(DiskLruCache this$0, IOException it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRebuildRequired(DiskLruCache $this) {
        return $this.journalRebuildRequired();
    }

    public static final /* synthetic */ void access$setRedundantOpCount$p(DiskLruCache $this, int n) {
        $this.redundantOpCount = n;
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0014\u0010\u001c\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007\u00a8\u0006 "}, d2={"Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Companion;", "", "<init>", "()V", "JOURNAL_FILE", "", "getJOURNAL_FILE", "()Ljava/lang/String;", "JOURNAL_FILE_TEMP", "getJOURNAL_FILE_TEMP", "JOURNAL_FILE_BACKUP", "getJOURNAL_FILE_BACKUP", "MAGIC", "getMAGIC", "VERSION_1", "getVERSION_1", "ANY_SEQUENCE_NUMBER", "", "getANY_SEQUENCE_NUMBER", "()J", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "getLEGAL_KEY_PATTERN", "()Lkotlin/text/Regex;", "CLEAN", "getCLEAN", "DIRTY", "getDIRTY", "REMOVE", "getREMOVE", "READ", "getREAD", "core-client-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getJOURNAL_FILE() {
            return JOURNAL_FILE;
        }

        @NotNull
        public final String getJOURNAL_FILE_TEMP() {
            return JOURNAL_FILE_TEMP;
        }

        @NotNull
        public final String getJOURNAL_FILE_BACKUP() {
            return JOURNAL_FILE_BACKUP;
        }

        @NotNull
        public final String getMAGIC() {
            return MAGIC;
        }

        @NotNull
        public final String getVERSION_1() {
            return VERSION_1;
        }

        public final long getANY_SEQUENCE_NUMBER() {
            return ANY_SEQUENCE_NUMBER;
        }

        @NotNull
        public final Regex getLEGAL_KEY_PATTERN() {
            return LEGAL_KEY_PATTERN;
        }

        @NotNull
        public final String getCLEAN() {
            return CLEAN;
        }

        @NotNull
        public final String getDIRTY() {
            return DIRTY;
        }

        @NotNull
        public final String getREMOVE() {
            return REMOVE;
        }

        @NotNull
        public final String getREAD() {
            return READ;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0010J\u0006\u0010\u0019\u001a\u00020\u0010R\u0018\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Editor;", "", "entry", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Entry;", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;", "<init>", "(Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Entry;)V", "getEntry$core_client_shared", "()Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Entry;", "written", "", "getWritten$core_client_shared", "()[Z", "done", "", "detach", "", "detach$core_client_shared", "newSource", "Lokio/Source;", "index", "", "newSink", "Lokio/Sink;", "commit", "abort", "core-client-shared"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        @Nullable
        private final boolean[] written;
        private boolean done;

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.written = this.entry.getReadable$core_client_shared() ? null : new boolean[DiskLruCache.this.getValueCount()];
        }

        @NotNull
        public final Entry getEntry$core_client_shared() {
            return this.entry;
        }

        @Nullable
        public final boolean[] getWritten$core_client_shared() {
            return this.written;
        }

        public final void detach$core_client_shared() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$core_client_shared(), (Object)this)) {
                if (DiskLruCache.this.civilizedFileSystem) {
                    DiskLruCache.this.completeEdit$core_client_shared(this, false);
                } else {
                    this.entry.setZombie$core_client_shared(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Source newSource(int index) {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                Source source;
                block7: {
                    boolean bl = false;
                    if (!(!this.done)) {
                        throw new IllegalStateException("Check failed.");
                    }
                    if (this.entry.getReadable$core_client_shared() && Intrinsics.areEqual((Object)this.entry.getCurrentEditor$core_client_shared(), (Object)this) && !this.entry.getZombie$core_client_shared()) break block7;
                    Source source2 = null;
                    return source2;
                }
                try {
                    source = diskLruCache.getFileSystem().source(this.entry.getCleanFiles$core_client_shared().get(index));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    source = null;
                }
                Source source3 = source;
                return source3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Sink newSink(int index) {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                block9: {
                    boolean bl = false;
                    if (!(!this.done)) {
                        throw new IllegalStateException("Check failed.");
                    }
                    if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$core_client_shared(), (Object)this)) break block9;
                    Sink sink = Okio.blackhole();
                    return sink;
                }
                if (!this.entry.getReadable$core_client_shared()) {
                    Intrinsics.checkNotNull((Object)this.written);
                    this.written[index] = true;
                }
                Path dirtyFile = this.entry.getDirtyFiles$core_client_shared().get(index);
                Sink sink = null;
                try {
                    sink = diskLruCache.getFileSystem().sink(dirtyFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Sink sink2 = Okio.blackhole();
                    return sink2;
                }
                Sink sink3 = (Sink)new FaultHidingSink(sink, (Function1<? super IOException, Unit>)((Function1)arg_0 -> Editor.newSink$lambda$3$lambda$2(diskLruCache, this, arg_0)));
                return sink3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (!(!this.done)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$core_client_shared(), (Object)this)) {
                    diskLruCache.completeEdit$core_client_shared(this, true);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abort() {
            Object object = DiskLruCache.this.lock;
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (!(!this.done)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$core_client_shared(), (Object)this)) {
                    diskLruCache.completeEdit$core_client_shared(this, false);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit newSink$lambda$3$lambda$2(DiskLruCache this$0, Editor this$1, IOException it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object = this$0.lock;
            synchronized (object) {
                boolean bl = false;
                this$1.detach$core_client_shared();
                Unit unit = Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000302H\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u0002002\u0006\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7J\u0016\u00108\u001a\u0002092\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000302H\u0002J\u0013\u0010:\u001a\b\u0018\u00010;R\u00020\u001eH\u0000\u00a2\u0006\u0002\b<J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020$H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R \u0010\u001c\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Entry;", "", "key", "", "<init>", "(Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;Ljava/lang/String;)V", "getKey$core_client_shared", "()Ljava/lang/String;", "lengths", "", "getLengths$core_client_shared", "()[J", "cleanFiles", "", "Lokio/Path;", "getCleanFiles$core_client_shared", "()Ljava/util/List;", "dirtyFiles", "getDirtyFiles$core_client_shared", "readable", "", "getReadable$core_client_shared", "()Z", "setReadable$core_client_shared", "(Z)V", "zombie", "getZombie$core_client_shared", "setZombie$core_client_shared", "currentEditor", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Editor;", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;", "getCurrentEditor$core_client_shared", "()Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Editor;", "setCurrentEditor$core_client_shared", "(Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Editor;)V", "lockingSourceCount", "", "getLockingSourceCount$core_client_shared", "()I", "setLockingSourceCount$core_client_shared", "(I)V", "sequenceNumber", "", "getSequenceNumber$core_client_shared", "()J", "setSequenceNumber$core_client_shared", "(J)V", "setLengths", "", "strings", "", "setLengths$core_client_shared", "writeLengths", "writer", "Lokio/BufferedSink;", "writeLengths$core_client_shared", "invalidLengths", "", "snapshot", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Snapshot;", "snapshot$core_client_shared", "newSource", "Lokio/Source;", "index", "core-client-shared"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final List<Path> cleanFiles;
        @NotNull
        private final List<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        @Nullable
        private Editor currentEditor;
        private int lockingSourceCount;
        private long sequenceNumber;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.getValueCount()];
            this.cleanFiles = new ArrayList();
            this.dirtyFiles = new ArrayList();
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.getValueCount();
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                Collection collection = this.cleanFiles;
                Path path = DiskLruCache.this.getDirectory();
                String string = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(Path.resolve$default((Path)path, (String)string, (boolean)false, (int)2, null));
                fileBuilder.append(".tmp");
                collection = this.dirtyFiles;
                Path path2 = DiskLruCache.this.getDirectory();
                String string2 = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                collection.add(Path.resolve$default((Path)path2, (String)string2, (boolean)false, (int)2, null));
                fileBuilder.setLength(truncateTo);
            }
        }

        @NotNull
        public final String getKey$core_client_shared() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths$core_client_shared() {
            return this.lengths;
        }

        @NotNull
        public final List<Path> getCleanFiles$core_client_shared() {
            return this.cleanFiles;
        }

        @NotNull
        public final List<Path> getDirtyFiles$core_client_shared() {
            return this.dirtyFiles;
        }

        public final boolean getReadable$core_client_shared() {
            return this.readable;
        }

        public final void setReadable$core_client_shared(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie$core_client_shared() {
            return this.zombie;
        }

        public final void setZombie$core_client_shared(boolean bl) {
            this.zombie = bl;
        }

        @Nullable
        public final Editor getCurrentEditor$core_client_shared() {
            return this.currentEditor;
        }

        public final void setCurrentEditor$core_client_shared(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSourceCount$core_client_shared() {
            return this.lockingSourceCount;
        }

        public final void setLockingSourceCount$core_client_shared(int n) {
            this.lockingSourceCount = n;
        }

        public final long getSequenceNumber$core_client_shared() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber$core_client_shared(long l) {
            this.sequenceNumber = l;
        }

        public final void setLengths$core_client_shared(@NotNull List<String> strings) {
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (strings.size() != DiskLruCache.this.getValueCount()) {
                this.invalidLengths(strings);
                throw new KotlinNothingValueException();
            }
            try {
                int n = ((Collection)strings).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.invalidLengths(strings);
                throw new KotlinNothingValueException();
            }
        }

        public final void writeLengths$core_client_shared(@NotNull BufferedSink writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        private final Void invalidLengths(List<String> strings) {
            throw new IOException("unexpected journal line: " + strings);
        }

        @Nullable
        public final Snapshot snapshot$core_client_shared() {
            if (!this.readable) {
                return null;
            }
            if (!DiskLruCache.this.civilizedFileSystem && (this.currentEditor != null || this.zombie)) {
                return null;
            }
            List sources = new ArrayList();
            long[] lengths = DiskLruCacheKt.access$cloneArray(this.lengths);
            try {
                int n = DiskLruCache.this.getValueCount();
                for (int i = 0; i < n; ++i) {
                    ((Collection)sources).add(this.newSource(i));
                }
                return new Snapshot(this.key, this.sequenceNumber, sources, lengths);
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (Source source : sources) {
                    try {
                        source.close();
                    }
                    catch (Exception ex) {
                        LoggerInterface.w$default((LoggerInterface)DiskLruCache.this.logger, null, () -> Entry.snapshot$lambda$0(ex), (int)1, null);
                    }
                }
                try {
                    DiskLruCache.this.removeEntry$core_client_shared(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }

        private final Source newSource(int index) {
            Source fileSource = DiskLruCache.this.getFileSystem().source(this.cleanFiles.get(index));
            if (DiskLruCache.this.civilizedFileSystem) {
                return fileSource;
            }
            int n = this.lockingSourceCount;
            this.lockingSourceCount = n + 1;
            return (Source)new ForwardingSource(fileSource, DiskLruCache.this, this){
                private boolean closed;
                final /* synthetic */ DiskLruCache this$0;
                final /* synthetic */ Entry this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super($fileSource);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    super.close();
                    if (!this.closed) {
                        this.closed = true;
                        Object object = DiskLruCache.access$getLock$p(this.this$0);
                        Entry entry = this.this$1;
                        DiskLruCache diskLruCache = this.this$0;
                        Object object2 = object;
                        synchronized (object2) {
                            boolean bl = false;
                            int n = entry.getLockingSourceCount$core_client_shared();
                            entry.setLockingSourceCount$core_client_shared(n + -1);
                            if (entry.getLockingSourceCount$core_client_shared() == 0 && entry.getZombie$core_client_shared()) {
                                diskLruCache.removeEntry$core_client_shared(entry);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }
            };
        }

        private static final String snapshot$lambda$0(Exception $ex) {
            return "Failed to close source: " + $ex.getMessage();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B/\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0003\u001a\u00020\u0004J\f\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lokio/Closeable;", "key", "", "sequenceNumber", "", "sources", "", "Lokio/Source;", "lengths", "", "<init>", "(Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;Ljava/lang/String;JLjava/util/List;[J)V", "edit", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache$Editor;", "Lvet/inpulse/core/client/shared/cache/internal/DiskLruCache;", "getSource", "index", "", "getLength", "close", "", "core-client-shared"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final String key;
        private final long sequenceNumber;
        @NotNull
        private final List<Source> sources;
        @NotNull
        private final long[] lengths;

        public Snapshot(String key, @NotNull long sequenceNumber, @NotNull List<? extends Source> sources, long[] lengths) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            this.key = key;
            this.sequenceNumber = sequenceNumber;
            this.sources = sources;
            this.lengths = lengths;
        }

        @NotNull
        public final String key() {
            return this.key;
        }

        @Nullable
        public final Editor edit() {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        @NotNull
        public final Source getSource(int index) {
            return this.sources.get(index);
        }

        public final long getLength(int index) {
            return this.lengths[index];
        }

        @Override
        public void close() {
            for (Source source : this.sources) {
                try {
                    source.close();
                }
                catch (Exception ex) {
                    LoggerInterface.w$default((LoggerInterface)DiskLruCache.this.logger, null, () -> Snapshot.close$lambda$0(this, ex), (int)1, null);
                }
            }
        }

        private static final String close$lambda$0(Snapshot this$0, Exception $ex) {
            return "Failed to close snapshot source (key: " + this$0.key + ", sequenceNumber: " + this$0.sequenceNumber + "): " + $ex.getMessage();
        }
    }
}

