/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.compression;

import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.compression.Algorithm;
import vet.inpulse.compression.Compression;
import vet.inpulse.compression.Compressions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lvet/inpulse/compression/CompressorSink;", "Lokio/Sink;", "sink", "algorithm", "Lvet/inpulse/compression/Algorithm;", "<init>", "(Lokio/Sink;Lvet/inpulse/compression/Algorithm;)V", "compressor", "Lvet/inpulse/compression/Compression;", "dst", "Lokio/BufferedSink;", "buffer", "", "write", "", "source", "Lokio/Buffer;", "byteCount", "", "flush", "close", "timeout", "Lokio/Timeout;", "compression"})
@SourceDebugExtension(value={"SMAP\nCompressorSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressorSink.kt\nvet/inpulse/compression/CompressorSink\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,69:1\n72#2:70\n58#2,22:71\n*S KotlinDebug\n*F\n+ 1 CompressorSink.kt\nvet/inpulse/compression/CompressorSink\n*L\n20#1:70\n20#1:71,22\n*E\n"})
public final class CompressorSink
implements Sink {
    @NotNull
    private final Compression compressor;
    @NotNull
    private final BufferedSink dst;
    @NotNull
    private final byte[] buffer;

    public CompressorSink(@NotNull Sink sink, @NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.compressor = Compressions.INSTANCE.compressor(algorithm);
        this.dst = Okio.buffer((Sink)sink);
        this.buffer = new byte[8192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long read = 0L;
        while (read < byteCount) {
            Boolean bl;
            Throwable thrown$iv;
            int[] outputConsumed;
            int[] inputConsumed;
            block17: {
                inputConsumed = new int[1];
                outputConsumed = new int[1];
                Closeable $this$use$iv = (Closeable)Buffer.readUnsafe$default((Buffer)source, null, (int)1, null);
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    Buffer.UnsafeCursor unsafe = (Buffer.UnsafeCursor)$this$use$iv;
                    boolean bl2 = false;
                    if (!(unsafe.next() > 0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Intrinsics.checkNotNull((Object)unsafe.data);
                    bl = Compression.process$default(this.compressor, unsafe.data, unsafe.start, unsafe.end - unsafe.start, inputConsumed, this.buffer, 0, this.buffer.length, outputConsumed, false, 256, null);
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        bl = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block18: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv2;
                                    break block18;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Boolean result$iv = bl;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            this.dst.write(this.buffer, 0, outputConsumed[0]);
            source.skip((long)inputConsumed[0]);
            read += (long)inputConsumed[0];
        }
    }

    public void flush() {
        boolean done;
        byte[] empty = new byte[]{};
        int[] inputConsumed = new int[1];
        int[] outputConsumed = new int[1];
        do {
            done = this.compressor.process(empty, 0, 0, inputConsumed, this.buffer, 0, this.buffer.length, outputConsumed, true);
            this.dst.write(this.buffer, 0, outputConsumed[0]);
        } while (!done);
        this.dst.flush();
    }

    public void close() {
        this.compressor.close();
        this.dst.close();
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }
}

