/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.filters;

import java.util.ArrayList;
import med.inpulse.signal_processing.exceptions.InvalidInputException;
import med.inpulse.signal_processing.exceptions.NativeMemoryException;
import med.inpulse.signal_processing.jni.JNIObject;

public class FilterCoefficients
extends JNIObject {
    private native long _init(int var1, int var2);

    private native void _free(long var1);

    private native float[] _get_numerator(long var1);

    private native float[] _get_denominator(long var1);

    public FilterCoefficients(int numeratorLength, int denominatorLength) throws NativeMemoryException {
        this.reference = this._init(numeratorLength, denominatorLength);
        if (this.reference == 0L) {
            throw new InvalidInputException("Both coefficients can't be zero at the same time.");
        }
    }

    public FilterCoefficients(long reference) {
        super(reference);
    }

    @Override
    public void free() {
        this._free(this.reference);
    }

    public ArrayList<Float> getNumerator() {
        float[] numerator = this._get_numerator(this.reference);
        ArrayList<Float> ret = new ArrayList<Float>();
        for (int i = 0; i < numerator.length; ++i) {
            ret.add(new Float(numerator[i]));
        }
        return ret;
    }

    public ArrayList<Float> getDenominator() {
        float[] denominator = this._get_denominator(this.reference);
        ArrayList<Float> ret = new ArrayList<Float>();
        for (int i = 0; i < denominator.length; ++i) {
            ret.add(new Float(denominator[i]));
        }
        return ret;
    }
}

