/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.ecg;

import java.util.ArrayList;
import med.inpulse.signal_processing.data_structures.LinkedList;
import med.inpulse.signal_processing.ecg.Complex;
import med.inpulse.signal_processing.ecg.MarkerType;
import med.inpulse.signal_processing.ecg.Species;
import med.inpulse.signal_processing.exceptions.InvalidInputException;
import med.inpulse.signal_processing.exceptions.NativeMemoryException;
import med.inpulse.signal_processing.jni.JNIObject;

public class ComplexDetector
extends JNIObject {
    private native long _init(int var1, int var2);

    private native void _free(long var1);

    private native void _calibrate(long var1, float[] var3);

    private native float[] _get_signal_average(long var1, float[] var3, float[] var4, long var5) throws NativeMemoryException;

    private native long _detect(long var1, float[] var3, int var4, long var5) throws NativeMemoryException;

    private native long _detect_average(long var1, float[] var3, float[] var4, int var5, long var6) throws NativeMemoryException;

    public ComplexDetector(Species species, int samplingRate) throws NativeMemoryException {
        if (samplingRate <= 0) {
            throw new IllegalArgumentException("Sampling rate must be greater than zero.");
        }
        this.reference = this._init(species.getValue(), samplingRate);
        if (this.reference == 0L) {
            throw new NativeMemoryException("Failed to initialize detector.");
        }
    }

    public ComplexDetector(long reference) {
        super(reference);
    }

    @Override
    public void free() {
        this._free(this.reference);
    }

    public void calibrate(float[] calibrationSignal) throws NativeMemoryException {
        if (calibrationSignal.length == 0) {
            throw new InvalidInputException("Interval must not be empty.");
        }
        this._calibrate(this.reference, calibrationSignal);
    }

    public float[] getSignalAverage(float[] d2Interval, float[] originalInterval, long calRelativeIndex) throws NativeMemoryException {
        if (calRelativeIndex < 0L) {
            throw new IllegalArgumentException("Calibration realtive index cannot be negative.");
        }
        if (d2Interval.length == 0) {
            throw new InvalidInputException("Interval must have size greater than zero.");
        }
        return this._get_signal_average(this.reference, d2Interval, originalInterval, calRelativeIndex);
    }

    public LinkedList<Complex> detect(float[] detecInterval, ArrayList<MarkerType> markers, long calRelativeIndex) throws NativeMemoryException {
        if (calRelativeIndex < 0L) {
            throw new IllegalArgumentException("Calibration realtive index cannot be negative.");
        }
        if (detecInterval.length == 0) {
            throw new InvalidInputException("Interval must not be empty.");
        }
        LinkedList<Complex> ret = null;
        int marker_flags = 0;
        for (MarkerType marker : markers) {
            marker_flags |= 1 << marker.getValue();
        }
        long complex_list_ref = this._detect(this.reference, detecInterval, marker_flags, calRelativeIndex);
        if (complex_list_ref != 0L) {
            ret = new LinkedList<Complex>(complex_list_ref, Complex.class);
        }
        return ret;
    }

    public Complex detectAverage(float[] detecInterval, float[] intervalAverage, ArrayList<MarkerType> markers, long calRelativeIndex) throws NativeMemoryException {
        if (calRelativeIndex < 0L) {
            throw new IllegalArgumentException("Calibration realtive index cannot be negative.");
        }
        if (detecInterval.length == 0 || intervalAverage.length == 0) {
            throw new InvalidInputException("Interval must not be empty.");
        }
        Complex ret = null;
        int marker_flags = 0;
        for (MarkerType marker : markers) {
            marker_flags |= 1 << marker.getValue();
        }
        long complex_ref = this._detect_average(this.reference, detecInterval, intervalAverage, marker_flags, calRelativeIndex);
        if (complex_ref != 0L) {
            ret = new Complex(complex_ref);
        }
        return ret;
    }
}

