/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.ecg;

import med.inpulse.signal_processing.ecg.Marker;
import med.inpulse.signal_processing.ecg.MarkerType;
import med.inpulse.signal_processing.exceptions.ItemNotFoundException;
import med.inpulse.signal_processing.exceptions.NativeMemoryException;
import med.inpulse.signal_processing.jni.JNIObject;

public class Complex
extends JNIObject {
    private native long _init(int var1);

    private native void _free(long var1);

    private native int _set_marker(long var1, int var3, long var4);

    private native int _remove_marker(long var1, int var3);

    private native long _get_marker(long var1, int var3);

    public Complex(int order) throws NativeMemoryException {
        if (order < 0) {
            throw new IllegalArgumentException("Order cannot be negative.");
        }
        this.reference = this._init(order);
        if (this.reference == 0L) {
            throw new NativeMemoryException("Failed to initialize complex.");
        }
    }

    public Complex(long reference) {
        super(reference);
    }

    @Override
    public void free() {
        this._free(this.reference);
        this.reference = 0L;
    }

    public void setMarker(MarkerType type, long sampleIndex) throws NativeMemoryException {
        if (this.reference != 0L) {
            int code = this._set_marker(this.reference, type.getValue(), sampleIndex);
            switch (code) {
                case -7: {
                    throw new IllegalArgumentException("Invalid sample index.");
                }
                case -2: {
                    throw new NativeMemoryException("Failed to allocate memory.");
                }
            }
        }
    }

    public void removeMarker(MarkerType type) {
        int code;
        if (this.reference != 0L && (code = this._remove_marker(this.reference, type.getValue())) == -3) {
            throw new ItemNotFoundException("The marker " + type.toString() + " was not found.");
        }
    }

    public Marker getMarker(MarkerType type) {
        Marker ret = null;
        if (this.reference != 0L) {
            long marker_ref = this._get_marker(this.reference, type.getValue());
            if (marker_ref == 0L) {
                throw new ItemNotFoundException("The marker " + type.toString() + " was not found.");
            }
            ret = new Marker(marker_ref);
        }
        return ret;
    }
}

