/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.analysis.ecg.views.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.analysis.ecg.views.utils.ActivePhraseInfo;
import vet.inpulse.app.analysis.ecg.views.utils.CompletionType;
import vet.inpulse.app.analysis.ecg.views.utils.TextFieldChangeType;
import vet.inpulse.core.models.phraseBank.PhraseBankItem;
import vet.inpulse.shared.utils.StringExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J9\u0010#\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010$\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\nH\u00d6\u0001J\t\u0010'\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lvet/inpulse/app/analysis/ecg/views/utils/AutoCompleteState;", "", "activePhrase", "Lvet/inpulse/app/analysis/ecg/views/utils/ActivePhraseInfo;", "suggestions", "", "Lvet/inpulse/core/models/phraseBank/PhraseBankItem;", "changeType", "Lvet/inpulse/app/analysis/ecg/views/utils/TextFieldChangeType;", "selectedIndex", "", "<init>", "(Lvet/inpulse/app/analysis/ecg/views/utils/ActivePhraseInfo;Ljava/util/List;Lvet/inpulse/app/analysis/ecg/views/utils/TextFieldChangeType;I)V", "getActivePhrase", "()Lvet/inpulse/app/analysis/ecg/views/utils/ActivePhraseInfo;", "getSuggestions", "()Ljava/util/List;", "getChangeType", "()Lvet/inpulse/app/analysis/ecg/views/utils/TextFieldChangeType;", "getSelectedIndex", "()I", "isDropdownVisible", "", "()Z", "inlineSuggestion", "getInlineSuggestion", "()Lvet/inpulse/core/models/phraseBank/PhraseBankItem;", "hint", "", "getHint", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "app"})
final class AutoCompleteState {
    @Nullable
    private final ActivePhraseInfo activePhrase;
    @NotNull
    private final List<PhraseBankItem> suggestions;
    @NotNull
    private final TextFieldChangeType changeType;
    private final int selectedIndex;

    public AutoCompleteState(@Nullable ActivePhraseInfo activePhrase, @NotNull List<? extends PhraseBankItem> suggestions, @NotNull TextFieldChangeType changeType, int selectedIndex) {
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        this.activePhrase = activePhrase;
        this.suggestions = suggestions;
        this.changeType = changeType;
        this.selectedIndex = selectedIndex;
    }

    public /* synthetic */ AutoCompleteState(ActivePhraseInfo activePhraseInfo, List list, TextFieldChangeType textFieldChangeType, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            activePhraseInfo = null;
        }
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            textFieldChangeType = TextFieldChangeType.Idle;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(activePhraseInfo, list, textFieldChangeType, n);
    }

    @Nullable
    public final ActivePhraseInfo getActivePhrase() {
        return this.activePhrase;
    }

    @NotNull
    public final List<PhraseBankItem> getSuggestions() {
        return this.suggestions;
    }

    @NotNull
    public final TextFieldChangeType getChangeType() {
        return this.changeType;
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    public final boolean isDropdownVisible() {
        if (this.activePhrase == null || this.suggestions.isEmpty() || this.changeType == TextFieldChangeType.CursorMoved || this.changeType == TextFieldChangeType.TextDeleted) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.activePhrase.getType().ordinal()]) {
            case 1 -> {
                if (!((Collection)this.suggestions).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.suggestions.size() > 1) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final PhraseBankItem getInlineSuggestion() {
        return !((Collection)this.suggestions).isEmpty() && this.changeType != TextFieldChangeType.CursorMoved && this.changeType != TextFieldChangeType.TextDeleted ? (PhraseBankItem)CollectionsKt.getOrNull(this.suggestions, (int)this.selectedIndex) : null;
    }

    @Nullable
    public final String getHint() {
        String string2;
        if (this.activePhrase == null || this.getInlineSuggestion() == null) {
            return null;
        }
        String textToCompare = switch (WhenMappings.$EnumSwitchMapping$0[this.activePhrase.getType().ordinal()]) {
            case 2 -> this.activePhrase.getText();
            case 1 -> StringsKt.drop((String)this.activePhrase.getText(), (int)1);
            default -> throw new NoWhenBranchMatchedException();
        };
        PhraseBankItem phraseBankItem = this.getInlineSuggestion();
        Intrinsics.checkNotNull((Object)phraseBankItem);
        if (StringsKt.startsWith((String)StringExtensionsKt.normalize((String)phraseBankItem.getPhrase()), (String)StringExtensionsKt.normalize((String)textToCompare), (boolean)true)) {
            PhraseBankItem phraseBankItem2 = this.getInlineSuggestion();
            Intrinsics.checkNotNull((Object)phraseBankItem2);
            String string3 = phraseBankItem2.getPhrase().substring(textToCompare.length());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            PhraseBankItem phraseBankItem3 = this.getInlineSuggestion();
            Intrinsics.checkNotNull((Object)phraseBankItem3);
            string2 = phraseBankItem3.getPhrase();
        }
        return string2;
    }

    @Nullable
    public final ActivePhraseInfo component1() {
        return this.activePhrase;
    }

    @NotNull
    public final List<PhraseBankItem> component2() {
        return this.suggestions;
    }

    @NotNull
    public final TextFieldChangeType component3() {
        return this.changeType;
    }

    public final int component4() {
        return this.selectedIndex;
    }

    @NotNull
    public final AutoCompleteState copy(@Nullable ActivePhraseInfo activePhrase, @NotNull List<? extends PhraseBankItem> suggestions, @NotNull TextFieldChangeType changeType, int selectedIndex) {
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        return new AutoCompleteState(activePhrase, suggestions, changeType, selectedIndex);
    }

    public static /* synthetic */ AutoCompleteState copy$default(AutoCompleteState autoCompleteState, ActivePhraseInfo activePhraseInfo, List list, TextFieldChangeType textFieldChangeType, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            activePhraseInfo = autoCompleteState.activePhrase;
        }
        if ((n2 & 2) != 0) {
            list = autoCompleteState.suggestions;
        }
        if ((n2 & 4) != 0) {
            textFieldChangeType = autoCompleteState.changeType;
        }
        if ((n2 & 8) != 0) {
            n = autoCompleteState.selectedIndex;
        }
        return autoCompleteState.copy(activePhraseInfo, list, textFieldChangeType, n);
    }

    @NotNull
    public String toString() {
        return "AutoCompleteState(activePhrase=" + this.activePhrase + ", suggestions=" + this.suggestions + ", changeType=" + this.changeType + ", selectedIndex=" + this.selectedIndex + ")";
    }

    public int hashCode() {
        int result2 = this.activePhrase == null ? 0 : this.activePhrase.hashCode();
        result2 = result2 * 31 + ((Object)this.suggestions).hashCode();
        result2 = result2 * 31 + this.changeType.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.selectedIndex);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AutoCompleteState)) {
            return false;
        }
        AutoCompleteState autoCompleteState = (AutoCompleteState)other;
        if (!Intrinsics.areEqual((Object)this.activePhrase, (Object)autoCompleteState.activePhrase)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.suggestions, autoCompleteState.suggestions)) {
            return false;
        }
        if (this.changeType != autoCompleteState.changeType) {
            return false;
        }
        return this.selectedIndex == autoCompleteState.selectedIndex;
    }

    public AutoCompleteState() {
        this(null, null, null, 0, 15, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompletionType.values().length];
            try {
                nArray[CompletionType.TAG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionType.PHRASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

