/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.analysis.ecg.utils;

import androidx.compose.ui.graphics.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.analysis.ecg.utils.ListIndexAndRelativeIndex;
import vet.inpulse.app.shared.analysis.ecg.data.AnalysisWaveform;
import vet.inpulse.app.shared.analysis.ecg.data.AnalysisWaveformsInfos;
import vet.inpulse.app.shared.analysis.ecg.data.EcgMorphologyMarkersIndexes;
import vet.inpulse.app.shared.utils.ColorUtilsKt;
import vet.inpulse.app.shared.utils.signal.MathUtilsKt;
import vet.inpulse.app.theme.ColorKt;
import vet.inpulse.core.models.model.EcgLead;
import vet.inpulse.core.models.model.HrvPoint;
import vet.inpulse.math.ArraysUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\b0\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u0011*\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\f\u001a\u00020\u0011*\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0016\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u0002*\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0016\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0016\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0016\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0016\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010&\u001a\u00020'*\u00020'2\u0006\u0010(\u001a\u00020\b\u001a\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0001*\b\u0012\u0004\u0012\u00020*0\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0018\u0010+\u001a\u00020**\b\u0012\u0004\u0012\u00020*0\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u00a8\u0006,"}, d2={"convertToAbsoluteIndexes", "", "", "waveformsAbsoluteStartIndexes", "waveformAbsoluteStartIndex", "calculateHrv", "Lvet/inpulse/core/models/model/HrvPoint;", "samplingFrequency", "", "maxOrNullWithIndex", "Lkotlin/Pair;", "", "downSample", "", "original", "factor", "findWaveformIndexAndRelativeIndex", "Lvet/inpulse/app/analysis/ecg/utils/ListIndexAndRelativeIndex;", "absoluteIndex", "upSample", "downSamplingFactors", "convertRelativeIndexToAbsoluteIndex", "waveformAbsoluteFirstIndex", "relativeIndex", "toAbsolutIndex", "absoluteStartIndexes", "toAbsoluteIndexes", "Lkotlin/ranges/IntRange;", "convertDownSampledAbsoluteIndexToOriginalAbsoluteIndex", "downSampledAbsoluteIndex", "waveformsInfos", "Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveformsInfos;", "convertDownSampledAbsoluteIndexesToOriginalAbsoluteIndexes", "downSampledAbsoluteIndexes", "convertOriginalAbsoluteIndexToDownSampledIndex", "originalAbsoluteIndex", "convertOriginalAbsoluteIndexesToDownSampledAbsoluteIndexes", "originalAbsoluteIndexes", "upSampledIndexes", "Lvet/inpulse/app/shared/analysis/ecg/data/EcgMorphologyMarkersIndexes;", "downSamplingFactor", "downSampled", "Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveform;", "downSampledToAbsolute", "app"})
@SourceDebugExtension(value={"SMAP\nEcgAnalysisUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcgAnalysisUtils.kt\nvet/inpulse/app/analysis/ecg/utils/EcgAnalysisUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,316:1\n1563#2:317\n1634#2,3:318\n1573#2:321\n1604#2,3:322\n1252#2,4:327\n1607#2:331\n1563#2:332\n1634#2,3:333\n1285#2,2:336\n1299#2,2:338\n1869#2,2:340\n1302#2:342\n463#3:325\n413#3:326\n*S KotlinDebug\n*F\n+ 1 EcgAnalysisUtils.kt\nvet/inpulse/app/analysis/ecg/utils/EcgAnalysisUtilsKt\n*L\n24#1:317\n24#1:318,3\n289#1:321\n289#1:322,3\n292#1:327,4\n289#1:331\n302#1:332\n302#1:333,3\n303#1:336,2\n303#1:338,2\n305#1:340,2\n303#1:342\n292#1:325\n292#1:326\n*E\n"})
public final class EcgAnalysisUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Integer> convertToAbsoluteIndexes(@NotNull List<? extends List<Integer>> $this$convertToAbsoluteIndexes, @NotNull List<Integer> waveformsAbsoluteStartIndexes) {
        Intrinsics.checkNotNullParameter($this$convertToAbsoluteIndexes, (String)"<this>");
        Intrinsics.checkNotNullParameter(waveformsAbsoluteStartIndexes, (String)"waveformsAbsoluteStartIndexes");
        Iterable iterable = $this$convertToAbsoluteIndexes;
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t : iterable) {
            void relativeIndexes;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)t;
            int waveformIndex = n2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)EcgAnalysisUtilsKt.convertToAbsoluteIndexes((List<Integer>)relativeIndexes, ((Number)waveformsAbsoluteStartIndexes.get(waveformIndex)).intValue()));
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Integer> convertToAbsoluteIndexes(@NotNull List<Integer> $this$convertToAbsoluteIndexes, int waveformAbsoluteStartIndex) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertToAbsoluteIndexes, (String)"<this>");
        Iterable $this$map$iv = $this$convertToAbsoluteIndexes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EcgAnalysisUtilsKt.convertRelativeIndexToAbsoluteIndex(waveformAbsoluteStartIndex, (int)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<HrvPoint> calculateHrv(@NotNull List<Integer> $this$calculateHrv, float samplingFrequency) {
        List list;
        Intrinsics.checkNotNullParameter($this$calculateHrv, (String)"<this>");
        if ($this$calculateHrv.size() < 2) {
            return CollectionsKt.emptyList();
        }
        List<Integer> rIndexes = $this$calculateHrv;
        List $this$calculateHrv_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = rIndexes.size();
        for (int i = 1; i < n; ++i) {
            int rr = ((Number)rIndexes.get(i)).intValue() - ((Number)rIndexes.get(i - 1)).intValue();
            $this$calculateHrv_u24lambda_u240.add(new HrvPoint(((Number)rIndexes.get(i)).intValue(), (float)Duration.getInWholeMilliseconds-impl((long)MathUtilsKt.sampleIndexToDuration((int)rr, (float)samplingFrequency)), i == 1 ? ColorUtilsKt.toColorArgb-8_81llA((long)ColorKt.getEcgAnalysisColorsLight().getHrvLine-0d7_KjU()) : ColorUtilsKt.toColorArgb-8_81llA((long)Color.Companion.getWhite-0d7_KjU()), null));
        }
        List hrv = CollectionsKt.build((List)list);
        return hrv;
    }

    @Nullable
    public static final Pair<Float, Integer> maxOrNullWithIndex(@NotNull Iterable<Float> $this$maxOrNullWithIndex) {
        Intrinsics.checkNotNullParameter($this$maxOrNullWithIndex, (String)"<this>");
        Iterator<Float> iterator = $this$maxOrNullWithIndex.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        float max = ((Number)iterator.next()).floatValue();
        int indexMax = 0;
        int currentIndex = 0;
        while (iterator.hasNext()) {
            float currentData = ((Number)iterator.next()).floatValue();
            ++currentIndex;
            if (!(currentData > max)) continue;
            max = currentData;
            indexMax = currentIndex;
        }
        return TuplesKt.to((Object)Float.valueOf(max), (Object)indexMax);
    }

    @NotNull
    public static final float[] downSample(@NotNull float[] original, int factor) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        if (factor <= 1) {
            return original;
        }
        float[] output = new float[original.length / factor];
        ArraysUtilsKt.copy$default((float[])original, (float[])output, (int)0, (int)factor, (int)0, (int)0, (int)output.length, (int)52, null);
        return output;
    }

    @NotNull
    public static final ListIndexAndRelativeIndex findWaveformIndexAndRelativeIndex(@NotNull List<Integer> $this$findWaveformIndexAndRelativeIndex, int absoluteIndex) {
        Intrinsics.checkNotNullParameter($this$findWaveformIndexAndRelativeIndex, (String)"<this>");
        int totalSize = 0;
        int waveformIndex = 0;
        int relativeIndex = -1;
        Iterator<Integer> iterator = $this$findWaveformIndexAndRelativeIndex.iterator();
        while (iterator.hasNext()) {
            int wfSize = ((Number)iterator.next()).intValue();
            if (absoluteIndex < totalSize + wfSize) {
                relativeIndex = absoluteIndex - totalSize;
                break;
            }
            totalSize += wfSize;
            ++waveformIndex;
        }
        return new ListIndexAndRelativeIndex(waveformIndex, relativeIndex);
    }

    @NotNull
    public static final ListIndexAndRelativeIndex upSample(@NotNull ListIndexAndRelativeIndex $this$upSample, @NotNull List<Integer> downSamplingFactors) {
        Intrinsics.checkNotNullParameter((Object)$this$upSample, (String)"<this>");
        Intrinsics.checkNotNullParameter(downSamplingFactors, (String)"downSamplingFactors");
        int upSampledIndex = $this$upSample.getRelativeIndex() * ((Number)downSamplingFactors.get($this$upSample.getListIndex())).intValue();
        return new ListIndexAndRelativeIndex($this$upSample.getListIndex(), upSampledIndex);
    }

    @NotNull
    public static final ListIndexAndRelativeIndex downSample(@NotNull ListIndexAndRelativeIndex $this$downSample, @NotNull List<Integer> downSamplingFactors) {
        Intrinsics.checkNotNullParameter((Object)$this$downSample, (String)"<this>");
        Intrinsics.checkNotNullParameter(downSamplingFactors, (String)"downSamplingFactors");
        int downSampledIndex = $this$downSample.getRelativeIndex() / ((Number)downSamplingFactors.get($this$downSample.getListIndex())).intValue();
        return new ListIndexAndRelativeIndex($this$downSample.getListIndex(), downSampledIndex);
    }

    public static final int convertRelativeIndexToAbsoluteIndex(int waveformAbsoluteFirstIndex, int relativeIndex) {
        return waveformAbsoluteFirstIndex + relativeIndex;
    }

    public static final int toAbsolutIndex(@NotNull ListIndexAndRelativeIndex $this$toAbsolutIndex, @NotNull List<Integer> absoluteStartIndexes) {
        Intrinsics.checkNotNullParameter((Object)$this$toAbsolutIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter(absoluteStartIndexes, (String)"absoluteStartIndexes");
        return EcgAnalysisUtilsKt.convertRelativeIndexToAbsoluteIndex(((Number)absoluteStartIndexes.get($this$toAbsolutIndex.getListIndex())).intValue(), $this$toAbsolutIndex.getRelativeIndex());
    }

    @NotNull
    public static final IntRange toAbsoluteIndexes(@NotNull IntRange $this$toAbsoluteIndexes, int waveformAbsoluteStartIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$toAbsoluteIndexes, (String)"<this>");
        int firstIndex = EcgAnalysisUtilsKt.convertRelativeIndexToAbsoluteIndex(waveformAbsoluteStartIndex, $this$toAbsoluteIndexes.getFirst());
        int lastIndex = EcgAnalysisUtilsKt.convertRelativeIndexToAbsoluteIndex(waveformAbsoluteStartIndex, $this$toAbsoluteIndexes.getLast());
        return new IntRange(firstIndex, lastIndex);
    }

    public static final int convertDownSampledAbsoluteIndexToOriginalAbsoluteIndex(int downSampledAbsoluteIndex, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        return EcgAnalysisUtilsKt.toAbsolutIndex(EcgAnalysisUtilsKt.upSample(EcgAnalysisUtilsKt.findWaveformIndexAndRelativeIndex(waveformsInfos.getDownSampledSizes(), downSampledAbsoluteIndex), waveformsInfos.getDownSamplingFactors()), waveformsInfos.getAbsoluteStartIndexes());
    }

    @NotNull
    public static final IntRange convertDownSampledAbsoluteIndexesToOriginalAbsoluteIndexes(@NotNull IntRange downSampledAbsoluteIndexes, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        Intrinsics.checkNotNullParameter((Object)downSampledAbsoluteIndexes, (String)"downSampledAbsoluteIndexes");
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        int firstIndex = EcgAnalysisUtilsKt.convertDownSampledAbsoluteIndexToOriginalAbsoluteIndex(downSampledAbsoluteIndexes.getFirst(), waveformsInfos);
        int lastIndex = EcgAnalysisUtilsKt.convertDownSampledAbsoluteIndexToOriginalAbsoluteIndex(downSampledAbsoluteIndexes.getLast(), waveformsInfos);
        return new IntRange(firstIndex, lastIndex);
    }

    public static final int convertOriginalAbsoluteIndexToDownSampledIndex(int originalAbsoluteIndex, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        return EcgAnalysisUtilsKt.toAbsolutIndex(EcgAnalysisUtilsKt.downSample(EcgAnalysisUtilsKt.findWaveformIndexAndRelativeIndex(waveformsInfos.getWaveformsSizes(), originalAbsoluteIndex), waveformsInfos.getDownSamplingFactors()), waveformsInfos.getDownSampledStartIndexes());
    }

    @NotNull
    public static final IntRange convertOriginalAbsoluteIndexesToDownSampledAbsoluteIndexes(@NotNull IntRange originalAbsoluteIndexes, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        Intrinsics.checkNotNullParameter((Object)originalAbsoluteIndexes, (String)"originalAbsoluteIndexes");
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        int firstIndex = EcgAnalysisUtilsKt.convertOriginalAbsoluteIndexToDownSampledIndex(originalAbsoluteIndexes.getFirst(), waveformsInfos);
        int lastIndex = EcgAnalysisUtilsKt.convertOriginalAbsoluteIndexToDownSampledIndex(originalAbsoluteIndexes.getLast(), waveformsInfos);
        return new IntRange(firstIndex, lastIndex);
    }

    @NotNull
    public static final EcgMorphologyMarkersIndexes upSampledIndexes(@NotNull EcgMorphologyMarkersIndexes $this$upSampledIndexes, float downSamplingFactor) {
        Intrinsics.checkNotNullParameter((Object)$this$upSampledIndexes, (String)"<this>");
        return new EcgMorphologyMarkersIndexes(MathKt.roundToInt((float)((float)$this$upSampledIndexes.getPInit() * downSamplingFactor)), MathKt.roundToInt((float)((float)$this$upSampledIndexes.getPEnd() * downSamplingFactor)), MathKt.roundToInt((float)((float)$this$upSampledIndexes.getQrsInit() * downSamplingFactor)), MathKt.roundToInt((float)((float)$this$upSampledIndexes.getQrsEnd() * downSamplingFactor)), MathKt.roundToInt((float)((float)$this$upSampledIndexes.getTInit() * downSamplingFactor)), MathKt.roundToInt((float)((float)$this$upSampledIndexes.getTEnd() * downSamplingFactor)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AnalysisWaveform> downSampled(@NotNull List<AnalysisWaveform> $this$downSampled, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$downSampled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        Iterable $this$mapIndexed$iv = $this$downSampled;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void waveform;
            void waveformIndex;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnalysisWaveform analysisWaveform = (AnalysisWaveform)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int downSamplingFactor = ((Number)waveformsInfos.getDownSamplingFactors().get((int)waveformIndex)).intValue();
            Map $this$mapValues$iv = waveform.getData();
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable2 = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                float[] data = (float[])entry2.getValue();
                float[] fArray = EcgAnalysisUtilsKt.downSample(data, downSamplingFactor);
                map4.put(k, fArray);
            }
            int n3 = ((Number)waveformsInfos.getDownSampledStartIndexes().get((int)waveformIndex)).intValue();
            float f = waveformsInfos.getChartSamplingFrequency();
            Map map5 = destination$iv$iv$iv;
            collection.add(new AnalysisWaveform(map5, f, n3));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AnalysisWaveform downSampledToAbsolute(@NotNull List<AnalysisWaveform> $this$downSampledToAbsolute, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        void $this$associateWithTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$downSampledToAbsolute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        Iterable $this$map$iv = $this$downSampledToAbsolute;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnalysisWaveform analysisWaveform = (AnalysisWaveform)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getData().keySet());
        }
        List leads = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        Iterable $this$associateWith$iv = leads;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $i$f$mapTo22 = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            EcgLead ecgLead = (EcgLead)element$iv$iv;
            Object e = element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            List leadData = new ArrayList();
            Iterable $this$forEach$iv = $this$downSampledToAbsolute;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float[] waveformLeadData;
                void lead;
                AnalysisWaveform waveform = (AnalysisWaveform)element$iv;
                boolean bl2 = false;
                if ((float[])waveform.getData().get(lead) == null) continue;
                leadData.addAll(ArraysKt.toList((float[])waveformLeadData));
            }
            float[] fArray = CollectionsKt.toFloatArray((Collection)leadData);
            object.put(e, fArray);
        }
        Map data = destination$iv$iv2;
        return new AnalysisWaveform(data, waveformsInfos.getChartSamplingFrequency(), 0);
    }
}

