/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.analysis.ecg.services.ml;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.AppSingletonsKt;
import vet.inpulse.app.analysis.ecg.services.ml.EcgSegmentationModel;
import vet.inpulse.app.analysis.ecg.services.ml.EcgSegmentationPostProcessing;
import vet.inpulse.app.analysis.ecg.services.ml.SegmentationResult;
import vet.inpulse.app.analysis.ecg.services.ml.SegmentationTrainedModelType;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH$\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0019\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010 J@\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H$0#0\"\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010$2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H%0\"2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H$0'JH\u0010(\u001a\u00020)\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010$*\b\u0012\u0004\u0012\u0002H%0*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H$0'2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u0002H$0-j\b\u0012\u0004\u0012\u0002H$`.R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00061"}, d2={"Lvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel;", "Lvet/inpulse/app/analysis/ecg/services/ml/EcgSegmentationModel;", "<init>", "()V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "getLogger", "()Lvet/inpulse/shared/log/LoggerInterface;", "segmentInternal", "", "", "modelType", "Lvet/inpulse/app/analysis/ecg/services/ml/SegmentationTrainedModelType;", "complex", "(Lvet/inpulse/app/analysis/ecg/services/ml/SegmentationTrainedModelType;[F)[[F", "postProcess", "Lkotlin/Result;", "Lvet/inpulse/app/analysis/ecg/services/ml/EcgSegmentationModel$Segments;", "rawModelOutput", "postProcess-IoAF18A", "([[F)Ljava/lang/Object;", "segment", "Lvet/inpulse/app/analysis/ecg/services/ml/SegmentationResult;", "offset", "", "length", "inplaceSoftmax", "", "data", "([[F)V", "argmax", "", "([[F)[I", "transitions", "", "Lvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel$Transition;", "R", "T", "mapper", "Lkotlin/Function1;", "isSortedBy", "", "", "selector", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "Companion", "Transition", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCommonEcgSegmentationModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonEcgSegmentationModel.kt\nvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1#2:197\n1#2:211\n1583#3,11:198\n1878#3,2:209\n1880#3:212\n1594#3:213\n*S KotlinDebug\n*F\n+ 1 CommonEcgSegmentationModel.kt\nvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel\n*L\n156#1:211\n156#1:198,11\n156#1:209,2\n156#1:212\n156#1:213\n*E\n"})
public abstract class CommonEcgSegmentationModel
implements EcgSegmentationModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoggerInterface logger = AppSingletonsKt.getAppLogModule().getLogger("EcgSegmentationModel");
    public static final int $stable = 8;
    public static final int MODEL_INPUT_LENGTH = 400;
    public static final int MINIMUM_SAMPLES = 100;
    public static final int MAXIMUM_SAMPLES = 400;

    @NotNull
    protected final LoggerInterface getLogger() {
        return this.logger;
    }

    @NotNull
    protected abstract float[][] segmentInternal(@NotNull SegmentationTrainedModelType var1, @NotNull float[] var2);

    private final Object postProcess-IoAF18A(float[][] rawModelOutput) {
        Object object;
        CommonEcgSegmentationModel commonEcgSegmentationModel = this;
        try {
            CommonEcgSegmentationModel $this$postProcess_IoAF18A_u24lambda_u240 = commonEcgSegmentationModel;
            boolean bl = false;
            $this$postProcess_IoAF18A_u24lambda_u240.inplaceSoftmax(rawModelOutput);
            Triple<IntRange, IntRange, IntRange> triple = EcgSegmentationPostProcessing.INSTANCE.postProcess(rawModelOutput);
            IntRange p = (IntRange)triple.component1();
            IntRange qrs = (IntRange)triple.component2();
            IntRange t = (IntRange)triple.component3();
            object = Result.constructor-impl((Object)new EcgSegmentationModel.Segments(p, qrs, t));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @Override
    @NotNull
    public SegmentationResult segment(@NotNull SegmentationTrainedModelType modelType, @NotNull float[] complex, int offset, int length) {
        SegmentationResult segmentationResult;
        Intrinsics.checkNotNullParameter((Object)((Object)modelType), (String)"modelType");
        Intrinsics.checkNotNullParameter((Object)complex, (String)"complex");
        if (length < 100) {
            return new SegmentationResult.Error.SignalTooShort(100);
        }
        if (length > 400) {
            return new SegmentationResult.Error.SignalTooLong(400);
        }
        this.logger.d(() -> CommonEcgSegmentationModel.segment$lambda$0(length, offset));
        try {
            Object object;
            Object object2;
            Object object3;
            IntRange it;
            EcgSegmentationModel.Segments segments;
            IntRange intRange;
            float firstValue = complex[offset];
            float lastValue = complex[offset + length - 1];
            int halfLength = length / 2;
            float[] fArray = new float[400];
            for (int i = 0; i < 400; ++i) {
                int n = i;
                fArray[n] = n < halfLength ? firstValue : lastValue;
            }
            float[] padded = fArray;
            int destinationOffset = (400 - length) / 2;
            ArraysKt.copyInto((float[])complex, (float[])padded, (int)destinationOffset, (int)offset, (int)(offset + length));
            float[][] rawModelOutput = this.segmentInternal(modelType, padded);
            Object object4 = this.postProcess-IoAF18A(rawModelOutput);
            ResultKt.throwOnFailure((Object)object4);
            EcgSegmentationModel.Segments processedSegments = (EcgSegmentationModel.Segments)object4;
            IntRange original = new IntRange(destinationOffset, destinationOffset + length - 1);
            EcgSegmentationModel.Segments segments2 = processedSegments;
            IntRange intRange2 = processedSegments.getP();
            if (intRange2 != null) {
                IntRange intRange3 = intRange = intRange2;
                segments = segments2;
                boolean bl = false;
                boolean bl2 = CommonEcgSegmentationModel.segment$containsRange(original, it);
                segments2 = segments;
                object3 = bl2 ? intRange : null;
            } else {
                object3 = null;
            }
            IntRange intRange4 = processedSegments.getQrs();
            if (intRange4 != null) {
                it = intRange = intRange4;
                IntRange intRange5 = object3;
                segments = segments2;
                boolean bl = false;
                boolean bl3 = CommonEcgSegmentationModel.segment$containsRange(original, it);
                segments2 = segments;
                object3 = intRange5;
                object2 = bl3 ? intRange : null;
            } else {
                object2 = null;
            }
            IntRange intRange6 = processedSegments.getT();
            if (intRange6 != null) {
                it = intRange = intRange6;
                IntRange intRange7 = object2;
                IntRange intRange8 = object3;
                segments = segments2;
                boolean bl = false;
                boolean bl4 = CommonEcgSegmentationModel.segment$containsRange(original, it);
                segments2 = segments;
                object3 = intRange8;
                object2 = intRange7;
                object = bl4 ? intRange : null;
            } else {
                object = null;
            }
            EcgSegmentationModel.Segments validSegments = segments2.copy((IntRange)object3, (IntRange)object2, (IntRange)object);
            this.logger.d(() -> CommonEcgSegmentationModel.segment$lambda$4(processedSegments, validSegments, destinationOffset));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EcgSegmentationModel.Wave.P), (Object)rawModelOutput[0]), TuplesKt.to((Object)((Object)EcgSegmentationModel.Wave.QRS), (Object)rawModelOutput[1]), TuplesKt.to((Object)((Object)EcgSegmentationModel.Wave.T), (Object)rawModelOutput[2]), TuplesKt.to((Object)((Object)EcgSegmentationModel.Wave.BACKGROUND), (Object)rawModelOutput[3])};
            segmentationResult = new SegmentationResult.Success(padded, MapsKt.mapOf((Pair[])pairArray), validSegments, destinationOffset);
        }
        catch (Exception ex) {
            this.logger.e((Throwable)ex, () -> CommonEcgSegmentationModel.segment$lambda$5(ex));
            segmentationResult = new SegmentationResult.Error.Failed(ex);
        }
        return segmentationResult;
    }

    public final void inplaceSoftmax(@NotNull float[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int length = data[0].length;
        for (int i = 0; i < length; ++i) {
            float f;
            int j;
            float sum = 0.0f;
            int n = ((Object[])data).length;
            for (j = 0; j < n; ++j) {
                f = data[j][i];
                float exp = (float)Math.exp(f);
                sum += exp;
            }
            n = ((Object[])data).length;
            for (j = 0; j < n; ++j) {
                float res;
                f = data[j][i];
                data[j][i] = res = (float)Math.exp(f) / sum;
            }
        }
    }

    @NotNull
    public final int[] argmax(@NotNull float[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int length = data[0].length;
        int[] output = new int[length];
        for (int i = 0; i < length; ++i) {
            float max = Float.MIN_VALUE;
            int argmax = 0;
            int n = ((Object[])data).length;
            for (int j = 0; j < n; ++j) {
                float value = data[j][i];
                if (!(value > max)) continue;
                max = value;
                argmax = j;
            }
            output[i] = argmax;
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T, R> List<Transition<R>> transitions(@NotNull List<? extends T> data, @NotNull Function1<? super T, ? extends R> mapper) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        List<? extends T> d = data.subList(1, CollectionsKt.getLastIndex(data));
        Iterable $this$mapIndexedNotNull$iv = CollectionsKt.zip((Iterable)data, (Iterable)d);
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Transition<Object> it$iv$iv;
            Object current;
            void pair;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            Pair pair2 = (Pair)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            Object previous = pair.component1();
            if ((!Intrinsics.areEqual((Object)previous, (Object)(current = pair.component2())) ? new Transition<Object>(index + 1, mapper.invoke(previous), mapper.invoke(current)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final <T, R> boolean isSortedBy(@NotNull Iterable<? extends T> $this$isSortedBy, @NotNull Function1<? super T, ? extends R> selector, @NotNull Comparator<R> comparator) {
        Intrinsics.checkNotNullParameter($this$isSortedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Iterator<T> it = $this$isSortedBy.iterator();
        if (!it.hasNext()) {
            return true;
        }
        T current = it.next();
        if (!it.hasNext()) {
            return true;
        }
        while (it.hasNext()) {
            Object compB;
            T next = it.next();
            Object compA = selector.invoke(current);
            int compare = comparator.compare(compA, compB = selector.invoke(next));
            if (compare > 0) {
                return false;
            }
            current = next;
        }
        return true;
    }

    private static final String segment$lambda$0(int $length, int $offset) {
        return "Segmenting ECG signal with length " + $length + " and offset " + $offset;
    }

    private static final boolean segment$containsRange(IntRange $this$segment_u24containsRange, IntRange range) {
        return $this$segment_u24containsRange.contains(range.getFirst()) && $this$segment_u24containsRange.contains(range.getLast());
    }

    private static final String segment$lambda$4(EcgSegmentationModel.Segments $processedSegments, EcgSegmentationModel.Segments $validSegments, int $destinationOffset) {
        return StringsKt.trimIndent((String)(" \n                    processed segments: " + $processedSegments + "\n                    valid segments: " + $validSegments + "\n                    padStart: " + $destinationOffset + "\n                "));
    }

    private static final String segment$lambda$5(Exception $ex) {
        return "Failed to segment ECG signal: " + $ex.getMessage();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel$Companion;", "", "<init>", "()V", "MODEL_INPUT_LENGTH", "", "MINIMUM_SAMPLES", "MAXIMUM_SAMPLES", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel$Transition;", "T", "", "index", "", "from", "to", "<init>", "(ILjava/lang/Object;Ljava/lang/Object;)V", "getIndex", "()I", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "component3", "copy", "(ILjava/lang/Object;Ljava/lang/Object;)Lvet/inpulse/app/analysis/ecg/services/ml/CommonEcgSegmentationModel$Transition;", "equals", "", "other", "hashCode", "toString", "", "app"})
    @StabilityInferred(parameters=1)
    public static final class Transition<T> {
        private final int index;
        private final T from;
        private final T to;
        public static final int $stable;

        public Transition(int index, T from, T to) {
            this.index = index;
            this.from = from;
            this.to = to;
        }

        public final int getIndex() {
            return this.index;
        }

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public final int component1() {
            return this.index;
        }

        public final T component2() {
            return this.from;
        }

        public final T component3() {
            return this.to;
        }

        @NotNull
        public final Transition<T> copy(int index, T from, T to) {
            return new Transition<T>(index, from, to);
        }

        public static /* synthetic */ Transition copy$default(Transition transition, int n, Object object, Object object2, int n2, Object object3) {
            if ((n2 & 1) != 0) {
                n = transition.index;
            }
            if ((n2 & 2) != 0) {
                object = transition.from;
            }
            if ((n2 & 4) != 0) {
                object2 = transition.to;
            }
            return transition.copy(n, object, object2);
        }

        @NotNull
        public String toString() {
            return "Transition(index=" + this.index + ", from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.index);
            result2 = result2 * 31 + (this.from == null ? 0 : this.from.hashCode());
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Transition)) {
                return false;
            }
            Transition transition = (Transition)other;
            if (this.index != transition.index) {
                return false;
            }
            if (!Intrinsics.areEqual(this.from, transition.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, transition.to);
        }
    }
}

