/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.analysis.ecg.services.impl;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.app.analysis.ecg.services.EcgMorphologyAnalysisCreator;
import vet.inpulse.app.analysis.ecg.services.EcgMorphologyAnalysisCreatorResult;
import vet.inpulse.app.analysis.ecg.services.ml.EcgSegmentationModel;
import vet.inpulse.app.analysis.ecg.services.ml.SegmentationResult;
import vet.inpulse.app.analysis.ecg.services.ml.SegmentationTrainedModelType;
import vet.inpulse.app.shared.analysis.ecg.data.EcgMorphologyMarkersIndexes;
import vet.inpulse.math.ArraysUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J%\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0082\u0002J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lvet/inpulse/app/analysis/ecg/services/impl/AiEcgMorphologyAnalysisCreator;", "Lvet/inpulse/app/analysis/ecg/services/EcgMorphologyAnalysisCreator;", "model", "Lvet/inpulse/app/analysis/ecg/services/ml/EcgSegmentationModel;", "<init>", "(Lvet/inpulse/app/analysis/ecg/services/ml/EcgSegmentationModel;)V", "create", "Lvet/inpulse/app/analysis/ecg/services/EcgMorphologyAnalysisCreatorResult;", "modelType", "Lvet/inpulse/app/analysis/ecg/services/ml/SegmentationTrainedModelType;", "indexes", "Lkotlin/ranges/IntRange;", "data", "", "distributeEvenly", "", "", "numIndexes", "start", "end", "buildOutput", "Lvet/inpulse/app/analysis/ecg/services/EcgMorphologyAnalysisCreatorResult$Success;", "Lvet/inpulse/app/shared/analysis/ecg/data/EcgMorphologyMarkersIndexes;", "missingWaves", "", "Lvet/inpulse/app/analysis/ecg/services/ml/EcgSegmentationModel$Wave;", "(Lvet/inpulse/app/shared/analysis/ecg/data/EcgMorphologyMarkersIndexes;[Lvet/inpulse/app/analysis/ecg/services/ml/EcgSegmentationModel$Wave;)Lvet/inpulse/app/analysis/ecg/services/EcgMorphologyAnalysisCreatorResult$Success;", "minus", "value", "createIndexes", "p", "qrs", "t", "app"})
@StabilityInferred(parameters=0)
public final class AiEcgMorphologyAnalysisCreator
implements EcgMorphologyAnalysisCreator {
    @NotNull
    private final EcgSegmentationModel model;
    public static final int $stable = 8;

    public AiEcgMorphologyAnalysisCreator(@NotNull EcgSegmentationModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
    }

    @Override
    @NotNull
    public EcgMorphologyAnalysisCreatorResult create(@NotNull SegmentationTrainedModelType modelType, @NotNull IntRange indexes, @NotNull float[] data) {
        EcgMorphologyAnalysisCreatorResult ecgMorphologyAnalysisCreatorResult;
        Intrinsics.checkNotNullParameter((Object)((Object)modelType), (String)"modelType");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int dataLength = ArraysUtilsKt.length((IntProgression)((IntProgression)indexes));
        SegmentationResult res = this.model.segment(modelType, data, indexes.getFirst(), dataLength);
        if (res instanceof SegmentationResult.Success) {
            EcgMorphologyAnalysisCreatorResult.Success success;
            EcgSegmentationModel.Segments $this$create_u24lambda_u240 = ((SegmentationResult.Success)res).getSegments();
            boolean bl = false;
            int padStart = ((SegmentationResult.Success)res).getPadStart();
            if ($this$create_u24lambda_u240.getP() != null && $this$create_u24lambda_u240.getQrs() != null && $this$create_u24lambda_u240.getT() != null) {
                success = this.buildOutput(this.createIndexes(this.minus($this$create_u24lambda_u240.getP(), padStart), this.minus($this$create_u24lambda_u240.getQrs(), padStart), this.minus($this$create_u24lambda_u240.getT(), padStart)), new EcgSegmentationModel.Wave[0]);
            } else if ($this$create_u24lambda_u240.getP() != null && $this$create_u24lambda_u240.getQrs() != null) {
                List<Integer> distributed = this.distributeEvenly(2, $this$create_u24lambda_u240.getQrs().getLast() - padStart, dataLength);
                IntRange t = RangesKt.until((int)((Number)distributed.get(0)).intValue(), (int)((Number)distributed.get(1)).intValue());
                EcgSegmentationModel.Wave[] waveArray = new EcgSegmentationModel.Wave[]{EcgSegmentationModel.Wave.T};
                success = this.buildOutput(this.createIndexes(this.minus($this$create_u24lambda_u240.getP(), padStart), this.minus($this$create_u24lambda_u240.getQrs(), padStart), t), waveArray);
            } else if ($this$create_u24lambda_u240.getP() != null && $this$create_u24lambda_u240.getT() != null) {
                List<Integer> distributed = this.distributeEvenly(2, $this$create_u24lambda_u240.getP().getLast() - padStart, $this$create_u24lambda_u240.getT().getFirst() - padStart);
                IntRange qrs = RangesKt.until((int)((Number)distributed.get(0)).intValue(), (int)((Number)distributed.get(1)).intValue());
                EcgSegmentationModel.Wave[] waveArray = new EcgSegmentationModel.Wave[]{EcgSegmentationModel.Wave.QRS};
                success = this.buildOutput(this.createIndexes(this.minus($this$create_u24lambda_u240.getP(), padStart), qrs, this.minus($this$create_u24lambda_u240.getT(), padStart)), waveArray);
            } else if ($this$create_u24lambda_u240.getP() != null) {
                List<Integer> distributed = this.distributeEvenly(4, $this$create_u24lambda_u240.getP().getLast() - padStart, dataLength);
                IntRange qrs = RangesKt.until((int)((Number)distributed.get(0)).intValue(), (int)((Number)distributed.get(1)).intValue());
                IntRange t = RangesKt.until((int)((Number)distributed.get(2)).intValue(), (int)((Number)distributed.get(3)).intValue());
                EcgSegmentationModel.Wave[] waveArray = new EcgSegmentationModel.Wave[]{EcgSegmentationModel.Wave.QRS, EcgSegmentationModel.Wave.T};
                success = this.buildOutput(this.createIndexes(this.minus($this$create_u24lambda_u240.getP(), padStart), qrs, t), waveArray);
            } else if ($this$create_u24lambda_u240.getQrs() != null && $this$create_u24lambda_u240.getT() != null) {
                List<Integer> distributed = this.distributeEvenly(2, 0, $this$create_u24lambda_u240.getQrs().getFirst() - padStart);
                IntRange p = RangesKt.until((int)((Number)distributed.get(0)).intValue(), (int)((Number)distributed.get(1)).intValue());
                EcgSegmentationModel.Wave[] t = new EcgSegmentationModel.Wave[]{EcgSegmentationModel.Wave.P};
                success = this.buildOutput(this.createIndexes(p, this.minus($this$create_u24lambda_u240.getQrs(), padStart), this.minus($this$create_u24lambda_u240.getT(), padStart)), t);
            } else if ($this$create_u24lambda_u240.getT() != null) {
                List<Integer> distributed = this.distributeEvenly(4, 0, $this$create_u24lambda_u240.getT().getFirst() - padStart);
                IntRange p = RangesKt.until((int)((Number)distributed.get(0)).intValue(), (int)((Number)distributed.get(1)).intValue());
                IntRange qrs = RangesKt.until((int)((Number)distributed.get(2)).intValue(), (int)((Number)distributed.get(3)).intValue());
                EcgSegmentationModel.Wave[] waveArray = new EcgSegmentationModel.Wave[]{EcgSegmentationModel.Wave.QRS, EcgSegmentationModel.Wave.T};
                success = this.buildOutput(this.createIndexes(p, qrs, this.minus($this$create_u24lambda_u240.getT(), padStart)), waveArray);
            } else {
                List<Integer> distributed = this.distributeEvenly(6, 0, dataLength);
                IntRange p = RangesKt.until((int)((Number)distributed.get(0)).intValue(), (int)((Number)distributed.get(1)).intValue());
                IntRange qrs = RangesKt.until((int)((Number)distributed.get(2)).intValue(), (int)((Number)distributed.get(3)).intValue());
                IntRange t = RangesKt.until((int)((Number)distributed.get(4)).intValue(), (int)((Number)distributed.get(5)).intValue());
                EcgSegmentationModel.Wave[] waveArray = new EcgSegmentationModel.Wave[]{EcgSegmentationModel.Wave.P, EcgSegmentationModel.Wave.QRS, EcgSegmentationModel.Wave.T};
                success = this.buildOutput(this.createIndexes(p, qrs, t), waveArray);
            }
            ecgMorphologyAnalysisCreatorResult = success;
        } else if (res instanceof SegmentationResult.Error) {
            ecgMorphologyAnalysisCreatorResult = new EcgMorphologyAnalysisCreatorResult.Error((SegmentationResult.Error)res);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ecgMorphologyAnalysisCreatorResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> distributeEvenly(int numIndexes, int start, int end) {
        float step = (float)(end - start) / (float)(numIndexes + 1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(numIndexes);
        int n = 0;
        while (n < numIndexes) {
            void it;
            int n2;
            int n3 = n2 = n++;
            ArrayList<Integer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(start + (int)((float)(it + true) * step));
        }
        return arrayList;
    }

    private final EcgMorphologyAnalysisCreatorResult.Success buildOutput(EcgMorphologyMarkersIndexes $this$buildOutput, EcgSegmentationModel.Wave ... missingWaves) {
        return new EcgMorphologyAnalysisCreatorResult.Success($this$buildOutput, ArraysKt.asList((Object[])missingWaves));
    }

    private final IntRange minus(IntRange $this$minus, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        return new IntRange($this$minus.getFirst() - value, $this$minus.getLast() - value);
    }

    private final EcgMorphologyMarkersIndexes createIndexes(IntRange p, IntRange qrs, IntRange t) {
        return new EcgMorphologyMarkersIndexes(p.getFirst(), p.getLast(), qrs.getFirst(), qrs.getLast(), t.getFirst(), t.getLast());
    }
}

