/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.xygraph;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Dp;
import io.github.koalaplot.core.xygraph.DiscreteLinearAxisModel;
import io.github.koalaplot.core.xygraph.LinearAxisModelKt;
import io.github.koalaplot.core.xygraph.TickValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0002H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0002J\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020,2\u0006\u0010-\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b.\u0010/J\u0010\u00100\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0018H\u0002J$\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020)2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0006\u00103\u001a\u00020\u0002H\u0002J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u0018H\u0016J\u0010\u00108\u001a\u0002052\u0006\u00109\u001a\u00020\u0018H\u0016J\u0016\u0010:\u001a\u0002052\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0016J\u0013\u0010<\u001a\u00020\f2\b\u0010=\u001a\u0004\u0018\u00010>H\u0096\u0002J\b\u0010?\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R \u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0#0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006@"}, d2={"Lio/github/koalaplot/core/xygraph/IntLinearAxisModel;", "Lio/github/koalaplot/core/xygraph/DiscreteLinearAxisModel;", "", "range", "Lkotlin/ranges/IntRange;", "minViewExtent", "maxViewExtent", "minimumMajorTickIncrement", "minimumMajorTickSpacing", "Landroidx/compose/ui/unit/Dp;", "minorTickCount", "allowZooming", "", "allowPanning", "inverted", "<init>", "(Lkotlin/ranges/IntRange;IIIFIZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getRange", "()Lkotlin/ranges/IntRange;", "getMinimumMajorTickSpacing-D9Ej5fM", "()F", "F", "offsetComputer", "Lkotlin/Function1;", "", "currentRange", "Landroidx/compose/runtime/MutableState;", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "getCurrentRange$koalaplot_core", "()Landroidx/compose/runtime/MutableState;", "setCurrentRange$koalaplot_core", "(Landroidx/compose/runtime/MutableState;)V", "viewRange", "Landroidx/compose/runtime/State;", "Lkotlin/ranges/ClosedRange;", "getViewRange", "()Landroidx/compose/runtime/State;", "computeOffset", "point", "computeMajorTickValues", "", "minTickSpacing", "computeTickValues", "Lio/github/koalaplot/core/xygraph/TickValues;", "axisLength", "computeTickValues-0680j_4", "(F)Lio/github/koalaplot/core/xygraph/TickValues;", "computeMajorTickSpacing", "computeMinorTickValues", "majorTickValues", "majorTickSpacing", "zoom", "", "zoomFactor", "pivot", "pan", "amount", "setViewRange", "newRange", "equals", "other", "", "hashCode", "koalaplot-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntLinearAxisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/IntLinearAxisModel\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n149#2:369\n149#2:371\n149#2:372\n1#3:370\n78#4:373\n1557#5:374\n1628#5,3:375\n*S KotlinDebug\n*F\n+ 1 IntLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/IntLinearAxisModel\n*L\n54#1:369\n44#1:371\n119#1:372\n122#1:373\n141#1:374\n141#1:375,3\n*E\n"})
public final class IntLinearAxisModel
implements DiscreteLinearAxisModel<Integer> {
    @NotNull
    private final IntRange range;
    private final int minViewExtent;
    private final int maxViewExtent;
    private final int minimumMajorTickIncrement;
    private final float minimumMajorTickSpacing;
    private final int minorTickCount;
    private final boolean allowZooming;
    private final boolean allowPanning;
    private final boolean inverted;
    @NotNull
    private Function1<? super Integer, Float> offsetComputer;
    @NotNull
    private MutableState<ClosedFloatingPointRange<Double>> currentRange;
    @NotNull
    private final State<ClosedRange<Double>> viewRange;
    public static final int $stable = 8;

    private IntLinearAxisModel(IntRange range, int minViewExtent, int maxViewExtent, int minimumMajorTickIncrement, float minimumMajorTickSpacing, int minorTickCount, boolean allowZooming, boolean allowPanning, boolean inverted) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
        this.minViewExtent = minViewExtent;
        this.maxViewExtent = maxViewExtent;
        this.minimumMajorTickIncrement = minimumMajorTickIncrement;
        this.minimumMajorTickSpacing = minimumMajorTickSpacing;
        this.minorTickCount = minorTickCount;
        this.allowZooming = allowZooming;
        this.allowPanning = allowPanning;
        this.inverted = inverted;
        if (!(this.getRange().getLast() > this.getRange().getFirst())) {
            boolean $i$a$-require-IntLinearAxisModel$82 = false;
            String $i$a$-require-IntLinearAxisModel$82 = "Axis range end (" + this.getRange().getLast() + ") must be greater than start (" + this.getRange().getFirst() + ")";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$82.toString());
        }
        boolean $this$dp$iv = false;
        boolean $i$f$getDp = false;
        if (!(Dp.compareTo-0680j_4((float)this.getMinimumMajorTickSpacing-D9Ej5fM(), (float)Dp.constructor-impl((float)((float)$this$dp$iv))) > 0)) {
            boolean $i$a$-require-IntLinearAxisModel$92 = false;
            String $i$a$-require-IntLinearAxisModel$92 = "Minimum major tick spacing must be greater than 0 dp";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$92.toString());
        }
        if (!(this.minViewExtent > 0)) {
            boolean $i$a$-require-IntLinearAxisModel$102 = false;
            String $i$a$-require-IntLinearAxisModel$102 = "minViewExtent must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$102.toString());
        }
        if (!(this.maxViewExtent > 0 && this.maxViewExtent >= this.minViewExtent)) {
            boolean $i$a$-require-IntLinearAxisModel$112 = false;
            String $i$a$-require-IntLinearAxisModel$112 = "maxViewExtent must be greater than 0 and greater than or equal to minViewExtent";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$112.toString());
        }
        if (!(this.minViewExtent <= this.getRange().getLast() - this.getRange().getFirst())) {
            boolean $i$a$-require-IntLinearAxisModel$122 = false;
            String $i$a$-require-IntLinearAxisModel$122 = "minViewExtent must be less than or equal to range";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$122.toString());
        }
        if (!(this.maxViewExtent <= this.getRange().getLast() - this.getRange().getFirst())) {
            boolean $i$a$-require-IntLinearAxisModel$132 = false;
            String $i$a$-require-IntLinearAxisModel$132 = "maxViewExtent must be less than or equal to range";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$132.toString());
        }
        if (!(this.minimumMajorTickIncrement <= this.getRange().getLast() - this.getRange().getFirst())) {
            boolean bl = false;
            String string = "minimumMajorTickIncrement must be less than or equal to the axis range";
            throw new IllegalArgumentException(string.toString());
        }
        this.offsetComputer = arg_0 -> IntLinearAxisModel.offsetComputer$lambda$7(this, arg_0);
        if (this.inverted) {
            this.offsetComputer = arg_0 -> IntLinearAxisModel._init_$lambda$8(this, arg_0);
        }
        this.currentRange = SnapshotStateKt.mutableStateOf$default((Object)RangesKt.rangeTo((double)this.getRange().getFirst(), (double)(this.getRange().getFirst() + this.maxViewExtent)), null, (int)2, null);
        this.viewRange = (State)this.currentRange;
    }

    public /* synthetic */ IntLinearAxisModel(IntRange intRange, int n, int n2, int n3, float f, int n4, boolean bl, boolean bl2, boolean bl3, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = (int)RangesKt.coerceAtLeast((double)((double)(intRange.getLast() - intRange.getFirst()) * 0.2), (double)1.0);
        }
        if ((n5 & 4) != 0) {
            n2 = intRange.getLast() - intRange.getFirst();
        }
        if ((n5 & 8) != 0) {
            n3 = (int)((float)(intRange.getLast() - intRange.getFirst()) * 0.1f);
        }
        if ((n5 & 0x10) != 0) {
            int $this$dp$iv = 50;
            boolean $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        }
        if ((n5 & 0x20) != 0) {
            n4 = 4;
        }
        if ((n5 & 0x40) != 0) {
            bl = true;
        }
        if ((n5 & 0x80) != 0) {
            bl2 = true;
        }
        if ((n5 & 0x100) != 0) {
            bl3 = false;
        }
        this(intRange, n, n2, n3, f, n4, bl, bl2, bl3, null);
    }

    @NotNull
    public IntRange getRange() {
        return this.range;
    }

    @Override
    public float getMinimumMajorTickSpacing-D9Ej5fM() {
        return this.minimumMajorTickSpacing;
    }

    @NotNull
    public final MutableState<ClosedFloatingPointRange<Double>> getCurrentRange$koalaplot_core() {
        return this.currentRange;
    }

    public final void setCurrentRange$koalaplot_core(@NotNull MutableState<ClosedFloatingPointRange<Double>> mutableState) {
        Intrinsics.checkNotNullParameter(mutableState, (String)"<set-?>");
        this.currentRange = mutableState;
    }

    @Override
    @NotNull
    public State<ClosedRange<Double>> getViewRange() {
        return this.viewRange;
    }

    @Override
    public float computeOffset(int point) {
        return ((Number)this.offsetComputer.invoke((Object)point)).floatValue();
    }

    private final List<Integer> computeMajorTickValues(float minTickSpacing) {
        List list;
        int tickSpacing = this.computeMajorTickSpacing(minTickSpacing);
        List $this$computeMajorTickValues_u24lambda_u249 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (tickSpacing > 0) {
            int lastTick;
            int tickCount = (int)Math.floor(((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() / (double)tickSpacing);
            do {
                if ((double)(lastTick = tickCount * tickSpacing) >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)lastTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue()) {
                    $this$computeMajorTickValues_u24lambda_u249.add(lastTick);
                }
                ++tickCount;
            } while ((double)lastTick < ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public TickValues<Integer> computeTickValues-0680j_4(float axisLength) {
        float f;
        boolean $this$dp$iv = false;
        boolean $i$f$getDp = false;
        if (Dp.equals-impl0((float)axisLength, (float)Dp.constructor-impl((float)((float)$this$dp$iv)))) {
            f = 1.0f;
        } else {
            float arg0$iv = this.getMinimumMajorTickSpacing-D9Ej5fM();
            boolean bl = false;
            f = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(arg0$iv / axisLength), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        }
        float minTickSpacing = f;
        List<Integer> majorTickValues = this.computeMajorTickValues(minTickSpacing);
        List<Integer> minorTickValues = this.computeMinorTickValues(majorTickValues, this.computeMajorTickSpacing(minTickSpacing));
        return new TickValues<Integer>(this, majorTickValues, minorTickValues){
            private final List<Integer> majorTickValues;
            private final List<Integer> minorTickValues;
            {
                this.majorTickValues = IntLinearAxisModel.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$majorTickValues) : $majorTickValues;
                this.minorTickValues = IntLinearAxisModel.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$minorTickValues) : $minorTickValues;
            }

            public List<Integer> getMajorTickValues() {
                return this.majorTickValues;
            }

            public List<Integer> getMinorTickValues() {
                return this.minorTickValues;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final int computeMajorTickSpacing(float minTickSpacing) {
        Iterator iterator;
        block3: {
            void $this$mapTo$iv$iv;
            if (!(minTickSpacing > 0.0f && minTickSpacing <= 1.0f)) {
                boolean bl = false;
                String string = "Minimum tick spacing must be greater than 0 and less than or equal to 1";
                throw new IllegalArgumentException(string.toString());
            }
            double length = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue();
            float magnitude = (float)Math.pow(10.0f, (float)Math.floor((float)Math.log10((float)length)));
            Iterable $this$map$iv = LinearAxisModelKt.getTickRatios();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MathKt.roundToInt((float)(it * magnitude)));
            }
            List scaledTickRatios = (List)destination$iv$iv;
            Iterable iterable2 = scaledTickRatios;
            for (Iterator iterator2 : iterable2) {
                int it = ((Number)((Object)iterator2)).intValue();
                boolean bl = false;
                if (!((float)it / (float)length >= minTickSpacing && it >= this.minimumMajorTickIncrement)) continue;
                iterator = iterator2;
                break block3;
            }
            iterator = null;
        }
        Integer n = (Integer)((Object)iterator);
        int tickSpacing = n != null ? n : this.minimumMajorTickIncrement;
        return tickSpacing;
    }

    private final List<Integer> computeMinorTickValues(List<Integer> majorTickValues, int majorTickSpacing) {
        int minorIncrement;
        List list;
        List $this$computeMinorTickValues_u24lambda_u2413 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.minorTickCount > 0 && !((Collection)majorTickValues).isEmpty() && (minorIncrement = majorTickSpacing / (this.minorTickCount + 1)) != 0) {
            int nextTick;
            int n = CollectionsKt.getLastIndex(majorTickValues);
            block0: for (int major = 0; major < n; ++major) {
                int majorTick1 = ((Number)majorTickValues.get(major)).intValue();
                int i = 1;
                int n2 = this.minorTickCount;
                if (i > n2) continue;
                while (true) {
                    $this$computeMinorTickValues_u24lambda_u2413.add(majorTick1 + minorIncrement * i);
                    if (i == n2) continue block0;
                    ++i;
                }
            }
            int i = 1;
            do {
                if ((double)(nextTick = ((Number)CollectionsKt.last(majorTickValues)).intValue() + minorIncrement * i) >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue()) {
                    $this$computeMinorTickValues_u24lambda_u2413.add(nextTick);
                }
                ++i;
            } while ((double)nextTick >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
            i = 1;
            do {
                if ((double)(nextTick = ((Number)CollectionsKt.first(majorTickValues)).intValue() - minorIncrement * i) >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue()) {
                    $this$computeMinorTickValues_u24lambda_u2413.add(nextTick);
                }
                ++i;
                if (!((double)nextTick >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue())) break;
            } while ((double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    public void zoom(float zoomFactor, float pivot) {
        if (!this.allowZooming || zoomFactor == 1.0f) {
            return;
        }
        if (!(zoomFactor > 0.0f)) {
            boolean $i$a$-require-IntLinearAxisModel$zoom$32 = false;
            String $i$a$-require-IntLinearAxisModel$zoom$32 = "Zoom amount must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-IntLinearAxisModel$zoom$32.toString());
        }
        double d = pivot;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean bl = false;
            String string = "Zoom pivot must be between 0 and 1: " + pivot;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(zoomFactor > 1.0f && ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() <= (double)this.minViewExtent || zoomFactor < 1.0f && ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() >= (double)this.maxViewExtent)) {
            double pivotAxisScale = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() + (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue()) * (double)pivot;
            double newLow = pivotAxisScale - (pivotAxisScale - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue()) / (double)zoomFactor;
            double newHi = pivotAxisScale + (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - pivotAxisScale) / (double)zoomFactor;
            this.setViewRange((ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)newLow, (double)newHi)));
        }
    }

    @Override
    public void pan(float amount) {
        if (!this.allowPanning) {
            return;
        }
        double panAxisScale = (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue()) * (double)amount;
        double panLimitEnd = Math.min(panAxisScale, (double)this.getRange().getLast() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        double panLimited = Math.max(panLimitEnd, (double)this.getRange().getFirst() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue());
        double newLow = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() + panLimited;
        double newHi = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() + panLimited;
        this.currentRange.setValue((Object)RangesKt.rangeTo((double)newLow, (double)newHi));
    }

    @Override
    public void setViewRange(@NotNull ClosedRange<Double> newRange) {
        Intrinsics.checkNotNullParameter(newRange, (String)"newRange");
        double newHi = RangesKt.coerceIn((double)((Number)((Object)newRange.getEndInclusive())).doubleValue(), (double)this.getRange().getFirst(), (double)this.getRange().getLast());
        double newLow = RangesKt.coerceIn((double)((Number)((Object)newRange.getStart())).doubleValue(), (double)this.getRange().getFirst(), (double)this.getRange().getLast());
        if (newHi - newLow < (double)this.minViewExtent) {
            double delta = ((double)this.minViewExtent - (newHi - newLow)) / (double)2;
            this.currentRange.setValue((Object)RangesKt.rangeTo((double)(newLow - delta), (double)(newHi + delta)));
            if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() < (double)this.getRange().getFirst()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)this.getRange().getFirst(), (double)(this.getRange().getFirst() + this.minViewExtent)));
            } else if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() > (double)this.getRange().getLast()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)(this.getRange().getLast() - this.minViewExtent), (double)this.getRange().getLast()));
            }
        } else if (newHi - newLow > (double)this.maxViewExtent) {
            double delta = (newHi - newLow - (double)this.maxViewExtent) / (double)2;
            this.currentRange.setValue((Object)RangesKt.rangeTo((double)(newLow + delta), (double)(newHi - delta)));
            if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() < (double)this.getRange().getFirst()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)this.getRange().getFirst(), (double)(this.getRange().getFirst() + this.maxViewExtent)));
            } else if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() > (double)this.getRange().getLast()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)(this.getRange().getLast() - this.maxViewExtent), (double)this.getRange().getLast()));
            }
        } else {
            this.currentRange.setValue((Object)RangesKt.rangeTo((double)newLow, (double)newHi));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IntLinearAxisModel cfr_ignored_0 = (IntLinearAxisModel)other;
        if (!Intrinsics.areEqual((Object)this.getRange(), (Object)((IntLinearAxisModel)other).getRange())) {
            return false;
        }
        if (this.minViewExtent != ((IntLinearAxisModel)other).minViewExtent) {
            return false;
        }
        if (this.minimumMajorTickIncrement != ((IntLinearAxisModel)other).minimumMajorTickIncrement) {
            return false;
        }
        if (!Dp.equals-impl0((float)this.getMinimumMajorTickSpacing-D9Ej5fM(), (float)((IntLinearAxisModel)other).getMinimumMajorTickSpacing-D9Ej5fM())) {
            return false;
        }
        if (this.minorTickCount != ((IntLinearAxisModel)other).minorTickCount) {
            return false;
        }
        if (this.allowZooming != ((IntLinearAxisModel)other).allowZooming) {
            return false;
        }
        return this.allowPanning == ((IntLinearAxisModel)other).allowPanning;
    }

    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + Integer.hashCode(this.minViewExtent);
        result = 31 * result + Integer.hashCode(this.minimumMajorTickIncrement);
        result = 31 * result + Dp.hashCode-impl((float)this.getMinimumMajorTickSpacing-D9Ej5fM());
        result = 31 * result + this.minorTickCount;
        result = 31 * result + Boolean.hashCode(this.allowZooming);
        result = 31 * result + Boolean.hashCode(this.allowPanning);
        return result;
    }

    private static final float offsetComputer$lambda$7(IntLinearAxisModel this$0, int point) {
        return (float)(((double)point - ((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getStart())).doubleValue()) / (((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getStart())).doubleValue()));
    }

    private static final float _init_$lambda$8(IntLinearAxisModel this$0, int point) {
        return (float)((((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getEndInclusive())).doubleValue() - (double)point) / (((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getStart())).doubleValue()));
    }

    public /* synthetic */ IntLinearAxisModel(IntRange range, int minViewExtent, int maxViewExtent, int minimumMajorTickIncrement, float minimumMajorTickSpacing, int minorTickCount, boolean allowZooming, boolean allowPanning, boolean inverted, DefaultConstructorMarker $constructor_marker) {
        this(range, minViewExtent, maxViewExtent, minimumMajorTickIncrement, minimumMajorTickSpacing, minorTickCount, allowZooming, allowPanning, inverted);
    }

    public static final /* synthetic */ boolean access$getInverted$p(IntLinearAxisModel $this) {
        return $this.inverted;
    }
}

