/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.xygraph;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Dp;
import io.github.koalaplot.core.xygraph.ContinuousLinearAxisModel;
import io.github.koalaplot.core.xygraph.LinearAxisModelKt;
import io.github.koalaplot.core.xygraph.TickValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001Be\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$2\u0006\u0010%\u001a\u00020\u0019H\u0002J\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0006\u0010(\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0019H\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020$2\u0006\u0010.\u001a\u00020\u0002H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u0019H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u0019H\u0016J\u0016\u00105\u001a\u0002002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0016J\u0013\u00107\u001a\u00020\r2\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010:\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006;"}, d2={"Lio/github/koalaplot/core/xygraph/DoubleLinearAxisModel;", "Lio/github/koalaplot/core/xygraph/ContinuousLinearAxisModel;", "", "range", "Lkotlin/ranges/ClosedFloatingPointRange;", "minViewExtent", "maxViewExtent", "minimumMajorTickIncrement", "minimumMajorTickSpacing", "Landroidx/compose/ui/unit/Dp;", "minorTickCount", "", "allowZooming", "", "allowPanning", "inverted", "<init>", "(Lkotlin/ranges/ClosedFloatingPointRange;DDDFIZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "getMinimumMajorTickSpacing-D9Ej5fM", "()F", "F", "offsetComputer", "Lkotlin/Function1;", "", "currentRange", "Landroidx/compose/runtime/MutableState;", "viewRange", "Landroidx/compose/runtime/State;", "Lkotlin/ranges/ClosedRange;", "getViewRange", "()Landroidx/compose/runtime/State;", "computeOffset", "point", "computeMajorTickValues", "", "minTickSpacing", "computeTickValues", "Lio/github/koalaplot/core/xygraph/TickValues;", "axisLength", "computeTickValues-0680j_4", "(F)Lio/github/koalaplot/core/xygraph/TickValues;", "computeMajorTickSpacing", "computeMinorTickValues", "majorTickValues", "majorTickSpacing", "zoom", "", "zoomFactor", "pivot", "pan", "amount", "setViewRange", "newRange", "equals", "other", "", "hashCode", "koalaplot-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDoubleLinearAxisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/DoubleLinearAxisModel\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n149#2:369\n149#2:371\n149#2:372\n1#3:370\n78#4:373\n1557#5:374\n1628#5,3:375\n*S KotlinDebug\n*F\n+ 1 DoubleLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/DoubleLinearAxisModel\n*L\n51#1:369\n41#1:371\n117#1:372\n120#1:373\n139#1:374\n139#1:375,3\n*E\n"})
public final class DoubleLinearAxisModel
implements ContinuousLinearAxisModel<Double> {
    @NotNull
    private final ClosedFloatingPointRange<Double> range;
    private final double minViewExtent;
    private final double maxViewExtent;
    private final double minimumMajorTickIncrement;
    private final float minimumMajorTickSpacing;
    private final int minorTickCount;
    private final boolean allowZooming;
    private final boolean allowPanning;
    private final boolean inverted;
    @NotNull
    private Function1<? super Double, Float> offsetComputer;
    @NotNull
    private MutableState<ClosedFloatingPointRange<Double>> currentRange;
    @NotNull
    private final State<ClosedRange<Double>> viewRange;
    public static final int $stable = 8;

    private DoubleLinearAxisModel(ClosedFloatingPointRange<Double> range, double minViewExtent, double maxViewExtent, double minimumMajorTickIncrement, float minimumMajorTickSpacing, int minorTickCount, boolean allowZooming, boolean allowPanning, boolean inverted) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        this.range = range;
        this.minViewExtent = minViewExtent;
        this.maxViewExtent = maxViewExtent;
        this.minimumMajorTickIncrement = minimumMajorTickIncrement;
        this.minimumMajorTickSpacing = minimumMajorTickSpacing;
        this.minorTickCount = minorTickCount;
        this.allowZooming = allowZooming;
        this.allowPanning = allowPanning;
        this.inverted = inverted;
        if (!(((Number)((Object)this.getRange().getEndInclusive())).doubleValue() > ((Number)((Object)this.getRange().getStart())).doubleValue())) {
            boolean $i$a$-require-DoubleLinearAxisModel$82 = false;
            String $i$a$-require-DoubleLinearAxisModel$82 = "Axis range end (" + this.getRange().getEndInclusive() + ") must be greater than start (" + this.getRange().getStart() + ")";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$82.toString());
        }
        boolean $this$dp$iv = false;
        boolean $i$f$getDp = false;
        if (!(Dp.compareTo-0680j_4((float)this.getMinimumMajorTickSpacing-D9Ej5fM(), (float)Dp.constructor-impl((float)((float)$this$dp$iv))) > 0)) {
            boolean $i$a$-require-DoubleLinearAxisModel$92 = false;
            String $i$a$-require-DoubleLinearAxisModel$92 = "Minimum major tick spacing must be greater than 0 dp";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$92.toString());
        }
        if (!(this.minViewExtent > 0.0)) {
            boolean $i$a$-require-DoubleLinearAxisModel$102 = false;
            String $i$a$-require-DoubleLinearAxisModel$102 = "minViewExtent must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$102.toString());
        }
        if (!(this.maxViewExtent > 0.0 && this.maxViewExtent >= this.minViewExtent)) {
            boolean $i$a$-require-DoubleLinearAxisModel$112 = false;
            String $i$a$-require-DoubleLinearAxisModel$112 = "maxViewExtent must be greater than 0 and greater than or equal to minViewExtent";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$112.toString());
        }
        if (!(this.minViewExtent <= ((Number)((Object)this.getRange().getEndInclusive())).doubleValue() - ((Number)((Object)this.getRange().getStart())).doubleValue())) {
            boolean $i$a$-require-DoubleLinearAxisModel$122 = false;
            String $i$a$-require-DoubleLinearAxisModel$122 = "minViewExtent must be less than or equal to range";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$122.toString());
        }
        if (!(this.maxViewExtent <= ((Number)((Object)this.getRange().getEndInclusive())).doubleValue() - ((Number)((Object)this.getRange().getStart())).doubleValue())) {
            boolean $i$a$-require-DoubleLinearAxisModel$132 = false;
            String $i$a$-require-DoubleLinearAxisModel$132 = "maxViewExtent must be less than or equal to range";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$132.toString());
        }
        if (!(this.minimumMajorTickIncrement <= ((Number)((Object)this.getRange().getEndInclusive())).doubleValue() - ((Number)((Object)this.getRange().getStart())).doubleValue())) {
            boolean bl = false;
            String string = "minimumMajorTickIncrement must be less than or equal to the axis range";
            throw new IllegalArgumentException(string.toString());
        }
        this.offsetComputer = arg_0 -> DoubleLinearAxisModel.offsetComputer$lambda$7(this, arg_0);
        if (this.inverted) {
            this.offsetComputer = arg_0 -> DoubleLinearAxisModel._init_$lambda$8(this, arg_0);
        }
        this.currentRange = SnapshotStateKt.mutableStateOf$default((Object)RangesKt.rangeTo((double)((Number)((Object)this.getRange().getStart())).doubleValue(), (double)(((Number)((Object)this.getRange().getStart())).doubleValue() + this.maxViewExtent)), null, (int)2, null);
        this.viewRange = (State)this.currentRange;
    }

    public /* synthetic */ DoubleLinearAxisModel(ClosedFloatingPointRange closedFloatingPointRange, double d, double d2, double d3, float f, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = (((Number)((Object)closedFloatingPointRange.getEndInclusive())).doubleValue() - ((Number)((Object)closedFloatingPointRange.getStart())).doubleValue()) * 0.2;
        }
        if ((n2 & 4) != 0) {
            d2 = ((Number)((Object)closedFloatingPointRange.getEndInclusive())).doubleValue() - ((Number)((Object)closedFloatingPointRange.getStart())).doubleValue();
        }
        if ((n2 & 8) != 0) {
            d3 = (((Number)((Object)closedFloatingPointRange.getEndInclusive())).doubleValue() - ((Number)((Object)closedFloatingPointRange.getStart())).doubleValue()) * (double)0.1f;
        }
        if ((n2 & 0x10) != 0) {
            int $this$dp$iv = 50;
            boolean $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        }
        if ((n2 & 0x20) != 0) {
            n = 4;
        }
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x100) != 0) {
            bl3 = false;
        }
        this(closedFloatingPointRange, d, d2, d3, f, n, bl, bl2, bl3, null);
    }

    @Override
    @NotNull
    public ClosedFloatingPointRange<Double> getRange() {
        return this.range;
    }

    @Override
    public float getMinimumMajorTickSpacing-D9Ej5fM() {
        return this.minimumMajorTickSpacing;
    }

    @Override
    @NotNull
    public State<ClosedRange<Double>> getViewRange() {
        return this.viewRange;
    }

    @Override
    public float computeOffset(double point) {
        return ((Number)this.offsetComputer.invoke((Object)point)).floatValue();
    }

    private final List<Double> computeMajorTickValues(float minTickSpacing) {
        List list;
        double tickSpacing = this.computeMajorTickSpacing(minTickSpacing);
        List $this$computeMajorTickValues_u24lambda_u249 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (tickSpacing > 0.0) {
            double lastTick;
            double tickCount = Math.floor(((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() / tickSpacing);
            do {
                lastTick = tickCount * tickSpacing;
                if (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(lastTick))) {
                    $this$computeMajorTickValues_u24lambda_u249.add(lastTick);
                }
                tickCount += 1.0;
            } while (lastTick < ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public TickValues<Double> computeTickValues-0680j_4(float axisLength) {
        float f;
        boolean $this$dp$iv = false;
        boolean $i$f$getDp = false;
        if (Dp.equals-impl0((float)axisLength, (float)Dp.constructor-impl((float)((float)$this$dp$iv)))) {
            f = 1.0f;
        } else {
            float arg0$iv = this.getMinimumMajorTickSpacing-D9Ej5fM();
            boolean bl = false;
            f = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(arg0$iv / axisLength), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        }
        float minTickSpacing = f;
        List<Double> majorTickValues = this.computeMajorTickValues(minTickSpacing);
        List<Double> minorTickValues = this.computeMinorTickValues(majorTickValues, this.computeMajorTickSpacing(minTickSpacing));
        return new TickValues<Double>(this, majorTickValues, minorTickValues){
            private final List<Double> majorTickValues;
            private final List<Double> minorTickValues;
            {
                this.majorTickValues = DoubleLinearAxisModel.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$majorTickValues) : $majorTickValues;
                this.minorTickValues = DoubleLinearAxisModel.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$minorTickValues) : $minorTickValues;
            }

            public List<Double> getMajorTickValues() {
                return this.majorTickValues;
            }

            public List<Double> getMinorTickValues() {
                return this.minorTickValues;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final double computeMajorTickSpacing(float minTickSpacing) {
        Object v0;
        block3: {
            void $this$mapTo$iv$iv;
            if (!(minTickSpacing > 0.0f && minTickSpacing <= 1.0f)) {
                boolean bl = false;
                String string = "Minimum tick spacing must be greater than 0 and less than or equal to 1";
                throw new IllegalArgumentException(string.toString());
            }
            double length = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue();
            double magnitude = Math.pow(10.0, Math.floor(Math.log10(length)));
            Iterable $this$map$iv = LinearAxisModelKt.getTickRatios();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((double)it * magnitude);
            }
            List scaledTickRatios = (List)destination$iv$iv;
            Iterable iterable2 = scaledTickRatios;
            for (Object t : iterable2) {
                double it = ((Number)t).doubleValue();
                boolean bl = false;
                if (!(it / length >= (double)minTickSpacing && it >= this.minimumMajorTickIncrement)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Double d = v0;
        double tickSpacing = d != null ? d : this.minimumMajorTickIncrement;
        return tickSpacing;
    }

    private final List<Double> computeMinorTickValues(List<Double> majorTickValues, double majorTickSpacing) {
        List list;
        List $this$computeMinorTickValues_u24lambda_u2413 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.minorTickCount > 0 && !((Collection)majorTickValues).isEmpty()) {
            double nextTick;
            double minorIncrement = majorTickSpacing / (double)(this.minorTickCount + 1);
            int n = CollectionsKt.getLastIndex(majorTickValues);
            block0: for (int major = 0; major < n; ++major) {
                double majorTick1 = ((Number)majorTickValues.get(major)).doubleValue();
                int i = 1;
                int n2 = this.minorTickCount;
                if (i > n2) continue;
                while (true) {
                    $this$computeMinorTickValues_u24lambda_u2413.add(majorTick1 + minorIncrement * (double)i);
                    if (i == n2) continue block0;
                    ++i;
                }
            }
            int i = 1;
            do {
                nextTick = ((Number)CollectionsKt.last(majorTickValues)).doubleValue() + minorIncrement * (double)i;
                if (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick))) {
                    $this$computeMinorTickValues_u24lambda_u2413.add(nextTick);
                }
                ++i;
            } while (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick)));
            i = 1;
            do {
                nextTick = ((Number)CollectionsKt.first(majorTickValues)).doubleValue() - minorIncrement * (double)i;
                if (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick))) {
                    $this$computeMinorTickValues_u24lambda_u2413.add(nextTick);
                }
                ++i;
            } while (((ClosedFloatingPointRange)this.currentRange.getValue()).contains((Comparable)Double.valueOf(nextTick)));
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    public void zoom(float zoomFactor, float pivot) {
        if (!this.allowZooming || zoomFactor == 1.0f) {
            return;
        }
        if (!(zoomFactor > 0.0f)) {
            boolean $i$a$-require-DoubleLinearAxisModel$zoom$32 = false;
            String $i$a$-require-DoubleLinearAxisModel$zoom$32 = "Zoom amount must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-DoubleLinearAxisModel$zoom$32.toString());
        }
        double d = pivot;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean bl = false;
            String string = "Zoom pivot must be between 0 and 1: " + pivot;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(zoomFactor > 1.0f && ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() == this.minViewExtent || zoomFactor < 1.0f && ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() == this.maxViewExtent)) {
            double pivotAxisScale = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() + (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue()) * (double)pivot;
            double newLow = pivotAxisScale - (pivotAxisScale - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue()) / (double)zoomFactor;
            double newHi = pivotAxisScale + (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - pivotAxisScale) / (double)zoomFactor;
            this.setViewRange((ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)newLow, (double)newHi)));
        }
    }

    @Override
    public void pan(float amount) {
        if (!this.allowPanning) {
            return;
        }
        double panAxisScale = (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue()) * (double)amount;
        double panLimitEnd = Math.min(panAxisScale, ((Number)((Object)this.getRange().getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        double panLimited = Math.max(panLimitEnd, ((Number)((Object)this.getRange().getStart())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue());
        double newLow = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() + panLimited;
        double newHi = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() + panLimited;
        this.currentRange.setValue((Object)RangesKt.rangeTo((double)newLow, (double)newHi));
    }

    @Override
    public void setViewRange(@NotNull ClosedRange<Double> newRange) {
        Intrinsics.checkNotNullParameter(newRange, (String)"newRange");
        double newHi = ((Number)((Object)RangesKt.coerceIn((Comparable)newRange.getEndInclusive(), this.getRange()))).doubleValue();
        double newLow = ((Number)((Object)RangesKt.coerceIn((Comparable)newRange.getStart(), this.getRange()))).doubleValue();
        if (newHi - newLow < this.minViewExtent) {
            double delta = (this.minViewExtent - (newHi - newLow)) / (double)2;
            this.currentRange.setValue((Object)RangesKt.rangeTo((double)(newLow - delta), (double)(newHi + delta)));
            if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() < ((Number)((Object)this.getRange().getStart())).doubleValue()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)((Number)((Object)this.getRange().getStart())).doubleValue(), (double)(((Number)((Object)this.getRange().getStart())).doubleValue() + this.minViewExtent)));
            } else if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() > ((Number)((Object)this.getRange().getEndInclusive())).doubleValue()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)(((Number)((Object)this.getRange().getEndInclusive())).doubleValue() - this.minViewExtent), (double)((Number)((Object)this.getRange().getEndInclusive())).doubleValue()));
            }
        } else if (newHi - newLow > this.maxViewExtent) {
            double delta = (newHi - newLow - this.maxViewExtent) / (double)2;
            this.currentRange.setValue((Object)RangesKt.rangeTo((double)(newLow + delta), (double)(newHi - delta)));
            if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() < ((Number)((Object)this.getRange().getStart())).doubleValue()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)((Number)((Object)this.getRange().getStart())).doubleValue(), (double)(((Number)((Object)this.getRange().getStart())).doubleValue() + this.maxViewExtent)));
            } else if (((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() > ((Number)((Object)this.getRange().getEndInclusive())).doubleValue()) {
                this.currentRange.setValue((Object)RangesKt.rangeTo((double)(((Number)((Object)this.getRange().getEndInclusive())).doubleValue() - this.maxViewExtent), (double)((Number)((Object)this.getRange().getEndInclusive())).doubleValue()));
            }
        } else {
            this.currentRange.setValue((Object)RangesKt.rangeTo((double)newLow, (double)newHi));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DoubleLinearAxisModel cfr_ignored_0 = (DoubleLinearAxisModel)other;
        if (!Intrinsics.areEqual(this.getRange(), ((DoubleLinearAxisModel)other).getRange())) {
            return false;
        }
        if (!(this.minViewExtent == ((DoubleLinearAxisModel)other).minViewExtent)) {
            return false;
        }
        if (!(this.minimumMajorTickIncrement == ((DoubleLinearAxisModel)other).minimumMajorTickIncrement)) {
            return false;
        }
        if (!Dp.equals-impl0((float)this.getMinimumMajorTickSpacing-D9Ej5fM(), (float)((DoubleLinearAxisModel)other).getMinimumMajorTickSpacing-D9Ej5fM())) {
            return false;
        }
        if (this.minorTickCount != ((DoubleLinearAxisModel)other).minorTickCount) {
            return false;
        }
        if (this.allowZooming != ((DoubleLinearAxisModel)other).allowZooming) {
            return false;
        }
        return this.allowPanning == ((DoubleLinearAxisModel)other).allowPanning;
    }

    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + Double.hashCode(this.minViewExtent);
        result = 31 * result + Double.hashCode(this.minimumMajorTickIncrement);
        result = 31 * result + Dp.hashCode-impl((float)this.getMinimumMajorTickSpacing-D9Ej5fM());
        result = 31 * result + this.minorTickCount;
        result = 31 * result + Boolean.hashCode(this.allowZooming);
        result = 31 * result + Boolean.hashCode(this.allowPanning);
        return result;
    }

    private static final float offsetComputer$lambda$7(DoubleLinearAxisModel this$0, double point) {
        return (float)((point - ((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getStart())).doubleValue()) / (((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getStart())).doubleValue()));
    }

    private static final float _init_$lambda$8(DoubleLinearAxisModel this$0, double point) {
        return (float)((((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getEndInclusive())).doubleValue() - point) / (((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this$0.currentRange.getValue()).getStart())).doubleValue()));
    }

    public /* synthetic */ DoubleLinearAxisModel(ClosedFloatingPointRange range, double minViewExtent, double maxViewExtent, double minimumMajorTickIncrement, float minimumMajorTickSpacing, int minorTickCount, boolean allowZooming, boolean allowPanning, boolean inverted, DefaultConstructorMarker $constructor_marker) {
        this((ClosedFloatingPointRange<Double>)range, minViewExtent, maxViewExtent, minimumMajorTickIncrement, minimumMajorTickSpacing, minorTickCount, allowZooming, allowPanning, inverted);
    }

    public static final /* synthetic */ boolean access$getInverted$p(DoubleLinearAxisModel $this) {
        return $this.inverted;
    }
}

