/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.util;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0080\u0002\u00a2\u0006\u0002\b\u000fJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0080\u0002\u00a2\u0006\u0002\b\u0012J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004H\u0080\u0002\u00a2\u0006\u0002\b\u0015J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0000H\u0080\u0002\u00a2\u0006\u0002\b\u0012J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0080\u0002\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0080\u0002\u00a2\u0006\u0002\b\u001aJ\r\u0010\u001b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u001e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lio/github/koalaplot/core/util/Vector;", "", "values", "", "", "<init>", "(Ljava/util/List;)V", "x", "y", "(FF)V", "getValues", "()Ljava/util/List;", "get", "i", "", "get$koalaplot_core", "times", "scalar", "times$koalaplot_core", "div", "f", "div$koalaplot_core", "vector", "plus", "plus$koalaplot_core", "minus", "minus$koalaplot_core", "norm", "norm$koalaplot_core", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "koalaplot-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nio/github/koalaplot/core/util/Vector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1557#2:120\n1628#2,3:121\n1812#2,4:125\n1567#2:129\n1598#2,4:130\n1567#2:134\n1598#2,4:135\n1797#2,3:139\n1#3:124\n*S KotlinDebug\n*F\n+ 1 Vector.kt\nio/github/koalaplot/core/util/Vector\n*L\n41#1:120\n41#1:121,3\n53#1:125,4\n62#1:129\n62#1:130,4\n71#1:134\n71#1:135,4\n79#1:139,3\n*E\n"})
public final class Vector {
    @NotNull
    private final List<Float> values;
    public static final int $stable = 8;

    public Vector(@NotNull List<Float> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = values;
    }

    @NotNull
    public final List<Float> getValues() {
        return this.values;
    }

    public Vector(float x, float y2) {
        Object[] objectArray = new Float[]{Float.valueOf(x), Float.valueOf(y2)};
        this(CollectionsKt.listOf((Object[])objectArray));
    }

    public final float get$koalaplot_core(int i) {
        return ((Number)this.values.get(i)).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vector times$koalaplot_core(float scalar) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)(it * scalar)));
        }
        List list = (List)destination$iv$iv;
        return new Vector(list);
    }

    @NotNull
    public final Vector div$koalaplot_core(float f) {
        return this.times$koalaplot_core(1.0f / f);
    }

    /*
     * WARNING - void declaration
     */
    public final float times$koalaplot_core(@NotNull Vector vector) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (!(this.values.size() == vector.values.size())) {
            boolean $i$a$-require-Vector$times$32 = false;
            String $i$a$-require-Vector$times$32 = "Dot product requires that both vectors are the same length";
            throw new IllegalArgumentException($i$a$-require-Vector$times$32.toString());
        }
        Iterable iterable = this.values;
        float initial$iv = 0.0f;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        float accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void t;
            void acc;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)element$iv).floatValue();
            float f2 = accumulator$iv;
            int index = n;
            boolean bl = false;
            accumulator$iv = acc + t * ((Number)vector.values.get(index)).floatValue();
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vector plus$koalaplot_core(@NotNull Vector vector) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (!(this.values.size() == vector.values.size())) {
            boolean $i$a$-require-Vector$plus$22 = false;
            String $i$a$-require-Vector$plus$22 = "Addition requires that both vectors are the same length";
            throw new IllegalArgumentException($i$a$-require-Vector$plus$22.toString());
        }
        Iterable $this$mapIndexed$iv = this.values;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv$iv).floatValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)(i + ((Number)vector.values.get((int)index)).floatValue())));
        }
        List list = (List)destination$iv$iv;
        return new Vector(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vector minus$koalaplot_core(@NotNull Vector vector) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (!(this.values.size() == vector.values.size())) {
            boolean $i$a$-require-Vector$minus$22 = false;
            String $i$a$-require-Vector$minus$22 = "Subtraction requires that both vectors are the same length";
            throw new IllegalArgumentException($i$a$-require-Vector$minus$22.toString());
        }
        Iterable $this$mapIndexed$iv = this.values;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv$iv).floatValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)(i - ((Number)vector.values.get((int)index)).floatValue())));
        }
        List list = (List)destination$iv$iv;
        return new Vector(list);
    }

    /*
     * WARNING - void declaration
     */
    public final float norm$koalaplot_core() {
        void $this$fold$iv;
        Iterable iterable = this.values;
        float initial$iv = 0.0f;
        boolean $i$f$fold = false;
        float accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void fl;
            float f = ((Number)element$iv).floatValue();
            float acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + fl * fl;
        }
        return (float)Math.sqrt(accumulator$iv);
    }

    @NotNull
    public final List<Float> component1() {
        return this.values;
    }

    @NotNull
    public final Vector copy(@NotNull List<Float> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new Vector(values);
    }

    public static /* synthetic */ Vector copy$default(Vector vector, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = vector.values;
        }
        return vector.copy(list);
    }

    @NotNull
    public String toString() {
        return "Vector(values=" + this.values + ")";
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)other;
        return Intrinsics.areEqual(this.values, vector.values);
    }
}

