/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.polar;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.koalaplot.core.polar.AngularAxisModel;
import io.github.koalaplot.core.util.AngularValue;
import io.github.koalaplot.core.util.Radians;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J3\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lio/github/koalaplot/core/polar/CategoryAngularAxisModel;", "T", "Lio/github/koalaplot/core/polar/AngularAxisModel;", "categories", "", "angleDirection", "Lio/github/koalaplot/core/polar/AngularAxisModel$AngleDirection;", "angleZero", "Lio/github/koalaplot/core/polar/AngularAxisModel$AngleZero;", "<init>", "(Ljava/util/List;Lio/github/koalaplot/core/polar/AngularAxisModel$AngleDirection;Lio/github/koalaplot/core/polar/AngularAxisModel$AngleZero;)V", "getAngleDirection", "()Lio/github/koalaplot/core/polar/AngularAxisModel$AngleDirection;", "getAngleZero", "()Lio/github/koalaplot/core/polar/AngularAxisModel$AngleZero;", "getTickValues", "computeOffset", "Lio/github/koalaplot/core/util/AngularValue;", "point", "(Ljava/lang/Object;)Lio/github/koalaplot/core/util/AngularValue;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "koalaplot-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAngularAxisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularAxisModel.kt\nio/github/koalaplot/core/polar/CategoryAngularAxisModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Geometry.kt\nio/github/koalaplot/core/util/GeometryKt\n*L\n1#1,124:1\n1#2:125\n77#3:126\n*S KotlinDebug\n*F\n+ 1 AngularAxisModel.kt\nio/github/koalaplot/core/polar/CategoryAngularAxisModel\n*L\n75#1:126\n*E\n"})
public final class CategoryAngularAxisModel<T>
implements AngularAxisModel<T> {
    @NotNull
    private final List<T> categories;
    @NotNull
    private final AngularAxisModel.AngleDirection angleDirection;
    @NotNull
    private final AngularAxisModel.AngleZero angleZero;
    public static final int $stable = 8;

    public CategoryAngularAxisModel(@NotNull List<? extends T> categories, @NotNull AngularAxisModel.AngleDirection angleDirection, @NotNull AngularAxisModel.AngleZero angleZero) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)angleDirection), (String)"angleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)angleZero), (String)"angleZero");
        this.categories = categories;
        this.angleDirection = angleDirection;
        this.angleZero = angleZero;
    }

    public /* synthetic */ CategoryAngularAxisModel(List list, AngularAxisModel.AngleDirection angleDirection, AngularAxisModel.AngleZero angleZero, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            angleDirection = AngularAxisModel.AngleDirection.CLOCKWISE;
        }
        if ((n & 4) != 0) {
            angleZero = AngularAxisModel.AngleZero.TWELVE_OCLOCK;
        }
        this(list, angleDirection, angleZero);
    }

    @Override
    @NotNull
    public AngularAxisModel.AngleDirection getAngleDirection() {
        return this.angleDirection;
    }

    @Override
    @NotNull
    public AngularAxisModel.AngleZero getAngleZero() {
        return this.angleZero;
    }

    @Override
    @NotNull
    public List<T> getTickValues() {
        return this.categories;
    }

    @Override
    @NotNull
    public AngularValue computeOffset(T point) {
        int index = this.categories.indexOf(point);
        if (!(index != -1)) {
            boolean bl = false;
            String string = "The provided category '" + point + "' is not a valid value for this axis.";
            throw new IllegalArgumentException(string.toString());
        }
        double $this$rad$iv = (double)index * 2.0 * Math.PI / (double)this.categories.size();
        boolean $i$f$getRad = false;
        return Radians.box-impl(Radians.constructor-impl($this$rad$iv));
    }

    private final List<T> component1() {
        return this.categories;
    }

    @NotNull
    public final AngularAxisModel.AngleDirection component2() {
        return this.angleDirection;
    }

    @NotNull
    public final AngularAxisModel.AngleZero component3() {
        return this.angleZero;
    }

    @NotNull
    public final CategoryAngularAxisModel<T> copy(@NotNull List<? extends T> categories, @NotNull AngularAxisModel.AngleDirection angleDirection, @NotNull AngularAxisModel.AngleZero angleZero) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)angleDirection), (String)"angleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)angleZero), (String)"angleZero");
        return new CategoryAngularAxisModel<T>(categories, angleDirection, angleZero);
    }

    public static /* synthetic */ CategoryAngularAxisModel copy$default(CategoryAngularAxisModel categoryAngularAxisModel, List list, AngularAxisModel.AngleDirection angleDirection, AngularAxisModel.AngleZero angleZero, int n, Object object) {
        if ((n & 1) != 0) {
            list = categoryAngularAxisModel.categories;
        }
        if ((n & 2) != 0) {
            angleDirection = categoryAngularAxisModel.angleDirection;
        }
        if ((n & 4) != 0) {
            angleZero = categoryAngularAxisModel.angleZero;
        }
        return categoryAngularAxisModel.copy(list, angleDirection, angleZero);
    }

    @NotNull
    public String toString() {
        return "CategoryAngularAxisModel(categories=" + this.categories + ", angleDirection=" + this.angleDirection + ", angleZero=" + this.angleZero + ")";
    }

    public int hashCode() {
        int result = ((Object)this.categories).hashCode();
        result = result * 31 + this.angleDirection.hashCode();
        result = result * 31 + this.angleZero.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CategoryAngularAxisModel)) {
            return false;
        }
        CategoryAngularAxisModel categoryAngularAxisModel = (CategoryAngularAxisModel)other;
        if (!Intrinsics.areEqual(this.categories, categoryAngularAxisModel.categories)) {
            return false;
        }
        if (this.angleDirection != categoryAngularAxisModel.angleDirection) {
            return false;
        }
        return this.angleZero == categoryAngularAxisModel.angleZero;
    }
}

