/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.pie;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.layout.Placeable;
import io.github.koalaplot.core.pie.CircularLabelPositionProviderKt;
import io.github.koalaplot.core.pie.ExternalLabelPosition;
import io.github.koalaplot.core.pie.InternalLabelPosition;
import io.github.koalaplot.core.pie.LabelPosition;
import io.github.koalaplot.core.pie.LabelPositionProvider;
import io.github.koalaplot.core.pie.None;
import io.github.koalaplot.core.pie.PieLabelPlacement;
import io.github.koalaplot.core.pie.PieParameters;
import io.github.koalaplot.core.pie.PieSliceData;
import io.github.koalaplot.core.pie.Quadrant;
import io.github.koalaplot.core.pie.SliceLabelData;
import io.github.koalaplot.core.util.AngularValue;
import io.github.koalaplot.core.util.Degrees;
import io.github.koalaplot.core.util.GeometryKt;
import io.github.koalaplot.core.util.PolarCoordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001)B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u0016J6\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\t0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u0002J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\t0\u0012H\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/github/koalaplot/core/pie/CircularLabelPositionProvider;", "Lio/github/koalaplot/core/pie/LabelPositionProvider;", "labelSpacing", "", "labelPlacement", "Lio/github/koalaplot/core/pie/PieLabelPlacement;", "<init>", "(FLio/github/koalaplot/core/pie/PieLabelPlacement;)V", "computeLabelPositions", "", "Lio/github/koalaplot/core/pie/LabelPosition;", "pieDiameter", "holeSize", "placeables", "Landroidx/compose/ui/layout/Placeable;", "pieSliceData", "Lio/github/koalaplot/core/pie/PieSliceData;", "groupLabels", "", "Lio/github/koalaplot/core/pie/Quadrant;", "Lio/github/koalaplot/core/pie/SliceLabelData;", "labelPlaceables", "pieSliceDatas", "computeInQuadrant", "pieParameters", "Lio/github/koalaplot/core/pie/PieParameters;", "sliceLabelData", "quadrant", "yState", "Lio/github/koalaplot/core/pie/CircularLabelPositionProvider$YState;", "sliceGroups", "computeExternalLabelOffset", "Lio/github/koalaplot/core/pie/ExternalLabelPosition;", "lastY", "computeInternalLabelOffset", "isBounded", "", "innerRadius", "outerRadius", "pt", "Lio/github/koalaplot/core/util/PolarCoordinate;", "YState", "koalaplot-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCircularLabelPositionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircularLabelPositionProvider.kt\nio/github/koalaplot/core/pie/CircularLabelPositionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Geometry.kt\nio/github/koalaplot/core/util/GeometryKt\n*L\n1#1,371:1\n1872#2,2:372\n1874#2:375\n1863#2,2:376\n1863#2,2:378\n1863#2,2:380\n1863#2,2:382\n1053#2:384\n1557#2:385\n1628#2,3:386\n1#3:374\n80#4:389\n79#4:390\n*S KotlinDebug\n*F\n+ 1 CircularLabelPositionProvider.kt\nio/github/koalaplot/core/pie/CircularLabelPositionProvider\n*L\n89#1:372,2\n89#1:375\n144#1:376,2\n149#1:378,2\n155#1:380,2\n160#1:382,2\n164#1:384\n164#1:385\n164#1:386,3\n253#1:389\n278#1:390\n*E\n"})
public final class CircularLabelPositionProvider
implements LabelPositionProvider {
    private final float labelSpacing;
    @NotNull
    private final PieLabelPlacement labelPlacement;
    public static final int $stable = 8;

    public CircularLabelPositionProvider(float labelSpacing, @NotNull PieLabelPlacement labelPlacement) {
        Intrinsics.checkNotNullParameter((Object)labelPlacement, (String)"labelPlacement");
        this.labelSpacing = labelSpacing;
        this.labelPlacement = labelPlacement;
    }

    public /* synthetic */ CircularLabelPositionProvider(float f, PieLabelPlacement pieLabelPlacement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pieLabelPlacement = PieLabelPlacement.External.INSTANCE;
        }
        this(f, pieLabelPlacement);
    }

    @Override
    @NotNull
    public List<LabelPosition> computeLabelPositions(float pieDiameter, float holeSize, @NotNull List<? extends Placeable> placeables, @NotNull List<PieSliceData> pieSliceData) {
        Intrinsics.checkNotNullParameter(placeables, (String)"placeables");
        Intrinsics.checkNotNullParameter(pieSliceData, (String)"pieSliceData");
        return this.computeLabelPositions(new PieParameters(pieDiameter, holeSize, this.labelPlacement), this.groupLabels(placeables, pieSliceData));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Quadrant, List<SliceLabelData>> groupLabels(List<? extends Placeable> labelPlaceables, List<PieSliceData> pieSliceDatas) {
        HashMap sliceGroups = new HashMap();
        Iterable $this$forEachIndexed$iv = labelPlaceables;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void placeable;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Placeable placeable2 = (Placeable)item$iv;
            int index = n;
            boolean bl = false;
            AngularValue centerAngle = GeometryKt.plus(pieSliceDatas.get(index).getStartAngle(), GeometryKt.div(pieSliceDatas.get(index).getAngle(), 2.0f));
            Quadrant matchingQuadrant = Quadrant.Companion.from(centerAngle);
            Map map = sliceGroups;
            Object object = ((Map)sliceGroups).get((Object)matchingQuadrant);
            if (object == null) {
                boolean bl2 = false;
                object = new ArrayList();
            }
            Object v = object;
            List $this$groupLabels_u24lambda_u242_u24lambda_u241 = (List)v;
            boolean bl3 = false;
            $this$groupLabels_u24lambda_u242_u24lambda_u241.add(new SliceLabelData(index, pieSliceDatas.get(index), (Placeable)placeable, centerAngle));
            map.put(matchingQuadrant, v);
        }
        return sliceGroups;
    }

    private final LabelPosition computeInQuadrant(PieParameters pieParameters, SliceLabelData sliceLabelData, Quadrant quadrant, YState yState) {
        LabelPosition pos1 = null;
        if (!(pieParameters.getLabelPlacement() instanceof PieLabelPlacement.External)) {
            pos1 = this.computeInternalLabelOffset(pieParameters, sliceLabelData);
        }
        if (pos1 == null || pos1 instanceof None && pieParameters.getLabelPlacement() instanceof PieLabelPlacement.InternalOrExternal) {
            pos1 = this.computeExternalLabelOffset(pieParameters, sliceLabelData, quadrant, yState.getLast());
            if (CircularLabelPositionProviderKt.access$isNorth(quadrant)) {
                yState.setLast(Offset.getY-impl((long)((ExternalLabelPosition)pos1).getPosition-F1C5BW0()));
                yState.setMax(Math.max(yState.getMax(), Offset.getY-impl((long)((ExternalLabelPosition)pos1).getPosition-F1C5BW0()) + (float)sliceLabelData.getLabelPlaceable().getHeight()));
            } else {
                yState.setLast(Offset.getY-impl((long)((ExternalLabelPosition)pos1).getPosition-F1C5BW0()) + (float)sliceLabelData.getLabelPlaceable().getHeight());
            }
        }
        return pos1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LabelPosition> computeLabelPositions(PieParameters pieParameters, Map<Quadrant, ? extends List<SliceLabelData>> sliceGroups) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SliceLabelData it;
        Iterable $this$forEach$iv;
        HashMap sliceOffsetMap = new HashMap();
        YState yState = new YState(Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY);
        List list = sliceGroups.get((Object)Quadrant.NorthEast);
        if (list != null && (list = CollectionsKt.reversed((Iterable)list)) != null) {
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                SliceLabelData it2 = (SliceLabelData)element$iv;
                boolean bl = false;
                ((Map)sliceOffsetMap).put(it2.getIndex(), this.computeInQuadrant(pieParameters, it2, Quadrant.NorthEast, yState));
            }
        }
        yState.setLast(yState.getMax());
        List<SliceLabelData> list2 = sliceGroups.get((Object)Quadrant.SouthEast);
        if (list2 != null) {
            $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SliceLabelData)element$iv;
                boolean bl = false;
                ((Map)sliceOffsetMap).put(it.getIndex(), this.computeInQuadrant(pieParameters, it, Quadrant.SouthEast, yState));
            }
        }
        yState.setLast(Float.POSITIVE_INFINITY);
        yState.setMax(Float.NEGATIVE_INFINITY);
        List<SliceLabelData> list3 = sliceGroups.get((Object)Quadrant.NorthWest);
        if (list3 != null) {
            $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SliceLabelData)element$iv;
                boolean bl = false;
                ((Map)sliceOffsetMap).put(it.getIndex(), this.computeInQuadrant(pieParameters, it, Quadrant.NorthWest, yState));
            }
        }
        yState.setLast(yState.getMax());
        List list4 = sliceGroups.get((Object)Quadrant.SouthWest);
        if (list4 != null && (list4 = CollectionsKt.reversed((Iterable)list4)) != null) {
            Iterable $this$forEach$iv3 = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                SliceLabelData it3 = (SliceLabelData)element$iv;
                boolean bl = false;
                ((Map)sliceOffsetMap).put(it3.getIndex(), this.computeInQuadrant(pieParameters, it3, Quadrant.SouthWest, yState));
            }
        }
        Set set = sliceOffsetMap.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$map = false;
        void $this$forEach$iv3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            Map.Entry bl = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add((LabelPosition)it4.getValue());
        }
        return (List)destination$iv$iv;
    }

    private final ExternalLabelPosition computeExternalLabelOffset(PieParameters pieParameters, SliceLabelData sliceLabelData, Quadrant quadrant, float lastY) {
        double d;
        float f;
        AngularValue angle = sliceLabelData.getCenterAngle();
        Placeable placeable = sliceLabelData.getLabelPlaceable();
        float labelDiameter = pieParameters.getPieDiameter() * this.labelSpacing;
        boolean isLeftSide = CircularLabelPositionProviderKt.access$isWest(quadrant);
        float labelTop = CircularLabelPositionProviderKt.access$isSouth(quadrant) ? Math.max(labelDiameter / 2.0f * (float)GeometryKt.sin(angle) - (float)placeable.getHeight() / 2.0f, lastY) : Math.min(labelDiameter / 2.0f * (float)GeometryKt.sin(angle) - (float)placeable.getHeight() / 2.0f, lastY - (float)placeable.getHeight());
        float labelBottom = labelTop + (float)placeable.getHeight();
        Pair<Float, Float> thetas1 = GeometryKt.y2theta(labelTop, labelDiameter / 2.0f);
        Pair<Float, Float> thetas2 = GeometryKt.y2theta(labelBottom, labelDiameter / 2.0f);
        float xLimit = labelDiameter / 2.0f * (float)GeometryKt.cos(angle);
        if (isLeftSide) {
            float xMin2;
            float xMin1 = Float.isNaN(((Number)thetas1.getFirst()).floatValue()) ? Float.POSITIVE_INFINITY : labelDiameter / 2.0f * Math.min((float)Math.cos(((Number)thetas1.getFirst()).floatValue()), (float)Math.cos(((Number)thetas1.getSecond()).floatValue()));
            float f2 = xMin2 = Float.isNaN(((Number)thetas2.getFirst()).floatValue()) ? Float.POSITIVE_INFINITY : labelDiameter / 2.0f * Math.min((float)Math.cos(((Number)thetas2.getFirst()).floatValue()), (float)Math.cos(((Number)thetas2.getSecond()).floatValue()));
            f = Float.isInfinite(xMin1) && Float.isInfinite(xMin2) ? xLimit : Math.min(Math.min(xMin1, xMin2), xLimit);
        } else {
            float xMax1 = Float.isNaN(((Number)thetas1.getFirst()).floatValue()) ? Float.NEGATIVE_INFINITY : labelDiameter / 2.0f * Math.max((float)Math.cos(((Number)thetas1.getFirst()).floatValue()), (float)Math.cos(((Number)thetas1.getSecond()).floatValue()));
            float xMax2 = Float.isNaN(((Number)thetas2.getFirst()).floatValue()) ? Float.NEGATIVE_INFINITY : labelDiameter / 2.0f * Math.max((float)Math.cos(((Number)thetas2.getFirst()).floatValue()), (float)Math.cos(((Number)thetas2.getSecond()).floatValue()));
            f = Float.isInfinite(xMax1) && Float.isInfinite(xMax2) ? xLimit : Math.max(Math.max(xMax1, xMax2), xLimit);
        }
        float xOffset = f;
        long offset = OffsetKt.Offset((float)xOffset, (float)labelTop);
        if (isLeftSide) {
            offset = Offset.plus-MK-Hz9U((long)offset, (long)OffsetKt.Offset((float)(-((float)placeable.getWidth())), (float)0.0f));
        }
        long anchorPoint = Offset.plus-MK-Hz9U((long)Offset.plus-MK-Hz9U((long)offset, (long)OffsetKt.Offset((float)0.0f, (float)((float)placeable.getHeight() / 2.0f))), (long)(isLeftSide ? OffsetKt.Offset((float)placeable.getWidth(), (float)0.0f) : OffsetKt.Offset((float)0.0f, (float)0.0f)));
        if (isLeftSide) {
            boolean $this$deg$iv = false;
            boolean $i$f$getDeg = false;
            d = Degrees.constructor-impl((double)$this$deg$iv);
        } else {
            int $this$deg$iv = 180;
            boolean $i$f$getDeg = false;
            d = Degrees.constructor-impl($this$deg$iv);
        }
        return new ExternalLabelPosition(offset, anchorPoint, Degrees.box-impl(d), null);
    }

    private final LabelPosition computeInternalLabelOffset(PieParameters pieParameters, SliceLabelData sliceLabelData) {
        float f;
        PieSliceData pieSliceData = sliceLabelData.getPieSliceData();
        Placeable placeable = sliceLabelData.getLabelPlaceable();
        PieLabelPlacement pieLabelPlacement = pieParameters.getLabelPlacement();
        if (pieLabelPlacement instanceof PieLabelPlacement.Internal) {
            f = ((PieLabelPlacement.Internal)pieParameters.getLabelPlacement()).getRadius();
        } else if (pieLabelPlacement instanceof PieLabelPlacement.InternalOrExternal) {
            f = ((PieLabelPlacement.InternalOrExternal)pieParameters.getLabelPlacement()).getRadius();
        } else {
            return None.INSTANCE;
        }
        float radius = f;
        float innerRadius = pieParameters.getPieDiameter() / 2.0f * pieParameters.getHoleSize();
        float outerRadius = pieParameters.getPieDiameter() / 2.0f;
        double $this$deg$iv = GeometryKt.toDegrees(pieSliceData.getAngle()) / (double)2.0f;
        boolean $i$f$getDeg = false;
        long labelCenter = GeometryKt.polarToCartesian(outerRadius * radius, GeometryKt.plus(pieSliceData.getStartAngle(), Degrees.box-impl(Degrees.constructor-impl($this$deg$iv))));
        PolarCoordinate c1 = GeometryKt.cartesianToPolar-k-4lQ0M(OffsetKt.Offset((float)(Offset.getX-impl((long)labelCenter) - (float)(placeable.getWidth() / 2)), (float)(Offset.getY-impl((long)labelCenter) - (float)(placeable.getHeight() / 2))));
        PolarCoordinate c2 = GeometryKt.cartesianToPolar-k-4lQ0M(OffsetKt.Offset((float)(Offset.getX-impl((long)labelCenter) + (float)(placeable.getWidth() / 2)), (float)(Offset.getY-impl((long)labelCenter) - (float)(placeable.getHeight() / 2))));
        PolarCoordinate c3 = GeometryKt.cartesianToPolar-k-4lQ0M(OffsetKt.Offset((float)(Offset.getX-impl((long)labelCenter) - (float)(placeable.getWidth() / 2)), (float)(Offset.getY-impl((long)labelCenter) + (float)(placeable.getHeight() / 2))));
        PolarCoordinate c4 = GeometryKt.cartesianToPolar-k-4lQ0M(OffsetKt.Offset((float)(Offset.getX-impl((long)labelCenter) + (float)(placeable.getWidth() / 2)), (float)(Offset.getY-impl((long)labelCenter) + (float)(placeable.getHeight() / 2))));
        boolean bounded = this.isBounded(innerRadius, outerRadius, pieSliceData, c1) && this.isBounded(innerRadius, outerRadius, pieSliceData, c2) && this.isBounded(innerRadius, outerRadius, pieSliceData, c3) && this.isBounded(innerRadius, outerRadius, pieSliceData, c4);
        return bounded ? (LabelPosition)new InternalLabelPosition(OffsetKt.Offset((float)(Offset.getX-impl((long)labelCenter) - (float)(placeable.getWidth() / 2)), (float)(Offset.getY-impl((long)labelCenter) - (float)(placeable.getHeight() / 2))), null) : (LabelPosition)None.INSTANCE;
    }

    private final boolean isBounded(float innerRadius, float outerRadius, PieSliceData pieSliceData, PolarCoordinate pt) {
        double pointAngle;
        double startNorm = (GeometryKt.toDegrees(pieSliceData.getStartAngle()) % 360.0 + 360.0) % 360.0;
        double endNorm = startNorm + GeometryKt.toDegrees(pieSliceData.getAngle());
        for (pointAngle = GeometryKt.toDegrees(pt.getAngle()); pointAngle < startNorm; pointAngle += 360.0) {
        }
        return pointAngle < endNorm && pt.getRadius() < outerRadius && pt.getRadius() > innerRadius;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lio/github/koalaplot/core/pie/CircularLabelPositionProvider$YState;", "", "last", "", "max", "<init>", "(FF)V", "getLast", "()F", "setLast", "(F)V", "getMax", "setMax", "koalaplot-core"})
    private static final class YState {
        private float last;
        private float max;

        public YState(float last, float max) {
            this.last = last;
            this.max = max;
        }

        public final float getLast() {
            return this.last;
        }

        public final void setLast(float f) {
            this.last = f;
        }

        public final float getMax() {
            return this.max;
        }

        public final void setMax(float f) {
            this.max = f;
        }
    }
}

