/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.transport.tcp.TcpBusAddress;

public class TcpTransport
extends AbstractTransport {
    private final int timeout;
    private SocketChannel socket;
    private ServerSocketChannel serverSocket;

    TcpTransport(BusAddress _address, int _timeout, TransportConfig _config) {
        super(_address, _config);
        this.timeout = _timeout;
        this.getSaslConfig().setAuthMode(2);
    }

    protected boolean hasFileDescriptorSupport() {
        return false;
    }

    public TcpBusAddress getAddress() {
        return (TcpBusAddress)super.getAddress();
    }

    protected boolean isBound() {
        return this.serverSocket != null && this.serverSocket.isOpen();
    }

    protected void bindImpl() throws IOException {
        if (!this.getAddress().isListeningSocket()) {
            throw new IOException("Cannot listen on client connections (use connectImpl() instead)");
        }
        if (!this.isBound()) {
            InetSocketAddress socketAddress = new InetSocketAddress(this.getAddress().getHost(), this.getAddress().getPort());
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.configureBlocking(true);
            this.getLogger().debug("Binding to {} using local port {}", (Object)this.getAddress().getHost(), (Object)this.getAddress().getPort());
            this.serverSocket.bind(socketAddress);
        }
    }

    protected SocketChannel acceptImpl() throws IOException {
        this.socket = this.serverSocket.accept();
        return this.socket;
    }

    public SocketChannel connectImpl() throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(this.getAddress().getHost(), this.getAddress().getPort());
        if (this.getAddress().isListeningSocket()) {
            throw new IOException("Connect connect to a listening socket (use listenImpl() instead)");
        }
        this.socket = SocketChannel.open();
        this.socket.configureBlocking(true);
        this.getLogger().trace("Setting timeout to {} on Socket", (Object)this.timeout);
        this.socket.socket().connect(socketAddress, this.timeout);
        this.getLogger().debug("Connected to {} using local port {} and remote port {}", new Object[]{this.getAddress().getHost(), this.getAddress().getPort(), this.socket.socket().getLocalPort()});
        return this.socket;
    }

    protected void closeTransport() throws IOException {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.close();
        }
        if (this.serverSocket != null && this.serverSocket.isOpen()) {
            this.serverSocket.close();
        }
    }
}

