/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.hrv.analysis;

import java.util.ArrayList;
import java.util.Iterator;

public class Linear {
    public static float mean(float[] data) {
        float sum = 0.0f;
        for (float f : data) {
            sum += f;
        }
        return sum / (float)data.length;
    }

    public static double mean(double[] data) {
        double sum = 0.0;
        for (double f : data) {
            sum += f;
        }
        return sum / (double)data.length;
    }

    public static double mean(ArrayList<Float> data) {
        double sum = 0.0;
        Iterator<Float> iterator = data.iterator();
        while (iterator.hasNext()) {
            double f = iterator.next().floatValue();
            sum += f;
        }
        return sum / (double)data.size();
    }

    public static float sdnn(float[] data) {
        float sum = 0.0f;
        float m = Linear.mean(data);
        for (float f : data) {
            sum += (f - m) * (f - m);
        }
        return (float)Math.sqrt(sum / (float)data.length);
    }

    public static double sdnn(double[] data) {
        double sum = 0.0;
        double m = Linear.mean(data);
        for (double f : data) {
            sum += (f - m) * (f - m);
        }
        return Math.sqrt(sum / (double)data.length);
    }

    public static float rmssd(float[] data) {
        float sum = 0.0f;
        for (int i = 1; i < data.length; ++i) {
            float value = data[i] - data[i - 1];
            sum += value * value;
        }
        return (float)Math.sqrt(sum / (float)(data.length - 1));
    }

    public static double rmssd(double[] data) {
        double sum = 0.0;
        for (int i = 1; i < data.length; ++i) {
            double value = data[i] - data[i - 1];
            sum += value * value;
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    public static float var(float[] data) {
        float m = Linear.mean(data);
        float sum = 0.0f;
        for (float a : data) {
            sum += (m - a) * (m - a);
        }
        return sum / (float)data.length;
    }

    public static double var(double[] data) {
        double m = Linear.mean(data);
        double sum = 0.0;
        for (double a : data) {
            sum += (m - a) * (m - a);
        }
        return sum / (double)data.length;
    }

    public static float std(float[] data) {
        return (float)Math.sqrt(Linear.var(data));
    }

    public static float sum(float[] data) {
        float sum = 0.0f;
        for (float d : data) {
            sum += d;
        }
        return sum;
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum;
    }

    public static float max(float[] data) {
        float max = Float.MIN_VALUE;
        for (float d : data) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static int max(int[] data) {
        int max = Integer.MIN_VALUE;
        for (int d : data) {
            if (d <= max) continue;
            max = d;
        }
        return max;
    }

    public static float min(float[] data) {
        float min = Float.MAX_VALUE;
        for (float d : data) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static float log(int x, int base) {
        return (float)(Math.log(x) / Math.log(base));
    }

    public static float log(float x, int base) {
        return (float)(Math.log(x) / Math.log(base));
    }

    public static double log(double x, int base) {
        return Math.log(x) / Math.log(base);
    }
}

