/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.hrv.analysis;

import med.inpulse.hrv.analysis.Linear;

public class Entropy {
    public static double approximate(int n, double r, double[] data) {
        double[] correlation = new double[2];
        for (int i = n; i <= n + 1; ++i) {
            boolean set = false;
            double count = 0.0;
            double[] counter = new double[data.length - i + 1];
            for (int j = 0; j <= data.length - i; ++j) {
                double[] current_window = new double[i];
                System.arraycopy(data, j, current_window, 0, i);
                for (int k = 0; k <= data.length - i; ++k) {
                    double[] sliding_window = new double[i];
                    System.arraycopy(data, k, sliding_window, 0, i);
                    for (int l = 0; l < i; ++l) {
                        if (!(Math.abs(current_window[l] - sliding_window[l]) > r) || set) continue;
                        set = true;
                    }
                    if (!set) {
                        count += 1.0;
                    }
                    set = false;
                }
                counter[j] = count / (double)(data.length - i + 1);
                count = 0.0;
            }
            correlation[i - n] = Linear.sum(counter) / (double)(data.length - i + 1);
        }
        return Math.log(correlation[0] / correlation[1]);
    }

    public static float approximate(int n, double r, float[] data) {
        float[] correlation = new float[2];
        for (int i = n; i <= n + 1; ++i) {
            boolean set = false;
            float count = 0.0f;
            float[] counter = new float[data.length - i + 1];
            for (int j = 0; j <= data.length - i; ++j) {
                float[] current_window = new float[i];
                System.arraycopy(data, j, current_window, 0, i);
                for (int k = 0; k <= data.length - i; ++k) {
                    float[] sliding_window = new float[i];
                    System.arraycopy(data, k, sliding_window, 0, i);
                    for (int l = 0; l < i; ++l) {
                        if (!((double)Math.abs(current_window[l] - sliding_window[l]) > r) || set) continue;
                        set = true;
                    }
                    if (!set) {
                        count += 1.0f;
                    }
                    set = false;
                }
                counter[j] = count / (float)(data.length - i + 1);
                count = 0.0f;
            }
            correlation[i - n] = Linear.sum(counter) / (float)(data.length - i + 1);
        }
        return (float)Math.log(correlation[0] / correlation[1]);
    }

    public static double sample(int n, double r, double[] data) {
        int i;
        int size = data.length;
        double[] correlation = new double[2];
        double[][] dataMat = new double[n + 1][size - n];
        for (i = 0; i <= n; ++i) {
            System.arraycopy(data, i, dataMat[i], 0, size - n);
        }
        for (i = n; i <= n + 1; ++i) {
            int j;
            double[] count = new double[size - n];
            double[][] tempMat = new double[i][size - n];
            for (j = 0; j < i; ++j) {
                System.arraycopy(dataMat[j], 0, tempMat[j], 0, size - n);
            }
            for (j = 1; j < size - i; ++j) {
                int k;
                double[][] temp = new double[tempMat.length][size - n - j];
                double[][] value = new double[tempMat.length][1];
                for (k = 0; k < size - n - j; ++k) {
                    for (int l = 0; l < tempMat.length; ++l) {
                        temp[l][k] = tempMat[l][k + j];
                    }
                }
                for (k = 0; k < tempMat.length; ++k) {
                    value[k][0] = tempMat[k][j - 1];
                }
                double[][] repmat = Entropy.repmat(value, size - n - j);
                double[][] subsdata = Entropy.subtractABS(temp, repmat);
                double[] dist = Entropy.max(subsdata);
                double[] dBool = Entropy.getArrayDistance(dist, r);
                count[j - 1] = Entropy.sum(dBool) / (double)(size - n);
            }
            correlation[i - n] = Entropy.sum(count) / (double)(size - n);
        }
        return Math.log(correlation[0] / correlation[1]);
    }

    public static float sample(int n, double r, float[] data) {
        int i;
        int size = data.length;
        float[] correlation = new float[2];
        float[][] dataMat = new float[n + 1][size - n];
        for (i = 0; i <= n; ++i) {
            System.arraycopy(data, i, dataMat[i], 0, size - n);
        }
        for (i = n; i <= n + 1; ++i) {
            int j;
            float[] count = new float[size - n];
            float[][] tempMat = new float[i][size - n];
            for (j = 0; j < i; ++j) {
                System.arraycopy(dataMat[j], 0, tempMat[j], 0, size - n);
            }
            for (j = 1; j < size - i; ++j) {
                int k;
                double[][] temp = new double[tempMat.length][size - n - j];
                double[][] value = new double[tempMat.length][1];
                for (k = 0; k < size - n - j; ++k) {
                    for (int l = 0; l < tempMat.length; ++l) {
                        temp[l][k] = tempMat[l][k + j];
                    }
                }
                for (k = 0; k < tempMat.length; ++k) {
                    value[k][0] = tempMat[k][j - 1];
                }
                double[][] repmat = Entropy.repmat(value, size - n - j);
                double[][] subsdata = Entropy.subtractABS(temp, repmat);
                double[] dist = Entropy.max(subsdata);
                double[] dBool = Entropy.getArrayDistance(dist, r);
                count[j - 1] = (float)(Entropy.sum(dBool) / (double)(size - n));
            }
            correlation[i - n] = Entropy.sum(count) / (float)(size - n);
        }
        return (float)Math.log(correlation[0] / correlation[1]);
    }

    public static double[][] repmat(double[][] data, int size) {
        int dataLength = data.length;
        double[][] repmat = new double[data.length][size];
        for (int i = 0; i < dataLength; ++i) {
            for (int j = 0; j < size; ++j) {
                repmat[i][j] = data[i][0];
            }
        }
        return repmat;
    }

    public static double[][] subtractABS(double[][] data, double[][] data1) {
        double[][] newData = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                newData[i][j] = Math.abs(data[i][j] - data1[i][j]);
            }
        }
        return newData;
    }

    public static double[] max(double[][] data) {
        double[] newData = new double[data[0].length];
        for (int i = 0; i < newData.length; ++i) {
            double max = data[0][i];
            for (int j = 1; j < data.length; ++j) {
                max = Math.max(data[j][i], max);
            }
            newData[i] = max;
        }
        return newData;
    }

    public static double[] getArrayDistance(double[] data, double r) {
        double[] d = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            d[i] = data[i] < r ? 1.0 : 0.0;
        }
        return d;
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum;
    }

    public static float sum(float[] data) {
        float sum = 0.0f;
        for (float d : data) {
            sum += d;
        }
        return sum;
    }
}

