/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.hrv.analysis;

import java.util.Collection;
import med.inpulse.hrv.analysis.Linear;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;

public class DFA {
    public static double dfa(double[] data, int[] scale, int m) {
        if (data.length < Linear.max(scale)) {
            return -1000.0;
        }
        double[] x = DFA.cumsum(data);
        int dataSize = x.length;
        int scaleSize = scale.length;
        double[] F = new double[scaleSize];
        for (int i = 0; i < scaleSize; ++i) {
            int tempSize = (int)Math.floor(dataSize / scale[i]);
            double[] rms2 = new double[tempSize];
            for (int j = 1; j <= tempSize; ++j) {
                int Idx_start = (j - 1) * scale[i] + 1;
                int Idx_stop = j * scale[i];
                double[] X_ = new double[Idx_stop - Idx_start + 1];
                double[] index = new double[Idx_stop - Idx_start + 1];
                for (int k = 0; k < index.length; ++k) {
                    index[k] = k;
                }
                System.arraycopy(x, Idx_start - 1, X_, 0, Idx_stop - Idx_start + 1);
                double[] dif2 = new double[index.length];
                PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)m);
                WeightedObservedPoints observedPoints = new WeightedObservedPoints();
                for (int k = 0; k < index.length; ++k) {
                    observedPoints.add(index[k], X_[k]);
                }
                PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)observedPoints.toList()));
                for (int k = 0; k < index.length; ++k) {
                    dif2[k] = (X_[k] - fitted.value((double)k)) * (X_[k] - fitted.value((double)k));
                }
                rms2[j - 1] = Math.sqrt(Linear.mean(dif2)) * Math.sqrt(Linear.mean(dif2));
            }
            F[i] = Math.sqrt(Linear.mean(rms2));
        }
        double[] logScale = new double[scaleSize];
        double[] logF = new double[scaleSize];
        PolynomialCurveFitter fitter2 = PolynomialCurveFitter.create((int)m);
        WeightedObservedPoints observedPoints2 = new WeightedObservedPoints();
        for (int i = 0; i < scaleSize; ++i) {
            logScale[i] = Linear.log(scale[i], 2);
            logF[i] = Linear.log(F[i], 2);
            observedPoints2.add(logScale[i], logF[i]);
        }
        double[] C = fitter2.fit((Collection)observedPoints2.toList());
        return C[C.length - 1];
    }

    public static float dfa(float[] data, int[] scale, int m) {
        if (data.length < Linear.max(scale)) {
            return -1000.0f;
        }
        float[] x = DFA.cumsum(data);
        int dataSize = x.length;
        int scaleSize = scale.length;
        float[] F = new float[scaleSize];
        for (int i = 0; i < scaleSize; ++i) {
            int tempSize = (int)Math.floor(dataSize / scale[i]);
            float[] rms2 = new float[tempSize];
            for (int j = 1; j <= tempSize; ++j) {
                int Idx_start = (j - 1) * scale[i] + 1;
                int Idx_stop = j * scale[i];
                float[] X_ = new float[Idx_stop - Idx_start + 1];
                float[] index = new float[Idx_stop - Idx_start + 1];
                for (int k = 0; k < index.length; ++k) {
                    index[k] = k;
                }
                System.arraycopy(x, Idx_start - 1, X_, 0, Idx_stop - Idx_start + 1);
                double[] dif2 = new double[index.length];
                PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)m);
                WeightedObservedPoints observedPoints = new WeightedObservedPoints();
                for (int k = 0; k < index.length; ++k) {
                    observedPoints.add((double)index[k], (double)X_[k]);
                }
                PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)observedPoints.toList()));
                for (int k = 0; k < index.length; ++k) {
                    dif2[k] = ((double)X_[k] - fitted.value((double)k)) * ((double)X_[k] - fitted.value((double)k));
                }
                rms2[j - 1] = (float)(Math.sqrt(Linear.mean(dif2)) * Math.sqrt(Linear.mean(dif2)));
            }
            F[i] = (float)Math.sqrt(Linear.mean(rms2));
        }
        double[] logScale = new double[scaleSize];
        double[] logF = new double[scaleSize];
        PolynomialCurveFitter fitter2 = PolynomialCurveFitter.create((int)m);
        WeightedObservedPoints observedPoints2 = new WeightedObservedPoints();
        for (int i = 0; i < scaleSize; ++i) {
            logScale[i] = Linear.log(scale[i], 2);
            logF[i] = Linear.log(F[i], 2);
            observedPoints2.add(logScale[i], logF[i]);
        }
        double[] C = fitter2.fit((Collection)observedPoints2.toList());
        return (float)C[C.length - 1];
    }

    public static double[] cumsum(double[] data) {
        int size = data.length;
        double[] csum = new double[data.length];
        double mean = Linear.mean(data);
        csum[0] = data[0] - mean;
        for (int i = 1; i < size; ++i) {
            csum[i] = csum[i - 1] + data[i] - mean;
        }
        return csum;
    }

    public static float[] cumsum(float[] data) {
        int size = data.length;
        float[] csum = new float[data.length];
        float mean = Linear.mean(data);
        csum[0] = data[0] - mean;
        for (int i = 1; i < size; ++i) {
            csum[i] = csum[i - 1] + data[i] - mean;
        }
        return csum;
    }
}

