/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jssc.SerialPortList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.locator.DeviceInterfaceInfo;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.desktop.util.WindowsSerialRegistryHelper;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.shared.log.LoggerModule;
import vet.inpulse.shared.models.KotlinPlatform;
import vet.inpulse.shared.models.NativePlatform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\b*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lvet/inpulse/libcomm/desktop/util/USBDetectorHelper;", "", "<init>", "()V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "readShortFromHex", "", "", "getPossibleSerialDevices", "", "Lvet/inpulse/libcomm/core/locator/DeviceInterfaceInfo$Serial;", "getSerialPortsLinux", "hexWith4Digits", "getHexWith4Digits", "(I)Ljava/lang/String;", "libcomm"})
@SourceDebugExtension(value={"SMAP\nUSBDetectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 USBDetectorHelper.kt\nvet/inpulse/libcomm/desktop/util/USBDetectorHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LoggerModels.kt\nvet/inpulse/shared/log/LoggerModelsKt\n*L\n1#1,147:1\n774#2:148\n865#2,2:149\n1563#2:151\n1634#2,3:152\n1617#2,9:155\n1869#2:164\n1870#2:166\n1626#2:167\n1#3:165\n65#4:168\n*S KotlinDebug\n*F\n+ 1 USBDetectorHelper.kt\nvet/inpulse/libcomm/desktop/util/USBDetectorHelper\n*L\n42#1:148\n42#1:149,2\n43#1:151\n43#1:152,3\n67#1:155,9\n67#1:164\n67#1:166\n67#1:167\n67#1:165\n26#1:168\n*E\n"})
public final class USBDetectorHelper {
    @NotNull
    public static final USBDetectorHelper INSTANCE = new USBDetectorHelper();
    @NotNull
    private static final LoggerInterface logger;

    private USBDetectorHelper() {
    }

    private final int readShortFromHex(String $this$readShortFromHex) {
        Buffer buf = new Buffer();
        return buf.write(ByteString.Companion.decodeHex($this$readShortFromHex)).readShort();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DeviceInterfaceInfo.Serial> getPossibleSerialDevices() {
        List list;
        KotlinPlatform kotlinPlatform = NativePlatform.INSTANCE.getCurrent();
        if (Intrinsics.areEqual((Object)kotlinPlatform, (Object)KotlinPlatform.Desktop.Win.INSTANCE)) {
            list = WindowsSerialRegistryHelper.INSTANCE.getWindowsSerialPorts();
        } else if (Intrinsics.areEqual((Object)kotlinPlatform, (Object)KotlinPlatform.Desktop.Mac.INSTANCE)) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = USBDetectorHelper.getPossibleSerialDevices$getAllSerialPortNames();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)"tty.usbserial", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"tty.usbmodem", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void portPath;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)portPath);
                collection.add(new DeviceInterfaceInfo.Serial((String)portPath, null, null, null));
            }
            list = (List)destination$iv$iv;
        } else if (Intrinsics.areEqual((Object)kotlinPlatform, (Object)KotlinPlatform.Desktop.Linux.INSTANCE)) {
            list = this.getSerialPortsLinux();
        } else if (kotlinPlatform instanceof KotlinPlatform.Desktop.Other || Intrinsics.areEqual((Object)kotlinPlatform, (Object)KotlinPlatform.Android.INSTANCE) || Intrinsics.areEqual((Object)kotlinPlatform, (Object)KotlinPlatform.Ios.INSTANCE)) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DeviceInterfaceInfo.Serial> getSerialPortsLinux() {
        void $this$mapNotNullTo$iv$iv;
        logger.d(USBDetectorHelper::getSerialPortsLinux$lambda$2);
        Path path = Paths.get("/dev/", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path it = path;
        boolean $i$a$-let-USBDetectorHelper$getSerialPortsLinux$entries$22 = false;
        List entries = CollectionsKt.plus((Collection)PathsKt.listDirectoryEntries((Path)it, (String)"ttyUSB*"), (Iterable)PathsKt.listDirectoryEntries((Path)it, (String)"ttyACM*"));
        Iterable $this$mapNotNull$iv = entries;
        boolean $i$f$mapNotNull = false;
        Iterable $i$a$-let-USBDetectorHelper$getSerialPortsLinux$entries$22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DeviceInterfaceInfo.Serial serial;
            Path devicePath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path path2 = (Path)element$iv$iv;
            boolean bl2 = false;
            String deviceName = PathsKt.getName((Path)path2);
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get("/sys/class/tty/" + deviceName + "/device", new String[0]), (String)"get(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(devicePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                serial = null;
            } else {
                Path fullDevicePath = devicePath.toRealPath(new LinkOption[0]);
                Intrinsics.checkNotNull((Object)fullDevicePath);
                Path path3 = fullDevicePath.resolve("subsystem");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                Path path4 = path3.toRealPath(new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toRealPath(...)");
                String subsystem = PathsKt.getName((Path)path4);
                if (Intrinsics.areEqual((Object)subsystem, (Object)"usb-serial")) {
                    Path usbInterfacePath = fullDevicePath.getParent();
                    Path usbDevicePath = usbInterfacePath.getParent();
                    Intrinsics.checkNotNull((Object)usbDevicePath);
                    Path path5 = usbDevicePath.resolve("idVendor");
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                    List<String> list = Files.readAllLines(path5, Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    String string = (String)CollectionsKt.firstOrNull(list);
                    Integer vid = string != null ? Integer.valueOf(INSTANCE.readShortFromHex(string)) : null;
                    Path path6 = usbDevicePath.resolve("idProduct");
                    Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
                    List<String> list2 = Files.readAllLines(path6, Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
                    String string2 = (String)CollectionsKt.firstOrNull(list2);
                    Integer pid = string2 != null ? Integer.valueOf(INSTANCE.readShortFromHex(string2)) : null;
                    serial = new DeviceInterfaceInfo.Serial(((Object)path2.toAbsolutePath()).toString(), vid, pid, null);
                } else {
                    serial = new DeviceInterfaceInfo.Serial(((Object)path2.toAbsolutePath()).toString(), null, null, null);
                }
            }
            if (serial == null) continue;
            DeviceInterfaceInfo.Serial it$iv$iv = serial;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getHexWith4Digits(int $this$hexWith4Digits) {
        String string = "%04X";
        Object[] objectArray = new Object[]{$this$hexWith4Digits};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final Set<String> getPossibleSerialDevices$getAllSerialPortNames() {
        String[] stringArray = SerialPortList.getPortNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPortNames(...)");
        return ArraysKt.toSet((Object[])stringArray);
    }

    private static final String getSerialPortsLinux$lambda$2() {
        return "getSerialPortsLinux()";
    }

    static {
        LoggerModule $this$getLogger$iv = InPulseLoggerKt.getLibcommLogModule();
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(USBDetectorHelper.class).getSimpleName();
        if (string == null) {
            string = "";
        }
        logger = $this$getLogger$iv.getLogger(string);
    }
}

