/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.io.usbserial;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jssc.SerialPort;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.io.IOOperator;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.HexPrinterKt;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.shared.log.LoggerModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010$\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lvet/inpulse/libcomm/desktop/io/usbserial/DesktopUsbSerialOperator;", "Lvet/inpulse/libcomm/core/io/IOOperator;", "serialPort", "Ljssc/SerialPort;", "<init>", "(Ljssc/SerialPort;)V", "getSerialPort", "()Ljssc/SerialPort;", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "parity", "", "dataBits", "stopBit", "flowControl", "baudRate", "opened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getOpened", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "open", "", "tryToWriteOnIO", "", "source", "Lokio/Buffer;", "byteCount", "", "flush", "tryToReadFromIO", "sink", "timeout", "Lokio/Timeout;", "close", "isOpened", "()Z", "libcomm"})
@SourceDebugExtension(value={"SMAP\nDesktopUsbSerialOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUsbSerialOperator.kt\nvet/inpulse/libcomm/desktop/io/usbserial/DesktopUsbSerialOperator\n+ 2 LoggerModels.kt\nvet/inpulse/shared/log/LoggerModelsKt\n*L\n1#1,103:1\n65#2:104\n*S KotlinDebug\n*F\n+ 1 DesktopUsbSerialOperator.kt\nvet/inpulse/libcomm/desktop/io/usbserial/DesktopUsbSerialOperator\n*L\n17#1:104\n*E\n"})
public class DesktopUsbSerialOperator
extends IOOperator {
    @NotNull
    private final SerialPort serialPort;
    @NotNull
    private final LoggerInterface logger;
    private final int parity;
    private final int dataBits;
    private final int stopBit;
    private int flowControl;
    private int baudRate;
    @NotNull
    private final AtomicBoolean opened;

    public DesktopUsbSerialOperator(@NotNull SerialPort serialPort) {
        Intrinsics.checkNotNullParameter((Object)serialPort, (String)"serialPort");
        this.serialPort = serialPort;
        LoggerModule $this$getLogger$iv = InPulseLoggerKt.getLibcommIoLogModule();
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(DesktopUsbSerialOperator.class).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.logger = $this$getLogger$iv.getLogger(string);
        this.dataBits = 8;
        this.stopBit = 1;
        this.flowControl = 3;
        this.baudRate = 460800;
        this.opened = new AtomicBoolean(false);
    }

    @NotNull
    protected final SerialPort getSerialPort() {
        return this.serialPort;
    }

    @NotNull
    protected final AtomicBoolean getOpened() {
        return this.opened;
    }

    @Override
    @NotNull
    public IOOperator.Interface getInterface() {
        return IOOperator.Interface.USB_SERIAL;
    }

    @Override
    public boolean open() {
        boolean bl;
        try {
            boolean bl2;
            if (this.serialPort.openPort()) {
                this.serialPort.setParams(this.baudRate, this.dataBits, this.stopBit, this.parity);
                this.serialPort.setFlowControlMode(this.flowControl);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception ex) {
            this.logger.e((Throwable)ex, () -> DesktopUsbSerialOperator.open$lambda$0(this, ex));
            bl = false;
        }
        boolean success = bl;
        this.opened.set(success);
        this.logger.i(() -> DesktopUsbSerialOperator.open$lambda$1(success));
        return success;
    }

    @Override
    public void tryToWriteOnIO(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        byte[] writeBuffer = new byte[(int)byteCount];
        source.read(writeBuffer, 0, (int)byteCount);
        this.serialPort.writeBytes(writeBuffer);
        this.setTotalBytesWritten(this.getTotalBytesWritten() + byteCount);
        this.logger.v(() -> DesktopUsbSerialOperator.tryToWriteOnIO$lambda$2(writeBuffer));
    }

    public void flush() {
        block3: {
            try {
                while (this.serialPort.getOutputBufferBytesCount() != 0) {
                }
            }
            catch (Exception e) {
                if (!this.isOpened()) break block3;
                this.logger.w((Throwable)e, () -> DesktopUsbSerialOperator.flush$lambda$3(e));
            }
        }
    }

    @Override
    public long tryToReadFromIO(@NotNull Buffer sink, long byteCount) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int bytesAvailable = this.serialPort.getInputBufferBytesCount();
        if (bytesAvailable > 0) {
            int numBytesToRead = RangesKt.coerceAtMost((int)bytesAvailable, (int)((int)byteCount));
            byte[] bytesRead = this.serialPort.readBytes(numBytesToRead);
            if (bytesRead != null) {
                sink.write(bytesRead);
                this.logger.v(() -> DesktopUsbSerialOperator.tryToReadFromIO$lambda$4(bytesRead, byteCount, numBytesToRead));
                this.setTotalBytesRead(this.getTotalBytesRead() + (long)bytesRead.length);
                l = bytesRead.length;
            } else {
                l = 0L;
            }
        } else {
            l = bytesAvailable;
        }
        return l;
    }

    @NotNull
    public Timeout timeout() {
        return new Timeout().timeout(3L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.opened.set(false);
        if (this.serialPort.isOpened()) {
            try {
                this.serialPort.closePort();
                this.logger.d(() -> DesktopUsbSerialOperator.close$lambda$5(this));
            }
            catch (Exception ex) {
                this.logger.w((Throwable)ex, () -> DesktopUsbSerialOperator.close$lambda$6(this));
            }
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened.get();
    }

    private static final String open$lambda$0(DesktopUsbSerialOperator this$0, Exception $ex) {
        return "Fail to open serial port (" + this$0.serialPort.getPortName() + ") due to " + $ex.getMessage();
    }

    private static final String open$lambda$1(boolean $success) {
        return "open(). success? " + $success;
    }

    private static final String tryToWriteOnIO$lambda$2(byte[] $writeBuffer) {
        return "---> " + HexPrinterKt.printAsHex$default($writeBuffer, 0, 0, 3, null);
    }

    private static final String flush$lambda$3(Exception $e) {
        return "Failed to flush serial port due to " + $e.getMessage();
    }

    private static final String tryToReadFromIO$lambda$4(byte[] $bytesRead, long $byteCount, int $numBytesToRead) {
        return "<--- (read " + $bytesRead.length + ") (count " + $byteCount + ") (fromAvailable: " + $numBytesToRead + ") " + HexPrinterKt.printAsHex$default($bytesRead, 0, 0, 3, null);
    }

    private static final String close$lambda$5(DesktopUsbSerialOperator this$0) {
        return "Serial port " + this$0.serialPort.getPortName() + " was closed";
    }

    private static final String close$lambda$6(DesktopUsbSerialOperator this$0) {
        return "Fail to close serial port " + this$0.serialPort.getPortName();
    }
}

