/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.io.usb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import okio.Buffer;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.usb4java.Device;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import vet.inpulse.libcomm.core.io.IOOperator;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.HexPrinterKt;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020(H\u0016J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020$2\u0006\u0010*\u001a\u00020(H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR+\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010+\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"\u00a8\u00063"}, d2={"Lvet/inpulse/libcomm/desktop/io/usb/LibusbOperator;", "Lvet/inpulse/libcomm/core/io/IOOperator;", "device", "Lorg/usb4java/Device;", "<init>", "(Lorg/usb4java/Device;)V", "getDevice", "()Lorg/usb4java/Device;", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "getLogger", "()Lvet/inpulse/shared/log/LoggerInterface;", "<set-?>", "", "_isOpened", "get_isOpened", "()Z", "set_isOpened", "(Z)V", "_isOpened$delegate", "Lkotlinx/atomicfu/AtomicBoolean;", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "handle", "Lorg/usb4java/DeviceHandle;", "getHandle", "()Lorg/usb4java/DeviceHandle;", "open", "close", "", "isOpened", "tempBuffer", "", "getTempBuffer", "()[B", "readBuffer", "Lokio/Buffer;", "getReadBuffer", "()Lokio/Buffer;", "tryToReadFromIO", "", "sink", "byteCount", "writeBuffer", "getWriteBuffer", "tryToWriteOnIO", "source", "timeout", "Lokio/Timeout;", "flush", "Companion", "libcomm"})
public final class LibusbOperator
extends IOOperator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Device device;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    private final AtomicBoolean _isOpened$delegate;
    @NotNull
    private final DeviceHandle handle;
    @NotNull
    private final byte[] tempBuffer;
    @NotNull
    private final Buffer readBuffer;
    @NotNull
    private final byte[] writeBuffer;
    private static final byte endpointIn = (byte)-126;
    private static final byte endpointOut = 1;

    public LibusbOperator(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.device = device;
        this.logger = InPulseLoggerKt.getLibcommIoLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this._isOpened$delegate = AtomicFU.atomic((boolean)false);
        this.handle = new DeviceHandle();
        this.tempBuffer = new byte[64];
        this.readBuffer = new Buffer();
        this.writeBuffer = new byte[64];
    }

    @NotNull
    public final Device getDevice() {
        return this.device;
    }

    @NotNull
    public final LoggerInterface getLogger() {
        return this.logger;
    }

    private final boolean get_isOpened() {
        AtomicBoolean atomicBoolean = this._isOpened$delegate;
        return atomicBoolean.getValue();
    }

    private final void set_isOpened(boolean bl) {
        AtomicBoolean atomicBoolean = this._isOpened$delegate;
        atomicBoolean.setValue(bl);
    }

    @Override
    @NotNull
    public IOOperator.Interface getInterface() {
        return IOOperator.Interface.USB_NATIVE;
    }

    @NotNull
    public final DeviceHandle getHandle() {
        return this.handle;
    }

    @Override
    public boolean open() {
        if (this.get_isOpened()) {
            return true;
        }
        int error = LibUsb.open((Device)this.device, (DeviceHandle)this.handle);
        if (error != 0) {
            String str = LibUsb.strError((int)error);
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LibusbOperator.open$lambda$0(str), (int)1, null);
            return false;
        }
        IntBuffer configBuffer = IntBuffer.allocate(1);
        error = LibUsb.getConfiguration((DeviceHandle)this.handle, (IntBuffer)configBuffer);
        if (error != 0) {
            String str = LibUsb.strError((int)error);
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LibusbOperator.open$lambda$1(str), (int)1, null);
            LibUsb.close((DeviceHandle)this.handle);
            return false;
        }
        int config = configBuffer.get();
        if (config != 1 && (error = LibUsb.setConfiguration((DeviceHandle)this.handle, (int)1)) != 0) {
            String str = LibUsb.strError((int)error);
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LibusbOperator.open$lambda$2(str), (int)1, null);
            LibUsb.close((DeviceHandle)this.handle);
            return false;
        }
        error = LibUsb.claimInterface((DeviceHandle)this.handle, (int)0);
        if (error != 0) {
            String str = LibUsb.strError((int)error);
            LoggerInterface.e$default((LoggerInterface)this.logger, null, () -> LibusbOperator.open$lambda$3(str), (int)1, null);
            LibUsb.close((DeviceHandle)this.handle);
            return false;
        }
        this.set_isOpened(true);
        return true;
    }

    @Override
    public void close() {
        if (!this.get_isOpened()) {
            return;
        }
        LibUsb.releaseInterface((DeviceHandle)this.handle, (int)0);
        LibUsb.close((DeviceHandle)this.handle);
        this.set_isOpened(false);
    }

    @Override
    public boolean isOpened() {
        return this.get_isOpened();
    }

    @NotNull
    public final byte[] getTempBuffer() {
        return this.tempBuffer;
    }

    @NotNull
    public final Buffer getReadBuffer() {
        return this.readBuffer;
    }

    @Override
    public long tryToReadFromIO(@NotNull Buffer sink, long byteCount) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        IntBuffer read = IntBuffer.allocate(1);
        ByteBuffer data = ByteBuffer.allocateDirect(64);
        int res = LibUsb.bulkTransfer((DeviceHandle)this.handle, (byte)endpointIn, (ByteBuffer)data, (IntBuffer)read, (long)1000L);
        switch (res) {
            case -7: {
                LoggerInterface.t$default((LoggerInterface)this.logger, null, LibusbOperator::tryToReadFromIO$lambda$4, (int)1, null);
                l = 0L;
                break;
            }
            case -9: {
                LoggerInterface.e$default((LoggerInterface)this.logger, null, LibusbOperator::tryToReadFromIO$lambda$5, (int)1, null);
                l = -1L;
                break;
            }
            case -4: {
                LoggerInterface.e$default((LoggerInterface)this.logger, null, LibusbOperator::tryToReadFromIO$lambda$6, (int)1, null);
                l = -1L;
                break;
            }
            case 0: {
                int r = read.get();
                data.get(this.tempBuffer, 0, r);
                this.readBuffer.write(this.tempBuffer, 0, r);
                LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> LibusbOperator.tryToReadFromIO$lambda$7(this, r), (int)1, null);
                this.setTotalBytesRead(this.getTotalBytesRead() + (long)r);
                long removed = this.readBuffer.read(sink, byteCount);
                return removed < 0L ? 0L : removed;
            }
            default: {
                throw new IllegalStateException(("not handled: " + LibUsb.strError((int)res)).toString());
            }
        }
        return l;
    }

    @NotNull
    public final byte[] getWriteBuffer() {
        return this.writeBuffer;
    }

    @Override
    public void tryToWriteOnIO(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long written = 0L;
        block6: while (written < byteCount) {
            long toRead = Math.min(byteCount - written, 64L);
            ByteBuffer data = ByteBuffer.allocateDirect((int)toRead);
            IntBuffer write = IntBuffer.allocate(1);
            int read = source.read(this.writeBuffer, 0, (int)toRead);
            data.put(this.writeBuffer, 0, read);
            int res = LibUsb.bulkTransfer((DeviceHandle)this.handle, (byte)endpointOut, (ByteBuffer)data, (IntBuffer)write, (long)1000L);
            switch (res) {
                case -7: {
                    LoggerInterface.t$default((LoggerInterface)this.logger, null, LibusbOperator::tryToWriteOnIO$lambda$8, (int)1, null);
                    continue block6;
                }
                case -9: {
                    LoggerInterface.e$default((LoggerInterface)this.logger, null, LibusbOperator::tryToWriteOnIO$lambda$9, (int)1, null);
                    throw new IllegalStateException("Pipe error while writing to USB");
                }
                case -4: {
                    LoggerInterface.e$default((LoggerInterface)this.logger, null, LibusbOperator::tryToWriteOnIO$lambda$10, (int)1, null);
                    throw new IllegalStateException("No device error while writing to USB");
                }
                case 0: {
                    int w = write.get();
                    LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> LibusbOperator.tryToWriteOnIO$lambda$11(this, w), (int)1, null);
                    written += (long)w;
                    this.setTotalBytesWritten(this.getTotalBytesWritten() + (long)w);
                    continue block6;
                }
            }
            throw new IllegalStateException("not handled".toString());
        }
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void flush() {
    }

    private static final String open$lambda$0(String $str) {
        return "Failed to open device due to " + $str;
    }

    private static final String open$lambda$1(String $str) {
        return "Failed to get configuration due to " + $str;
    }

    private static final String open$lambda$2(String $str) {
        return "Failed to set configuration due to " + $str;
    }

    private static final String open$lambda$3(String $str) {
        return "Failed to claim interface due to " + $str;
    }

    private static final String tryToReadFromIO$lambda$4() {
        return "Timeout while reading from USB";
    }

    private static final String tryToReadFromIO$lambda$5() {
        return "Pipe error while reading from USB";
    }

    private static final String tryToReadFromIO$lambda$6() {
        return "No device error while reading from USB";
    }

    private static final String tryToReadFromIO$lambda$7(LibusbOperator this$0, int $r) {
        return "<-- " + HexPrinterKt.printAsHex(this$0.tempBuffer, 0, $r);
    }

    private static final String tryToWriteOnIO$lambda$8() {
        return "Timeout while writing to USB";
    }

    private static final String tryToWriteOnIO$lambda$9() {
        return "Pipe error while writing to USB";
    }

    private static final String tryToWriteOnIO$lambda$10() {
        return "No device error while writing to USB";
    }

    private static final String tryToWriteOnIO$lambda$11(LibusbOperator this$0, int $w) {
        return "--> " + HexPrinterKt.printAsHex(this$0.writeBuffer, 0, $w);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lvet/inpulse/libcomm/desktop/io/usb/LibusbOperator$Companion;", "", "<init>", "()V", "endpointIn", "", "endpointOut", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

