/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.desktop.io.bluetoothNative;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.io.IOOperator;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.util.HexPrinterKt;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010(\u001a\n )*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lvet/inpulse/libcomm/desktop/io/bluetoothNative/DesktopBluetoothNativeOperator;", "Lvet/inpulse/libcomm/core/io/IOOperator;", "Ljava/io/Closeable;", "Lokio/Closeable;", "connectionURL", "", "<init>", "(Ljava/lang/String;)V", "getConnectionURL", "()Ljava/lang/String;", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "connection", "Ljavax/microedition/io/StreamConnection;", "sockSink", "Lokio/Sink;", "sockSource", "Lokio/BufferedSource;", "snifferReadBuffer", "Lokio/Buffer;", "connected", "Ljava/util/concurrent/atomic/AtomicBoolean;", "timeout", "Lokio/Timeout;", "getInterface", "Lvet/inpulse/libcomm/core/io/IOOperator$Interface;", "open", "", "tryToOpenConnection", "", "tryToWriteOnIO", "source", "byteCount", "", "isOpened", "()Z", "flush", "close", "tryToReadFromIO", "sink", "tag", "kotlin.jvm.PlatformType", "libcomm"})
public final class DesktopBluetoothNativeOperator
extends IOOperator
implements Closeable {
    @NotNull
    private final String connectionURL;
    @NotNull
    private final LoggerInterface logger;
    @Nullable
    private StreamConnection connection;
    @Nullable
    private Sink sockSink;
    @Nullable
    private BufferedSource sockSource;
    @NotNull
    private final Buffer snifferReadBuffer;
    @NotNull
    private final AtomicBoolean connected;
    private final String tag;

    public DesktopBluetoothNativeOperator(@NotNull String connectionURL) {
        Intrinsics.checkNotNullParameter((Object)connectionURL, (String)"connectionURL");
        this.connectionURL = connectionURL;
        this.logger = InPulseLoggerKt.getLibcommIoLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.snifferReadBuffer = new Buffer();
        this.connected = new AtomicBoolean(false);
        this.tag = this.getClass().getSimpleName();
    }

    @NotNull
    public final String getConnectionURL() {
        return this.connectionURL;
    }

    @NotNull
    public Timeout timeout() {
        return new Timeout().timeout(30L, TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public IOOperator.Interface getInterface() {
        return IOOperator.Interface.BLUETOOTH_NATIVE;
    }

    @Override
    public boolean open() {
        this.logger.i(() -> DesktopBluetoothNativeOperator.open$lambda$0(this));
        if (this.isOpened()) {
            return true;
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ DesktopBluetoothNativeOperator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        counterTries = 0;
                        maxTries = 2;
lbl7:
                        // 3 sources

                        while (!this.this$0.isOpened() && counterTries++ < maxTries) {
                            DesktopBluetoothNativeOperator.access$tryToOpenConnection(this.this$0);
                            this.I$0 = counterTries;
                            this.I$1 = maxTries;
                            this.label = 1;
                            v0 = DelayKt.delay((long)800L, (Continuation)((Continuation)this));
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        maxTries = this.I$1;
                        counterTries = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.logger.i(() -> DesktopBluetoothNativeOperator.open$lambda$1(this));
        return this.isOpened();
    }

    /*
     * WARNING - void declaration
     */
    private final void tryToOpenConnection() {
        try {
            void $this$tryToOpenConnection_u24lambda_u242;
            StreamConnection streamConnection;
            Connection connection = Connector.open((String)this.connectionURL, (int)3, (boolean)false);
            Intrinsics.checkNotNull((Object)connection, (String)"null cannot be cast to non-null type javax.microedition.io.StreamConnection");
            StreamConnection streamConnection2 = streamConnection = (StreamConnection)connection;
            DesktopBluetoothNativeOperator desktopBluetoothNativeOperator = this;
            boolean bl = false;
            DataOutputStream dataOutputStream = $this$tryToOpenConnection_u24lambda_u242.openDataOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)dataOutputStream, (String)"openDataOutputStream(...)");
            this.sockSink = Okio.sink((OutputStream)dataOutputStream);
            DataInputStream dataInputStream = $this$tryToOpenConnection_u24lambda_u242.openDataInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)dataInputStream, (String)"openDataInputStream(...)");
            this.sockSource = Okio.buffer((Source)Okio.source((InputStream)dataInputStream));
            desktopBluetoothNativeOperator.connection = streamConnection;
            this.connected.set(true);
        }
        catch (Exception ex) {
            this.connection = null;
            this.sockSink = null;
            this.sockSource = null;
            LoggerInterface.w$default((LoggerInterface)this.logger, null, () -> DesktopBluetoothNativeOperator.tryToOpenConnection$lambda$3(this, ex), (int)1, null);
            this.connected.set(false);
        }
    }

    @Override
    public void tryToWriteOnIO(@NotNull Buffer source, long byteCount) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> DesktopBluetoothNativeOperator.tryToWriteOnIO$lambda$4(source, byteCount), (int)1, null);
            this.setTotalBytesWritten(this.getTotalBytesWritten() + byteCount);
            Sink sink = this.sockSink;
            if (sink == null) break block0;
            sink.write(source, byteCount);
        }
    }

    @Override
    public boolean isOpened() {
        return this.connection != null && this.connected.get();
    }

    public void flush() {
        block1: {
            if (!this.isOpened()) break block1;
            Sink sink = this.sockSink;
            if (sink != null) {
                sink.flush();
            }
        }
    }

    @Override
    public void close() {
        if (!this.isOpened()) {
            return;
        }
        this.logger.v(() -> DesktopBluetoothNativeOperator.close$lambda$5(this));
        this.connected.set(false);
        try {
            BufferedSource bufferedSource = this.sockSource;
            if (bufferedSource != null) {
                bufferedSource.close();
            }
            Sink sink = this.sockSink;
            if (sink != null) {
                sink.close();
            }
            StreamConnection streamConnection = this.connection;
            if (streamConnection != null) {
                streamConnection.close();
            }
            this.logger.v(DesktopBluetoothNativeOperator::close$lambda$6);
        }
        catch (Exception e) {
            this.logger.w((Throwable)e, () -> DesktopBluetoothNativeOperator.close$lambda$7(e));
        }
    }

    @Override
    public long tryToReadFromIO(@NotNull Buffer sink, long byteCount) {
        long read;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> DesktopBluetoothNativeOperator.tryToReadFromIO$lambda$8(this, byteCount), (int)1, null);
        BufferedSource bufferedSource = this.sockSource;
        long l = read = bufferedSource != null ? bufferedSource.read(sink, byteCount) : -1L;
        if (read > 0L) {
            this.setTotalBytesRead(this.getTotalBytesRead() + read);
        }
        return read;
    }

    private static final String open$lambda$0(DesktopBluetoothNativeOperator this$0) {
        return "opening " + this$0.connectionURL;
    }

    private static final String open$lambda$1(DesktopBluetoothNativeOperator this$0) {
        return "open()? " + this$0.isOpened();
    }

    private static final String tryToOpenConnection$lambda$3(DesktopBluetoothNativeOperator this$0, Exception $ex) {
        return "Failed to open connection on " + this$0.connectionURL + ": " + $ex.getMessage();
    }

    private static final String tryToWriteOnIO$lambda$4(Buffer $source, long $byteCount) {
        return "---> " + HexPrinterKt.printAsHex$default($source.peek().readByteArray($byteCount), 0, 0, 3, null);
    }

    private static final String close$lambda$5(DesktopBluetoothNativeOperator this$0) {
        return "closing io on " + this$0.connectionURL;
    }

    private static final String close$lambda$6() {
        return "Closed Bluetooth port";
    }

    private static final String close$lambda$7(Exception $e) {
        return "Error closing port due to " + $e.getMessage();
    }

    private static final String tryToReadFromIO$lambda$8(DesktopBluetoothNativeOperator this$0, long $byteCount) {
        BufferedSource bufferedSource = this$0.sockSource;
        long numRead = bufferedSource != null && (bufferedSource = bufferedSource.peek()) != null ? bufferedSource.read(this$0.snifferReadBuffer, $byteCount) : -1L;
        return "<--- " + HexPrinterKt.printAsHex$default(this$0.snifferReadBuffer.readByteArray(), 0, 0, 3, null) + ".  numRead " + numRead;
    }

    public static final /* synthetic */ void access$tryToOpenConnection(DesktopBluetoothNativeOperator $this) {
        $this.tryToOpenConnection();
    }
}

