/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u001bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lvet/inpulse/libcomm/core/util/SourceMarker;", "", "source", "Lokio/Source;", "<init>", "(Lokio/Source;)V", "offset", "", "getOffset", "()J", "setOffset", "(J)V", "mark", "getMark", "setMark", "limit", "getLimit", "setLimit", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "markSource", "Lvet/inpulse/libcomm/core/util/SourceMarker$MarkSource;", "userSource", "Lokio/BufferedSource;", "markBuffer", "Lokio/Buffer;", "getMarkBuffer", "()Lokio/Buffer;", "userBuffer", "readLimit", "reset", "", "userOffset", "MarkSource", "libcomm"})
@SourceDebugExtension(value={"SMAP\nSourceMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMarker.kt\nvet/inpulse/libcomm/core/util/SourceMarker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class SourceMarker {
    private long offset;
    private long mark;
    private long limit;
    private boolean closed;
    @NotNull
    private final MarkSource markSource;
    @NotNull
    private final BufferedSource userSource;
    @NotNull
    private final Buffer markBuffer;
    @NotNull
    private final Buffer userBuffer;

    public SourceMarker(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.mark = -1L;
        this.limit = -1L;
        this.markSource = new MarkSource(source);
        this.markBuffer = new Buffer();
        this.userSource = Okio.buffer((Source)((Source)this.markSource));
        this.userBuffer = this.userSource.getBuffer();
    }

    public final long getOffset() {
        return this.offset;
    }

    public final void setOffset(long l) {
        this.offset = l;
    }

    public final long getMark() {
        return this.mark;
    }

    public final void setMark(long l) {
        this.mark = l;
    }

    public final long getLimit() {
        return this.limit;
    }

    public final void setLimit(long l) {
        this.limit = l;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final Buffer getMarkBuffer() {
        return this.markBuffer;
    }

    @NotNull
    public final BufferedSource source() {
        return this.userSource;
    }

    public final long mark(long readLimit) throws IOException {
        long newMarkBufferLimit;
        if (!(readLimit >= 0L)) {
            boolean $i$a$-require-SourceMarker$mark$22 = false;
            String $i$a$-require-SourceMarker$mark$22 = "readLimit < 0: " + readLimit;
            throw new IllegalArgumentException($i$a$-require-SourceMarker$mark$22.toString());
        }
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        long userOffset = this.offset - this.userBuffer.size();
        if (this.mark == -1L) {
            this.markBuffer.writeAll((Source)this.userBuffer);
            this.mark = userOffset;
            this.offset = userOffset;
        }
        this.limit = newMarkBufferLimit = userOffset + readLimit;
        return userOffset;
    }

    public final void reset(long userOffset) throws IOException {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (userOffset < this.mark || userOffset > this.limit || userOffset > this.mark + this.markBuffer.size() || this.offset - this.userBuffer.size() > this.limit) {
            throw new IOException("cannot reset to " + userOffset + ": out of range");
        }
        this.offset = userOffset;
        this.userBuffer.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lvet/inpulse/libcomm/core/util/SourceMarker$MarkSource;", "Lokio/ForwardingSource;", "source", "Lokio/Source;", "<init>", "(Lvet/inpulse/libcomm/core/util/SourceMarker;Lokio/Source;)V", "read", "", "sink", "Lokio/Buffer;", "byteCount", "close", "", "libcomm"})
    @SourceDebugExtension(value={"SMAP\nSourceMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMarker.kt\nvet/inpulse/libcomm/core/util/SourceMarker$MarkSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
    public final class MarkSource
    extends ForwardingSource {
        public MarkSource(Source source) {
            Source source2 = source;
            Intrinsics.checkNotNull((Object)source2);
            super(source2);
        }

        public long read(@NotNull Buffer sink, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(!SourceMarker.this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (SourceMarker.this.getMark() == -1L) {
                long result2 = super.read(sink, byteCount);
                if (result2 == -1L) {
                    return -1L;
                }
                SourceMarker.this.setOffset(SourceMarker.this.getOffset() + result2);
                return result2;
            }
            if (SourceMarker.this.getOffset() < SourceMarker.this.getMark() + SourceMarker.this.getMarkBuffer().size()) {
                long posInBuffer = SourceMarker.this.getOffset() - SourceMarker.this.getMark();
                long result3 = Math.min(byteCount, SourceMarker.this.getMarkBuffer().size() - posInBuffer);
                SourceMarker.this.getMarkBuffer().copyTo(sink, posInBuffer, result3);
                SourceMarker.this.setOffset(SourceMarker.this.getOffset() + result3);
                return result3;
            }
            if (SourceMarker.this.getOffset() < SourceMarker.this.getLimit()) {
                long byteCountBeforeLimit = SourceMarker.this.getLimit() - (SourceMarker.this.getMark() + SourceMarker.this.getMarkBuffer().size());
                long result4 = super.read(SourceMarker.this.getMarkBuffer(), Math.min(byteCount, byteCountBeforeLimit));
                if (result4 == -1L) {
                    return -1L;
                }
                SourceMarker.this.getMarkBuffer().copyTo(sink, SourceMarker.this.getMarkBuffer().size() - result4, result4);
                SourceMarker.this.setOffset(SourceMarker.this.getOffset() + result4);
                return result4;
            }
            long result5 = super.read(sink, byteCount);
            if (result5 == -1L) {
                return -1L;
            }
            SourceMarker.this.getMarkBuffer().clear();
            SourceMarker.this.setMark(-1L);
            SourceMarker.this.setLimit(-1L);
            return result5;
        }

        public void close() throws IOException {
            if (SourceMarker.this.getClosed()) {
                return;
            }
            SourceMarker.this.setClosed(true);
            SourceMarker.this.getMarkBuffer().clear();
            super.close();
        }
    }
}

