/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\r\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0080\b\u001a\r\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0086\b\u001a\r\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0080\b\u001a\r\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0080\b\u001a\r\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0080\b\u001a\u0015\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0080\b\u001a\u001d\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0080\b\u001a\u0019\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0080\b\u001a\r\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0080\b\u001a\r\u0010\u0014\u001a\u00020\u0001*\u00020\u0002H\u0080\b\u001a\r\u0010\u0016\u001a\u00020\u0001*\u00020\u0002H\u0080\b\u001a\r\u0010\u0017\u001a\u00020\u0015*\u00020\u0001H\u0080\b\u001a\u0015\u0010\u0018\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010\u001a\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0001H\u0080\b\u001a\r\u0010 \u001a\u00020\u0004*\u00020\u001dH\u0080\b\u001a\r\u0010!\u001a\u00020\u0011*\u00020\u0002H\u0080\b\u001a\u0011\u0010\"\u001a\u00020\u0001*\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u001b\u001a\u00020\u001c*\u00020\u001d8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"readByteAsInt", "", "Lokio/BufferedSource;", "asInt", "", "read24BitInt", "read24BitUInt", "read24BitUIntLe", "MAX_FLOAT_BITS_24", "MIN_FLOAT_BITS_24", "write24BitInt", "", "Lokio/BufferedSink;", "i", "write24BitIntLe", "write24BitFloat", "f", "", "range", "mapFloatInto24BitRange", "read22BitInt", "", "read22BitIntLe", "serializeAs22Bits", "write22BitIntLe", "value", "write22BitInt", "lastIndex", "", "Lokio/Buffer;", "getLastIndex", "(Lokio/Buffer;)J", "last", "readFloat", "toBooleanByte", "", "(Ljava/lang/Boolean;)I", "libcomm"})
@SourceDebugExtension(value={"SMAP\nSourceByteUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n13#1:156\n11#1,3:157\n11#1,3:160\n11#1,3:163\n11#1,3:166\n11#1,3:169\n11#1,3:172\n11#1,3:175\n11#1,3:178\n11#1,3:181\n66#1:184\n67#1,16:186\n43#1,7:202\n13#1:210\n11#1,3:211\n11#1,3:214\n11#1,3:217\n11#1,3:220\n11#1,3:223\n11#1,3:226\n144#1:229\n1#2:185\n1#2:209\n*S KotlinDebug\n*F\n+ 1 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n11#1:156\n19#1:157,3\n20#1:160,3\n21#1:163,3\n26#1:166,3\n27#1:169,3\n28#1:172,3\n33#1:175,3\n34#1:178,3\n35#1:181,3\n61#1:184\n61#1:186,16\n62#1:202,7\n89#1:210\n97#1:211,3\n98#1:214,3\n99#1:217,3\n104#1:220,3\n105#1:223,3\n106#1:226,3\n146#1:229\n61#1:185\n*E\n"})
public final class SourceByteUtilsKt {
    private static final int MAX_FLOAT_BITS_24 = 0x7FFFFF;
    private static final int MIN_FLOAT_BITS_24 = 0x800000;

    public static final int readByteAsInt(@NotNull BufferedSource $this$readByteAsInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteAsInt, (String)"<this>");
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv = $this$readByteAsInt.readByte();
        boolean $i$f$asInt = false;
        return $this$asInt$iv & 0xFF;
    }

    public static final int asInt(byte $this$asInt) {
        boolean $i$f$asInt = false;
        return $this$asInt & 0xFF;
    }

    public static final int read24BitInt(@NotNull BufferedSource $this$read24BitInt) {
        Intrinsics.checkNotNullParameter((Object)$this$read24BitInt, (String)"<this>");
        boolean $i$f$read24BitInt = false;
        BufferedSource $this$readByteAsInt$iv = $this$read24BitInt;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b2 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$read24BitInt;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$read24BitInt;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int b0 = $this$asInt$iv$iv3 & 0xFF;
        return (b2 << 24 | b1 << 16 | b0 << 8) >> 8;
    }

    public static final int read24BitUInt(@NotNull BufferedSource $this$read24BitUInt) {
        Intrinsics.checkNotNullParameter((Object)$this$read24BitUInt, (String)"<this>");
        boolean $i$f$read24BitUInt = false;
        BufferedSource $this$readByteAsInt$iv = $this$read24BitUInt;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b2 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$read24BitUInt;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$read24BitUInt;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int b0 = $this$asInt$iv$iv3 & 0xFF;
        return b2 << 16 | b1 << 8 | b0;
    }

    public static final int read24BitUIntLe(@NotNull BufferedSource $this$read24BitUIntLe) {
        Intrinsics.checkNotNullParameter((Object)$this$read24BitUIntLe, (String)"<this>");
        boolean $i$f$read24BitUIntLe = false;
        BufferedSource $this$readByteAsInt$iv = $this$read24BitUIntLe;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b0 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$read24BitUIntLe;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$read24BitUIntLe;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int b2 = $this$asInt$iv$iv3 & 0xFF;
        return b2 << 16 | b1 << 8 | b0;
    }

    public static final void write24BitInt(@NotNull BufferedSink $this$write24BitInt, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$write24BitInt, (String)"<this>");
        boolean $i$f$write24BitInt = false;
        int a = (i & 0xFF0000) >> 16;
        int b = (i & 0xFF00) >> 8;
        int c = i & 0xFF;
        $this$write24BitInt.writeByte(a);
        $this$write24BitInt.writeByte(b);
        $this$write24BitInt.writeByte(c);
    }

    public static final void write24BitIntLe(@NotNull BufferedSink $this$write24BitIntLe, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$write24BitIntLe, (String)"<this>");
        boolean $i$f$write24BitIntLe = false;
        int a = (i & 0xFF0000) >> 16;
        int b = (i & 0xFF00) >> 8;
        int c = i & 0xFF;
        $this$write24BitIntLe.writeByte(c);
        $this$write24BitIntLe.writeByte(b);
        $this$write24BitIntLe.writeByte(a);
    }

    /*
     * WARNING - void declaration
     */
    public static final void write24BitFloat(@NotNull BufferedSink $this$write24BitFloat, float f, float range) {
        void $this$write24BitInt$iv;
        int n;
        void f$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$write24BitFloat, (String)"<this>");
        boolean $i$f$write24BitFloat = false;
        float f2 = f;
        float range$iv = range;
        boolean $i$f$mapFloatInto24BitRange = false;
        if (!(range$iv > 0.01f)) {
            boolean $i$a$-require-SourceByteUtilsKt$mapFloatInto24BitRange$1$iv22 = false;
            String $i$a$-require-SourceByteUtilsKt$mapFloatInto24BitRange$1$iv22 = "range is too small, values explode";
            throw new IllegalArgumentException($i$a$-require-SourceByteUtilsKt$mapFloatInto24BitRange$1$iv22.toString());
        }
        if (f$iv2 >= range$iv) {
            n = 0x7FFFFF;
        } else if (f$iv2 <= -range$iv) {
            n = 0x800000;
        } else {
            int negative$iv;
            int mapped$iv = MathKt.roundToInt((float)(f$iv2 / range$iv * (float)0x7FFFFF));
            n = mapped$iv >= 0 ? mapped$iv : (negative$iv = 0x7FFFFF - mapped$iv + 0x800000);
        }
        int v = n;
        BufferedSink f$iv2 = $this$write24BitFloat;
        int i$iv = v;
        boolean $i$f$write24BitInt = false;
        int a$iv = (i$iv & 0xFF0000) >> 16;
        int b$iv = (i$iv & 0xFF00) >> 8;
        int c$iv = i$iv & 0xFF;
        $this$write24BitInt$iv.writeByte(a$iv);
        $this$write24BitInt$iv.writeByte(b$iv);
        $this$write24BitInt$iv.writeByte(c$iv);
    }

    public static final int mapFloatInto24BitRange(float f, float range) {
        int n;
        boolean $i$f$mapFloatInto24BitRange = false;
        if (!(range > 0.01f)) {
            boolean $i$a$-require-SourceByteUtilsKt$mapFloatInto24BitRange$22 = false;
            String $i$a$-require-SourceByteUtilsKt$mapFloatInto24BitRange$22 = "range is too small, values explode";
            throw new IllegalArgumentException($i$a$-require-SourceByteUtilsKt$mapFloatInto24BitRange$22.toString());
        }
        if (f >= range) {
            n = 0x7FFFFF;
        } else if (f <= -range) {
            n = 0x800000;
        } else {
            int negative;
            int mapped = MathKt.roundToInt((float)(f / range * (float)0x7FFFFF));
            n = mapped >= 0 ? mapped : (negative = 0x7FFFFF - mapped + 0x800000);
        }
        return n;
    }

    public static final int read22BitInt(@NotNull byte[] $this$read22BitInt) {
        Intrinsics.checkNotNullParameter((Object)$this$read22BitInt, (String)"<this>");
        boolean $i$f$read22BitInt = false;
        byte $this$asInt$iv = $this$read22BitInt[0];
        boolean $i$f$asInt = false;
        int n = ($this$asInt$iv & 0xFF) << 26;
        $this$asInt$iv = $this$read22BitInt[1];
        $i$f$asInt = false;
        int n2 = n | ($this$asInt$iv & 0xFF) << 18;
        $this$asInt$iv = $this$read22BitInt[2];
        $i$f$asInt = false;
        return (n2 | ($this$asInt$iv & 0xFF) << 10) >> 10;
    }

    public static final int read22BitInt(@NotNull BufferedSource $this$read22BitInt) {
        Intrinsics.checkNotNullParameter((Object)$this$read22BitInt, (String)"<this>");
        boolean $i$f$read22BitInt = false;
        BufferedSource $this$readByteAsInt$iv = $this$read22BitInt;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b2 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$read22BitInt;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$read22BitInt;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int b0 = $this$asInt$iv$iv3 & 0xFF;
        return (b2 << 26 | b1 << 18 | b0 << 10) >> 10;
    }

    public static final int read22BitIntLe(@NotNull BufferedSource $this$read22BitIntLe) {
        Intrinsics.checkNotNullParameter((Object)$this$read22BitIntLe, (String)"<this>");
        boolean $i$f$read22BitIntLe = false;
        BufferedSource $this$readByteAsInt$iv = $this$read22BitIntLe;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b0 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$read22BitIntLe;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$read22BitIntLe;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int b2 = $this$asInt$iv$iv3 & 0xFF;
        return (b2 << 26 | b1 << 18 | b0 << 10) >> 10;
    }

    @NotNull
    public static final byte[] serializeAs22Bits(int $this$serializeAs22Bits) {
        boolean $i$f$serializeAs22Bits = false;
        byte b0 = (byte)($this$serializeAs22Bits & 0xFF);
        byte b1 = (byte)($this$serializeAs22Bits >> 8 & 0xFF);
        byte b2 = (byte)($this$serializeAs22Bits >> 16 & 0x3F);
        byte[] byArray = new byte[]{b2, b1, b0};
        return byArray;
    }

    public static final void write22BitIntLe(@NotNull BufferedSink $this$write22BitIntLe, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$write22BitIntLe, (String)"<this>");
        boolean $i$f$write22BitIntLe = false;
        int b0 = value & 0xFF;
        int b1 = value >> 8 & 0xFF;
        int b2 = value >> 16 & 0x3F;
        $this$write22BitIntLe.writeByte(b0);
        $this$write22BitIntLe.writeByte(b1);
        $this$write22BitIntLe.writeByte(b2);
    }

    public static final void write22BitInt(@NotNull BufferedSink $this$write22BitInt, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$write22BitInt, (String)"<this>");
        boolean $i$f$write22BitInt = false;
        int b0 = value & 0xFF;
        int b1 = value >> 8 & 0xFF;
        int b2 = value >> 16 & 0x3F;
        $this$write22BitInt.writeByte(b2);
        $this$write22BitInt.writeByte(b1);
        $this$write22BitInt.writeByte(b0);
    }

    public static final long getLastIndex(@NotNull Buffer $this$lastIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$lastIndex, (String)"<this>");
        boolean $i$f$getLastIndex = false;
        return $this$lastIndex.size() - 1L;
    }

    public static final byte last(@NotNull Buffer $this$last) {
        Intrinsics.checkNotNullParameter((Object)$this$last, (String)"<this>");
        boolean $i$f$last = false;
        Buffer $this$lastIndex$iv = $this$last;
        boolean $i$f$getLastIndex = false;
        return $this$last.getByte($this$lastIndex$iv.size() - 1L);
    }

    public static final float readFloat(@NotNull BufferedSource $this$readFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$readFloat, (String)"<this>");
        boolean $i$f$readFloat = false;
        return Float.intBitsToFloat($this$readFloat.readIntLe());
    }

    public static final int toBooleanByte(@Nullable Boolean $this$toBooleanByte) {
        return $this$toBooleanByte == null || $this$toBooleanByte == false ? 0 : 1;
    }
}

