/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bJ\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lvet/inpulse/libcomm/core/util/RollingMeanStdDev;", "", "windowSize", "", "<init>", "(I)V", "data", "Lkotlin/collections/ArrayDeque;", "", "_mean", "mean", "getMean", "()D", "_stdDev", "stdDev", "getStdDev", "size", "getSize", "()I", "addData", "", "value", "updateMean", "updateStdDev", "reset", "libcomm"})
public final class RollingMeanStdDev {
    private final int windowSize;
    @NotNull
    private final ArrayDeque<Double> data;
    private double _mean;
    private double _stdDev;

    public RollingMeanStdDev(int windowSize) {
        this.windowSize = windowSize;
        this.data = new ArrayDeque();
    }

    public /* synthetic */ RollingMeanStdDev(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        this(n);
    }

    public final double getMean() {
        return this._mean;
    }

    public final double getStdDev() {
        return this._stdDev;
    }

    public final int getSize() {
        return this.data.size();
    }

    public final void addData(double value) {
        int diff = this.windowSize - this.data.size();
        if (diff <= 0) {
            int n = diff + 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.data.removeFirstOrNull();
            }
        }
        this.data.addLast((Object)value);
        this.updateMean();
        this.updateStdDev();
    }

    private final void updateMean() {
        int size = this.data.size();
        if (size == 0) {
            this._mean = 0.0;
            return;
        }
        double sum = CollectionsKt.sumOfDouble((Iterable)((Iterable)this.data));
        this._mean = sum / (double)size;
    }

    private final void updateStdDev() {
        int size = this.data.size();
        double mean = this._mean;
        double acc = 0.0;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            double d = ((Number)iterator.next()).doubleValue();
            acc += Math.pow(d - mean, 2);
        }
        this._stdDev = Math.sqrt(acc /= (double)size);
    }

    public final void reset() {
        this.data.clear();
        this._mean = 0.0;
        this._stdDev = 0.0;
    }

    public RollingMeanStdDev() {
        this(0, 1, null);
    }
}

