/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.util;

import kotlin.Metadata;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"ppgConversionConstant", "", "getRealG1", "controlValue", "", "getRealG2", "convertPpgRawVoltageToCurrent", "", "rawDigitalValue", "rawAmbientDigitalValue", "g1", "g2", "libcomm"})
public final class PpgConversionKt {
    private static final double ppgConversionConstant = 0.5722048626922907;

    private static final double getRealG1(int controlValue) {
        return switch (controlValue) {
            case 1 -> 10000.0;
            case 2 -> 25000.0;
            case 3 -> 50000.0;
            case 4 -> 100000.0;
            case 5 -> 250000.0;
            case 6 -> 500000.0;
            case 7 -> 1000000.0;
            default -> Double.NaN;
        };
    }

    private static final double getRealG2(int controlValue) {
        return switch (controlValue) {
            case 0 -> 1.0;
            case 1 -> 1.5;
            case 2 -> 2.0;
            case 3 -> 3.0;
            case 4 -> 4.0;
            default -> Double.NaN;
        };
    }

    public static final float convertPpgRawVoltageToCurrent(int rawDigitalValue, int rawAmbientDigitalValue, int g1, int g2) {
        double realG1 = PpgConversionKt.getRealG1(g1);
        double realG2 = PpgConversionKt.getRealG2(g2);
        if (Double.isNaN(realG1) || Double.isNaN(realG2)) {
            return Float.NaN;
        }
        double deltaV = (double)rawDigitalValue - (double)rawAmbientDigitalValue;
        return (float)(deltaV * 0.5722048626922907 / (2.0 * realG1 * realG2));
    }
}

