/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.ppg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.data.PpgCalibrationParameters;
import vet.inpulse.libcomm.core.device.data.PpgDiagnosis;
import vet.inpulse.libcomm.core.device.data.PpgSampleStatus;
import vet.inpulse.libcomm.core.device.data.PpgState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001c\u00a8\u0006\u001f"}, d2={"Lvet/inpulse/libcomm/core/protocol/ppg/PpgCommonSerializer;", "", "<init>", "()V", "writePpgStateV2", "", "sink", "Lokio/BufferedSink;", "state", "Lvet/inpulse/libcomm/core/device/data/PpgState;", "readPpgStateV2", "source", "Lokio/BufferedSource;", "assembleBitField", "", "upper", "", "lower", "maskLower", "writePpgCalibrationParametersV2", "params", "Lvet/inpulse/libcomm/core/device/data/PpgCalibrationParameters$V2;", "readPpgCalibrationParametersV2", "writePpgControlPhaseConfig", "config", "Lvet/inpulse/libcomm/core/device/data/PpgCalibrationParameters$ControlPhaseConfig;", "readPpgControlPhaseConfig", "readPpgDiagnosis", "Lvet/inpulse/libcomm/core/device/data/PpgDiagnosis;", "writePpgDiagnosis", "diagnosis", "libcomm"})
@SourceDebugExtension(value={"SMAP\nPpgCommonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PpgCommonSerializer.kt\nvet/inpulse/libcomm/core/protocol/ppg/PpgCommonSerializer\n+ 2 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n1#1,181:1\n11#2,3:182\n11#2,3:185\n11#2,3:188\n11#2,3:191\n11#2,3:194\n11#2,3:197\n11#2,3:200\n11#2,3:203\n11#2,3:206\n11#2,3:209\n11#2,3:212\n*S KotlinDebug\n*F\n+ 1 PpgCommonSerializer.kt\nvet/inpulse/libcomm/core/protocol/ppg/PpgCommonSerializer\n*L\n27#1:182,3\n28#1:185,3\n29#1:188,3\n30#1:191,3\n31#1:194,3\n73#1:197,3\n105#1:200,3\n106#1:203,3\n107#1:206,3\n135#1:209,3\n136#1:212,3\n*E\n"})
public final class PpgCommonSerializer {
    @NotNull
    public static final PpgCommonSerializer INSTANCE = new PpgCommonSerializer();

    private PpgCommonSerializer() {
    }

    public final void writePpgStateV2(@NotNull BufferedSink sink, @NotNull PpgState state) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int b0 = this.assembleBitField((byte)state.getGainRed1(), (byte)state.getGainRed2(), (byte)15);
        int b1 = this.assembleBitField((byte)state.getGainIR1(), (byte)state.getGainIR2(), (byte)15);
        int b4 = this.assembleBitField(state.getStatus().getByte(), (byte)state.getAmbdac(), (byte)15);
        sink.writeByte(b0);
        sink.writeByte(b1);
        sink.writeByte(state.getLedRed());
        sink.writeByte(state.getLedIR());
        sink.writeByte(b4);
    }

    @NotNull
    public final PpgState readPpgStateV2(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BufferedSource $this$readByteAsInt$iv = source;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b0 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = source;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b1 = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = source;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int ledRed = $this$asInt$iv$iv3 & 0xFF;
        BufferedSource $this$readByteAsInt$iv4 = source;
        boolean $i$f$readByteAsInt4 = false;
        byte $this$asInt$iv$iv4 = $this$readByteAsInt$iv4.readByte();
        boolean $i$f$asInt4 = false;
        int ledIr = $this$asInt$iv$iv4 & 0xFF;
        BufferedSource $this$readByteAsInt$iv5 = source;
        boolean $i$f$readByteAsInt5 = false;
        byte $this$asInt$iv$iv5 = $this$readByteAsInt$iv5.readByte();
        boolean $i$f$asInt5 = false;
        int b4 = $this$asInt$iv$iv5 & 0xFF;
        int gainRed1 = (b0 & 0xF0) >> 4;
        int gainRed2 = b0 & 0xF;
        int gainIr1 = (b1 & 0xF0) >> 4;
        int gainIr2 = b1 & 0xF;
        byte status = (byte)((b4 & 0xF0) >> 4);
        int ambdac = b4 & 0xF;
        return new PpgState(gainRed1, gainRed2, ledRed, gainIr1, gainIr2, ledIr, ambdac, PpgSampleStatus.Companion.fromByte(status));
    }

    private final int assembleBitField(byte upper, byte lower, byte maskLower) {
        byte maskUpper = ~maskLower;
        int shift = Integer.numberOfTrailingZeros(maskUpper);
        int shifted = upper << shift;
        int resultUpper = shifted & maskUpper;
        byte resultLower = (byte)(lower & maskLower);
        return resultUpper | resultLower;
    }

    public final void writePpgCalibrationParametersV2(@NotNull BufferedSink sink, @NotNull PpgCalibrationParameters.V2 params) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.writePpgStateV2(sink, params.getLeadOffEvaluationState());
        this.writePpgStateV2(sink, params.getInitialCalibrationState());
        sink.writeByte(params.getControlWindow());
        for (PpgCalibrationParameters.ControlPhaseConfig c : params.getControlPhaseConfigOrder()) {
            this.writePpgControlPhaseConfig(sink, c);
        }
    }

    @NotNull
    public final PpgCalibrationParameters.V2 readPpgCalibrationParametersV2(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        PpgState leadOffEvaluationState = this.readPpgStateV2(source);
        PpgState initialCalibrationState = this.readPpgStateV2(source);
        BufferedSource $this$readByteAsInt$iv = source;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int controlWindow = $this$asInt$iv$iv & 0xFF;
        List phases = new ArrayList();
        while (source.request(28L)) {
            ((Collection)phases).add(this.readPpgControlPhaseConfig(source));
        }
        return new PpgCalibrationParameters.V2(leadOffEvaluationState, initialCalibrationState, controlWindow, phases);
    }

    public final void writePpgControlPhaseConfig(@NotNull BufferedSink sink, @NotNull PpgCalibrationParameters.ControlPhaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        BufferedSink $this$writePpgControlPhaseConfig_u24lambda_u240 = sink;
        boolean bl = false;
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeByte((int)config.getControlPhase().getHwByte());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeByte(config.getMinValue());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeByte(config.getMaxValue());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeByte(config.getStep());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getRedMin());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getRedMax());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getARedMin());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getARedMax());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getIrMin());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getIrMax());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getAIrMin());
        $this$writePpgControlPhaseConfig_u24lambda_u240.writeIntLe(config.getAIrMax());
    }

    @NotNull
    public final PpgCalibrationParameters.ControlPhaseConfig readPpgControlPhaseConfig(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BufferedSource $this$readPpgControlPhaseConfig_u24lambda_u241 = source;
        boolean bl = false;
        byte phase = $this$readPpgControlPhaseConfig_u24lambda_u241.readByte();
        BufferedSource $this$readByteAsInt$iv = $this$readPpgControlPhaseConfig_u24lambda_u241;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int minValue = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = $this$readPpgControlPhaseConfig_u24lambda_u241;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int maxValue = $this$asInt$iv$iv2 & 0xFF;
        BufferedSource $this$readByteAsInt$iv3 = $this$readPpgControlPhaseConfig_u24lambda_u241;
        boolean $i$f$readByteAsInt3 = false;
        byte $this$asInt$iv$iv3 = $this$readByteAsInt$iv3.readByte();
        boolean $i$f$asInt3 = false;
        int step = $this$asInt$iv$iv3 & 0xFF;
        int redMin = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int redMax = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int aRedMin = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int aRedMax = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int irMin = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int irMax = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int aIrMin = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        int aIrMax = $this$readPpgControlPhaseConfig_u24lambda_u241.readIntLe();
        return new PpgCalibrationParameters.ControlPhaseConfig(PpgCalibrationParameters.ControlPhase.Companion.fromByte(phase), minValue, maxValue, step, redMin, redMax, aRedMin, aRedMax, irMin, irMax, aIrMin, aIrMax);
    }

    @NotNull
    public final PpgDiagnosis readPpgDiagnosis(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BufferedSource $this$readByteAsInt$iv = source;
        boolean $i$f$readByteAsInt = false;
        byte $this$asInt$iv$iv = $this$readByteAsInt$iv.readByte();
        boolean $i$f$asInt = false;
        int b1 = $this$asInt$iv$iv & 0xFF;
        BufferedSource $this$readByteAsInt$iv2 = source;
        boolean $i$f$readByteAsInt2 = false;
        byte $this$asInt$iv$iv2 = $this$readByteAsInt$iv2.readByte();
        boolean $i$f$asInt2 = false;
        int b2 = $this$asInt$iv$iv2 & 0xFF;
        return new PpgDiagnosis((b1 & 0x10) > 0, (b1 & 8) > 0, (b1 & 4) > 0, (b1 & 2) > 0, (b1 & 1) > 0, (b2 & 0x80) > 0, (b2 & 0x40) > 0, (b2 & 0x20) > 0, (b2 & 0x10) > 0, (b2 & 8) > 0, (b2 & 4) > 0, (b2 & 2) > 0, (b2 & 1) > 0);
    }

    public final void writePpgDiagnosis(@NotNull BufferedSink sink, @NotNull PpgDiagnosis diagnosis) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)diagnosis, (String)"diagnosis");
        int b1 = 0;
        b1 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b1, 16, diagnosis.getPD_ALM());
        b1 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b1, 8, diagnosis.getLED_ALM());
        b1 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b1, 4, diagnosis.getLED1OPEN());
        b1 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b1, 2, diagnosis.getLED2OPEN());
        b1 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b1, 1, diagnosis.getLEDSC());
        int b2 = 0;
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 128, diagnosis.getOUTPSHGND());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 64, diagnosis.getOUTNSHGND());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 32, diagnosis.getPDOC());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 16, diagnosis.getPDSC());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 8, diagnosis.getINNSCGND());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 4, diagnosis.getINPSCGND());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 2, diagnosis.getINNSCLED());
        b2 = PpgCommonSerializer.writePpgDiagnosis$maskIfTrue(b2, 1, diagnosis.getINPSCLED());
        sink.writeByte(b1);
        sink.writeByte(b2);
    }

    private static final int writePpgDiagnosis$maskIfTrue(int original, int bitIfTrue, boolean flag) {
        int combine = flag ? bitIfTrue : 0;
        return original | combine;
    }
}

