/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.payloadSerializer.impl;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.data.BatteryInfo;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.protocol.message.BatteryInfoMessage;
import vet.inpulse.libcomm.core.protocol.payloadSerializer.MessagePayloadSerializer;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lvet/inpulse/libcomm/core/protocol/payloadSerializer/impl/BatteryInfoSerializer;", "Lvet/inpulse/libcomm/core/protocol/payloadSerializer/MessagePayloadSerializer;", "Lvet/inpulse/libcomm/core/protocol/message/BatteryInfoMessage;", "<init>", "()V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "serializePayload", "", "sink", "Lokio/BufferedSink;", "message", "deserializePayload", "source", "Lokio/BufferedSource;", "libcomm"})
public final class BatteryInfoSerializer
implements MessagePayloadSerializer<BatteryInfoMessage> {
    @NotNull
    public static final BatteryInfoSerializer INSTANCE = new BatteryInfoSerializer();
    @NotNull
    private static final LoggerInterface logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(INSTANCE.getClass()));

    private BatteryInfoSerializer() {
    }

    @Override
    public void serializePayload(@NotNull BufferedSink sink, @NotNull BatteryInfoMessage message2) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        BatteryInfo batteryInfo = message2.getInfo();
        if (batteryInfo instanceof BatteryInfo.Normal) {
            sink.writeShortLe(((BatteryInfo.Normal)message2.getInfo()).getDurationInMinutes());
            sink.writeShortLe(((BatteryInfo.Normal)message2.getInfo()).getCharge());
        } else if (!Intrinsics.areEqual((Object)batteryInfo, (Object)BatteryInfo.Unknown.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    @NotNull
    public BatteryInfoMessage deserializePayload(@NotNull BufferedSource source) {
        BatteryInfo batteryInfo;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            short duration = source.readShortLe();
            short charge = source.readShortLe();
            batteryInfo = new BatteryInfo.Normal(duration, charge, null, duration < 0, 4, null);
        }
        catch (Exception ex) {
            LoggerInterface.w$default((LoggerInterface)logger, null, () -> BatteryInfoSerializer.deserializePayload$lambda$0(ex), (int)1, null);
            batteryInfo = BatteryInfo.Unknown.INSTANCE;
        }
        BatteryInfo batteryInfo2 = batteryInfo;
        return new BatteryInfoMessage(batteryInfo2);
    }

    private static final String deserializePayload$lambda$0(Exception $ex) {
        return "Failed to deserialize battery info: " + $ex.getMessage();
    }
}

