/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.message;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Source;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.data.BatteryInfo;
import vet.inpulse.libcomm.core.device.data.WifiConfiguration;
import vet.inpulse.libcomm.core.device.data.WifiStatus;
import vet.inpulse.libcomm.core.protocol.InPulseProtocolV2;
import vet.inpulse.libcomm.core.protocol.message.BatteryInfoMessage;
import vet.inpulse.libcomm.core.protocol.message.ExtendedMyInfo;
import vet.inpulse.libcomm.core.protocol.message.ExtendedMyInfoFields;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lvet/inpulse/libcomm/core/protocol/message/ExtendedMyInfoDeserializer;", "", "<init>", "()V", "tryDeserialize", "Lvet/inpulse/libcomm/core/protocol/message/ExtendedMyInfo;", "source", "Lokio/BufferedSource;", "serialize", "", "sink", "Lokio/BufferedSink;", "info", "libcomm"})
public final class ExtendedMyInfoDeserializer {
    @NotNull
    public static final ExtendedMyInfoDeserializer INSTANCE = new ExtendedMyInfoDeserializer();

    private ExtendedMyInfoDeserializer() {
    }

    @Nullable
    public final ExtendedMyInfo tryDeserialize(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.exhausted()) {
            return null;
        }
        String serialNumber = null;
        String friendlyName = null;
        BatteryInfo batteryInfo = null;
        WifiConfiguration wifiConfig = null;
        WifiStatus wifiConnectionInfo = null;
        block8: while (!source.exhausted()) {
            byte typeByte = source.readByte();
            byte size = source.readByte();
            if (!source.request((long)size)) break;
            switch (WhenMappings.$EnumSwitchMapping$0[ExtendedMyInfoFields.Companion.fromByte(typeByte).ordinal()]) {
                case 1: {
                    long length = source.readByte();
                    serialNumber = source.readUtf8(length);
                    continue block8;
                }
                case 2: {
                    long length = source.readByte();
                    friendlyName = source.readUtf8(length);
                    continue block8;
                }
                case 3: {
                    Object object = InPulseProtocolV2.Companion.deserializeBatteryInfoV2-IoAF18A(source);
                    if (Result.isSuccess-impl((Object)object)) {
                        BatteryInfoMessage it = (BatteryInfoMessage)object;
                        boolean bl = false;
                        batteryInfo = it.getInfo();
                    }
                    Result.box-impl((Object)object);
                    continue block8;
                }
                case 4: {
                    wifiConfig = InPulseProtocolV2.Companion.deserializeWifiConfiguration(source);
                    continue block8;
                }
                case 5: {
                    wifiConnectionInfo = InPulseProtocolV2.Companion.deserializeWifiStatus(source);
                    continue block8;
                }
                case 6: {
                    source.skip((long)size);
                    continue block8;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return new ExtendedMyInfo(serialNumber, friendlyName, batteryInfo, wifiConfig, wifiConnectionInfo);
    }

    public final void serialize(@NotNull BufferedSink sink, @NotNull ExtendedMyInfo info) {
        int coercedStringLength;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Buffer buffer = new Buffer();
        if (info.getSerialNumber() != null) {
            coercedStringLength = (int)Utf8.size$default((String)info.getSerialNumber(), (int)0, (int)0, (int)3, null);
            sink.writeByte((int)ExtendedMyInfoFields.SERIAL_NUMBER.getTypeByte());
            sink.writeByte(coercedStringLength + 1);
            sink.writeByte(coercedStringLength);
            sink.writeUtf8(info.getSerialNumber(), 0, coercedStringLength);
        }
        if (info.getFriendlyName() != null) {
            coercedStringLength = (int)Utf8.size$default((String)info.getFriendlyName(), (int)0, (int)0, (int)3, null);
            sink.writeByte((int)ExtendedMyInfoFields.FRIENDLY_NAME.getTypeByte());
            sink.writeByte(coercedStringLength + 1);
            sink.writeByte(coercedStringLength);
            sink.writeUtf8(info.getFriendlyName(), 0, coercedStringLength);
        }
        if (info.getBatteryInfo() != null) {
            InPulseProtocolV2.Companion.serializeBatteryInfoV2((BufferedSink)buffer, info.getBatteryInfo());
            sink.writeByte((int)ExtendedMyInfoFields.BATTERY_INFO_V2.getTypeByte());
            sink.writeByte((int)buffer.size());
            sink.writeAll((Source)buffer);
            buffer.clear();
        }
        if (info.getWifiConfig() != null) {
            buffer.writeByte(info.getWifiConfig().getSsid().length());
            buffer.writeUtf8(info.getWifiConfig().getSsid());
            buffer.writeByte(info.getWifiConfig().getWifiAuthMode().getByte());
            sink.writeByte((int)ExtendedMyInfoFields.WIFI_CONFIGURATION_V1.getTypeByte());
            sink.writeByte((int)buffer.size());
            sink.writeAll((Source)buffer);
            buffer.clear();
        }
        if (info.getWifiConnectionInfo() != null) {
            InPulseProtocolV2.Companion.serializeWifiStatus(info.getWifiConnectionInfo(), (BufferedSink)buffer);
            sink.writeByte((int)ExtendedMyInfoFields.WIFI_CONNECTION_INFO_V1.getTypeByte());
            sink.writeByte((int)buffer.size());
            sink.writeAll((Source)buffer);
            buffer.clear();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExtendedMyInfoFields.values().length];
            try {
                nArray[ExtendedMyInfoFields.SERIAL_NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtendedMyInfoFields.FRIENDLY_NAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtendedMyInfoFields.BATTERY_INFO_V2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtendedMyInfoFields.WIFI_CONFIGURATION_V1.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtendedMyInfoFields.WIFI_CONNECTION_INFO_V1.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExtendedMyInfoFields.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

