/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.capno;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import okio.BufferedSource;
import okio.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.protocol.capno.AvailableCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.BalanceGas;
import vet.inpulse.libcomm.core.protocol.capno.BreathDetected;
import vet.inpulse.libcomm.core.protocol.capno.CO2O2Waveform;
import vet.inpulse.libcomm.core.protocol.capno.CO2Status;
import vet.inpulse.libcomm.core.protocol.capno.CO2StatusError;
import vet.inpulse.libcomm.core.protocol.capno.CO2Waveform;
import vet.inpulse.libcomm.core.protocol.capno.CapnostatZero;
import vet.inpulse.libcomm.core.protocol.capno.CurrentCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.DataParameter;
import vet.inpulse.libcomm.core.protocol.capno.DataParameterIndex;
import vet.inpulse.libcomm.core.protocol.capno.ETCO2;
import vet.inpulse.libcomm.core.protocol.capno.FeO2;
import vet.inpulse.libcomm.core.protocol.capno.FiO2;
import vet.inpulse.libcomm.core.protocol.capno.GetAvailableCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.GetCurrentCapabilities;
import vet.inpulse.libcomm.core.protocol.capno.GetSensorSettings;
import vet.inpulse.libcomm.core.protocol.capno.GetSoftwareRevision;
import vet.inpulse.libcomm.core.protocol.capno.HardwareStatus;
import vet.inpulse.libcomm.core.protocol.capno.HardwareStatusFlags;
import vet.inpulse.libcomm.core.protocol.capno.InspiredCO2;
import vet.inpulse.libcomm.core.protocol.capno.NackError;
import vet.inpulse.libcomm.core.protocol.capno.O2Status;
import vet.inpulse.libcomm.core.protocol.capno.O2StatusError;
import vet.inpulse.libcomm.core.protocol.capno.ResetCapnostat;
import vet.inpulse.libcomm.core.protocol.capno.ResetNoBreathsDetected;
import vet.inpulse.libcomm.core.protocol.capno.RespirationRate;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsPacket;
import vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocolKt;
import vet.inpulse.libcomm.core.protocol.capno.RevisionFormat;
import vet.inpulse.libcomm.core.protocol.capno.SensorCapabilityFlags;
import vet.inpulse.libcomm.core.protocol.capno.SensorSetting;
import vet.inpulse.libcomm.core.protocol.capno.SensorSettingIdentifier;
import vet.inpulse.libcomm.core.protocol.capno.SetSensorSettings;
import vet.inpulse.libcomm.core.protocol.capno.SoftwareRevision;
import vet.inpulse.libcomm.core.protocol.capno.StartCO2DataMode;
import vet.inpulse.libcomm.core.protocol.capno.StartCO2O2DataMode;
import vet.inpulse.libcomm.core.protocol.capno.StartCapnostatZero;
import vet.inpulse.libcomm.core.protocol.capno.StopContinuousMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lvet/inpulse/libcomm/core/protocol/capno/RespironicsProtocol;", "", "<init>", "()V", "Companion", "libcomm"})
public final class RespironicsProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final byte CO2_WAVEFORM_DATA_MODE = -128;
    public static final byte CAPNOSTAT_ZERO = -126;
    public static final byte GET_SET_SENSOR_SETTINGS = -124;
    public static final byte CO2_O2_WAVEFORM_MODE = -112;
    public static final byte NACK_ERROR = -56;
    public static final byte STOP_CONTINUOUS_MODE = -55;
    public static final byte GET_SOFTWARE_REVISION = -54;
    public static final byte SENSOR_CAPABILITIES = -53;
    public static final byte RESET_NO_BREATHS_DETECTED = -52;
    public static final byte RESET_CAPNOSTAT = -8;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J\"\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J$\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\\\u0010#\u001a\u0004\u0018\u00010$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020.0*2!\u0010/\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002010*J*\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u00105\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lvet/inpulse/libcomm/core/protocol/capno/RespironicsProtocol$Companion;", "", "<init>", "()V", "CO2_WAVEFORM_DATA_MODE", "", "CAPNOSTAT_ZERO", "GET_SET_SENSOR_SETTINGS", "CO2_O2_WAVEFORM_MODE", "NACK_ERROR", "STOP_CONTINUOUS_MODE", "GET_SOFTWARE_REVISION", "SENSOR_CAPABILITIES", "RESET_NO_BREATHS_DETECTED", "RESET_CAPNOSTAT", "findCommand", "", "data", "", "offset", "length", "isValidPacket", "", "calculateChecksum", "get5ByteInt", "", "db1", "db2", "db3", "db4", "db5", "getSettingIsb", "settings", "Lvet/inpulse/libcomm/core/protocol/capno/SensorSetting;", "(Lvet/inpulse/libcomm/core/protocol/capno/SensorSetting;)Ljava/lang/Byte;", "deserializeMessage", "Lvet/inpulse/libcomm/core/protocol/capno/RespironicsPacket;", "source", "Lokio/BufferedSource;", "next", "Lkotlin/Function0;", "readString", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "size", "", "throwIfNotAvailable", "required", "", "serializePacket", "packet", "dest", "limit", "libcomm"})
    @SourceDebugExtension(value={"SMAP\nRespironicsProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RespironicsProtocol.kt\nvet/inpulse/libcomm/core/protocol/capno/RespironicsProtocol$Companion\n+ 2 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n1#1,1276:1\n13#2:1277\n13#2:1278\n13#2:1279\n13#2:1280\n13#2:1281\n13#2:1282\n13#2:1283\n13#2:1284\n13#2:1285\n13#2:1286\n13#2:1287\n13#2:1288\n13#2:1289\n13#2:1290\n13#2:1291\n*S KotlinDebug\n*F\n+ 1 RespironicsProtocol.kt\nvet/inpulse/libcomm/core/protocol/capno/RespironicsProtocol$Companion\n*L\n86#1:1277\n87#1:1278\n88#1:1279\n89#1:1280\n90#1:1281\n253#1:1282\n257#1:1283\n345#1:1284\n151#1:1285\n157#1:1286\n175#1:1287\n176#1:1288\n177#1:1289\n178#1:1290\n179#1:1291\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int findCommand(@NotNull byte[] data, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int cmdMask = -128;
            boolean zero = false;
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                byte test = (byte)(data[i] & cmdMask);
                if (test == 0) continue;
                return i;
            }
            return -1;
        }

        public static /* synthetic */ int findCommand$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.findCommand(byArray, n, n2);
        }

        public final boolean isValidPacket(@NotNull byte[] data, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int cmdOffset = this.findCommand(data, offset, length);
            if (cmdOffset < 0) {
                return false;
            }
            if (cmdOffset + 1 > offset + length) {
                return false;
            }
            byte packetLength = data[cmdOffset + 1];
            if (cmdOffset + 1 + packetLength > offset + length) {
                return false;
            }
            byte expectedChecksum = data[cmdOffset + 1 + packetLength];
            int checksum = 0;
            int n = cmdOffset + packetLength + 1;
            for (int i = cmdOffset; i < n; ++i) {
                checksum = (byte)(checksum + data[i]);
            }
            byte calc = (byte)((byte)(checksum & 0x7F) + expectedChecksum);
            return (byte)(calc & 0x7F) == 0;
        }

        public static /* synthetic */ boolean isValidPacket$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.isValidPacket(byArray, n, n2);
        }

        public final byte calculateChecksum(@NotNull byte[] data, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int checksum = 0;
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                checksum = (byte)(checksum + data[i]);
            }
            checksum = (byte)((byte)(~checksum) + 1);
            return (byte)(checksum & 0x7F);
        }

        public static /* synthetic */ byte calculateChecksum$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.calculateChecksum(byArray, n, n2);
        }

        private final long get5ByteInt(byte db1, byte db2, byte db3, byte db4, byte db5) {
            byte $this$asInt$iv = db1;
            boolean $i$f$asInt = false;
            long l = ($this$asInt$iv & 0xFF) << 28;
            $this$asInt$iv = db2;
            $i$f$asInt = false;
            long l2 = l + (long)(($this$asInt$iv & 0xFF) << 21);
            $this$asInt$iv = db3;
            $i$f$asInt = false;
            long l3 = l2 + (long)(($this$asInt$iv & 0xFF) << 14);
            $this$asInt$iv = db4;
            $i$f$asInt = false;
            long l4 = l3 + (long)(($this$asInt$iv & 0xFF) << 7);
            $this$asInt$iv = db5;
            $i$f$asInt = false;
            return l4 + (long)($this$asInt$iv & 0xFF);
        }

        private final Byte getSettingIsb(SensorSetting settings) {
            Byte by;
            SensorSetting sensorSetting = settings;
            if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetBarometricPressure.INSTANCE) || sensorSetting instanceof SensorSetting.BarometricPressure) {
                by = SensorSettingIdentifier.BAROMETRIC_PRESSURE.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetGasTemperature.INSTANCE) || sensorSetting instanceof SensorSetting.GasTemperature) {
                by = SensorSettingIdentifier.GAS_TEMPERATURE.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetETCO2TimePeriod.INSTANCE) || sensorSetting instanceof SensorSetting.ETCO2TimePeriod) {
                by = SensorSettingIdentifier.CURRENT_ETCO2_TIME_PERIOD.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetNoBreathsDetectedTimeout.INSTANCE) || sensorSetting instanceof SensorSetting.NoBreathsDetectedTimeout) {
                by = SensorSettingIdentifier.NO_BREATHS_DETECTED.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetCurrentCO2Units.INSTANCE) || sensorSetting instanceof SensorSetting.CurrentCO2Units) {
                by = SensorSettingIdentifier.CURRENT_CO2_UNITS.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetSleepMode.INSTANCE) || sensorSetting instanceof SensorSetting.SleepMode) {
                by = SensorSettingIdentifier.SLEEP_MODE.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetZeroGasType.INSTANCE) || sensorSetting instanceof SensorSetting.ZeroGasType) {
                by = SensorSettingIdentifier.ZERO_GAS_TYPE.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetGasCompensations.INSTANCE) || sensorSetting instanceof SensorSetting.GasCompensations) {
                by = SensorSettingIdentifier.GAS_COMPENSATIONS.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetSensorPartNumber.INSTANCE) || sensorSetting instanceof SensorSetting.SensorPartNumber) {
                by = SensorSettingIdentifier.SENSOR_PART_NUMBER.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetOemId.INSTANCE) || sensorSetting instanceof SensorSetting.OemId) {
                by = SensorSettingIdentifier.OEM_ID.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetSerialNumber.INSTANCE) || sensorSetting instanceof SensorSetting.SerialNumber) {
                by = SensorSettingIdentifier.SENSOR_SERIAL_NUMBER.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetHardwareRevision.INSTANCE) || sensorSetting instanceof SensorSetting.HardwareRevision) {
                by = SensorSettingIdentifier.HARDWARE_REVISION.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetTotalUseTime.INSTANCE) || sensorSetting instanceof SensorSetting.TotalUseTime) {
                by = SensorSettingIdentifier.TOTAL_USE_TIME.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetLastZeroTime.INSTANCE) || sensorSetting instanceof SensorSetting.LastZeroTime) {
                by = SensorSettingIdentifier.LAST_ZERO_TIME.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetPumpTotalUseTime.INSTANCE) || sensorSetting instanceof SensorSetting.PumpTotalUseTime) {
                by = SensorSettingIdentifier.TOTAL_PUMP_USE_TIME.getByte();
            } else if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.GetPumpMaxUseTime.INSTANCE) || sensorSetting instanceof SensorSetting.PumpMaxUseTime) {
                by = SensorSettingIdentifier.MAX_PUMP_USE_TIME.getByte();
            } else if (sensorSetting instanceof SensorSetting.DisableSamplingPump) {
                by = SensorSettingIdentifier.DISABLE_SAMPLING_PUMP.getByte();
            } else {
                if (Intrinsics.areEqual((Object)sensorSetting, (Object)SensorSetting.Invalid.INSTANCE)) {
                    return null;
                }
                throw new NoWhenBranchMatchedException();
            }
            return by;
        }

        @Nullable
        public final RespironicsPacket deserializeMessage(@NotNull byte[] data, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!this.isValidPacket(data, offset, length)) {
                return null;
            }
            Ref.IntRef current = new Ref.IntRef();
            current.element = offset;
            return this.deserializeMessage((Function0<Byte>)((Function0)() -> Companion.deserializeMessage$lambda$0(current, offset, length, data)), (Function1<? super Integer, String>)((Function1)arg_0 -> Companion.deserializeMessage$lambda$2(data, current, arg_0)), (Function1<? super Integer, Unit>)((Function1)arg_0 -> Companion.deserializeMessage$lambda$3(length, current, offset, arg_0)));
        }

        public static /* synthetic */ RespironicsPacket deserializeMessage$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.deserializeMessage(byArray, n, n2);
        }

        @Nullable
        public final RespironicsPacket deserializeMessage(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!source.request(2L)) {
                return null;
            }
            return this.deserializeMessage((Function0<Byte>)((Function0)() -> Companion.deserializeMessage$lambda$4(source)), (Function1<? super Integer, String>)((Function1)arg_0 -> Companion.deserializeMessage$lambda$5(source, arg_0)), (Function1<? super Integer, Unit>)((Function1)arg_0 -> Companion.deserializeMessage$lambda$6(source, arg_0)));
        }

        @Nullable
        public final RespironicsPacket deserializeMessage(@NotNull Function0<Byte> next, @NotNull Function1<? super Integer, String> readString, @NotNull Function1<? super Integer, Unit> throwIfNotAvailable) {
            RespironicsPacket respironicsPacket;
            Intrinsics.checkNotNullParameter(next, (String)"next");
            Intrinsics.checkNotNullParameter(readString, (String)"readString");
            Intrinsics.checkNotNullParameter(throwIfNotAvailable, (String)"throwIfNotAvailable");
            byte cmd = ((Number)next.invoke()).byteValue();
            byte bytesToFollow = ((Number)next.invoke()).byteValue();
            throwIfNotAvailable.invoke((Object)bytesToFollow);
            byte by = cmd;
            if (by == -128) {
                byte sync = ((Number)next.invoke()).byteValue();
                int co2 = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt(next);
                float co2Value = (float)(co2 - 1000) / 100.0f;
                DataParameter dp = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$deserializeDataParameter(next, bytesToFollow, 4);
                respironicsPacket = new CO2Waveform(sync, co2Value, dp);
            } else if (by == -126) {
                byte zsb = ((Number)next.invoke()).byteValue();
                respironicsPacket = new CapnostatZero(RespironicsProtocolKt.access$toZeroStatus(zsb));
            } else if (by == -124) {
                byte isb = ((Number)next.invoke()).byteValue();
                SensorSettingIdentifier sensorSettingIdentifier = RespironicsProtocolKt.access$toSensorSettingIdentifier(isb);
                SensorSetting setting = switch (sensorSettingIdentifier == null ? -1 : WhenMappings.$EnumSwitchMapping$1[sensorSettingIdentifier.ordinal()]) {
                    case 1 -> SensorSetting.Invalid.INSTANCE;
                    case 2 -> {
                        int barometricPressure = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt(next);
                        yield new SensorSetting.BarometricPressure(barometricPressure);
                    }
                    case 3 -> {
                        float gasTemperature = (float)vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt(next) / 10.0f;
                        yield new SensorSetting.GasTemperature(gasTemperature);
                    }
                    case 4 -> {
                        byte db1;
                        byte $this$asInt$iv = db1 = ((Number)next.invoke()).byteValue();
                        boolean $i$f$asInt = false;
                        yield new SensorSetting.ETCO2TimePeriod($this$asInt$iv & 0xFF);
                    }
                    case 5 -> {
                        byte db1;
                        byte $this$asInt$iv = db1 = ((Number)next.invoke()).byteValue();
                        boolean $i$f$asInt = false;
                        yield new SensorSetting.NoBreathsDetectedTimeout($this$asInt$iv & 0xFF);
                    }
                    case 6 -> {
                        byte db1 = ((Number)next.invoke()).byteValue();
                        yield new SensorSetting.CurrentCO2Units(RespironicsProtocolKt.access$toCo2Unit(db1));
                    }
                    case 7 -> {
                        byte db1 = ((Number)next.invoke()).byteValue();
                        yield new SensorSetting.SleepMode(RespironicsProtocolKt.access$toSleepMode(db1));
                    }
                    case 8 -> {
                        byte db1 = ((Number)next.invoke()).byteValue();
                        yield new SensorSetting.ZeroGasType(RespironicsProtocolKt.access$toZeroGas(db1));
                    }
                    case 9 -> {
                        byte o2Compensation = ((Number)next.invoke()).byteValue();
                        BalanceGas balanceGas = RespironicsProtocolKt.access$toBalanceGas(((Number)next.invoke()).byteValue());
                        int value = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt(next);
                        float anestheticAgentX10 = (float)value / 10.0f;
                        yield new SensorSetting.GasCompensations(o2Compensation, balanceGas, anestheticAgentX10);
                    }
                    case 10 -> {
                        String partNumber = (String)readString.invoke((Object)10);
                        yield new SensorSetting.SensorPartNumber(partNumber);
                    }
                    case 11 -> {
                        byte id = ((Number)next.invoke()).byteValue();
                        yield new SensorSetting.OemId(id);
                    }
                    case 12 -> {
                        long serialNumber = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read5ByteLong(next);
                        yield new SensorSetting.SerialNumber(serialNumber);
                    }
                    case 13 -> {
                        String revision = (String)readString.invoke((Object)3);
                        yield new SensorSetting.HardwareRevision(revision);
                    }
                    case 14 -> {
                        long totalUseTime = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read5ByteLong(next);
                        yield new SensorSetting.TotalUseTime(totalUseTime);
                    }
                    case 15 -> {
                        long lastZeroTime = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read5ByteLong(next);
                        yield new SensorSetting.LastZeroTime(lastZeroTime);
                    }
                    case 16 -> {
                        long totalPumpUseTime = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read5ByteLong(next);
                        yield new SensorSetting.PumpTotalUseTime(totalPumpUseTime);
                    }
                    case 17 -> {
                        long maxPumpUseTime = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read5ByteLong(next);
                        yield new SensorSetting.PumpMaxUseTime(maxPumpUseTime);
                    }
                    case 18 -> {
                        boolean disabled = ((Number)next.invoke()).byteValue() == 1;
                        yield new SensorSetting.DisableSamplingPump(disabled);
                    }
                    case -1 -> SensorSetting.Invalid.INSTANCE;
                    default -> throw new NoWhenBranchMatchedException();
                };
                respironicsPacket = new GetSensorSettings(setting);
            } else if (by == -112) {
                byte sync = ((Number)next.invoke()).byteValue();
                int co2 = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt(next);
                float co2Value = (float)(co2 - 1000) / 100.0f;
                int o2 = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt(next);
                float o2Value = (float)(o2 - 1000) / 100.0f;
                DataParameter parameter = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$deserializeDataParameter(next, bytesToFollow, 6);
                respironicsPacket = new CO2O2Waveform(sync, co2Value, o2Value, parameter);
            } else if (by == -56) {
                respironicsPacket = new NackError(RespironicsProtocolKt.access$toNackError(((Number)next.invoke()).byteValue()));
            } else if (by == -55) {
                respironicsPacket = StopContinuousMode.INSTANCE;
            } else if (by == -54) {
                RevisionFormat revisionFormat = RespironicsProtocolKt.access$toRevisionFormat(((Number)next.invoke()).byteValue());
                String string = (String)readString.invoke((Object)(bytesToFollow - 2));
                respironicsPacket = new SoftwareRevision(revisionFormat, string);
            } else if (by == -53) {
                byte $this$asInt$iv = ((Number)next.invoke()).byteValue();
                boolean $i$f$asInt = false;
                int sci = $this$asInt$iv & 0xFF;
                byte caps2 = ((Number)next.invoke()).byteValue();
                List capsList = new ArrayList();
                if ((byte)(caps2 & 1) > 0) {
                    capsList.add(SensorCapabilityFlags.CO2Mainstream);
                }
                if ((byte)(caps2 & 2) > 0) {
                    capsList.add(SensorCapabilityFlags.CO2Sidestream);
                }
                if ((byte)(caps2 & 4) > 0) {
                    capsList.add(SensorCapabilityFlags.O2Mainstream);
                }
                switch (sci) {
                    case 0: {
                        respironicsPacket = new AvailableCapabilities(capsList);
                        break;
                    }
                    case 1: {
                        respironicsPacket = new CurrentCapabilities(capsList);
                        break;
                    }
                    case 2: {
                        respironicsPacket = new CurrentCapabilities(capsList);
                        break;
                    }
                    default: {
                        respironicsPacket = null;
                        break;
                    }
                }
            } else {
                respironicsPacket = by == -52 ? (RespironicsPacket)ResetNoBreathsDetected.INSTANCE : (by == -8 ? (RespironicsPacket)ResetCapnostat.INSTANCE : null);
            }
            RespironicsPacket packet = respironicsPacket;
            next.invoke();
            return packet;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int serializePacket(@NotNull RespironicsPacket packet, @NotNull byte[] dest, int offset, int limit) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Ref.IntRef current = new Ref.IntRef();
            RespironicsPacket respironicsPacket = packet;
            if (Intrinsics.areEqual((Object)respironicsPacket, (Object)StartCO2DataMode.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-128);
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)0);
            } else if (Intrinsics.areEqual((Object)respironicsPacket, (Object)StartCapnostatZero.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-126);
            } else if (respironicsPacket instanceof GetSensorSettings) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-124);
                Byte by = this.getSettingIsb(((GetSensorSettings)packet).getSettings());
                if (by == null) {
                    return 0;
                }
                isb = by;
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, isb);
            } else if (respironicsPacket instanceof SetSensorSettings) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-124);
                Byte by = this.getSettingIsb(((SetSensorSettings)packet).getSettings());
                if (by == null) {
                    return 0;
                }
                isb = by;
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, isb);
                SensorSetting sensorSetting = ((SetSensorSettings)packet).getSettings();
                if (sensorSetting instanceof SensorSetting.BarometricPressure) {
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write2ByteInt(current, offset, limit, dest, ((SensorSetting.BarometricPressure)((SetSensorSettings)packet).getSettings()).getPressureMmhg());
                } else if (sensorSetting instanceof SensorSetting.GasTemperature) {
                    int intValue = MathKt.roundToInt((float)(((SensorSetting.GasTemperature)((SetSensorSettings)packet).getSettings()).getTempCelsius() * (float)10));
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write2ByteInt(current, offset, limit, dest, intValue);
                } else if (sensorSetting instanceof SensorSetting.ETCO2TimePeriod) {
                    byte by2 = (byte)(((SensorSetting.ETCO2TimePeriod)((SetSensorSettings)packet).getSettings()).getPeriodSeconds() & 0x7F);
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, by2);
                } else if (sensorSetting instanceof SensorSetting.NoBreathsDetectedTimeout) {
                    byte by3 = (byte)(((SensorSetting.NoBreathsDetectedTimeout)((SetSensorSettings)packet).getSettings()).getTimeoutSeconds() & 0x7F);
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, by3);
                } else if (sensorSetting instanceof SensorSetting.CurrentCO2Units) {
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, ((SensorSetting.CurrentCO2Units)((SetSensorSettings)packet).getSettings()).getUnit().getByte());
                } else if (sensorSetting instanceof SensorSetting.SleepMode) {
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, ((SensorSetting.SleepMode)((SetSensorSettings)packet).getSettings()).getMode().getByte());
                } else if (sensorSetting instanceof SensorSetting.ZeroGasType) {
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, ((SensorSetting.ZeroGasType)((SetSensorSettings)packet).getSettings()).getGas().getByte());
                } else if (sensorSetting instanceof SensorSetting.GasCompensations) {
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, ((SensorSetting.GasCompensations)((SetSensorSettings)packet).getSettings()).getO2());
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, ((SensorSetting.GasCompensations)((SetSensorSettings)packet).getSettings()).getBalanceGas().getByte());
                    int anestheticAgent = MathKt.roundToInt((float)(((SensorSetting.GasCompensations)((SetSensorSettings)packet).getSettings()).getAnestheticAgent() * (float)10));
                    vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write2ByteInt(current, offset, limit, dest, anestheticAgent);
                } else {
                    if (!(sensorSetting instanceof SensorSetting.DisableSamplingPump)) return 0;
                    if (((SensorSetting.DisableSamplingPump)((SetSensorSettings)packet).getSettings()).getDisabled()) {
                        vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)1);
                    } else {
                        vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)0);
                    }
                }
            } else if (Intrinsics.areEqual((Object)respironicsPacket, (Object)StartCO2O2DataMode.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-112);
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)0);
            } else if (Intrinsics.areEqual((Object)respironicsPacket, (Object)StopContinuousMode.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-55);
            } else if (Intrinsics.areEqual((Object)respironicsPacket, (Object)GetAvailableCapabilities.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-53);
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)0);
            } else if (Intrinsics.areEqual((Object)respironicsPacket, (Object)GetCurrentCapabilities.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-53);
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)1);
            } else if (respironicsPacket instanceof CurrentCapabilities) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-53);
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)2);
                int flags = 0;
                for (SensorCapabilityFlags cap : ((CurrentCapabilities)packet).getCapabilities()) {
                    int mask = 1 << cap.getBit();
                    flags |= mask;
                }
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, (byte)flags);
            } else if (respironicsPacket instanceof GetSoftwareRevision) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-54);
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, ((GetSoftwareRevision)packet).getRevisionFormat().getByte());
            } else if (Intrinsics.areEqual((Object)respironicsPacket, (Object)ResetNoBreathsDetected.INSTANCE)) {
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-52);
            } else {
                if (!Intrinsics.areEqual((Object)respironicsPacket, (Object)ResetCapnostat.INSTANCE)) return 0;
                vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$writeCommand(current, offset, limit, dest, (byte)-8);
            }
            int nbf = current.element - offset - 1;
            if (nbf < 1) {
                return 0;
            }
            dest[offset + 1] = (byte)nbf;
            byte checksum = this.calculateChecksum(dest, offset, nbf + 1);
            vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, offset, limit, dest, checksum);
            return current.element - offset;
        }

        public static /* synthetic */ int serializePacket$default(Companion companion, RespironicsPacket respironicsPacket, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = byArray.length;
            }
            return companion.serializePacket(respironicsPacket, byArray, n, n2);
        }

        private static final byte deserializeMessage$lambda$0(Ref.IntRef $current, int $offset, int $length, byte[] $data) {
            if ($current.element - $offset > $length) {
                throw new IllegalStateException("trying to read out of bounds");
            }
            int n = $current.element;
            $current.element = n + 1;
            return $data[$offset + n];
        }

        private static final String deserializeMessage$lambda$2(byte[] $data, Ref.IntRef $current, int it) {
            String string;
            String it2 = string = _Utf8Kt.commonToUtf8String((byte[])$data, (int)$current.element, (int)($current.element + 10));
            boolean bl = false;
            $current.element += 10;
            return string;
        }

        private static final Unit deserializeMessage$lambda$3(int $length, Ref.IntRef $current, int $offset, int it) {
            if (it > $length - ($current.element - $offset) && $current.element - $offset > $length) {
                throw new IllegalStateException("not enough bytes to read");
            }
            return Unit.INSTANCE;
        }

        private static final byte deserializeMessage$lambda$4(BufferedSource $source) {
            return $source.readByte();
        }

        private static final String deserializeMessage$lambda$5(BufferedSource $source, int it) {
            return $source.readUtf8((long)it);
        }

        private static final Unit deserializeMessage$lambda$6(BufferedSource $source, int it) {
            $source.require((long)it);
            return Unit.INSTANCE;
        }

        private static final int deserializeMessage$read2ByteInt(Function0<Byte> $next) {
            byte db1 = ((Number)$next.invoke()).byteValue();
            byte db2 = ((Number)$next.invoke()).byteValue();
            byte $this$asInt$iv = db1;
            boolean $i$f$asInt = false;
            int n = ($this$asInt$iv & 0xFF) << 7;
            $this$asInt$iv = db2;
            $i$f$asInt = false;
            return n + ($this$asInt$iv & 0xFF);
        }

        private static final int deserializeMessage$read2ByteBitfield(Function0<Byte> $next) {
            byte db1 = ((Number)$next.invoke()).byteValue();
            byte db2 = ((Number)$next.invoke()).byteValue();
            byte $this$asInt$iv = db1;
            boolean $i$f$asInt = false;
            int n = ($this$asInt$iv & 0xFF) << 8;
            $this$asInt$iv = db2;
            $i$f$asInt = false;
            return n + ($this$asInt$iv & 0xFF);
        }

        private static final long deserializeMessage$read5ByteLong(Function0<Byte> $next) {
            byte db1 = ((Number)$next.invoke()).byteValue();
            byte db2 = ((Number)$next.invoke()).byteValue();
            byte db3 = ((Number)$next.invoke()).byteValue();
            byte db4 = ((Number)$next.invoke()).byteValue();
            byte db5 = ((Number)$next.invoke()).byteValue();
            return Companion.get5ByteInt(db1, db2, db3, db4, db5);
        }

        private static final long deserializeMessage$read5ByteBitField(Function0<Byte> $next) {
            byte db1 = ((Number)$next.invoke()).byteValue();
            byte db2 = ((Number)$next.invoke()).byteValue();
            byte db3 = ((Number)$next.invoke()).byteValue();
            byte db4 = ((Number)$next.invoke()).byteValue();
            byte db5 = ((Number)$next.invoke()).byteValue();
            byte $this$asInt$iv = db1;
            boolean $i$f$asInt = false;
            long l = ($this$asInt$iv & 0xFF) << 32;
            $this$asInt$iv = db2;
            $i$f$asInt = false;
            long l2 = l + (long)(($this$asInt$iv & 0xFF) << 24);
            $this$asInt$iv = db3;
            $i$f$asInt = false;
            long l3 = l2 + (long)(($this$asInt$iv & 0xFF) << 16);
            $this$asInt$iv = db4;
            $i$f$asInt = false;
            long l4 = l3 + (long)(($this$asInt$iv & 0xFF) << 8);
            $this$asInt$iv = db5;
            $i$f$asInt = false;
            return l4 + (long)($this$asInt$iv & 0xFF);
        }

        private static final DataParameter deserializeMessage$deserializeDataParameter(Function0<Byte> $next, byte bytesToFollow, int threshold) {
            DataParameter dataParameter;
            block13: {
                block12: {
                    if (bytesToFollow <= threshold) break block12;
                    byte dpi = ((Number)$next.invoke()).byteValue();
                    DataParameterIndex dataParameterIndex = DataParameterIndex.Companion.fromByteOrNull(dpi);
                    switch (dataParameterIndex == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dataParameterIndex.ordinal()]) {
                        case 1: {
                            long rawValue = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read5ByteBitField($next);
                            dataParameter = CO2Status.Companion.fromStatusBitfield-Fy-wJmU(CO2StatusError.constructor-impl(rawValue));
                            break block13;
                        }
                        case 2: {
                            dataParameter = new ETCO2(vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt($next));
                            break block13;
                        }
                        case 3: {
                            int rr = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt($next);
                            dataParameter = new RespirationRate(rr);
                            break block13;
                        }
                        case 4: {
                            int inspiredCO2 = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt($next);
                            dataParameter = new InspiredCO2(inspiredCO2);
                            break block13;
                        }
                        case 5: {
                            dataParameter = BreathDetected.INSTANCE;
                            break block13;
                        }
                        case 6: {
                            dataParameter = new HardwareStatus(HardwareStatusFlags.constructor-impl(vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteBitfield($next)), null);
                            break block13;
                        }
                        case 7: {
                            dataParameter = new O2Status(O2StatusError.constructor-impl(vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteBitfield($next)), null);
                            break block13;
                        }
                        case 8: {
                            int fio2 = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt($next);
                            dataParameter = new FiO2(fio2);
                            break block13;
                        }
                        case 9: {
                            int feo2 = vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.deserializeMessage$read2ByteInt($next);
                            dataParameter = new FeO2(feo2);
                            break block13;
                        }
                        case -1: {
                            dataParameter = null;
                            break block13;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                dataParameter = null;
            }
            return dataParameter;
        }

        private static final void serializePacket$writeCommand(Ref.IntRef current, int $offset, int $limit, byte[] $dest, byte by) {
            if (current.element > $offset + $limit) {
                throw new IllegalStateException("writing would go beyond limit");
            }
            $dest[$offset] = by;
            current.element = $offset + 2;
        }

        private static final void serializePacket$write(Ref.IntRef current, int $offset, int $limit, byte[] $dest, byte by) {
            if (current.element > $offset + $limit) {
                throw new IllegalStateException("writing would go beyond limit");
            }
            int n = current.element;
            current.element = n + 1;
            $dest[$offset + n] = by;
        }

        private static final void serializePacket$write2ByteInt(Ref.IntRef current, int $offset, int $limit, byte[] $dest, int value) {
            byte db1 = (byte)(value >> 7 & 0x7F);
            byte db2 = (byte)(value & 0x7F);
            vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, $offset, $limit, $dest, db1);
            vet.inpulse.libcomm.core.protocol.capno.RespironicsProtocol$Companion.serializePacket$write(current, $offset, $limit, $dest, db2);
        }

        private static final void serializePacket$skip(Ref.IntRef current, int $offset, int $limit, int n) {
            if (current.element + n > $offset + $limit) {
                throw new IllegalStateException("writing would go beyond limit");
            }
            ++current.element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[DataParameterIndex.values().length];
                try {
                    nArray[DataParameterIndex.CO2_STATUS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.ETCO2_X10.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.RESPIRATION_RATE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.INSPIRED_CO2_X10.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.BREATH_DETECTED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.HARDWARE_STATUS.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.O2_STATUS.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.FiO2.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataParameterIndex.FeO2.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[SensorSettingIdentifier.values().length];
                try {
                    nArray[SensorSettingIdentifier.INVALID.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.BAROMETRIC_PRESSURE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.GAS_TEMPERATURE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.CURRENT_ETCO2_TIME_PERIOD.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.NO_BREATHS_DETECTED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.CURRENT_CO2_UNITS.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.SLEEP_MODE.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.ZERO_GAS_TYPE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.GAS_COMPENSATIONS.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.SENSOR_PART_NUMBER.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.OEM_ID.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.SENSOR_SERIAL_NUMBER.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.HARDWARE_REVISION.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.TOTAL_USE_TIME.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.LAST_ZERO_TIME.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.TOTAL_PUMP_USE_TIME.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.MAX_PUMP_USE_TIME.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SensorSettingIdentifier.DISABLE_SAMPLING_PUMP.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

