/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.capno;

import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.protocol.capno.O2AdapterZeroStatus;
import vet.inpulse.libcomm.core.protocol.capno.O2SignalStrength;
import vet.inpulse.libcomm.core.protocol.capno.O2SystemZeroStatus;
import vet.inpulse.libcomm.core.protocol.capno.O2TemperatureStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u00a8\u0006#"}, d2={"Lvet/inpulse/libcomm/core/protocol/capno/O2StatusError;", "", "bitfield", "", "constructor-impl", "(I)I", "getByteN", "byteN", "getByteN-impl", "(II)I", "o2SensorNotReadyToZero", "", "o2SensorNotReadyToZero-impl", "(I)Z", "o2SignalStrength", "Lvet/inpulse/libcomm/core/protocol/capno/O2SignalStrength;", "o2SignalStrength-impl", "(I)Lvet/inpulse/libcomm/core/protocol/capno/O2SignalStrength;", "o2AdapterZeroStatus", "Lvet/inpulse/libcomm/core/protocol/capno/O2AdapterZeroStatus;", "o2AdapterZeroStatus-impl", "(I)Lvet/inpulse/libcomm/core/protocol/capno/O2AdapterZeroStatus;", "o2SystemZeroStatus", "Lvet/inpulse/libcomm/core/protocol/capno/O2SystemZeroStatus;", "o2SystemZeroStatus-impl", "(I)Lvet/inpulse/libcomm/core/protocol/capno/O2SystemZeroStatus;", "o2TemperatureStatus", "Lvet/inpulse/libcomm/core/protocol/capno/O2TemperatureStatus;", "o2TemperatureStatus-impl", "(I)Lvet/inpulse/libcomm/core/protocol/capno/O2TemperatureStatus;", "equals", "other", "hashCode", "toString", "", "libcomm"})
public final class O2StatusError {
    private final int bitfield;

    private static final int getByteN-impl(int arg0, int byteN) {
        int shift = (2 - byteN) * 8;
        int mask = 255 << shift;
        return (arg0 & mask) >> shift;
    }

    public static final boolean o2SensorNotReadyToZero-impl(int arg0) {
        return (O2StatusError.getByteN-impl(arg0, 1) & 0x40) > 0;
    }

    @NotNull
    public static final O2SignalStrength o2SignalStrength-impl(int arg0) {
        int value = O2StatusError.getByteN-impl(arg0, 1);
        int srcCurrent = (value & 0x30) >> 4;
        return switch (srcCurrent) {
            case 0 -> O2SignalStrength.Normal;
            case 1 -> O2SignalStrength.LowSignal;
            case 2 -> O2SignalStrength.SignalFailure;
            case 3 -> O2SignalStrength.NoAdapterPresent;
            default -> O2SignalStrength.Normal;
        };
    }

    @NotNull
    public static final O2AdapterZeroStatus o2AdapterZeroStatus-impl(int arg0) {
        int value = O2StatusError.getByteN-impl(arg0, 1);
        int o2val = (value & 0xC) >> 2;
        return switch (o2val) {
            case 0 -> O2AdapterZeroStatus.NoO2ZeroInProgress;
            case 1 -> O2AdapterZeroStatus.O2ZeroInProgress;
            case 2 -> O2AdapterZeroStatus.O2ZeroRequired;
            case 3 -> O2AdapterZeroStatus.O2ZeroError;
            default -> O2AdapterZeroStatus.NoO2ZeroInProgress;
        };
    }

    @NotNull
    public static final O2SystemZeroStatus o2SystemZeroStatus-impl(int arg0) {
        int value = O2StatusError.getByteN-impl(arg0, 1);
        int o2Val = value & 3;
        return switch (o2Val) {
            case 0 -> O2SystemZeroStatus.NoO2SystemZeroInProgress;
            case 1 -> O2SystemZeroStatus.O2SystemZeroInProgress;
            case 2 -> O2SystemZeroStatus.O2SystemZeroRequired;
            case 3 -> O2SystemZeroStatus.O2SystemZeroError;
            default -> O2SystemZeroStatus.NoO2SystemZeroInProgress;
        };
    }

    @NotNull
    public static final O2TemperatureStatus o2TemperatureStatus-impl(int arg0) {
        int value = O2StatusError.getByteN-impl(arg0, 2);
        int tempVal = (value & 0x60) >> 5;
        return switch (tempVal) {
            case 0 -> O2TemperatureStatus.StableAtOperationTemperature;
            case 1 -> O2TemperatureStatus.BelowOperationTemperature;
            case 2 -> O2TemperatureStatus.AboveOperationTemperature;
            case 3 -> O2TemperatureStatus.TemperatureUnstable;
            default -> O2TemperatureStatus.StableAtOperationTemperature;
        };
    }

    public static String toString-impl(int arg0) {
        return "O2StatusError(bitfield=" + arg0 + ")";
    }

    public String toString() {
        return O2StatusError.toString-impl(this.bitfield);
    }

    public static int hashCode-impl(int arg0) {
        return Integer.hashCode(arg0);
    }

    public int hashCode() {
        return O2StatusError.hashCode-impl(this.bitfield);
    }

    public static boolean equals-impl(int arg0, Object other) {
        if (!(other instanceof O2StatusError)) {
            return false;
        }
        int n = ((O2StatusError)other).unbox-impl();
        return arg0 == n;
    }

    public boolean equals(Object other) {
        return O2StatusError.equals-impl(this.bitfield, other);
    }

    private /* synthetic */ O2StatusError(int bitfield) {
        this.bitfield = bitfield;
    }

    public static int constructor-impl(int bitfield) {
        return bitfield;
    }

    public static final /* synthetic */ O2StatusError box-impl(int v) {
        return new O2StatusError(v);
    }

    public final /* synthetic */ int unbox-impl() {
        return this.bitfield;
    }

    public static final boolean equals-impl0(int p1, int p2) {
        return p1 == p2;
    }
}

