/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol.capno;

import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.protocol.capno.CalibrationStatus;
import vet.inpulse.libcomm.core.protocol.capno.PrioritizedCO2StatusError;
import vet.inpulse.libcomm.core.protocol.capno.SourceCurrent;
import vet.inpulse.libcomm.core.protocol.capno.TemperatureStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0010J\r\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0010J\r\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0016\u0010\u0010J\r\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0018\u0010\u0010J\r\u0010\u0019\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u0010J\r\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001c\u0010\u0010J\r\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u000e\u00a2\u0006\u0004\b\"\u0010\u0010J\r\u0010#\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\u000e\u00a2\u0006\u0004\b,\u0010\u0010J\r\u0010-\u001a\u00020\u000e\u00a2\u0006\u0004\b.\u0010\u0010J\r\u0010/\u001a\u00020\u000e\u00a2\u0006\u0004\b0\u0010\u0010J\r\u00101\u001a\u00020\u000e\u00a2\u0006\u0004\b2\u0010\u0010J\r\u00103\u001a\u00020\u000e\u00a2\u0006\u0004\b4\u0010\u0010J\r\u00105\u001a\u00020\u000e\u00a2\u0006\u0004\b6\u0010\u0010J\r\u00107\u001a\u000208\u00a2\u0006\u0004\b9\u0010:J\u0013\u0010;\u001a\u00020\u000e2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010=\u001a\u00020\tH\u00d6\u0001J\t\u0010>\u001a\u00020?H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006@"}, d2={"Lvet/inpulse/libcomm/core/protocol/capno/CO2StatusError;", "", "bitfield", "", "constructor-impl", "(J)J", "getBitfield", "()J", "getByteN", "", "byteN", "getByteN-impl", "(JI)I", "co2NoBreathsDetected", "", "co2NoBreathsDetected-impl", "(J)Z", "inSleepMode", "inSleepMode-impl", "co2SensorNotReadyToZero", "co2SensorNotReadyToZero-impl", "co2OutOfRange", "co2OutOfRange-impl", "breathsDetected", "breathsDetected-impl", "checkAdapter", "checkAdapter-impl", "negativeCo2Error", "negativeCo2Error-impl", "sourceCurrent", "Lvet/inpulse/libcomm/core/protocol/capno/SourceCurrent;", "sourceCurrent-impl", "(J)Lvet/inpulse/libcomm/core/protocol/capno/SourceCurrent;", "compensationNotYetSet", "compensationNotYetSet-impl", "calibrationStatus", "Lvet/inpulse/libcomm/core/protocol/capno/CalibrationStatus;", "calibrationStatus-impl", "(J)Lvet/inpulse/libcomm/core/protocol/capno/CalibrationStatus;", "temperatureStatus", "Lvet/inpulse/libcomm/core/protocol/capno/TemperatureStatus;", "temperatureStatus-impl", "(J)Lvet/inpulse/libcomm/core/protocol/capno/TemperatureStatus;", "eepromChecksumFaulty", "eepromChecksumFaulty-impl", "hardwareError", "hardwareError-impl", "pumpOff", "pumpOff-impl", "pneumaticSystemError", "pneumaticSystemError-impl", "pumpLifeExceeded", "pumpLifeExceeded-impl", "sidestreamAdapterNotDetected", "sidestreamAdapterNotDetected-impl", "prioritizedCO2StatusError", "Lvet/inpulse/libcomm/core/protocol/capno/PrioritizedCO2StatusError;", "prioritizedCO2StatusError-impl", "(J)Lvet/inpulse/libcomm/core/protocol/capno/PrioritizedCO2StatusError;", "equals", "other", "hashCode", "toString", "", "libcomm"})
public final class CO2StatusError {
    private final long bitfield;

    public final long getBitfield() {
        return this.bitfield;
    }

    public static final int getByteN-impl(long arg0, int byteN) {
        int shift = (4 - byteN) * 8;
        long mask = 255L << shift;
        long l = (arg0 & mask) >> shift;
        return (int)l;
    }

    public static final boolean co2NoBreathsDetected-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 0x40) > 0;
    }

    public static final boolean inSleepMode-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 0x20) > 0;
    }

    public static final boolean co2SensorNotReadyToZero-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 0x10) > 0;
    }

    public static final boolean co2OutOfRange-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 8) > 0;
    }

    public static final boolean breathsDetected-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 4) > 0;
    }

    public static final boolean checkAdapter-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 2) > 0;
    }

    public static final boolean negativeCo2Error-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 1) & 1) > 0;
    }

    @NotNull
    public static final SourceCurrent sourceCurrent-impl(long arg0) {
        int value = CO2StatusError.getByteN-impl(arg0, 2);
        int srcCurrent = (value & 0x60) >> 5;
        return switch (srcCurrent) {
            case 0 -> SourceCurrent.Normal;
            case 1 -> SourceCurrent.WaitingForStabilization;
            case 2 -> SourceCurrent.CurrentDrift;
            case 3 -> SourceCurrent.CurrentLimitError;
            default -> SourceCurrent.Normal;
        };
    }

    public static final boolean compensationNotYetSet-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 2) & 0x10) > 0;
    }

    @NotNull
    public static final CalibrationStatus calibrationStatus-impl(long arg0) {
        int value = CO2StatusError.getByteN-impl(arg0, 2);
        int srcCurrent = (value & 0xC) >> 2;
        return switch (srcCurrent) {
            case 0 -> CalibrationStatus.NoZeroInProgress;
            case 1 -> CalibrationStatus.ZeroInProgress;
            case 2 -> CalibrationStatus.ZeroRequired;
            case 3 -> CalibrationStatus.ZeroRequiredZeroError;
            default -> CalibrationStatus.NoZeroInProgress;
        };
    }

    @NotNull
    public static final TemperatureStatus temperatureStatus-impl(long arg0) {
        int value = CO2StatusError.getByteN-impl(arg0, 2);
        int srcCurrent = value & 3;
        return switch (srcCurrent) {
            case 0 -> TemperatureStatus.StableAtOperationTemperature;
            case 1 -> TemperatureStatus.BelowOperationTemperature;
            case 2 -> TemperatureStatus.AboveOperationTemperature;
            case 3 -> TemperatureStatus.TemperatureUnstable;
            default -> TemperatureStatus.StableAtOperationTemperature;
        };
    }

    public static final boolean eepromChecksumFaulty-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 3) & 0x40) > 0;
    }

    public static final boolean hardwareError-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 3) & 0x20) > 0;
    }

    public static final boolean pumpOff-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 4) & 8) > 0;
    }

    public static final boolean pneumaticSystemError-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 4) & 4) > 0;
    }

    public static final boolean pumpLifeExceeded-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 4) & 2) > 0;
    }

    public static final boolean sidestreamAdapterNotDetected-impl(long arg0) {
        return (CO2StatusError.getByteN-impl(arg0, 4) & 1) > 0;
    }

    @NotNull
    public static final PrioritizedCO2StatusError prioritizedCO2StatusError-impl(long arg0) {
        int byteN = CO2StatusError.getByteN-impl(arg0, 0);
        return switch (byteN) {
            case 1 -> PrioritizedCO2StatusError.SensorOverTemp;
            case 2 -> PrioritizedCO2StatusError.SensorFaulty;
            case 3 -> PrioritizedCO2StatusError.NoMessage;
            case 4 -> PrioritizedCO2StatusError.SleepMode;
            case 5 -> PrioritizedCO2StatusError.ZeroInProgress;
            case 6 -> PrioritizedCO2StatusError.SensorWarmUp;
            case 10 -> PrioritizedCO2StatusError.CheckSamplingLine;
            case 7 -> PrioritizedCO2StatusError.ZeroRequired;
            case 8 -> PrioritizedCO2StatusError.CO2OutOfRange;
            case 9 -> PrioritizedCO2StatusError.CheckAirwayAdapter;
            default -> PrioritizedCO2StatusError.None;
        };
    }

    public static String toString-impl(long arg0) {
        return "CO2StatusError(bitfield=" + arg0 + ")";
    }

    public String toString() {
        return CO2StatusError.toString-impl(this.bitfield);
    }

    public static int hashCode-impl(long arg0) {
        return Long.hashCode(arg0);
    }

    public int hashCode() {
        return CO2StatusError.hashCode-impl(this.bitfield);
    }

    public static boolean equals-impl(long arg0, Object other) {
        if (!(other instanceof CO2StatusError)) {
            return false;
        }
        long l = ((CO2StatusError)other).unbox-impl();
        return arg0 == l;
    }

    public boolean equals(Object other) {
        return CO2StatusError.equals-impl(this.bitfield, other);
    }

    private /* synthetic */ CO2StatusError(long bitfield) {
        this.bitfield = bitfield;
    }

    public static long constructor-impl(long bitfield) {
        return bitfield;
    }

    public static final /* synthetic */ CO2StatusError box-impl(long v) {
        return new CO2StatusError(v);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.bitfield;
    }

    public static final boolean equals-impl0(long p1, long p2) {
        return p1 == p2;
    }
}

