/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol;

import java.io.EOFException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.BatteryCharge;
import vet.inpulse.libcomm.core.protocol.message.Connect;
import vet.inpulse.libcomm.core.protocol.message.ConnectBt;
import vet.inpulse.libcomm.core.protocol.message.ConnectUsb;
import vet.inpulse.libcomm.core.protocol.message.Connected;
import vet.inpulse.libcomm.core.protocol.message.Disconnect;
import vet.inpulse.libcomm.core.protocol.message.ExtendedMyInfo;
import vet.inpulse.libcomm.core.protocol.message.ExtendedMyInfoDeserializer;
import vet.inpulse.libcomm.core.protocol.message.FirmwareVersion;
import vet.inpulse.libcomm.core.protocol.message.GetFirmwareVersion;
import vet.inpulse.libcomm.core.protocol.message.GetInfo;
import vet.inpulse.libcomm.core.protocol.message.GetMac;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.MessageType;
import vet.inpulse.libcomm.core.protocol.message.MyInfo;
import vet.inpulse.libcomm.core.protocol.message.MyMac;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.UnknownMessage;
import vet.inpulse.libcomm.core.protocol.payloadSerializer.impl.MyInfoSerializer;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lvet/inpulse/libcomm/core/protocol/UnknownDeviceProtocol;", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "<init>", "()V", "TAG", "", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "serialize", "", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "sink", "Lokio/BufferedSink;", "deserialize", "Lkotlin/Result;", "source", "Lokio/BufferedSource;", "deserialize-IoAF18A", "(Lokio/BufferedSource;)Ljava/lang/Object;", "mapMessageTypeToByte", "", "type", "Lvet/inpulse/libcomm/core/protocol/message/MessageType;", "(Lvet/inpulse/libcomm/core/protocol/message/MessageType;)Ljava/lang/Byte;", "libcomm"})
public final class UnknownDeviceProtocol
extends Protocol {
    @NotNull
    public static final UnknownDeviceProtocol INSTANCE = new UnknownDeviceProtocol();
    @NotNull
    private static final String TAG = "UnknownDeviceProtocol";
    @NotNull
    private static final LoggerInterface logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(INSTANCE.getClass()));

    private UnknownDeviceProtocol() {
    }

    @Override
    public void serialize(@NotNull Message message2, @NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int n = this.byteForType(message2.getType());
        if (n == 255) {
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
        sink.writeByte(n);
        Message message3 = message2;
        if (message3 instanceof Ack) {
            sink.writeByte(this.byteForType(((Ack)message2).getAckedMessage()));
        } else if (message3 instanceof Nack) {
            sink.writeByte(this.byteForType(((Nack)message2).getNackedMessage()));
        } else if (message3 instanceof MyInfo) {
            MyInfoSerializer.INSTANCE.serializePayload(sink, (MyInfo)message2);
            ExtendedMyInfoDeserializer.INSTANCE.serialize(sink, ExtendedMyInfo.Companion.fromMyInfo((MyInfo)message2));
        } else if (message3 instanceof MyMac) {
            sink.writeUtf8(((MyMac)message2).getMacAddress().toString());
        } else if (message3 instanceof FirmwareVersion) {
            sink.writeByte(0);
            sink.writeByte((int)((FirmwareVersion)message2).getHardwareByte());
            sink.writeByte(((FirmwareVersion)message2).getFirmwareVersion());
        } else if (message3 instanceof Connected) {
            Integer n2 = ((Connected)message2).getLegacyProtocolVersion();
            sink.writeByte(n2 != null ? n2 : 0);
        } else if (!(Intrinsics.areEqual((Object)message3, (Object)Connect.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)ConnectBt.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)ConnectUsb.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)Disconnect.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetFirmwareVersion.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetInfo.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetMac.INSTANCE))) {
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public Object deserialize-IoAF18A(@NotNull BufferedSource source) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            byte cmdByte = source.readByte();
            Message msg = switch (WhenMappings.$EnumSwitchMapping$0[this.typeForByte(cmdByte).ordinal()]) {
                case 1 -> {
                    byte acked = source.readByte();
                    yield new Ack(this.typeForByte(acked));
                }
                case 2 -> {
                    byte nacked = source.readByte();
                    yield new Nack(this.typeForByte(nacked));
                }
                case 3 -> ConnectUsb.INSTANCE;
                case 4 -> ConnectBt.INSTANCE;
                case 5 -> {
                    byte protocolVersion = source.readByte();
                    yield new Connected(Integer.valueOf(protocolVersion));
                }
                case 6 -> Disconnect.INSTANCE;
                case 7 -> GetInfo.INSTANCE;
                case 8 -> MyInfoSerializer.INSTANCE.deserializePayload(source);
                case 9 -> GetMac.INSTANCE;
                case 10 -> {
                    RemoteAddress macAddress = this.readMacAddressString(source);
                    yield new MyMac(macAddress);
                }
                case 11 -> GetFirmwareVersion.INSTANCE;
                case 12 -> {
                    source.readByte();
                    yield new FirmwareVersion(source.readByte(), source.readByte());
                }
                case 13 -> new BatteryCharge(-1);
                default -> {
                    logger.v(() -> UnknownDeviceProtocol.deserialize_IoAF18A$lambda$0(cmdByte));
                    yield new UnknownMessage(cmdByte);
                }
            };
            object = Result.constructor-impl((Object)msg);
        }
        catch (Exception e) {
            if (e instanceof EOFException) {
                throw e;
            }
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e));
        }
        return object;
    }

    @Override
    @NotNull
    public Byte mapMessageTypeToByte(@NotNull MessageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return (byte)(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 16;
            case 4 -> 17;
            case 5 -> 18;
            case 6 -> 20;
            case 7 -> 21;
            case 8 -> 22;
            case 9 -> 48;
            case 10 -> 49;
            case 11 -> 161;
            case 12 -> 162;
            case 13 -> 51;
            default -> 255;
        });
    }

    private static final String deserialize_IoAF18A$lambda$0(byte $cmdByte) {
        return "Received a message not known by this protocol: " + $cmdByte;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Ack.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Nack.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ConnectUsb.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ConnectBt.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Connected.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Disconnect.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetInfo.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyInfo.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetMac.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyMac.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetFirmwareVersion.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.FirmwareVersion.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.BatteryCharge.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

