/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.protocol;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.data.EcgLeadOff;
import vet.inpulse.libcomm.core.device.data.converters.EcgLeadOffConvertersKt;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.AskConfirm;
import vet.inpulse.libcomm.core.protocol.message.BatteryCharge;
import vet.inpulse.libcomm.core.protocol.message.BatteryDuration;
import vet.inpulse.libcomm.core.protocol.message.BatteryTemperature;
import vet.inpulse.libcomm.core.protocol.message.Connect;
import vet.inpulse.libcomm.core.protocol.message.ConnectBt;
import vet.inpulse.libcomm.core.protocol.message.ConnectUsb;
import vet.inpulse.libcomm.core.protocol.message.Connected;
import vet.inpulse.libcomm.core.protocol.message.Disconnect;
import vet.inpulse.libcomm.core.protocol.message.EcgDataMessage;
import vet.inpulse.libcomm.core.protocol.message.EcgGain;
import vet.inpulse.libcomm.core.protocol.message.EcgModuleSample;
import vet.inpulse.libcomm.core.protocol.message.FirmwareVersion;
import vet.inpulse.libcomm.core.protocol.message.GetBatteryCharge;
import vet.inpulse.libcomm.core.protocol.message.GetBatteryDuration;
import vet.inpulse.libcomm.core.protocol.message.GetBatteryInfo;
import vet.inpulse.libcomm.core.protocol.message.GetBatteryTemperature;
import vet.inpulse.libcomm.core.protocol.message.GetFirmwareVersion;
import vet.inpulse.libcomm.core.protocol.message.GetInfo;
import vet.inpulse.libcomm.core.protocol.message.GetLeadsOff;
import vet.inpulse.libcomm.core.protocol.message.GetMac;
import vet.inpulse.libcomm.core.protocol.message.GoToBootloader;
import vet.inpulse.libcomm.core.protocol.message.LeadOffMessage;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.MessageType;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.MyInfo;
import vet.inpulse.libcomm.core.protocol.message.MyMac;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.PpgGetDiagnosis;
import vet.inpulse.libcomm.core.protocol.message.PrepareSendEcg;
import vet.inpulse.libcomm.core.protocol.message.ReadySendEcg;
import vet.inpulse.libcomm.core.protocol.message.SetChannelsOn;
import vet.inpulse.libcomm.core.protocol.message.SetEcgGain;
import vet.inpulse.libcomm.core.protocol.message.SetMac;
import vet.inpulse.libcomm.core.protocol.message.StartAcquisition;
import vet.inpulse.libcomm.core.protocol.message.StopAcquisition;
import vet.inpulse.libcomm.core.protocol.message.YesConfirm;
import vet.inpulse.libcomm.core.protocol.payloadSerializer.impl.MyInfoSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lvet/inpulse/libcomm/core/protocol/InCardioProtocol;", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "samplesPerPacket", "", "channelsPerSample", "<init>", "(II)V", "serialize", "", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "sink", "Lokio/BufferedSink;", "deserialize", "Lkotlin/Result;", "source", "Lokio/BufferedSource;", "deserialize-IoAF18A", "(Lokio/BufferedSource;)Ljava/lang/Object;", "mapMessageTypeToByte", "", "type", "Lvet/inpulse/libcomm/core/protocol/message/MessageType;", "(Lvet/inpulse/libcomm/core/protocol/message/MessageType;)Ljava/lang/Byte;", "Companion", "libcomm"})
@SourceDebugExtension(value={"SMAP\nInCardioProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InCardioProtocol.kt\nvet/inpulse/libcomm/core/protocol/InCardioProtocol\n+ 2 SourceByteUtils.kt\nvet/inpulse/libcomm/core/util/SourceByteUtilsKt\n*L\n1#1,285:1\n43#2,7:286\n43#2,7:293\n19#2:300\n11#2,12:301\n19#2:313\n11#2,12:314\n*S KotlinDebug\n*F\n+ 1 InCardioProtocol.kt\nvet/inpulse/libcomm/core/protocol/InCardioProtocol\n*L\n108#1:286,7\n113#1:293,7\n206#1:300\n206#1:301,12\n211#1:313\n211#1:314,12\n*E\n"})
public final class InCardioProtocol
extends Protocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int samplesPerPacket;
    private final int channelsPerSample;
    @NotNull
    private static final String TAG = "InCardioProtocol";

    public InCardioProtocol(int samplesPerPacket, int channelsPerSample) {
        this.samplesPerPacket = samplesPerPacket;
        this.channelsPerSample = channelsPerSample;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(@NotNull Message message2, @NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int n = this.byteForType(message2.getType());
        if (n == 255) {
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
        sink.writeByte(n);
        Message message3 = message2;
        if (message3 instanceof Ack) {
            sink.writeByte(this.byteForType(((Ack)message2).getAckedMessage()));
        } else if (message3 instanceof Nack) {
            sink.writeByte(this.byteForType(((Nack)message2).getNackedMessage()));
        } else if (message3 instanceof BatteryCharge) {
            sink.writeByte(((BatteryCharge)message2).getCharge());
        } else if (message3 instanceof BatteryDuration) {
            sink.writeShort(((BatteryDuration)message2).getDuration());
        } else if (message3 instanceof BatteryTemperature) {
            sink.writeShort(((BatteryTemperature)message2).getTempKelvinTimes10());
        } else if (message3 instanceof MyInfo) {
            MyInfoSerializer.INSTANCE.serializePayload(sink, (MyInfo)message2);
        } else if (message3 instanceof MyMac) {
            sink.writeUtf8(((MyMac)message2).getMacAddress().toString());
        } else if (message3 instanceof FirmwareVersion) {
            sink.writeByte(0);
            sink.writeByte((int)((FirmwareVersion)message2).getHardwareByte());
            sink.writeByte(((FirmwareVersion)message2).getFirmwareVersion());
        } else if (message3 instanceof LeadOffMessage) {
            EcgLeadOffConvertersKt.toInCardioLeadOff-WTP-F3M(((LeadOffMessage)message2).getLeadOff-any4o4A(), sink);
        } else if (message3 instanceof SetMac) {
            sink.writeUtf8(((SetMac)message2).getMacAddress().toString());
        } else if (message3 instanceof SetEcgGain) {
            sink.writeByte(((SetEcgGain)message2).getEcgGain().getGainValue());
            sink.writeByte(255);
        } else if (message3 instanceof SetChannelsOn) {
            sink.writeByte((int)((SetChannelsOn)message2).getMask());
        } else if (message3 instanceof EcgDataMessage) {
            void $this$write24BitInt$iv;
            int packetId = ((EcgDataMessage)message2).getData().getSampleIdOfFirst() / ((EcgDataMessage)message2).getData().getSamples().size();
            BufferedSink bufferedSink = sink;
            int i$iv = packetId;
            boolean $i$f$write24BitInt = false;
            int a$iv = (i$iv & 0xFF0000) >> 16;
            int b$iv = (i$iv & 0xFF00) >> 8;
            int c$iv = i$iv & 0xFF;
            $this$write24BitInt$iv.writeByte(a$iv);
            $this$write24BitInt$iv.writeByte(b$iv);
            $this$write24BitInt$iv.writeByte(c$iv);
            i$iv = ((Collection)((EcgDataMessage)message2).getData().getSamples()).size();
            for (int i = 0; i < i$iv; ++i) {
                EcgModuleSample s = ((EcgDataMessage)message2).getData().getSamples().get(i);
                int n2 = s.getChannels().length;
                for (int j = 0; j < n2; ++j) {
                    void $this$write24BitInt$iv2;
                    int toWrite = s.getChannels()[j];
                    BufferedSink bufferedSink2 = sink;
                    int i$iv2 = toWrite;
                    boolean $i$f$write24BitInt2 = false;
                    int a$iv2 = (i$iv2 & 0xFF0000) >> 16;
                    int b$iv2 = (i$iv2 & 0xFF00) >> 8;
                    int c$iv2 = i$iv2 & 0xFF;
                    $this$write24BitInt$iv2.writeByte(a$iv2);
                    $this$write24BitInt$iv2.writeByte(b$iv2);
                    $this$write24BitInt$iv2.writeByte(c$iv2);
                }
            }
        } else if (message3 instanceof Connected) {
            Integer n3 = ((Connected)message2).getLegacyProtocolVersion();
            if (n3 != null) {
                int it = ((Number)n3).intValue();
                boolean bl = false;
                sink.writeByte(it);
            }
        } else if (!(message3 instanceof StartAcquisition || message3 instanceof StopAcquisition || Intrinsics.areEqual((Object)message3, (Object)PrepareSendEcg.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)ReadySendEcg.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)AskConfirm.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)Connect.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)ConnectBt.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)ConnectUsb.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)Disconnect.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)YesConfirm.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetBatteryCharge.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetBatteryDuration.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetBatteryTemperature.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetFirmwareVersion.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetInfo.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetLeadsOff.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetMac.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)PpgGetDiagnosis.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GetBatteryInfo.INSTANCE) || Intrinsics.areEqual((Object)message3, (Object)GoToBootloader.INSTANCE))) {
            this.throwUnsupportedMessageSerialization(message2, TAG);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public Object deserialize-IoAF18A(@NotNull BufferedSource source) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            byte cmdByte = source.readByte();
            Message msg = switch (WhenMappings.$EnumSwitchMapping$0[this.typeForByte(cmdByte).ordinal()]) {
                case 1 -> {
                    byte acked = source.readByte();
                    yield new Ack(this.typeForByte(acked));
                }
                case 2 -> {
                    byte nacked = source.readByte();
                    yield new Nack(this.typeForByte(nacked));
                }
                case 3 -> ConnectUsb.INSTANCE;
                case 4 -> ConnectBt.INSTANCE;
                case 5 -> {
                    Integer protocolVersion = source.request(1L) ? Integer.valueOf(source.readByte()) : null;
                    yield new Connected(protocolVersion);
                }
                case 6 -> Disconnect.INSTANCE;
                case 7 -> GetInfo.INSTANCE;
                case 8 -> MyInfoSerializer.INSTANCE.deserializePayload(source);
                case 9 -> GetMac.INSTANCE;
                case 10 -> new MyMac(this.readMacAddressString(source));
                case 11 -> new SetMac(this.readMacAddressString(source));
                case 12 -> AskConfirm.INSTANCE;
                case 13 -> YesConfirm.INSTANCE;
                case 14 -> GetFirmwareVersion.INSTANCE;
                case 15 -> {
                    source.readByte();
                    yield new FirmwareVersion(source.readByte(), source.readByte());
                }
                case 16 -> {
                    byte gain = source.readByte();
                    yield new SetEcgGain(EcgGain.Companion.fromGain(gain));
                }
                case 17 -> {
                    byte mask = source.readByte();
                    yield new SetChannelsOn(mask);
                }
                case 18 -> PrepareSendEcg.INSTANCE;
                case 19 -> ReadySendEcg.INSTANCE;
                case 20 -> new StartAcquisition(CollectionsKt.emptyList());
                case 21 -> new StopAcquisition(CollectionsKt.emptyList());
                case 22 -> {
                    BufferedSource $this$read24BitInt$iv = source;
                    boolean $i$f$read24BitInt = false;
                    BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                    boolean $i$f$asInt = false;
                    int b2$iv = $this$asInt$iv$iv$iv & 0xFF;
                    BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                    boolean $i$f$asInt = false;
                    int b1$iv = $this$asInt$iv$iv$iv & 0xFF;
                    BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                    boolean $i$f$readByteAsInt = false;
                    byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                    boolean $i$f$asInt = false;
                    int b0$iv = $this$asInt$iv$iv$iv & 0xFF;
                    int packetId = (b2$iv << 24 | b1$iv << 16 | b0$iv << 8) >> 8;
                    int sampleIdOfFirst = packetId * this.samplesPerPacket;
                    int var7_18 = this.samplesPerPacket;
                    ArrayList<EcgModuleSample> var8_22 = new ArrayList<EcgModuleSample>(var7_18);
                    for (int var9_25 = 0; var9_25 < var7_18; ++var9_25) {
                        int var10_26;
                        b2$iv = var10_26 = var9_25;
                        ArrayList<EcgModuleSample> var26_46 = var8_22;
                        boolean $i$a$-List-InCardioProtocol$deserialize$msg$sampleList$1 = false;
                        int[] channels = new int[this.channelsPerSample];
                        int var15_32 = this.channelsPerSample;
                        for (int j = 0; j < var15_32; ++j) {
                            int rawValue;
                            BufferedSource $this$read24BitInt$iv = source;
                            boolean $i$f$read24BitInt = false;
                            BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                            boolean $i$f$readByteAsInt = false;
                            byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                            boolean $i$f$asInt = false;
                            int b2$iv = $this$asInt$iv$iv$iv & 0xFF;
                            BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                            boolean $i$f$readByteAsInt = false;
                            byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                            boolean $i$f$asInt = false;
                            int b1$iv = $this$asInt$iv$iv$iv & 0xFF;
                            BufferedSource $this$readByteAsInt$iv$iv = $this$read24BitInt$iv;
                            boolean $i$f$readByteAsInt = false;
                            byte $this$asInt$iv$iv$iv = $this$readByteAsInt$iv$iv.readByte();
                            boolean $i$f$asInt = false;
                            int b0$iv = $this$asInt$iv$iv$iv & 0xFF;
                            channels[j] = rawValue = (b2$iv << 24 | b1$iv << 16 | b0$iv << 8) >> 8;
                        }
                        var26_46.add(new EcgModuleSample(null, channels));
                    }
                    List sampleList = var8_22;
                    yield new EcgDataMessage(new ModulePacket<EcgModuleSample>(sampleIdOfFirst, sampleList, null));
                }
                case 23 -> GetBatteryCharge.INSTANCE;
                case 24 -> new BatteryCharge(source.readByte());
                case 25 -> GetBatteryDuration.INSTANCE;
                case 26 -> {
                    short duration = source.readShort();
                    yield new BatteryDuration(duration);
                }
                case 27 -> GetBatteryTemperature.INSTANCE;
                case 28 -> {
                    short rawTemperature = source.readShort();
                    yield new BatteryTemperature(rawTemperature);
                }
                case 29 -> GetLeadsOff.INSTANCE;
                case 30 -> {
                    byte p = source.readByte();
                    byte n = source.readByte();
                    yield new LeadOffMessage(EcgLeadOff.Companion.fromInCardio-KWHoVdY(p, n), null);
                }
                case 31 -> GoToBootloader.INSTANCE;
                default -> throw this.getUnsupportedMessageParsing(cmdByte, TAG);
            };
            object = Result.constructor-impl((Object)msg);
        }
        catch (Exception e) {
            if (e instanceof EOFException) {
                throw e;
            }
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e));
        }
        return object;
    }

    @Override
    @NotNull
    public Byte mapMessageTypeToByte(@NotNull MessageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return (byte)(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 12 -> 2;
            case 13 -> 3;
            case 3 -> 16;
            case 4 -> 17;
            case 5 -> 18;
            case 6 -> 20;
            case 7 -> 21;
            case 8 -> 22;
            case 21 -> 32;
            case 20 -> 33;
            case 18 -> 35;
            case 19 -> 36;
            case 22 -> 37;
            case 9 -> 48;
            case 10 -> 49;
            case 23 -> 50;
            case 24 -> 51;
            case 25 -> 52;
            case 26 -> 53;
            case 27 -> 54;
            case 28 -> 55;
            case 29 -> 56;
            case 30 -> 57;
            case 16 -> 85;
            case 17 -> 86;
            case 11 -> 87;
            case 31 -> 160;
            case 14 -> 161;
            case 15 -> 162;
            default -> 255;
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/protocol/InCardioProtocol$Companion;", "", "<init>", "()V", "TAG", "", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Ack.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Nack.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ConnectUsb.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ConnectBt.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Connected.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Disconnect.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetInfo.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyInfo.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetMac.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.MyMac.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetMac.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.AskConfirm.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.YesConfirm.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetFirmwareVersion.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.FirmwareVersion.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetEcgGain.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SetChannelsOn.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.PrepareSendEcg.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ReadySendEcg.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StartAcquisition.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.StopAcquisition.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.EcgData.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetBatteryCharge.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.BatteryCharge.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetBatteryDuration.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.BatteryDuration.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetBatteryTemperature.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.BatteryTemperature.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GetLeadsOff.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.LeadsOff.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.GoToBootloader.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

