/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.mdns;

import java.net.Inet4Address;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.log.InPulseLoggerKt;
import vet.inpulse.libcomm.core.mdns.ARecord;
import vet.inpulse.libcomm.core.mdns.DnsClass;
import vet.inpulse.libcomm.core.mdns.DnsMessage;
import vet.inpulse.libcomm.core.mdns.DnsOpcode;
import vet.inpulse.libcomm.core.mdns.DnsQuestion;
import vet.inpulse.libcomm.core.mdns.DnsRecord;
import vet.inpulse.libcomm.core.mdns.DnsRecordType;
import vet.inpulse.libcomm.core.mdns.DnsResponseCode;
import vet.inpulse.libcomm.core.mdns.MdnsMessage;
import vet.inpulse.libcomm.core.mdns.MdnsService;
import vet.inpulse.libcomm.core.mdns.MdnsSocket;
import vet.inpulse.libcomm.core.mdns.PtrRecord;
import vet.inpulse.libcomm.core.mdns.ServerHandle;
import vet.inpulse.libcomm.core.mdns.SrvRecord;
import vet.inpulse.libcomm.core.mdns.TxtRecord;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001e0\u001d0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001a2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0006\u0010*\u001a\u00020+J\u0015\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000f\u00a2\u0006\u0004\b.\u0010/J\u0015\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u000e\u00a2\u0006\u0004\b2\u00103J\b\u00104\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lvet/inpulse/libcomm/core/mdns/MdnsServer;", "", "socketDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "nextId", "", "job", "Lkotlinx/coroutines/Job;", "svcs", "", "Lvet/inpulse/libcomm/core/mdns/ServerHandle;", "Lvet/inpulse/libcomm/core/mdns/MdnsService;", "socketAddress", "Ljava/net/SocketAddress;", "open", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "handleQuestions", "socket", "Lvet/inpulse/libcomm/core/mdns/MdnsSocket;", "generateAnswers", "", "Lvet/inpulse/libcomm/core/mdns/DnsRecord;", "matchedServices", "Lkotlin/Pair;", "Lvet/inpulse/libcomm/core/mdns/DnsQuestion;", "buildFullDomainName", "", "mdnsService", "generatePtrRecord", "Lvet/inpulse/libcomm/core/mdns/PtrRecord;", "generateSrvRecord", "Lvet/inpulse/libcomm/core/mdns/SrvRecord;", "generateTxtRecord", "Lvet/inpulse/libcomm/core/mdns/TxtRecord;", "generateARecords", "Lvet/inpulse/libcomm/core/mdns/ARecord;", "close", "", "addService", "record", "addService-onghIaY", "(Lvet/inpulse/libcomm/core/mdns/MdnsService;)I", "removeService", "handle", "removeService-is97aks", "(I)V", "getSocketAddress", "libcomm"})
@SourceDebugExtension(value={"SMAP\nMdnsServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnsServer.kt\nvet/inpulse/libcomm/core/mdns/MdnsServer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n126#2:216\n153#2,3:217\n1563#3:220\n1634#3,3:221\n*S KotlinDebug\n*F\n+ 1 MdnsServer.kt\nvet/inpulse/libcomm/core/mdns/MdnsServer\n*L\n169#1:216\n169#1:217,3\n188#1:220\n188#1:221,3\n*E\n"})
public final class MdnsServer {
    @NotNull
    private final CoroutineDispatcher socketDispatcher;
    @NotNull
    private final LoggerInterface logger;
    private int nextId;
    @Nullable
    private Job job;
    @NotNull
    private final Map<ServerHandle, MdnsService> svcs;
    @Nullable
    private SocketAddress socketAddress;

    public MdnsServer(@NotNull CoroutineDispatcher socketDispatcher) {
        Intrinsics.checkNotNullParameter((Object)socketDispatcher, (String)"socketDispatcher");
        this.socketDispatcher = socketDispatcher;
        this.logger = InPulseLoggerKt.getLibcommLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.svcs = new LinkedHashMap();
    }

    public /* synthetic */ MdnsServer(CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(coroutineDispatcher);
    }

    public final boolean open(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (this.job != null) {
            return false;
        }
        this.logger.d(MdnsServer::open$lambda$0);
        MdnsSocket socket = new MdnsSocket(0, 0, this.socketDispatcher, 3, null);
        boolean opened = socket.open();
        if (opened) {
            this.socketAddress = socket.localSocketAddress();
            this.job = this.handleQuestions(scope, socket);
        }
        return opened;
    }

    private final Job handleQuestions(CoroutineScope scope, MdnsSocket socket) {
        return BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(socket, this, null){
            int label;
            final /* synthetic */ MdnsSocket $socket;
            final /* synthetic */ MdnsServer this$0;
            {
                this.$socket = $socket;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$socket.receiveMessage().collect(new FlowCollector(this.this$0, this.$socket){
                            final /* synthetic */ MdnsServer this$0;
                            final /* synthetic */ MdnsSocket $socket;
                            {
                                this.this$0 = $receiver;
                                this.$socket = $socket;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(MdnsMessage mdnsMessage, Continuation<? super Unit> $completion) {
                                void $this$forEach$iv;
                                List<DnsQuestion> questions = mdnsMessage.getMessage().getQuestions();
                                if (questions.isEmpty()) {
                                    return Unit.INSTANCE;
                                }
                                List allMatched = new ArrayList<E>();
                                Iterable iterable = questions;
                                MdnsServer mdnsServer = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    Map matched;
                                    Map.Entry<K, V> entry;
                                    void $this$filterTo$iv$iv;
                                    DnsQuestion it = (DnsQuestion)element$iv;
                                    boolean bl = false;
                                    Map $this$filter$iv = MdnsServer.access$getSvcs$p(mdnsServer);
                                    boolean $i$f$filter = false;
                                    Map map2 = $this$filter$iv;
                                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                                    boolean $i$f$filterTo = false;
                                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        Map.Entry<K, V> element$iv$iv;
                                        entry = element$iv$iv = iterator.next();
                                        boolean bl2 = false;
                                        MdnsService svc = (MdnsService)entry.getValue();
                                        if (!svc.getService().containsAll((Collection)it.getLabels())) continue;
                                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                    }
                                    $this$filter$iv = matched = destination$iv$iv;
                                    List list = allMatched;
                                    boolean $i$f$map = false;
                                    $this$filterTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                                    boolean $i$f$mapTo = false;
                                    for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                                        void m;
                                        entry = item$iv$iv;
                                        Object object = destination$iv$iv;
                                        boolean bl3 = false;
                                        object.add(TuplesKt.to(m.getValue(), (Object)it));
                                    }
                                    list.addAll((List)destination$iv$iv);
                                }
                                if (allMatched.isEmpty()) {
                                    return Unit.INSTANCE;
                                }
                                List answers = MdnsServer.access$generateAnswers(this.this$0, allMatched);
                                if (!((Collection)answers).isEmpty()) {
                                    boolean isUnicastQuestion;
                                    DnsMessage response;
                                    block11: {
                                        response = new DnsMessage(mdnsMessage.getMessage().getId(), true, DnsOpcode.QUERY, true, answers.size() <= 1, false, false, DnsResponseCode.NO_ERROR, CollectionsKt.emptyList(), answers, CollectionsKt.emptyList(), CollectionsKt.emptyList());
                                        Iterable $this$any$iv = mdnsMessage.getMessage().getQuestions();
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            v0 = false;
                                        } else {
                                            for (T element$iv : $this$any$iv) {
                                                DnsQuestion it = (DnsQuestion)element$iv;
                                                boolean bl = false;
                                                if (!it.getUnicast()) continue;
                                                v0 = true;
                                                break block11;
                                            }
                                            v0 = isUnicastQuestion = false;
                                        }
                                    }
                                    if (isUnicastQuestion) {
                                        this.$socket.sendMessageTo(response, mdnsMessage.getFrom());
                                    } else {
                                        this.$socket.broadcastMessage(response);
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable throwable) {
                            this.$socket.close();
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final List<DnsRecord> generateAnswers(List<Pair<MdnsService, DnsQuestion>> matchedServices) {
        List answers = new ArrayList();
        for (Pair<MdnsService, DnsQuestion> pair : matchedServices) {
            TxtRecord txt;
            boolean isAll;
            MdnsService s = (MdnsService)pair.component1();
            DnsQuestion q = (DnsQuestion)pair.component2();
            boolean isAny = q.getQClass() == DnsClass.ANY;
            boolean isIn = q.getQClass() == DnsClass.IN;
            boolean bl = isAll = q.getQType() == DnsRecordType.ALL;
            if (isAny || isAll) {
                PtrRecord ptr = this.generatePtrRecord(s);
                SrvRecord srv = this.generateSrvRecord(s);
                txt = this.generateTxtRecord(s);
                List<ARecord> aRecords = this.generateARecords(s);
                answers.add(ptr);
                answers.add(srv);
                answers.add(txt);
                answers.addAll((Collection)aRecords);
                continue;
            }
            if (!isIn) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[q.getQType().ordinal()]) {
                case 1: {
                    PtrRecord ptr = this.generatePtrRecord(s);
                    answers.add(ptr);
                    break;
                }
                case 2: {
                    SrvRecord srv = this.generateSrvRecord(s);
                    answers.add(srv);
                    break;
                }
                case 3: {
                    txt = this.generateTxtRecord(s);
                    answers.add(txt);
                    break;
                }
                case 4: {
                    List<ARecord> aRecords = this.generateARecords(s);
                    answers.addAll((Collection)aRecords);
                }
            }
        }
        return answers;
    }

    private final String buildFullDomainName(MdnsService mdnsService) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFullDomainName_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildFullDomainName_u24lambda_u241.append(mdnsService.getHostname());
        for (String l : mdnsService.getService()) {
            $this$buildFullDomainName_u24lambda_u241.append(".");
            $this$buildFullDomainName_u24lambda_u241.append(l);
        }
        return stringBuilder.toString();
    }

    private final PtrRecord generatePtrRecord(MdnsService mdnsService) {
        return new PtrRecord(CollectionsKt.joinToString$default((Iterable)mdnsService.getService(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), DnsClass.IN, 60, this.buildFullDomainName(mdnsService));
    }

    private final SrvRecord generateSrvRecord(MdnsService mdnsService) {
        return new SrvRecord(this.buildFullDomainName(mdnsService), DnsClass.IN, 60, 1, 1, (short)mdnsService.getPort(), mdnsService.getHostname() + ".local");
    }

    /*
     * WARNING - void declaration
     */
    private final TxtRecord generateTxtRecord(MdnsService mdnsService) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = mdnsService.getTxt();
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            StringBuilder stringBuilder;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            StringBuilder $this$generateTxtRecord_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$generateTxtRecord_u24lambda_u243_u24lambda_u242.append(k);
            if (v != null) {
                $this$generateTxtRecord_u24lambda_u243_u24lambda_u242.append("=");
                $this$generateTxtRecord_u24lambda_u243_u24lambda_u242.append(v);
            }
            collection.add(stringBuilder.toString());
        }
        List txtData = (List)destination$iv$iv;
        return new TxtRecord(this.buildFullDomainName(mdnsService), DnsClass.IN, 60, txtData);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ARecord> generateARecords(MdnsService mdnsService) {
        void $this$mapTo$iv$iv;
        String hostname = mdnsService.getHostname() + ".local";
        Iterable $this$map$iv = mdnsService.getIpv4Addresses();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Inet4Address inet4Address = (Inet4Address)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ARecord(hostname, DnsClass.IN, 60, (Inet4Address)it));
        }
        return (List)destination$iv$iv;
    }

    public final void close() {
        block0: {
            this.socketAddress = null;
            Job job2 = this.job;
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
    }

    public final int addService-onghIaY(@NotNull MdnsService record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        int n = this.nextId;
        this.nextId = n + 1;
        int handle = ServerHandle.constructor-impl(n);
        this.svcs.put(ServerHandle.box-impl(handle), record);
        return handle;
    }

    public final void removeService-is97aks(int handle) {
        this.svcs.remove(ServerHandle.box-impl(handle));
    }

    @Nullable
    public final SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    private static final String open$lambda$0() {
        return "opening mdns server";
    }

    public MdnsServer() {
        this(null, 1, null);
    }

    public static final /* synthetic */ List access$generateAnswers(MdnsServer $this, List matchedServices) {
        return $this.generateAnswers(matchedServices);
    }

    public static final /* synthetic */ Map access$getSvcs$p(MdnsServer $this) {
        return $this.svcs;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DnsRecordType.values().length];
            try {
                nArray[DnsRecordType.PTR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.SRV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.TXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.A.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

