/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.mdns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.locator.DeviceInfo;
import vet.inpulse.libcomm.core.mdns.AAAARecord;
import vet.inpulse.libcomm.core.mdns.ARecord;
import vet.inpulse.libcomm.core.mdns.DnsClass;
import vet.inpulse.libcomm.core.mdns.DnsMessage;
import vet.inpulse.libcomm.core.mdns.DnsOpcode;
import vet.inpulse.libcomm.core.mdns.DnsQuestion;
import vet.inpulse.libcomm.core.mdns.DnsRecordType;
import vet.inpulse.libcomm.core.mdns.DnsResponseCode;
import vet.inpulse.libcomm.core.mdns.SrvRecord;
import vet.inpulse.libcomm.core.mdns.TxtRecord;
import vet.inpulse.libcomm.core.network.mdns.MdnsUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001d"}, d2={"Lvet/inpulse/libcomm/core/mdns/MdnsDefs;", "", "<init>", "()V", "MDNS_PORT", "", "MDNS_IPv4_IP", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "getMDNS_IPv4_IP", "()Ljava/net/InetAddress;", "MDNS_IPv6_IP", "getMDNS_IPv6_IP", "getServerPort", "message", "Lvet/inpulse/libcomm/core/mdns/DnsMessage;", "(Lvet/inpulse/libcomm/core/mdns/DnsMessage;)Ljava/lang/Integer;", "getServerAddress", "address", "getTxtEntries", "", "", "getDeviceInfo", "Lvet/inpulse/libcomm/core/locator/DeviceInfo;", "getDefaultQueryMessage", "labels", "", "unicast", "", "libcomm"})
@SourceDebugExtension(value={"SMAP\nMdnsDefs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnsDefs.kt\nvet/inpulse/libcomm/core/mdns/MdnsDefs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n808#2,11:89\n808#2,11:100\n808#2,11:111\n808#2,11:122\n808#2,11:133\n808#2,11:144\n1374#2:155\n1460#2,2:156\n1563#2:158\n1634#2,3:159\n1462#2,3:162\n*S KotlinDebug\n*F\n+ 1 MdnsDefs.kt\nvet/inpulse/libcomm/core/mdns/MdnsDefs\n*L\n19#1:89,11\n28#1:100,11\n33#1:111,11\n51#1:122,11\n52#1:133,11\n53#1:144,11\n56#1:155\n56#1:156,2\n57#1:158\n57#1:159,3\n56#1:162,3\n*E\n"})
public final class MdnsDefs {
    @NotNull
    public static final MdnsDefs INSTANCE = new MdnsDefs();
    public static final int MDNS_PORT = 5353;
    private static final InetAddress MDNS_IPv4_IP = Inet4Address.getByName("224.0.0.251");
    private static final InetAddress MDNS_IPv6_IP = Inet6Address.getByName("FF02::FB");

    private MdnsDefs() {
    }

    public final InetAddress getMDNS_IPv4_IP() {
        return MDNS_IPv4_IP;
    }

    public final InetAddress getMDNS_IPv6_IP() {
        return MDNS_IPv6_IP;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getServerPort(DnsMessage message2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = message2.getAnswers();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SrvRecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List srvRecords = (List)destination$iv$iv;
        if (!((Collection)srvRecords).isEmpty()) {
            return ((SrvRecord)CollectionsKt.first((List)srvRecords)).getPort();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final InetAddress getServerAddress(@NotNull InetAddress address, @NotNull DnsMessage message2) {
        boolean isMulticast;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Iterable $this$filterIsInstance$iv = message2.getAllRecords();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ARecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aRecords = (List)destination$iv$iv;
        if (!((Collection)aRecords).isEmpty()) {
            return ((ARecord)CollectionsKt.first((List)aRecords)).getAddress();
        }
        Iterable $this$filterIsInstance$iv2 = message2.getAllRecords();
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AAAARecord)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List aaaaRecords = (List)destination$iv$iv2;
        if (!((Collection)aaaaRecords).isEmpty()) {
            return ((AAAARecord)CollectionsKt.first((List)aaaaRecords)).getAddress();
        }
        InetAddress inetAddress = address;
        boolean bl = inetAddress instanceof Inet4Address ? ((Inet4Address)address).isMulticastAddress() : (isMulticast = inetAddress instanceof Inet6Address ? ((Inet6Address)address).isMulticastAddress() : true);
        if (!isMulticast) {
            return address;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getTxtEntries(DnsMessage message2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = message2.getAnswers();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TxtRecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = message2.getAdditionalRecords();
        Collection collection = (List)destination$iv$iv;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TxtRecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = message2.getAuthorities();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TxtRecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allTxts = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        Iterable $this$flatMap$iv = allTxts;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TxtRecord it = (TxtRecord)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getTxtData();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void txt;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String[] stringArray = new String[]{"="};
                List tokens = StringsKt.split$default((CharSequence)((CharSequence)txt), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String key = (String)CollectionsKt.first((List)tokens);
                String value = (String)CollectionsKt.last((List)tokens);
                collection2.add(TuplesKt.to((Object)key, (Object)value));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final DeviceInfo getDeviceInfo(@NotNull DnsMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Map<String, String> txtData = this.getTxtEntries(message2);
        return MdnsUtilsKt.deviceInfoFromTxtData(txtData);
    }

    @NotNull
    public final DnsMessage getDefaultQueryMessage(@NotNull List<String> labels, boolean unicast) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        return new DnsMessage((short)MathKt.roundToInt((double)Math.floor(Random.Default.nextDouble() * (double)Short.MAX_VALUE)), false, DnsOpcode.QUERY, false, false, false, false, DnsResponseCode.NO_ERROR, CollectionsKt.listOf((Object)new DnsQuestion(labels, DnsRecordType.ALL, DnsClass.IN, unicast)), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    public static /* synthetic */ DnsMessage getDefaultQueryMessage$default(MdnsDefs mdnsDefs, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return mdnsDefs.getDefaultQueryMessage(list, bl);
    }
}

