/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.mdns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.mdns.AAAARecord;
import vet.inpulse.libcomm.core.mdns.ARecord;
import vet.inpulse.libcomm.core.mdns.CNameRecord;
import vet.inpulse.libcomm.core.mdns.DnsClass;
import vet.inpulse.libcomm.core.mdns.DnsMessage;
import vet.inpulse.libcomm.core.mdns.DnsOpcode;
import vet.inpulse.libcomm.core.mdns.DnsQuestion;
import vet.inpulse.libcomm.core.mdns.DnsRecord;
import vet.inpulse.libcomm.core.mdns.DnsRecordType;
import vet.inpulse.libcomm.core.mdns.DnsResponseCode;
import vet.inpulse.libcomm.core.mdns.DnsSerializationContext;
import vet.inpulse.libcomm.core.mdns.NsRecord;
import vet.inpulse.libcomm.core.mdns.PtrRecord;
import vet.inpulse.libcomm.core.mdns.SrvRecord;
import vet.inpulse.libcomm.core.mdns.TxtRecord;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t\u001a<\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u001a:\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t\u001a(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t\u001a\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t\u001a6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u001a6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u001a\u001c\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001eH\u0002\u001a\u001c\u0010&\u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0018H\u0002\u001a\"\u0010(\u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0016\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,\u00a8\u0006-"}, d2={"toDnsOpcode", "Lvet/inpulse/libcomm/core/mdns/DnsOpcode;", "", "toDnsResponseCode", "Lvet/inpulse/libcomm/core/mdns/DnsResponseCode;", "toDnsRecordType", "Lvet/inpulse/libcomm/core/mdns/DnsRecordType;", "toDnsClass", "Lvet/inpulse/libcomm/core/mdns/DnsClass;", "", "deserializeDomainName", "", "", "src", "Lokio/BufferedSource;", "bytes", "", "offset", "length", "labels", "", "deserializeDomainNamePointer", "ptrOffset", "deserializeDnsRecord", "Lvet/inpulse/libcomm/core/mdns/DnsRecord;", "deserializeDnsMessage", "Lvet/inpulse/libcomm/core/mdns/DnsMessage;", "parseDnsRecords", "count", "parseDnsQuestions", "Lvet/inpulse/libcomm/core/mdns/DnsQuestion;", "qdCount", "serializeDnsQuestion", "", "Lokio/Buffer;", "context", "Lvet/inpulse/libcomm/core/mdns/DnsSerializationContext;", "question", "serializeDnsRecord", "record", "writeDomain", "serializeDnsMessage", "message", "sink", "Lokio/BufferedSink;", "libcomm"})
@SourceDebugExtension(value={"SMAP\nDnsRecords.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsRecords.kt\nvet/inpulse/libcomm/core/mdns/DnsRecordsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,560:1\n1#2:561\n*E\n"})
public final class DnsRecordsKt {
    @Nullable
    public static final DnsOpcode toDnsOpcode(short $this$toDnsOpcode) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)DnsOpcode.getEntries();
            for (Object t : iterable) {
                DnsOpcode it = (DnsOpcode)((Object)t);
                boolean bl = false;
                if (!(it.getValue() == $this$toDnsOpcode)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final DnsResponseCode toDnsResponseCode(short $this$toDnsResponseCode) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)DnsResponseCode.getEntries();
            for (Object t : iterable) {
                DnsResponseCode it = (DnsResponseCode)((Object)t);
                boolean bl = false;
                if (!(it.getValue() == $this$toDnsResponseCode)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final DnsRecordType toDnsRecordType(short $this$toDnsRecordType) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)DnsRecordType.getEntries();
            for (Object t : iterable) {
                DnsRecordType it = (DnsRecordType)((Object)t);
                boolean bl = false;
                if (!(it.getValue() == $this$toDnsRecordType)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final DnsClass toDnsClass(int $this$toDnsClass) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)DnsClass.getEntries();
            for (Object t : iterable) {
                DnsClass it = (DnsClass)((Object)t);
                boolean bl = false;
                if (!(it.getValue() == $this$toDnsClass)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final List<String> deserializeDomainName(@NotNull BufferedSource src, @NotNull byte[] bytes, int offset, int length, @NotNull List<String> labels) {
        int firstByte;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        while ((firstByte = src.readByte() & 0xFF) != 0) {
            int isPtr = firstByte & 0xC0;
            if (isPtr == 192) {
                int secondByte = src.readByte() & 0xFF;
                int offsetInMessage = (firstByte & 0x3F) << 8 | secondByte;
                DnsRecordsKt.deserializeDomainNamePointer(labels, bytes, offset, length, offsetInMessage);
                break;
            }
            long labelSize = firstByte;
            String segment = src.readUtf8(labelSize);
            labels.add(segment);
        }
        return labels;
    }

    public static /* synthetic */ List deserializeDomainName$default(BufferedSource bufferedSource, byte[] byArray, int n, int n2, List list, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            int n4 = 0;
            ArrayList<String> arrayList = new ArrayList<String>(n4);
            int n5 = 0;
            while (n5 < 0) {
                int n6;
                int n7 = n6 = n5++;
                ArrayList<String> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add("");
            }
            list = arrayList;
        }
        return DnsRecordsKt.deserializeDomainName(bufferedSource, byArray, n, n2, list);
    }

    @NotNull
    public static final List<String> deserializeDomainNamePointer(@NotNull List<String> labels, @NotNull byte[] bytes, int offset, int length, int ptrOffset) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Buffer it = buffer = new Buffer();
        boolean bl = false;
        it.write(bytes, offset, length);
        it.skip((long)ptrOffset);
        Buffer buffer2 = buffer;
        return DnsRecordsKt.deserializeDomainName((BufferedSource)buffer2, bytes, offset, length, labels);
    }

    @Nullable
    public static final DnsRecord deserializeDnsRecord(@NotNull BufferedSource src, @NotNull byte[] bytes, int offset, int length) {
        DnsRecord dnsRecord;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String name = CollectionsKt.joinToString$default((Iterable)DnsRecordsKt.deserializeDomainName$default(src, bytes, offset, length, null, 16, null), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        short typeValue = src.readShort();
        DnsRecordType type = DnsRecordsKt.toDnsRecordType(typeValue);
        int dnsClassShort = src.readShort() & 0xFFFF;
        boolean cacheFlush = (dnsClassShort & 0x8000) > 0;
        DnsClass dnsClass = DnsRecordsKt.toDnsClass(dnsClassShort & Short.MAX_VALUE);
        if (dnsClass == null) {
            throw new IllegalArgumentException("not a valid dns class");
        }
        DnsClass dnsClass2 = dnsClass;
        int ttl = src.readInt();
        long dataLength = (long)src.readShort() & 0xFFFFL;
        if (type == null) {
            src.skip(dataLength);
            return null;
        }
        DnsRecordType dnsRecordType = type;
        switch (WhenMappings.$EnumSwitchMapping$0[dnsRecordType.ordinal()]) {
            case 1: {
                if (!((int)dataLength == 4)) {
                    boolean $i$a$-require-DnsRecordsKt$deserializeDnsRecord$32 = false;
                    String $i$a$-require-DnsRecordsKt$deserializeDnsRecord$32 = "must be size 4";
                    throw new IllegalArgumentException($i$a$-require-DnsRecordsKt$deserializeDnsRecord$32.toString());
                }
                InetAddress inetAddress = Inet4Address.getByAddress(src.readByteArray(4L));
                Intrinsics.checkNotNull((Object)inetAddress, (String)"null cannot be cast to non-null type java.net.Inet4Address");
                dnsRecord = new ARecord(name, dnsClass2, ttl, (Inet4Address)inetAddress);
                break;
            }
            case 2: {
                String nsdName = src.readUtf8(dataLength);
                dnsRecord = new NsRecord(name, dnsClass2, ttl, nsdName);
                break;
            }
            case 3: {
                String ptrDName = CollectionsKt.joinToString$default((Iterable)DnsRecordsKt.deserializeDomainName$default(src, bytes, offset, length, null, 16, null), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                dnsRecord = new PtrRecord(name, dnsClass2, ttl, ptrDName);
                break;
            }
            case 4: {
                String cname = src.readUtf8(dataLength);
                dnsRecord = new CNameRecord(name, dnsClass2, ttl, cname);
                break;
            }
            case 5: {
                List txtRecords = new ArrayList();
                long characterStringLength = (long)src.readByte() & 0xFFL;
                long read = 1L;
                while (characterStringLength != 0L) {
                    String txtRecord = src.readUtf8(characterStringLength);
                    txtRecords.add(txtRecord);
                    if ((read += characterStringLength) >= dataLength) break;
                    characterStringLength = src.readByte();
                    ++read;
                }
                dnsRecord = new TxtRecord(name, dnsClass2, ttl, txtRecords);
                break;
            }
            case 6: {
                short priority = src.readShort();
                short weight = src.readShort();
                short port = src.readShort();
                String target = CollectionsKt.joinToString$default((Iterable)DnsRecordsKt.deserializeDomainName$default(src, bytes, offset, length, null, 16, null), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                return new SrvRecord(name, dnsClass2, ttl, priority, weight, port, target);
            }
            case 7: {
                if (!((int)dataLength == 16)) {
                    boolean bl = false;
                    String string = "not a valid AAAA record size";
                    throw new IllegalArgumentException(string.toString());
                }
                byte[] address = src.readByteArray(16L);
                InetAddress inetAddress = Inet6Address.getByAddress(address);
                Intrinsics.checkNotNull((Object)inetAddress, (String)"null cannot be cast to non-null type java.net.Inet6Address");
                return new AAAARecord(name, dnsClass2, ttl, (Inet6Address)inetAddress);
            }
            default: {
                src.skip(dataLength);
                dnsRecord = null;
            }
        }
        return dnsRecord;
    }

    @NotNull
    public static final DnsMessage deserializeDnsMessage(@NotNull byte[] bytes, int offset, int length) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Buffer $this$deserializeDnsMessage_u24lambda_u248 = buffer = new Buffer();
        boolean bl = false;
        $this$deserializeDnsMessage_u24lambda_u248.write(bytes, offset, length);
        BufferedSource src = (BufferedSource)buffer;
        short id = src.readShort();
        byte flags1 = src.readByte();
        byte flags2 = src.readByte();
        short qdCount = src.readShort();
        short anCount = src.readShort();
        short authCount = src.readShort();
        short addCount = src.readShort();
        int isResponse = flags1 & 0x80;
        DnsOpcode dnsOpcode = DnsRecordsKt.toDnsOpcode((short)((flags1 & 0x70) >> 1));
        if (dnsOpcode == null) {
            throw new IllegalArgumentException("not a valid opcode");
        }
        DnsOpcode opcode = dnsOpcode;
        boolean isAuthoritative = (flags1 & 4) > 0;
        boolean truncated = (flags1 & 2) > 0;
        boolean recursionDesired = (flags1 & 1) > 0;
        boolean recursionAvailable = (flags2 & 0x80) > 0;
        DnsResponseCode dnsResponseCode = DnsRecordsKt.toDnsResponseCode((short)((flags2 & 7) >> 1));
        if (dnsResponseCode == null) {
            throw new IllegalArgumentException("not a valid opcode");
        }
        DnsResponseCode responseCode = dnsResponseCode;
        List<DnsQuestion> questions = DnsRecordsKt.parseDnsQuestions(qdCount, src, bytes, offset, length);
        List<DnsRecord> answers = DnsRecordsKt.parseDnsRecords(anCount, src, bytes, offset, length);
        List<DnsRecord> authorities = DnsRecordsKt.parseDnsRecords(authCount, src, bytes, offset, length);
        List<DnsRecord> additional = DnsRecordsKt.parseDnsRecords(addCount, src, bytes, offset, length);
        return new DnsMessage(id, isResponse != 0, opcode, isAuthoritative, truncated, recursionDesired, recursionAvailable, responseCode, questions, answers, authorities, additional);
    }

    private static final List<DnsRecord> parseDnsRecords(short count, BufferedSource src, byte[] bytes, int offset, int length) {
        List records = new ArrayList();
        int n = count;
        for (int i = 0; i < n; ++i) {
            DnsRecord dnsRecord;
            if (DnsRecordsKt.deserializeDnsRecord(src, bytes, offset, length) == null) continue;
            DnsRecord record = dnsRecord;
            boolean bl = false;
            records.add(record);
        }
        return records;
    }

    private static final List<DnsQuestion> parseDnsQuestions(short qdCount, BufferedSource src, byte[] bytes, int offset, int length) {
        List questions = new ArrayList();
        int n = qdCount;
        for (int i = 0; i < n; ++i) {
            List labels = DnsRecordsKt.deserializeDomainName$default(src, bytes, offset, length, null, 16, null);
            short qType = src.readShort();
            short unicastAndQClass = src.readShort();
            boolean unicast = (unicastAndQClass & 0x8000) > 0;
            int qClass = unicastAndQClass & Short.MAX_VALUE;
            DnsRecordType dnsRecordType = DnsRecordsKt.toDnsRecordType(qType);
            if (dnsRecordType == null) {
                throw new IllegalArgumentException("QTYPE " + qType + " is not a valid QTYPE");
            }
            DnsClass dnsClass = DnsRecordsKt.toDnsClass(qClass);
            if (dnsClass == null) {
                throw new IllegalArgumentException("QCLASS " + qClass + " is not a valid QCLASS");
            }
            DnsQuestion question = new DnsQuestion(labels, dnsRecordType, dnsClass, unicast);
            questions.add(question);
        }
        return questions;
    }

    private static final void serializeDnsQuestion(Buffer $this$serializeDnsQuestion, DnsSerializationContext context, DnsQuestion question) {
        DnsRecordsKt.writeDomain($this$serializeDnsQuestion, context, question.getLabels());
        $this$serializeDnsQuestion.writeShort((int)question.getQType().getValue());
        int unicastAndQClass = question.getQClass().getValue();
        if (question.getUnicast()) {
            unicastAndQClass |= 0x8000;
        }
        $this$serializeDnsQuestion.writeShort(unicastAndQClass);
    }

    private static final void serializeDnsRecord(Buffer $this$serializeDnsRecord, DnsSerializationContext context, DnsRecord record) {
        String[] stringArray = new String[]{"."};
        DnsRecordsKt.writeDomain($this$serializeDnsRecord, context, StringsKt.split$default((CharSequence)record.getName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        $this$serializeDnsRecord.writeShort((int)record.getType().getValue());
        $this$serializeDnsRecord.writeShort(record.getRecordClass().getValue());
        $this$serializeDnsRecord.writeInt(record.getTtl());
        context.setBaseOffset($this$serializeDnsRecord.size() + (long)2);
        Buffer payload = new Buffer();
        DnsRecord dnsRecord = record;
        if (dnsRecord instanceof CNameRecord) {
            v0 = payload.writeUtf8(((CNameRecord)record).getCname());
        } else if (dnsRecord instanceof NsRecord) {
            v0 = payload.writeUtf8(((NsRecord)record).getNsdName());
        } else if (dnsRecord instanceof PtrRecord) {
            String[] stringArray2 = new String[]{"."};
            DnsRecordsKt.writeDomain(payload, context, StringsKt.split$default((CharSequence)((PtrRecord)record).getPtrDomainName(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            v0 = Unit.INSTANCE;
        } else if (dnsRecord instanceof TxtRecord) {
            for (String cs : ((TxtRecord)record).getTxtData()) {
                ByteString encoded = ByteString.Companion.encodeUtf8(cs);
                payload.writeByte(encoded.size());
                payload.write(encoded);
            }
            v0 = Unit.INSTANCE;
        } else if (dnsRecord instanceof ARecord) {
            byte[] byArray = ((ARecord)record).getAddress().getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
            v0 = payload.write(byArray);
        } else if (dnsRecord instanceof AAAARecord) {
            byte[] byArray = ((AAAARecord)record).getAddress().getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
            v0 = payload.write(byArray);
        } else if (dnsRecord instanceof SrvRecord) {
            payload.writeShort((int)((SrvRecord)record).getPriority());
            payload.writeShort((int)((SrvRecord)record).getWeight());
            payload.writeShort((int)((SrvRecord)record).getPort());
            String[] stringArray3 = new String[]{"."};
            DnsRecordsKt.writeDomain(payload, context, StringsKt.split$default((CharSequence)((SrvRecord)record).getTarget(), (String[])stringArray3, (boolean)false, (int)0, (int)6, null));
            v0 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        context.setBaseOffset(0L);
        $this$serializeDnsRecord.writeShort((int)payload.size());
        $this$serializeDnsRecord.writeAll((Source)payload);
    }

    private static final void writeDomain(Buffer $this$writeDomain, DnsSerializationContext context, List<String> labels) {
        List ls = CollectionsKt.toMutableList((Collection)labels);
        while ((String)CollectionsKt.firstOrNull((List)ls) != null) {
            String segment;
            String key = CollectionsKt.joinToString$default((Iterable)ls, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            Long foundLabel = context.getLabels().get(key);
            if (foundLabel != null) {
                $this$writeDomain.writeByte(192);
                $this$writeDomain.writeByte((int)foundLabel.longValue());
                return;
            }
            ByteString str = ByteString.Companion.encodeUtf8(segment);
            long offsetInThisBuffer = $this$writeDomain.size();
            long finalOffset = context.getBaseOffset() + offsetInThisBuffer;
            $this$writeDomain.writeByte(str.size());
            $this$writeDomain.write(str);
            if (finalOffset < 255L) {
                context.getLabels().put(key, finalOffset);
            }
            String cfr_ignored_0 = (String)CollectionsKt.removeFirstOrNull((List)ls);
        }
        $this$writeDomain.writeByte(0);
    }

    public static final void serializeDnsMessage(@NotNull DnsMessage message2, @NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DnsSerializationContext context = new DnsSerializationContext();
        Buffer buffer = context.getBuffer();
        buffer.writeShort((int)message2.getId());
        int flags1 = 0;
        flags1 |= message2.getResponse() ? 128 : 0;
        flags1 |= message2.getOpcode().getValue() << 3;
        flags1 |= message2.getAuthoritativeAnswer() ? 4 : 0;
        flags1 |= message2.getTruncated() ? 2 : 0;
        int flags2 = 0;
        flags2 |= message2.getRecursionAvailable() ? 128 : 0;
        buffer.writeByte(flags1 |= message2.getRecursionDesired() ? 1 : 0);
        buffer.writeByte(flags2 |= message2.getResponseCode().getValue());
        buffer.writeShort(message2.getQuestions().size());
        buffer.writeShort(message2.getAnswers().size());
        buffer.writeShort(message2.getAuthorities().size());
        buffer.writeShort(message2.getAdditionalRecords().size());
        for (DnsQuestion q : message2.getQuestions()) {
            DnsRecordsKt.serializeDnsQuestion(buffer, context, q);
        }
        for (DnsRecord r : message2.getAnswers()) {
            DnsRecordsKt.serializeDnsRecord(buffer, context, r);
        }
        for (DnsRecord r : message2.getAuthorities()) {
            DnsRecordsKt.serializeDnsRecord(buffer, context, r);
        }
        for (DnsRecord r : message2.getAdditionalRecords()) {
            DnsRecordsKt.serializeDnsRecord(buffer, context, r);
        }
        sink.writeAll((Source)buffer);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DnsRecordType.values().length];
            try {
                nArray[DnsRecordType.A.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.NS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.PTR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.CNAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.TXT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.SRV.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DnsRecordType.AAAA.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

