/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.locator.bluetooth;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.util.HexPrinterKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0013\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "", "macAddress", "", "<init>", "(Ljava/lang/String;)V", "getMacAddress", "()Ljava/lang/String;", "isValid", "", "toNonSeparatedString", "toByteArray", "", "macVendor", "getMacVendor", "toString", "equals", "other", "hashCode", "", "Companion", "libcomm"})
@SourceDebugExtension(value={"SMAP\nRemoteAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteAddress.kt\nvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,85:1\n434#2:86\n507#2,5:87\n*S KotlinDebug\n*F\n+ 1 RemoteAddress.kt\nvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress\n*L\n65#1:86\n65#1:87,5\n*E\n"})
public final class RemoteAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String macAddress;
    @NotNull
    private static final Regex macAddressRegex = new Regex("^([0-9A-F]{2}[:]){5}([0-9A-F]{2})$");
    @NotNull
    private static final Regex nonSeparatedRegex = new Regex("^([0-9A-Fa-f]{12})$");
    @NotNull
    private static final String formatter = "%02X:%02X:%02X:%02X:%02X:%02X";

    public RemoteAddress(@NotNull String macAddress) {
        Intrinsics.checkNotNullParameter((Object)macAddress, (String)"macAddress");
        this.macAddress = macAddress;
        if (!this.isValid()) {
            boolean bl = false;
            String string = "The given address <" + this.macAddress + "> did not match the expected pattern";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getMacAddress() {
        return this.macAddress;
    }

    private final boolean isValid() {
        return Companion.isValid(this.macAddress);
    }

    @NotNull
    public final String toNonSeparatedString() {
        return StringsKt.replace$default((String)this.macAddress, (String)":", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] toByteArray() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String string = this.macAddress;
        ByteString.Companion companion = ByteString.Companion;
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isLetterOrDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return companion.decodeHex(((StringBuilder)destination$iv$iv).toString()).toByteArray();
    }

    @NotNull
    public final String getMacVendor() {
        return StringsKt.substring((String)this.macAddress, (IntRange)RangesKt.until((int)0, (int)8));
    }

    @NotNull
    public String toString() {
        return this.macAddress;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RemoteAddress cfr_ignored_0 = (RemoteAddress)other;
        if (!Intrinsics.areEqual((Object)this.macAddress, (Object)((RemoteAddress)other).macAddress)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getMacVendor(), (Object)((RemoteAddress)other).getMacVendor());
    }

    public int hashCode() {
        return this.macAddress.hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress$Companion;", "", "<init>", "()V", "macAddressRegex", "Lkotlin/text/Regex;", "nonSeparatedRegex", "formatter", "", "fromNonSeparatedMac", "Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "mac", "isValid", "", "macAddress", "fromByteArray", "byteArray", "", "offset", "", "libcomm"})
    @SourceDebugExtension(value={"SMAP\nRemoteAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteAddress.kt\nvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteAddress fromNonSeparatedMac(@NotNull String mac) {
            Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
            CharSequence charSequence = mac;
            if (!nonSeparatedRegex.matches(charSequence)) {
                boolean $i$a$-require-RemoteAddress$Companion$fromNonSeparatedMac$22 = false;
                String $i$a$-require-RemoteAddress$Companion$fromNonSeparatedMac$22 = "The given address <" + mac + "> did not match the expected pattern: " + nonSeparatedRegex;
                throw new IllegalArgumentException($i$a$-require-RemoteAddress$Companion$fromNonSeparatedMac$22.toString());
            }
            CharSequence $this$fromNonSeparatedMac_u24lambda_u241 = charSequence = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < 6; ++i) {
                String string = mac.substring(i * 2, i * 2 + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                ((StringBuilder)$this$fromNonSeparatedMac_u24lambda_u241).append(string);
                if (i >= 5) continue;
                ((StringBuilder)$this$fromNonSeparatedMac_u24lambda_u241).append(":");
            }
            String string = ((StringBuilder)charSequence).toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String it = string;
            boolean bl2 = false;
            return new RemoteAddress(it);
        }

        public final boolean isValid(@NotNull String macAddress) {
            Intrinsics.checkNotNullParameter((Object)macAddress, (String)"macAddress");
            CharSequence charSequence = macAddress;
            return macAddressRegex.matches(charSequence) && !Intrinsics.areEqual((Object)macAddress, (Object)"00:00:00:00:00:00");
        }

        @NotNull
        public final RemoteAddress fromByteArray(@NotNull byte[] byteArray, int offset) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            if (!(byteArray.length - offset >= 6)) {
                boolean bl = false;
                String string = "byteArray.size - offset < 6. size: " + byteArray.length + ", offset: " + offset + ".";
                throw new IllegalArgumentException(string.toString());
            }
            int n = 17;
            StringBuilder $this$fromByteArray_u24lambda_u244 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            $this$fromByteArray_u24lambda_u244.append(HexPrinterKt.toHex(byteArray[offset + 0]));
            for (int i = 1; i < 6; ++i) {
                $this$fromByteArray_u24lambda_u244.append(":");
                $this$fromByteArray_u24lambda_u244.append(HexPrinterKt.toHex(byteArray[offset + i]));
            }
            String string = stringBuilder.toString();
            return new RemoteAddress(string);
        }

        public static /* synthetic */ RemoteAddress fromByteArray$default(Companion companion, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromByteArray(byArray, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

