/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.locator;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.DeviceType;
import vet.inpulse.libcomm.core.device.data.PpgCalibrationControlMode;
import vet.inpulse.libcomm.core.device.types.Agile;
import vet.inpulse.libcomm.core.device.types.AgileV2;
import vet.inpulse.libcomm.core.device.types.BpScan;
import vet.inpulse.libcomm.core.device.types.BpScanSV1;
import vet.inpulse.libcomm.core.device.types.BpScanV2;
import vet.inpulse.libcomm.core.device.types.Device;
import vet.inpulse.libcomm.core.device.types.HolterV1;
import vet.inpulse.libcomm.core.device.types.InCardio;
import vet.inpulse.libcomm.core.device.types.InCardioCs;
import vet.inpulse.libcomm.core.device.types.InCardioV3;
import vet.inpulse.libcomm.core.device.types.InMonitorBasic;
import vet.inpulse.libcomm.core.device.types.InMonitorV2;
import vet.inpulse.libcomm.core.io.IOOperator;
import vet.inpulse.libcomm.core.io.engine.CommunicationEngine;
import vet.inpulse.libcomm.core.io.engine.ThreadedCommunicationEngine;
import vet.inpulse.libcomm.core.locator.DeviceInfo;
import vet.inpulse.libcomm.core.locator.DeviceInterfaceInfo;
import vet.inpulse.libcomm.core.locator.DeviceLocatorUtilsKt;
import vet.inpulse.libcomm.core.locator.StateSnapshot;
import vet.inpulse.libcomm.core.log.LogConfiguration;
import vet.inpulse.libcomm.core.protocol.CodecSpec;
import vet.inpulse.libcomm.core.protocol.InCardioProtocol;
import vet.inpulse.libcomm.core.protocol.InPulseProtocolV2;
import vet.inpulse.libcomm.core.protocol.MonitorBasicProtocol;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.UnknownDeviceException;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ1\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011JC\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0018"}, d2={"Lvet/inpulse/libcomm/core/locator/DeviceLocatorUtils;", "", "<init>", "()V", "getProtocolForDevice", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "deviceInfo", "Lvet/inpulse/libcomm/core/locator/DeviceInfo;", "getProtocolForDevice$libcomm", "buildDevice", "Lvet/inpulse/libcomm/core/device/types/Device;", "stateSnapshot", "Lvet/inpulse/libcomm/core/locator/StateSnapshot;", "engine", "Lvet/inpulse/libcomm/core/io/engine/CommunicationEngine;", "interfaceInfo", "Lvet/inpulse/libcomm/core/locator/DeviceInterfaceInfo;", "buildDevice$libcomm", "codecSpec", "Lvet/inpulse/libcomm/core/protocol/CodecSpec;", "ioOperator", "Lvet/inpulse/libcomm/core/io/IOOperator;", "logConfiguration", "Lvet/inpulse/libcomm/core/log/LogConfiguration;", "libcomm"})
public final class DeviceLocatorUtils {
    @NotNull
    public static final DeviceLocatorUtils INSTANCE = new DeviceLocatorUtils();

    private DeviceLocatorUtils() {
    }

    @NotNull
    public final Protocol getProtocolForDevice$libcomm(@NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        return switch (WhenMappings.$EnumSwitchMapping$0[deviceInfo.getDeviceType().ordinal()]) {
            case 1 -> throw new UnknownDeviceException("Failed to get protocol for an unknown device: " + deviceInfo.getDeviceType(), null, 2, null);
            case 2 -> new InCardioProtocol(2, 8);
            case 3 -> new InPulseProtocolV2();
            case 4 -> new InCardioProtocol(5, 3);
            case 5 -> new InCardioProtocol(2, 8);
            case 6 -> new InPulseProtocolV2();
            case 7 -> {
                boolean var2_2 = deviceInfo.getFirmwareVersion() > 11;
                boolean var3_3 = deviceInfo.getFirmwareVersion() > 11;
                boolean var4_4 = deviceInfo.getFirmwareVersion() > 11;
                yield new MonitorBasicProtocol(4, var3_3, var2_2, var4_4);
            }
            case 8 -> new MonitorBasicProtocol(0, false, false, false, 15, null);
            case 9 -> new InPulseProtocolV2();
            case 10 -> new InPulseProtocolV2();
            case 11 -> new InPulseProtocolV2();
            case 12 -> new InPulseProtocolV2();
            case 13 -> throw new IllegalStateException("No protocol for AFTSCAN".toString());
            case 14 -> throw new IllegalStateException("No protocol for dongle".toString());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final Device buildDevice$libcomm(@NotNull DeviceInfo deviceInfo, @Nullable StateSnapshot stateSnapshot, @NotNull CommunicationEngine engine, @NotNull DeviceInterfaceInfo interfaceInfo) {
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)interfaceInfo, (String)"interfaceInfo");
        Device device = switch (WhenMappings.$EnumSwitchMapping$0[deviceInfo.getDeviceType().ordinal()]) {
            case 4 -> new Agile(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, 112, null);
            case 11 -> new AgileV2(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, null, null, 1008, null);
            case 5 -> new InCardioCs(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, 112, null);
            case 7 -> new InMonitorBasic(deviceInfo, stateSnapshot, engine, interfaceInfo, PpgCalibrationControlMode.Companion.fromFirmwareVersion(deviceInfo.getFirmwareVersion()), deviceInfo.getFirmwareVersion() > 10, null, null, null, null, null, null, null, 8128, null);
            case 2 -> new InCardio(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, 240, null);
            case 3 -> new InCardioV3(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, null, null, null, null, 4080, null);
            case 6 -> new InMonitorV2(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, null, null, null, null, null, null, null, null, 65520, null);
            case 8 -> new BpScan(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, null, 496, null);
            case 9 -> new BpScanV2(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, null, null, null, null, null, 8176, null);
            case 12 -> new HolterV1(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, 112, null);
            case 10 -> new BpScanSV1(deviceInfo, stateSnapshot, engine, interfaceInfo, null, null, null, null, null, null, null, 2032, null);
            case 1, 13, 14 -> {
                LoggerInterface.w$default((LoggerInterface)DeviceLocatorUtilsKt.access$getLogger$p(), null, () -> DeviceLocatorUtils.buildDevice$lambda$0(deviceInfo), (int)1, null);
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return device;
    }

    @Nullable
    public final Device buildDevice$libcomm(@NotNull CodecSpec codecSpec, @NotNull DeviceInfo deviceInfo, @Nullable StateSnapshot stateSnapshot, @NotNull IOOperator ioOperator, @NotNull DeviceInterfaceInfo interfaceInfo, @NotNull LogConfiguration logConfiguration) {
        Intrinsics.checkNotNullParameter((Object)codecSpec, (String)"codecSpec");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        Intrinsics.checkNotNullParameter((Object)ioOperator, (String)"ioOperator");
        Intrinsics.checkNotNullParameter((Object)interfaceInfo, (String)"interfaceInfo");
        Intrinsics.checkNotNullParameter((Object)logConfiguration, (String)"logConfiguration");
        Protocol protocol = this.getProtocolForDevice$libcomm(deviceInfo);
        ThreadedCommunicationEngine engine = new ThreadedCommunicationEngine(protocol, ioOperator, codecSpec, logConfiguration);
        return this.buildDevice$libcomm(deviceInfo, stateSnapshot, engine, interfaceInfo);
    }

    public static /* synthetic */ Device buildDevice$libcomm$default(DeviceLocatorUtils deviceLocatorUtils, CodecSpec codecSpec, DeviceInfo deviceInfo, StateSnapshot stateSnapshot, IOOperator iOOperator, DeviceInterfaceInfo deviceInterfaceInfo, LogConfiguration logConfiguration, int n, Object object) {
        if ((n & 0x20) != 0) {
            logConfiguration = new LogConfiguration(true, true);
        }
        return deviceLocatorUtils.buildDevice$libcomm(codecSpec, deviceInfo, stateSnapshot, iOOperator, deviceInterfaceInfo, logConfiguration);
    }

    private static final String buildDevice$lambda$0(DeviceInfo $deviceInfo) {
        return "Failed to build device of type " + $deviceInfo.getDeviceType() + " using deviceInfo: " + $deviceInfo;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.INCARDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.INCARDIO_V3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.AGILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.INCARDIO_CS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.INMONITOR_20.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.INMONITOR_BASIC.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.BPSCAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.BPSCAN_V2.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.BPSCAN_S_V1.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.AGILE_V2.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.HOLTER_V1.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.AFTSCAN.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.BLUETOOTH_DONGLE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

