/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.virtual.operator;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.libcomm.core.device.DeviceType;
import vet.inpulse.libcomm.core.device.data.BatteryInfo;
import vet.inpulse.libcomm.core.device.data.NibpStatus;
import vet.inpulse.libcomm.core.device.virtual.operator.VirtualOperator;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;
import vet.inpulse.libcomm.core.protocol.CodecSpec;
import vet.inpulse.libcomm.core.protocol.Protocol;
import vet.inpulse.libcomm.core.protocol.message.Ack;
import vet.inpulse.libcomm.core.protocol.message.BatteryInfoMessage;
import vet.inpulse.libcomm.core.protocol.message.Connect;
import vet.inpulse.libcomm.core.protocol.message.GetInfo;
import vet.inpulse.libcomm.core.protocol.message.Message;
import vet.inpulse.libcomm.core.protocol.message.ModulePacket;
import vet.inpulse.libcomm.core.protocol.message.MyInfo;
import vet.inpulse.libcomm.core.protocol.message.Nack;
import vet.inpulse.libcomm.core.protocol.message.NibpDataMessage;
import vet.inpulse.libcomm.core.protocol.message.NibpModuleSample;
import vet.inpulse.libcomm.core.protocol.message.Ping;
import vet.inpulse.libcomm.core.protocol.message.Pong;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationParameters;
import vet.inpulse.libcomm.core.protocol.message.SetNibpCalibrationPressure;
import vet.inpulse.libcomm.core.protocol.message.StartNibp;
import vet.inpulse.libcomm.core.protocol.message.StartNibpCalibration;
import vet.inpulse.libcomm.core.protocol.message.StopNibp;
import vet.inpulse.libcomm.core.util.data_generator.DataGenerator;
import vet.inpulse.libcomm.core.util.data_generator.SinusoidalGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lvet/inpulse/libcomm/core/device/virtual/operator/VirtualBpScanOperator;", "Lvet/inpulse/libcomm/core/device/virtual/operator/VirtualOperator;", "protocol", "Lvet/inpulse/libcomm/core/protocol/Protocol;", "codecSpec", "Lvet/inpulse/libcomm/core/protocol/CodecSpec;", "nibpGenerator", "Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;", "<init>", "(Lvet/inpulse/libcomm/core/protocol/Protocol;Lvet/inpulse/libcomm/core/protocol/CodecSpec;Lvet/inpulse/libcomm/core/util/data_generator/DataGenerator;)V", "inflateSlopeStep", "", "peakSamples", "", "dataBuffer", "", "currentSampleId", "status", "Lvet/inpulse/libcomm/core/device/data/NibpStatus;", "calibrationTargetPressure", "peakSamplesRun", "currentPressure", "maxPressure", "minPressure", "slopeStep", "generatePacket", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "acquisitionFuture", "Lkotlinx/coroutines/Job;", "generateBatteryInfo", "batteryInfoTask", "processMessage", "", "message", "Lvet/inpulse/libcomm/core/protocol/message/Message;", "eventLoop", "Lkotlinx/coroutines/CoroutineScope;", "resetAcquisitionState", "initialStatus", "stopAcquisition", "startAcquisition", "setupAcquisition", "newMessage", "Lvet/inpulse/libcomm/core/protocol/message/StartNibp;", "libcomm"})
public final class VirtualBpScanOperator
extends VirtualOperator {
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final DataGenerator nibpGenerator;
    private final float inflateSlopeStep;
    private final int peakSamples;
    @NotNull
    private final float[] dataBuffer;
    private int currentSampleId;
    @NotNull
    private NibpStatus status;
    private float calibrationTargetPressure;
    private int peakSamplesRun;
    private float currentPressure;
    private float maxPressure;
    private float minPressure;
    private float slopeStep;
    @NotNull
    private final Runnable generatePacket;
    @Nullable
    private Job acquisitionFuture;
    @NotNull
    private final Runnable generateBatteryInfo;
    @Nullable
    private Job batteryInfoTask;

    public VirtualBpScanOperator(@NotNull Protocol protocol, @NotNull CodecSpec codecSpec, @NotNull DataGenerator nibpGenerator) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)codecSpec, (String)"codecSpec");
        Intrinsics.checkNotNullParameter((Object)nibpGenerator, (String)"nibpGenerator");
        super(protocol, codecSpec);
        this.protocol = protocol;
        this.nibpGenerator = nibpGenerator;
        this.inflateSlopeStep = 0.05f;
        this.peakSamples = 100;
        this.dataBuffer = new float[1];
        this.status = NibpStatus.NONE;
        this.generatePacket = () -> VirtualBpScanOperator.generatePacket$lambda$1(this);
        this.generateBatteryInfo = () -> VirtualBpScanOperator.generateBatteryInfo$lambda$2(this);
    }

    public /* synthetic */ VirtualBpScanOperator(Protocol protocol, CodecSpec codecSpec, DataGenerator dataGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            dataGenerator = new SinusoidalGenerator(600.0, 1.0, 1.0);
        }
        this(protocol, codecSpec, dataGenerator);
    }

    @Override
    public void processMessage(@NotNull Message message2, @NotNull CoroutineScope eventLoop) {
        Message message3;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)eventLoop, (String)"eventLoop");
        if (this.batteryInfoTask == null) {
            this.batteryInfoTask = this.scheduleAtFixedRate(eventLoop, this.generateBatteryInfo, 1, 5, DurationUnit.SECONDS);
        }
        if (!Intrinsics.areEqual((Object)(message3 = message2), (Object)Connect.INSTANCE)) {
            if (Intrinsics.areEqual((Object)message3, (Object)Ping.INSTANCE)) {
                this.sendMessage(Pong.INSTANCE);
            } else if (message3 instanceof StartNibp) {
                this.resetAcquisitionState(NibpStatus.INFLATING);
                this.setupAcquisition((StartNibp)message2);
                this.startAcquisition(eventLoop);
            } else if (Intrinsics.areEqual((Object)message3, (Object)StopNibp.INSTANCE)) {
                this.stopAcquisition();
            } else if (Intrinsics.areEqual((Object)message3, (Object)StartNibpCalibration.INSTANCE)) {
                this.resetAcquisitionState(NibpStatus.CALIBRATING);
                this.startAcquisition(eventLoop);
            } else if (!(message3 instanceof SetNibpCalibrationParameters)) {
                if (message3 instanceof SetNibpCalibrationPressure) {
                    this.calibrationTargetPressure = ((SetNibpCalibrationPressure)message2).getPressure();
                } else if (message3 instanceof GetInfo) {
                    this.sendMessage(new MyInfo(1, DeviceType.BPSCAN.getDeviceTypeByte(), 6, new RemoteAddress("00:11:22:33:44:55"), null, null, null, null, null, 496, null));
                } else {
                    this.sendMessage(new Nack(message2.getType()));
                    return;
                }
            }
        }
        this.sendMessage(new Ack(message2.getType()));
    }

    private final void resetAcquisitionState(NibpStatus initialStatus) {
        this.status = initialStatus;
        this.peakSamplesRun = 0;
        this.currentPressure = 0.0f;
        this.nibpGenerator.reset();
    }

    private final void stopAcquisition() {
        Job job2 = this.acquisitionFuture;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.acquisitionFuture = null;
    }

    private final void startAcquisition(CoroutineScope eventLoop) {
        this.acquisitionFuture = this.scheduleAtFixedRate(eventLoop, this.generatePacket, 0, 6666, DurationUnit.MICROSECONDS);
    }

    private final void setupAcquisition(StartNibp newMessage) {
        this.maxPressure = newMessage.getMaxPressure();
        this.slopeStep = (float)newMessage.getSlope() / 600.0f;
        this.minPressure = newMessage.getFinalCuffPressure();
    }

    private static final void generatePacket$lambda$1(VirtualBpScanOperator this$0) {
        int n = 4;
        ArrayList<NibpModuleSample> arrayList = new ArrayList<NibpModuleSample>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = i;
            ArrayList<NibpModuleSample> arrayList2 = arrayList;
            boolean bl = false;
            this$0.dataBuffer[0] = 0.0f;
            switch (WhenMappings.$EnumSwitchMapping$0[this$0.status.ordinal()]) {
                case 1: {
                    this$0.status = NibpStatus.INFLATING;
                    break;
                }
                case 2: {
                    this$0.nibpGenerator.generateData(this$0.dataBuffer, 1, 1);
                    this$0.currentPressure += this$0.inflateSlopeStep;
                    if (!(this$0.currentPressure > this$0.maxPressure)) break;
                    this$0.status = NibpStatus.PEAK;
                    break;
                }
                case 3: {
                    this$0.nibpGenerator.generateData(this$0.dataBuffer, 1, 1);
                    ++this$0.peakSamplesRun;
                    if (this$0.peakSamplesRun <= this$0.peakSamples) break;
                    this$0.status = NibpStatus.CONTROLLING;
                    break;
                }
                case 4: {
                    this$0.nibpGenerator.generateData(this$0.dataBuffer, 1, 1);
                    this$0.currentPressure -= this$0.slopeStep;
                    if (!(this$0.currentPressure < this$0.minPressure)) break;
                    this$0.status = NibpStatus.FINISHING;
                    break;
                }
                case 5: {
                    this$0.status = NibpStatus.IDLE;
                    break;
                }
                case 6: {
                    this$0.stopAcquisition();
                    break;
                }
                case 7: {
                    if (this$0.currentPressure < this$0.calibrationTargetPressure) {
                        this$0.currentPressure += this$0.inflateSlopeStep;
                        break;
                    }
                    this$0.currentPressure -= this$0.inflateSlopeStep;
                    break;
                }
                case 8: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 9: {
                    throw new NotImplementedError(null, 1, null);
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            arrayList2.add(new NibpModuleSample(this$0.currentPressure + this$0.dataBuffer[0], this$0.status, null, null, null, 28, null));
        }
        List samples = arrayList;
        ModulePacket<NibpModuleSample> p = new ModulePacket<NibpModuleSample>(this$0.currentSampleId, samples, null);
        this$0.currentSampleId += samples.size();
        this$0.sendMessage(new NibpDataMessage(p));
    }

    private static final void generateBatteryInfo$lambda$2(VirtualBpScanOperator this$0) {
        BatteryInfoMessage batteryInfo = new BatteryInfoMessage(new BatteryInfo.Normal(120, 100, null, null, 8, null));
        this$0.sendMessage(batteryInfo);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NibpStatus.values().length];
            try {
                nArray[NibpStatus.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.INFLATING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.PEAK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.CONTROLLING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.FINISHING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.IDLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.CALIBRATING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.ADJUSTING_CALIBRATION_OFFSET.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpStatus.SETTING_PRESSURE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

