/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.types.bt_macs;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.DeviceType;
import vet.inpulse.libcomm.core.device.types.bt_macs.BtMacsFromAnalogKt;
import vet.inpulse.libcomm.core.device.types.bt_macs.BtMacsFromBT121Kt;
import vet.inpulse.libcomm.core.device.types.bt_macs.BtMacsFromTexasKt;
import vet.inpulse.libcomm.core.device.types.bt_macs.BtMacsFromWT11Kt;
import vet.inpulse.libcomm.core.device.types.bt_macs.EspressifBtMacPatternProvider;
import vet.inpulse.libcomm.core.locator.bluetooth.RemoteAddress;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lvet/inpulse/libcomm/core/device/types/bt_macs/DeviceBtMacPatternProvider;", "", "espressifBtMacPatternProvider", "Lvet/inpulse/libcomm/core/device/types/bt_macs/EspressifBtMacPatternProvider;", "<init>", "(Lvet/inpulse/libcomm/core/device/types/bt_macs/EspressifBtMacPatternProvider;)V", "getPossibleDeviceTypesFromBluetoothMac", "", "Lvet/inpulse/libcomm/core/device/DeviceType;", "remoteAddress", "Lvet/inpulse/libcomm/core/locator/bluetooth/RemoteAddress;", "libcomm"})
public final class DeviceBtMacPatternProvider {
    @NotNull
    private final EspressifBtMacPatternProvider espressifBtMacPatternProvider;

    public DeviceBtMacPatternProvider(@NotNull EspressifBtMacPatternProvider espressifBtMacPatternProvider) {
        Intrinsics.checkNotNullParameter((Object)espressifBtMacPatternProvider, (String)"espressifBtMacPatternProvider");
        this.espressifBtMacPatternProvider = espressifBtMacPatternProvider;
    }

    @NotNull
    public final Set<DeviceType> getPossibleDeviceTypesFromBluetoothMac(@NotNull RemoteAddress remoteAddress) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        List espressifMacPatterns = (List)this.espressifBtMacPatternProvider.getEspressifBtMacPatterns().getValue();
        String string = remoteAddress.getMacVendor();
        if (espressifMacPatterns.contains(string)) {
            DeviceType[] deviceTypeArray = new DeviceType[]{DeviceType.INCARDIO_V3, DeviceType.INMONITOR_20, DeviceType.BPSCAN_V2};
            set = SetsKt.setOf((Object[])deviceTypeArray);
        } else if (ArraysKt.contains((Object[])BtMacsFromBT121Kt.getBtMacsFromBT121(), (Object)string)) {
            DeviceType[] deviceTypeArray = new DeviceType[]{DeviceType.INMONITOR_BASIC, DeviceType.BPSCAN};
            set = SetsKt.setOf((Object[])deviceTypeArray);
        } else if (ArraysKt.contains((Object[])BtMacsFromTexasKt.getTexasBtMacs(), (Object)string)) {
            set = SetsKt.setOf((Object)((Object)DeviceType.INMONITOR_BASIC));
        } else if (ArraysKt.contains((Object[])BtMacsFromWT11Kt.getOriginalBluegigaBtMacs(), (Object)string)) {
            DeviceType[] deviceTypeArray = new DeviceType[]{DeviceType.INMONITOR_BASIC, DeviceType.BPSCAN, DeviceType.INCARDIO};
            set = SetsKt.setOf((Object[])deviceTypeArray);
        } else {
            set = ArraysKt.contains((Object[])BtMacsFromWT11Kt.getSiliconLabsWt11BtMacs(), (Object)string) ? SetsKt.setOf((Object)((Object)DeviceType.INCARDIO)) : (ArraysKt.contains((Object[])BtMacsFromAnalogKt.getAnalogBtMacs(), (Object)string) ? SetsKt.setOf((Object)((Object)DeviceType.HOLTER_V1)) : SetsKt.emptySet());
        }
        return set;
    }
}

