/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.module.hardware;

import kotlin.Metadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/libcomm/core/device/module/hardware/TemperatureCalculator;", "", "<init>", "()V", "rRef", "", "gain", "digitalScale", "YSIcoef_A", "YSIcoef_B", "YSIcoef_C", "thermistorVoltageThreshold", "", "tempCoefficient1", "tempCoefficient2", "temperatureCoefficient", "calculateTemperatureCoefficient", "vRef", "", "updateTemperatureCoefficient", "", "v1", "", "v2", "calculateSteinhartEquation", "thermistorVoltage", "libcomm"})
public final class TemperatureCalculator {
    private final double rRef;
    private final double gain;
    private final double digitalScale = Math.pow(2.0, 16);
    private final double YSIcoef_A;
    private final double YSIcoef_B;
    private final double YSIcoef_C;
    private final int thermistorVoltageThreshold;
    private final double tempCoefficient1 = this.calculateTemperatureCoefficient(1.0f);
    private final double tempCoefficient2 = this.calculateTemperatureCoefficient(2.0f);
    private double temperatureCoefficient = this.tempCoefficient1;

    public TemperatureCalculator() {
        this.rRef = 10000.0;
        this.gain = 1.0;
        this.YSIcoef_A = 0.0014733;
        this.YSIcoef_B = 2.372E-4;
        this.YSIcoef_C = 1.074E-7;
        this.thermistorVoltageThreshold = 12000;
    }

    private final double calculateTemperatureCoefficient(float vRef) {
        double fsr = (double)vRef / this.gain;
        double scale = (double)2 * fsr / this.digitalScale;
        return scale * this.rRef;
    }

    public final void updateTemperatureCoefficient(short v1, short v2) {
        boolean shouldUseVref2 = v1 < this.thermistorVoltageThreshold && v2 < this.thermistorVoltageThreshold;
        this.temperatureCoefficient = shouldUseVref2 ? this.tempCoefficient2 : this.tempCoefficient1;
    }

    public final float calculateSteinhartEquation(short thermistorVoltage) {
        double thermistorValue = this.temperatureCoefficient * (double)thermistorVoltage;
        double logR = Math.log(thermistorValue);
        double tempKelvin = Math.pow(this.YSIcoef_A + this.YSIcoef_B * logR + this.YSIcoef_C * Math.pow(logR, 3.0), -1.0);
        return (float)(tempKelvin - 273.15);
    }
}

